/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.quarkus.config;

import com.intellij.lang.annotation.AnnotationBuilder;
import com.intellij.lang.annotation.AnnotationHolder;
import com.intellij.lang.annotation.Annotator;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.microservices.jvm.config.hints.HintReferenceBase;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.DefaultLanguageHighlighterColors;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.JavaClassReference;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.PsiPackageReference;
import com.intellij.quarkus.config.QsConfigPlaceholderReference;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.util.containers.ContainerUtil;
import java.util.HashSet;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b&\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0006\u001a\u00020\u0007H$J\u0018\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0004J \u0010\u000e\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0007H\u0004J(\u0010\u0012\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0004R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcom/intellij/quarkus/config/QsConfigFileAnnotator;", "Lcom/intellij/lang/annotation/Annotator;", "<init>", "()V", "DEBUG_MODE", "", "getPlaceholderTextAttributesKey", "Lcom/intellij/openapi/editor/colors/TextAttributesKey;", "annotateValue", "", "element", "Lcom/intellij/psi/PsiElement;", "holder", "Lcom/intellij/lang/annotation/AnnotationHolder;", "doAnnotate", "range", "Lcom/intellij/openapi/util/TextRange;", "key", "doAnnotateEnforced", "Lcom/intellij/ui/SimpleTextAttributes;", "debugMessage", "", "intellij.quarkus"})
public abstract class QsConfigFileAnnotator
implements Annotator {
    private final boolean DEBUG_MODE = ApplicationManager.getApplication().isUnitTestMode();

    @NotNull
    protected abstract TextAttributesKey getPlaceholderTextAttributesKey();

    protected final void annotateValue(@NotNull PsiElement element, @NotNull AnnotationHolder holder) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        int elementOffset = element.getNode().getStartOffset();
        Object[] objectArray = element.getReferences();
        Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"getReferences(...)");
        Object[] references = objectArray;
        boolean highlightOnlyPlaceholders = ContainerUtil.findInstance((Object[])references, QsConfigPlaceholderReference.class) != null;
        Set annotatedOffsets = new HashSet();
        for (Object reference : references) {
            TextRange highlightTextRange;
            TextAttributesKey key = null;
            if (highlightOnlyPlaceholders) {
                if (reference instanceof QsConfigPlaceholderReference) {
                    key = this.getPlaceholderTextAttributesKey();
                }
            } else if (reference instanceof JavaClassReference || reference instanceof PsiPackageReference) {
                if (reference.resolve() != null) {
                    key = DefaultLanguageHighlighterColors.CLASS_REFERENCE;
                }
            } else if (reference instanceof HintReferenceBase) {
                key = ((HintReferenceBase)reference).getTextAttributesKey();
            }
            if (key == null) continue;
            Intrinsics.checkNotNullExpressionValue((Object)reference.getRangeInElement().shiftRight(elementOffset), (String)"shiftRight(...)");
            if (!annotatedOffsets.add(highlightTextRange.getStartOffset())) continue;
            this.doAnnotate(holder, highlightTextRange, key);
        }
    }

    protected final void doAnnotate(@NotNull AnnotationHolder holder, @NotNull TextRange range, @NotNull TextAttributesKey key) {
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        Intrinsics.checkNotNullParameter((Object)range, (String)"range");
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        if (range.isEmpty()) {
            return;
        }
        AnnotationBuilder annotationBuilder = this.DEBUG_MODE ? holder.newAnnotation(HighlightSeverity.INFORMATION, key.getExternalName()) : holder.newSilentAnnotation(HighlightSeverity.INFORMATION);
        Intrinsics.checkNotNull((Object)annotationBuilder);
        AnnotationBuilder annotationBuilder2 = annotationBuilder;
        annotationBuilder2.range(range).textAttributes(key).create();
    }

    protected final void doAnnotateEnforced(@NotNull AnnotationHolder holder, @NotNull TextRange range, @NotNull SimpleTextAttributes key, @NotNull String debugMessage) {
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        Intrinsics.checkNotNullParameter((Object)range, (String)"range");
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)debugMessage, (String)"debugMessage");
        if (range.isEmpty()) {
            return;
        }
        String message = this.DEBUG_MODE ? debugMessage : null;
        AnnotationBuilder annotationBuilder = message != null ? holder.newAnnotation(HighlightSeverity.INFORMATION, message) : holder.newSilentAnnotation(HighlightSeverity.INFORMATION);
        Intrinsics.checkNotNull((Object)annotationBuilder);
        AnnotationBuilder annotationBuilder2 = annotationBuilder;
        annotationBuilder2.range(range).enforcedTextAttributes(key.toTextAttributes()).create();
    }
}

