/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database;

import com.intellij.database.util.DbTestUtils;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.extensions.ExtensionPoint;
import com.intellij.openapi.extensions.ExtensionPointListener;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.PluginDescriptor;
import com.intellij.util.containers.CollectionFactory;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.xmlb.annotations.Attribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;
import org.jetbrains.annotations.Unmodifiable;

public abstract class HSet {
    @NotNull
    public static HSet create(@NotNull String name) {
        if (name == null) {
            HSet.$$$reportNull$$$0(0);
        }
        HSetImpl hSetImpl = LazyData.createImpl(name);
        if (hSetImpl == null) {
            HSet.$$$reportNull$$$0(1);
        }
        return hSetImpl;
    }

    @NotNull
    public static HSet create(HSet ... sets) {
        if (sets == null) {
            HSet.$$$reportNull$$$0(2);
        }
        return new HSetSet(Arrays.asList(sets));
    }

    @NotNull
    public HSet and(HSet ... sets) {
        if (sets == null) {
            HSet.$$$reportNull$$$0(3);
        }
        ArrayList<HSet> res = new ArrayList<HSet>(sets.length + 1);
        res.add(this);
        Collections.addAll(res, sets);
        return new HSetSet(res);
    }

    @NotNull
    public abstract String getName();

    public abstract boolean contains(@NotNull HSet var1);

    @TestOnly
    public static @Unmodifiable List<HSet> getAllSets() {
        return ContainerUtil.map((Collection)LazyData.SET_EP.getExtensionsIfPointIsRegistered(), b -> HSet.create(b.item));
    }

    @TestOnly
    public static Iterable<? extends HSet> getParentSets(@NotNull HSet set) {
        if (set == null) {
            HSet.$$$reportNull$$$0(4);
        }
        if (set instanceof HSetImpl) {
            return ((HSetImpl)set).getParentSets();
        }
        return Collections.emptyList();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/HSet";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sets";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "set";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/HSet";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "create";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "create";
                break;
            }
            case 1: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "and";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getParentSets";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1 -> new IllegalStateException(string);
        };
    }

    private static class LazyData {
        private static final Map<String, HSetImpl> ourInstances = CollectionFactory.createConcurrentWeakValueMap();
        private static final ExtensionPointName<HSetBean> SET_EP = ExtensionPointName.create((String)"com.intellij.database.addToHSet");
        private static boolean ourListenerAdded = LazyData.addListener(LazyData.getPoint());
        private static volatile List<HSetBean> ourTestBeans = null;

        private LazyData() {
        }

        @NotNull
        private static HSetImpl createImpl(@NotNull String name) {
            if (name == null) {
                LazyData.$$$reportNull$$$0(0);
            }
            HSetImpl hSetImpl = ourInstances.computeIfAbsent(name, HSetImpl::new);
            if (hSetImpl == null) {
                LazyData.$$$reportNull$$$0(1);
            }
            return hSetImpl;
        }

        private static boolean addListener(ExtensionPoint<HSetBean> ep) {
            if (ep == null) {
                return false;
            }
            ep.addExtensionPointListener((ExtensionPointListener)new ExtensionPointListener<HSetBean>(){

                public void extensionAdded(@NotNull HSetBean extension, @NotNull PluginDescriptor pluginDescriptor) {
                    HSetImpl item;
                    if (extension == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    if (pluginDescriptor == null) {
                        1.$$$reportNull$$$0(1);
                    }
                    HSetImpl hSetImpl = item = extension.item == null ? null : ourInstances.get(extension.item);
                    if (item != null) {
                        item.clearParents();
                    }
                }

                public void extensionRemoved(@NotNull HSetBean extension, @NotNull PluginDescriptor pluginDescriptor) {
                    HSetImpl item;
                    if (extension == null) {
                        1.$$$reportNull$$$0(2);
                    }
                    if (pluginDescriptor == null) {
                        1.$$$reportNull$$$0(3);
                    }
                    HSetImpl hSetImpl = item = extension.item == null ? null : ourInstances.get(extension.item);
                    if (item != null) {
                        item.clearParents();
                    }
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2;
                    Object[] objectArray3 = new Object[3];
                    switch (n) {
                        default: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "extension";
                            break;
                        }
                        case 1: 
                        case 3: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "pluginDescriptor";
                            break;
                        }
                    }
                    objectArray2[1] = "com/intellij/database/HSet$LazyData$1";
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[2] = "extensionAdded";
                            break;
                        }
                        case 2: 
                        case 3: {
                            objectArray = objectArray2;
                            objectArray2[2] = "extensionRemoved";
                            break;
                        }
                    }
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            }, false, null);
            return true;
        }

        @Nullable
        private static ExtensionPoint<HSetBean> getPoint() {
            Application application = ApplicationManager.getApplication();
            return application == null ? null : application.getExtensionArea().getExtensionPointIfRegistered(SET_EP.getName());
        }

        @Nullable
        private static List<HSetImpl> loadParentSets(@NotNull String name) {
            List<HSetBean> beans;
            if (name == null) {
                LazyData.$$$reportNull$$$0(2);
            }
            if ((beans = LazyData.getBeans()) == null) {
                return null;
            }
            ArrayList<HSetImpl> res = new ArrayList<HSetImpl>();
            for (HSetBean bean : beans) {
                if (bean.set == null || !name.equals(bean.item)) continue;
                res.add(LazyData.createImpl(bean.set));
            }
            return res;
        }

        @Nullable
        private static List<HSetBean> getBeans() {
            ExtensionPoint<HSetBean> point = LazyData.getPoint();
            if (point == null) {
                Application application = ApplicationManager.getApplication();
                if (application == null || application.isUnitTestMode()) {
                    return LazyData.getTestBeans();
                }
                return null;
            }
            if (!ourListenerAdded) {
                ourListenerAdded = LazyData.addListener(point);
            }
            return point.getExtensionList();
        }

        @TestOnly
        private static List<HSetBean> getTestBeans() {
            if (ourTestBeans == null) {
                ourTestBeans = DbTestUtils.loadBeans(SET_EP.getName(), HSetBean.class).toList();
            }
            return ourTestBeans;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "name";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/HSet$LazyData";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/HSet$LazyData";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createImpl";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "createImpl";
                    break;
                }
                case 1: {
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "loadParentSets";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1 -> new IllegalStateException(string);
            };
        }
    }

    private static class HSetImpl
    extends HSet {
        private final String myName;
        private volatile List<HSetImpl> myParents;

        private HSetImpl(@NotNull String name) {
            if (name == null) {
                HSetImpl.$$$reportNull$$$0(0);
            }
            this.myName = name;
        }

        @Override
        @NotNull
        public String getName() {
            String string = this.myName;
            if (string == null) {
                HSetImpl.$$$reportNull$$$0(1);
            }
            return string;
        }

        public boolean isIn(@NotNull String name) {
            if (name == null) {
                HSetImpl.$$$reportNull$$$0(2);
            }
            if (name.equals(this.myName)) {
                return true;
            }
            for (HSetImpl set : this.getParentSets()) {
                if (!set.isIn(name)) continue;
                return true;
            }
            return false;
        }

        @Override
        public boolean contains(@NotNull HSet set) {
            if (set == null) {
                HSetImpl.$$$reportNull$$$0(3);
            }
            if (set == this) {
                return true;
            }
            if (set instanceof HSetImpl) {
                return ((HSetImpl)set).isIn(this.myName);
            }
            return false;
        }

        @NotNull
        public Iterable<HSetImpl> getParentSets() {
            if (this.myParents != null) {
                List<HSetImpl> list = this.myParents;
                if (list == null) {
                    HSetImpl.$$$reportNull$$$0(4);
                }
                return list;
            }
            List<HSetImpl> parents = LazyData.loadParentSets(this.myName);
            if (parents == null) {
                List<HSetImpl> list = Collections.emptyList();
                if (list == null) {
                    HSetImpl.$$$reportNull$$$0(5);
                }
                return list;
            }
            this.myParents = parents;
            if (this.myParents == null) {
                HSetImpl.$$$reportNull$$$0(6);
            }
            return this.myParents;
        }

        private void clearParents() {
            this.myParents = null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1, 4, 5, 6 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "name";
                    break;
                }
                case 1: 
                case 4: 
                case 5: 
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/HSet$HSetImpl";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "set";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/HSet$HSetImpl";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 4: 
                case 5: 
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getParentSets";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 4: 
                case 5: 
                case 6: {
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "isIn";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "contains";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1, 4, 5, 6 -> new IllegalStateException(string);
            };
        }
    }

    private static class HSetSet
    extends HSet {
        private final List<HSet> myChildren;

        private HSetSet(@NotNull List<HSet> children) {
            if (children == null) {
                HSetSet.$$$reportNull$$$0(0);
            }
            this.myChildren = children;
        }

        @Override
        @NotNull
        public String getName() {
            return "";
        }

        @Override
        public boolean contains(@NotNull HSet set) {
            if (set == null) {
                HSetSet.$$$reportNull$$$0(1);
            }
            if (set == this) {
                return true;
            }
            for (HSet child : this.myChildren) {
                if (!child.contains(set)) continue;
                return true;
            }
            return false;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "children";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "set";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/database/HSet$HSetSet";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "contains";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static final class HSetBean {
        @Attribute(value="item")
        public String item;
        @Attribute(value="set")
        public String set;
    }
}

