/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diagram.util;

import com.intellij.openapi.util.ScalableIcon;
import com.intellij.ui.DeferredIcon;
import com.intellij.ui.LayeredIcon;
import com.intellij.ui.RetrievableIcon;
import com.intellij.ui.icons.CompositeIcon;
import com.intellij.ui.icons.RowIcon;
import com.intellij.util.concurrency.ThreadingAssertions;
import com.intellij.util.concurrency.annotations.RequiresReadLock;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.List;
import java.util.function.Function;
import java.util.stream.IntStream;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;

public final class DiagramIconUtil {
    private DiagramIconUtil() {
    }

    @RequiresReadLock
    @NotNull
    public static Icon evaluateDeferred(@NotNull Icon icon) {
        if (icon == null) {
            DiagramIconUtil.$$$reportNull$$$0(0);
        }
        ThreadingAssertions.softAssertReadAccess();
        if (icon instanceof RetrievableIcon) {
            return DiagramIconUtil.evaluateDeferred(((RetrievableIcon)icon).retrieveIcon());
        }
        if (icon instanceof DeferredIcon) {
            return DiagramIconUtil.evaluateDeferred(((DeferredIcon)icon).evaluate());
        }
        if (icon instanceof CompositeIcon) {
            return DiagramIconUtil.mapCompositeIcon((CompositeIcon)icon, it -> DiagramIconUtil.evaluateDeferred(it));
        }
        Icon icon2 = icon;
        if (icon2 == null) {
            DiagramIconUtil.$$$reportNull$$$0(1);
        }
        return icon2;
    }

    public static boolean isDeferred(@NotNull Icon icon) {
        if (icon == null) {
            DiagramIconUtil.$$$reportNull$$$0(2);
        }
        if (icon instanceof DeferredIcon) {
            return true;
        }
        if (icon instanceof CompositeIcon) {
            return ContainerUtil.exists(DiagramIconUtil.getIconComponents((CompositeIcon)icon), it -> DiagramIconUtil.isDeferred(it));
        }
        return false;
    }

    @NotNull
    public static Icon deepScaleTo(@NotNull Icon icon, float scale) {
        if (icon == null) {
            DiagramIconUtil.$$$reportNull$$$0(3);
        }
        if (icon instanceof ScalableIcon) {
            Icon icon2 = ((ScalableIcon)icon).scale(scale);
            if (icon2 == null) {
                DiagramIconUtil.$$$reportNull$$$0(4);
            }
            return icon2;
        }
        if (icon instanceof CompositeIcon) {
            return DiagramIconUtil.mapCompositeIcon((CompositeIcon)icon, it -> DiagramIconUtil.deepScaleTo(it, scale));
        }
        Icon icon3 = icon;
        if (icon3 == null) {
            DiagramIconUtil.$$$reportNull$$$0(5);
        }
        return icon3;
    }

    @NotNull
    public static List<Icon> getIconComponents(@NotNull CompositeIcon icon) {
        if (icon == null) {
            DiagramIconUtil.$$$reportNull$$$0(6);
        }
        if (icon instanceof RowIcon) {
            List list = ((RowIcon)icon).getAllIcons();
            if (list == null) {
                DiagramIconUtil.$$$reportNull$$$0(7);
            }
            return list;
        }
        if (icon instanceof LayeredIcon) {
            LayeredIcon layeredIcon = (LayeredIcon)icon;
            List<Icon> list = IntStream.range(0, layeredIcon.getIconCount()).mapToObj(it -> layeredIcon.getIcon(it)).filter(it -> it != null).toList();
            if (list == null) {
                DiagramIconUtil.$$$reportNull$$$0(8);
            }
            return list;
        }
        List<CompositeIcon> list = List.of(icon);
        if (list == null) {
            DiagramIconUtil.$$$reportNull$$$0(9);
        }
        return list;
    }

    @NotNull
    public static Icon mapCompositeIcon(@NotNull CompositeIcon icon, @NotNull Function<Icon, Icon> mapper) {
        if (icon == null) {
            DiagramIconUtil.$$$reportNull$$$0(10);
        }
        if (mapper == null) {
            DiagramIconUtil.$$$reportNull$$$0(11);
        }
        if (icon instanceof RowIcon) {
            return new com.intellij.ui.RowIcon((Icon[])ContainerUtil.map2Array((Collection)((RowIcon)icon).getAllIcons(), Icon.class, it -> (Icon)mapper.apply((Icon)it)));
        }
        if (icon instanceof LayeredIcon) {
            LayeredIcon layeredIcon = (LayeredIcon)icon;
            Icon[] normalized = (Icon[])IntStream.range(0, layeredIcon.getIconCount()).mapToObj(it -> layeredIcon.getIcon(it)).filter(it -> it != null).map(mapper).toArray(Icon[]::new);
            LayeredIcon layeredIcon2 = LayeredIcon.layeredIcon((Icon[])normalized);
            if (layeredIcon2 == null) {
                DiagramIconUtil.$$$reportNull$$$0(12);
            }
            return layeredIcon2;
        }
        CompositeIcon compositeIcon = icon;
        if (compositeIcon == null) {
            DiagramIconUtil.$$$reportNull$$$0(13);
        }
        return compositeIcon;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 4, 5, 7, 8, 9, 12, 13 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "icon";
                break;
            }
            case 1: 
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 12: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/diagram/util/DiagramIconUtil";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mapper";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/diagram/util/DiagramIconUtil";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "evaluateDeferred";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "deepScaleTo";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getIconComponents";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "mapCompositeIcon";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "evaluateDeferred";
                break;
            }
            case 1: 
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 12: 
            case 13: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isDeferred";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "deepScaleTo";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getIconComponents";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "mapCompositeIcon";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 4, 5, 7, 8, 9, 12, 13 -> new IllegalStateException(string);
        };
    }
}

