/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.sql.completion.cloud.context;

import com.intellij.database.psi.DbElement;
import com.intellij.database.psi.DbTable;
import com.intellij.database.util.DatabaseDefinitionHelper;
import com.intellij.ml.llm.core.settings.LLMSettingsManager;
import com.intellij.ml.llm.privacy.PSString;
import com.intellij.ml.llm.privacy.PrivacySafe;
import com.intellij.ml.llm.privacy.trustedStringBuilders.ConstantsKt;
import com.intellij.ml.llm.sql.completion.cloud.context.InlineCompletionLanguageContextCollector;
import com.intellij.ml.llm.sql.completion.cloud.context.InlineCompletionLanguageContextCollectorKt;
import com.intellij.ml.llm.sql.completion.cloud.context.SqlCollectorKt;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiTreeUtilKt;
import com.intellij.sql.dialects.SqlLanguageDialectEx;
import com.intellij.sql.psi.SqlBatchBlock;
import com.intellij.sql.psi.SqlDmlStatement;
import com.intellij.sql.psi.SqlElement;
import com.intellij.sql.psi.SqlFile;
import com.intellij.sql.psi.SqlStatement;
import com.intellij.sql.psi.impl.SqlImplUtil;
import com.intellij.util.containers.JBIterable;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KClass;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J \u0010\n\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\b\u001a\u00020\tH\u0016J\u0018\u0010\u000e\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\u000f2\u0006\u0010\f\u001a\u00020\rH\u0002J\u0018\u0010\u0010\u001a\u00020\u00052\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\f\u001a\u00020\rH\u0002J\u0018\u0010\u0013\u001a\u00020\u00052\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\f\u001a\u00020\rH\u0002J\u0014\u0010\u0016\u001a\u00020\u0005*\u00020\r2\u0006\u0010\u0017\u001a\u00020\u0007H\u0002J \u0010\u0018\u001a\u00020\u00052\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\b\u001a\u00020\tH\u0002J\u0014\u0010\u0016\u001a\u00020\u0005*\u00020\r2\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J\u000e\u0010\u001b\u001a\u0004\u0018\u00010\u001c*\u00020\u001aH\u0002J\u0012\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00070\u001e*\u00020\u0007H\u0002J\u0014\u0010\u001f\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00070 *\u00020\u0007H\u0002J\u0010\u0010!\u001a\u00020\"2\u0006\u0010\u000b\u001a\u00020\u0007H\u0016J\u0010\u0010#\u001a\u00020\"2\u0006\u0010\u0017\u001a\u00020\u0007H\u0002J\u0012\u0010$\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u0017\u001a\u00020\u0007H\u0016J\u0010\u0010%\u001a\u00020&2\u0006\u0010\u0017\u001a\u00020\u0007H\u0016\u00a8\u0006'"}, d2={"Lcom/intellij/ml/llm/sql/completion/cloud/context/SqlCollector;", "Lcom/intellij/ml/llm/sql/completion/cloud/context/InlineCompletionLanguageContextCollector;", "<init>", "()V", "start", "", "place", "Lcom/intellij/psi/PsiElement;", "processor", "Lcom/intellij/ml/llm/sql/completion/cloud/context/InlineCompletionLanguageContextCollector$Processor;", "expandLevel", "element", "builder", "Lcom/intellij/ml/llm/sql/completion/cloud/context/InlineCompletionLanguageContextCollector$ExpansionBuilder;", "expandDbElement", "Lcom/intellij/database/psi/DbElement;", "expandFile", "file", "Lcom/intellij/sql/psi/SqlFile;", "expandBatchBlock", "batch", "Lcom/intellij/sql/psi/SqlBatchBlock;", "addExpandableStatement", "e", "expandSqlStatement", "statement", "Lcom/intellij/sql/psi/SqlStatement;", "collectTextTillSeparator", "", "followingLeaves", "Lkotlin/sequences/Sequence;", "statementsLevel", "Lcom/intellij/util/containers/JBIterable;", "accept", "", "deprioritize", "getRoot", "getRootName", "Lcom/intellij/ml/llm/privacy/PSString;", "intellij.ml.llm.sql.completion"})
@SourceDebugExtension(value={"SMAP\nSqlCollector.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SqlCollector.kt\ncom/intellij/ml/llm/sql/completion/cloud/context/SqlCollector\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,149:1\n1869#2,2:150\n1869#2,2:152\n1869#2,2:154\n*S KotlinDebug\n*F\n+ 1 SqlCollector.kt\ncom/intellij/ml/llm/sql/completion/cloud/context/SqlCollector\n*L\n48#1:150,2\n55#1:152,2\n61#1:154,2\n*E\n"})
public final class SqlCollector
implements InlineCompletionLanguageContextCollector {
    @Override
    public void start(@NotNull PsiElement place, @NotNull InlineCompletionLanguageContextCollector.Processor processor) {
        Intrinsics.checkNotNullParameter((Object)place, (String)"place");
        Intrinsics.checkNotNullParameter((Object)processor, (String)"processor");
        KClass[] kClassArray = new KClass[]{Reflection.getOrCreateKotlinClass(SqlStatement.class), Reflection.getOrCreateKotlinClass(SqlBatchBlock.class), Reflection.getOrCreateKotlinClass(SqlFile.class)};
        SqlElement parent = (SqlElement)PsiTreeUtilKt.parentOfTypes((PsiElement)place, (KClass[])kClassArray, (boolean)true);
        processor.setupPriorityPatcher((Function1<? super PsiElement, Boolean>)((Function1)new Function1<PsiElement, Boolean>((Object)this){

            public final Boolean invoke(PsiElement p0) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                return SqlCollector.access$deprioritize((SqlCollector)this.receiver, p0);
            }
        }));
        processor.enqueue((PsiElement)parent);
    }

    @Override
    public void expandLevel(@NotNull PsiElement element, @NotNull InlineCompletionLanguageContextCollector.ExpansionBuilder builder2, @NotNull InlineCompletionLanguageContextCollector.Processor processor) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)builder2, (String)"builder");
        Intrinsics.checkNotNullParameter((Object)processor, (String)"processor");
        PsiElement psiElement = element;
        if (psiElement instanceof SqlFile) {
            this.expandFile((SqlFile)element, builder2);
        } else if (psiElement instanceof SqlBatchBlock) {
            this.expandBatchBlock((SqlBatchBlock)element, builder2);
        } else if (psiElement instanceof SqlStatement) {
            this.expandSqlStatement((SqlStatement)element, builder2, processor);
        } else if (psiElement instanceof DbElement) {
            this.expandDbElement((DbElement)element, builder2);
        }
    }

    private final void expandDbElement(DbElement element, InlineCompletionLanguageContextCollector.ExpansionBuilder builder2) {
        if (!LLMSettingsManager.Companion.getInstance().isDatabaseContextEnabled()) {
            return;
        }
        if (element instanceof DbTable) {
            String string = DatabaseDefinitionHelper.generateDefinition((DbElement)element, (StringBuilder)new StringBuilder()).toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
            InlineCompletionLanguageContextCollectorKt.addText(builder2, (PrivacySafe<? extends CharSequence>)((PrivacySafe)ConstantsKt.getPrivacyConst((String)string)));
        } else {
            JBIterable jBIterable = element.getDasChildren(null);
            Intrinsics.checkNotNullExpressionValue((Object)jBIterable, (String)"getDasChildren(...)");
            Iterable $this$forEach$iv = (Iterable)jBIterable;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                DbElement it = (DbElement)element$iv;
                boolean bl = false;
                InlineCompletionLanguageContextCollectorKt.addExpandable(builder2, (PsiElement)it, (PrivacySafe<? extends CharSequence>)((PrivacySafe)ConstantsKt.getEMPTY()));
            }
        }
    }

    private final void expandFile(SqlFile file, InlineCompletionLanguageContextCollector.ExpansionBuilder builder2) {
        Iterable $this$forEach$iv = (Iterable)this.statementsLevel((PsiElement)file);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            PsiElement it = (PsiElement)element$iv;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)it);
            this.addExpandableStatement(builder2, it);
        }
    }

    private final void expandBatchBlock(SqlBatchBlock batch, InlineCompletionLanguageContextCollector.ExpansionBuilder builder2) {
        Iterable $this$forEach$iv = (Iterable)this.statementsLevel((PsiElement)batch);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            PsiElement it = (PsiElement)element$iv;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)it);
            this.addExpandableStatement(builder2, it);
        }
    }

    private final void addExpandableStatement(InlineCompletionLanguageContextCollector.ExpansionBuilder $this$addExpandableStatement, PsiElement e) {
        if (e instanceof SqlStatement) {
            this.addExpandableStatement($this$addExpandableStatement, (SqlStatement)e);
        } else {
            InlineCompletionLanguageContextCollectorKt.addExpandable($this$addExpandableStatement, e, (PrivacySafe<? extends CharSequence>)((PrivacySafe)SqlCollectorKt.access$getPlaceholder$p()));
        }
    }

    private final void expandSqlStatement(SqlStatement statement, InlineCompletionLanguageContextCollector.ExpansionBuilder builder2, InlineCompletionLanguageContextCollector.Processor processor) {
        processor.enqueueAllReferencesUnder((PsiElement)statement);
        InlineCompletionLanguageContextCollectorKt.addElementText(builder2, (PsiElement)statement);
        String extra = this.collectTextTillSeparator(statement);
        if (extra != null) {
            builder2.addTextRaw((PrivacySafe<? extends CharSequence>)((PrivacySafe)ConstantsKt.getPrivacyConst((String)extra)), PsiTreeUtilKt.getEndOffset((PsiElement)((PsiElement)statement)));
        }
        if (extra == null || !StringsKt.endsWith$default((CharSequence)extra, (char)'\n', (boolean)false, (int)2, null)) {
            InlineCompletionLanguageContextCollectorKt.addText(builder2, (PrivacySafe<? extends CharSequence>)((PrivacySafe)ConstantsKt.getPrivacyConst((String)"\n")));
        }
    }

    private final void addExpandableStatement(InlineCompletionLanguageContextCollector.ExpansionBuilder $this$addExpandableStatement, SqlStatement statement) {
        String extra = this.collectTextTillSeparator(statement);
        String string = extra;
        TextRange textRange = TextRange.create((int)PsiTreeUtilKt.getStartOffset((PsiElement)((PsiElement)statement)), (int)(PsiTreeUtilKt.getEndOffset((PsiElement)((PsiElement)statement)) + (string != null ? string.length() : 0)));
        Intrinsics.checkNotNullExpressionValue((Object)textRange, (String)"create(...)");
        TextRange range = textRange;
        $this$addExpandableStatement.addExpandable((PsiElement)statement, range, (PrivacySafe<? extends CharSequence>)((PrivacySafe)SqlCollectorKt.access$getPlaceholder$p()));
    }

    private final String collectTextTillSeparator(SqlStatement $this$collectTextTillSeparator) {
        StringBuilder res = new StringBuilder();
        for (PsiElement leaf : this.followingLeaves((PsiElement)$this$collectTextTillSeparator)) {
            if (!(leaf instanceof PsiWhiteSpace) || !(leaf instanceof PsiComment)) {
                SqlLanguageDialectEx sqlLanguageDialectEx = SqlImplUtil.getSqlDialectSafe((PsiElement)((PsiElement)$this$collectTextTillSeparator));
                Intrinsics.checkNotNullExpressionValue((Object)sqlLanguageDialectEx, (String)"getSqlDialectSafe(...)");
                SqlLanguageDialectEx dialect = sqlLanguageDialectEx;
                if (!dialect.getStatementSeparators().contains(PsiTreeUtilKt.getElementType((PsiElement)leaf))) {
                    return null;
                }
                res.append(leaf.getText());
                for (PsiElement after : this.followingLeaves(leaf)) {
                    StringBuilder stringBuilder;
                    PsiElement psiElement = after;
                    if (psiElement instanceof PsiWhiteSpace) {
                        String text2 = ((PsiWhiteSpace)after).getText();
                        Intrinsics.checkNotNull((Object)text2);
                        int idx = StringsKt.indexOf$default((CharSequence)text2, (char)'\n', (int)0, (boolean)false, (int)6, null);
                        if (idx == -1) {
                            stringBuilder = res.append(text2);
                            continue;
                        }
                        res.append(text2, 0, idx + 1);
                        break;
                    }
                    if (!(psiElement instanceof PsiComment)) break;
                    stringBuilder = res.append(((PsiComment)after).getText());
                }
                return res.toString();
            }
            res.append(leaf.getText());
        }
        return null;
    }

    private final Sequence<PsiElement> followingLeaves(PsiElement $this$followingLeaves) {
        return SequencesKt.generateSequence((Object)PsiTreeUtil.nextLeaf((PsiElement)$this$followingLeaves), SqlCollector::followingLeaves$lambda$0);
    }

    private final JBIterable<? extends PsiElement> statementsLevel(PsiElement $this$statementsLevel) {
        JBIterable jBIterable = SqlImplUtil.childrenIt((PsiElement)$this$statementsLevel).filter(arg_0 -> SqlCollector.statementsLevel$lambda$1(SqlCollector::statementsLevel$lambda$0, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)jBIterable, (String)"filter(...)");
        return jBIterable;
    }

    @Override
    public boolean accept(@NotNull PsiElement element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        return true;
    }

    private final boolean deprioritize(PsiElement e) {
        return e instanceof SqlDmlStatement;
    }

    @Override
    @Nullable
    public PsiElement getRoot(@NotNull PsiElement e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        if (e instanceof DbElement) {
            return (PsiElement)((DbElement)e).getDataSource();
        }
        return InlineCompletionLanguageContextCollector.super.getRoot(e);
    }

    @Override
    @NotNull
    public PSString getRootName(@NotNull PsiElement e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        return e instanceof DbElement ? ConstantsKt.getPrivacyConst((String)(((DbElement)e).getName() + ".sql")) : InlineCompletionLanguageContextCollector.super.getRootName(e);
    }

    private static final PsiElement followingLeaves$lambda$0(PsiElement it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return PsiTreeUtil.nextLeaf((PsiElement)it);
    }

    private static final boolean statementsLevel$lambda$0(PsiElement it) {
        return it instanceof SqlBatchBlock || it instanceof SqlStatement;
    }

    private static final boolean statementsLevel$lambda$1(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    public static final /* synthetic */ boolean access$deprioritize(SqlCollector $this, PsiElement e) {
        return $this.deprioritize(e);
    }
}

