/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.fullLine.core.utils.common;

import com.intellij.fullLine.core.utils.common.InlineCompletionSpecialRange;
import com.intellij.fullLine.core.utils.common.PlainHighlightingRange;
import com.intellij.openapi.editor.markup.EffectType;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.util.TextRange;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.VisibleForTesting;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c7\u0002\u0018\u00002\u00020\u0001:\u0001\u0012B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001c\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u0007J\u0018\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\tH\u0007J\u0018\u0010\f\u001a\b\u0012\u0004\u0012\u00020\r0\u0005*\b\u0012\u0004\u0012\u00020\u00060\u0005H\u0002J\f\u0010\u000e\u001a\u00020\u000f*\u00020\tH\u0002J\f\u0010\u0010\u001a\u00020\u000f*\u00020\u0011H\u0002\u00a8\u0006\u0013"}, d2={"Lcom/intellij/fullLine/core/utils/common/InlineCompletionHighlightRangesNormalizer;", "", "<init>", "()V", "normalize", "", "Lcom/intellij/fullLine/core/utils/common/InlineCompletionSpecialRange$Highlighting;", "ranges", "mergeAttributes", "Lcom/intellij/openapi/editor/markup/TextAttributes;", "first", "second", "toSortedScanLineEvents", "Lcom/intellij/fullLine/core/utils/common/InlineCompletionHighlightRangesNormalizer$ScanLineEvent;", "containsEffect", "", "isSupported", "Lcom/intellij/openapi/editor/markup/EffectType;", "ScanLineEvent", "intellij.fullLine.core.utils.common"})
@VisibleForTesting
@ApiStatus.Internal
@SourceDebugExtension(value={"SMAP\nInlineCompletionHighlighterUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 InlineCompletionHighlighterUtils.kt\ncom/intellij/fullLine/core/utils/common/InlineCompletionHighlightRangesNormalizer\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,371:1\n774#2:372\n865#2,2:373\n1056#2:375\n1563#2:376\n1634#2,3:377\n1563#2:380\n1634#2,3:381\n2783#2,7:384\n1056#2:391\n*S KotlinDebug\n*F\n+ 1 InlineCompletionHighlighterUtils.kt\ncom/intellij/fullLine/core/utils/common/InlineCompletionHighlightRangesNormalizer\n*L\n284#1:372\n284#1:373,2\n285#1:375\n287#1:376\n287#1:377,3\n303#1:380\n303#1:381,3\n303#1:384,7\n344#1:391\n*E\n"})
public final class InlineCompletionHighlightRangesNormalizer {
    @NotNull
    public static final InlineCompletionHighlightRangesNormalizer INSTANCE = new InlineCompletionHighlightRangesNormalizer();

    private InlineCompletionHighlightRangesNormalizer() {
    }

    /*
     * WARNING - void declaration
     */
    @VisibleForTesting
    @NotNull
    public final List<InlineCompletionSpecialRange.Highlighting> normalize(@NotNull List<? extends InlineCompletionSpecialRange.Highlighting> ranges) {
        Collection collection;
        void $this$mapTo$iv$iv;
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter(ranges, (String)"ranges");
        Iterable $this$filter$iv = ranges;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo22 = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            InlineCompletionSpecialRange.Highlighting it = (InlineCompletionSpecialRange.Highlighting)element$iv$iv;
            boolean bl = false;
            if (!(!it.getAbsoluteLocation().isEmpty())) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$sortedBy$iv = (List)destination$iv$iv;
        boolean $i$f$sortedBy = false;
        List sortedRanges = CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                InlineCompletionSpecialRange.Highlighting it = (InlineCompletionSpecialRange.Highlighting)a;
                boolean bl = false;
                Comparable comparable = Integer.valueOf(it.getAbsoluteLocation().getStartOffset());
                it = (InlineCompletionSpecialRange.Highlighting)b;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Integer.valueOf(it.getAbsoluteLocation().getStartOffset()));
            }
        });
        List<ScanLineEvent> events = this.toSortedScanLineEvents(sortedRanges);
        Iterable $this$map$iv = events;
        boolean $i$f$map = false;
        Iterable $i$f$filterTo22 = $this$map$iv;
        Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            ScanLineEvent scanLineEvent = (ScanLineEvent)item$iv$iv;
            collection = destination$iv$iv2;
            boolean bl = false;
            collection.add(it.getOffset());
        }
        List sortedOffsets = CollectionsKt.distinct((Iterable)((List)destination$iv$iv2));
        List result2 = new ArrayList();
        int iEvent = 0;
        Set currentRangesIndices = new LinkedHashSet();
        int n = ((Collection)sortedOffsets).size();
        for (int iOffset = 0; iOffset < n; ++iOffset) {
            void $this$reduce$iv;
            void $this$mapTo$iv$iv2;
            while (iEvent < events.size() && events.get(iEvent).getOffset() < ((Number)sortedOffsets.get(iOffset)).intValue()) {
                switch (WhenMappings.$EnumSwitchMapping$0[events.get(iEvent).getType().ordinal()]) {
                    case 1: {
                        ((Collection)currentRangesIndices).add(events.get(iEvent).getRangeIndex());
                        break;
                    }
                    case 2: {
                        ((Collection)currentRangesIndices).remove(events.get(iEvent).getRangeIndex());
                        break;
                    }
                    default: {
                        throw new NoWhenBranchMatchedException();
                    }
                }
                ++iEvent;
            }
            if (!(!((Collection)currentRangesIndices).isEmpty())) continue;
            if (!(iOffset > 0)) {
                throw new IllegalStateException("Check failed.");
            }
            TextRange textRange = new TextRange(((Number)sortedOffsets.get(iOffset - 1)).intValue(), ((Number)sortedOffsets.get(iOffset)).intValue());
            Iterable $this$map$iv2 = currentRangesIndices;
            boolean $i$f$map2 = false;
            Iterable iterable2 = $this$map$iv2;
            Collection destination$iv$iv3 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
            boolean $i$f$mapTo22 = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv2) {
                void it;
                int n2 = ((Number)item$iv$iv).intValue();
                collection = destination$iv$iv3;
                boolean bl = false;
                collection.add(((InlineCompletionSpecialRange.Highlighting)sortedRanges.get((int)it)).getAttributes());
            }
            $this$map$iv2 = (List)destination$iv$iv3;
            boolean $i$f$reduce = false;
            Iterator iterator$iv = $this$reduce$iv.iterator();
            if (!iterator$iv.hasNext()) {
                throw new UnsupportedOperationException("Empty collection can't be reduced.");
            }
            Object accumulator$iv = iterator$iv.next();
            while (iterator$iv.hasNext()) {
                void p1;
                TextAttributes $i$f$mapTo22 = (TextAttributes)iterator$iv.next();
                TextAttributes p0 = (TextAttributes)accumulator$iv;
                boolean bl = false;
                accumulator$iv = this.mergeAttributes(p0, (TextAttributes)p1);
            }
            TextAttributes textAttributes = (TextAttributes)accumulator$iv;
            ((Collection)result2).add(new PlainHighlightingRange(textRange, textAttributes));
        }
        return result2;
    }

    @VisibleForTesting
    @NotNull
    public final TextAttributes mergeAttributes(@NotNull TextAttributes first, @NotNull TextAttributes second) {
        TextAttributes effectSource;
        Intrinsics.checkNotNullParameter((Object)first, (String)"first");
        Intrinsics.checkNotNullParameter((Object)second, (String)"second");
        if (Intrinsics.areEqual((Object)first, (Object)second)) {
            return first;
        }
        TextAttributes textAttributes = TextAttributes.merge((TextAttributes)second, (TextAttributes)first);
        if (textAttributes == null) {
            textAttributes = first;
        }
        TextAttributes result2 = textAttributes;
        TextAttributes textAttributes2 = effectSource = this.containsEffect(first) ? first : (this.containsEffect(second) ? second : null);
        result2.setEffectType((EffectType)(textAttributes2 != null ? textAttributes2.getEffectType() : null));
        TextAttributes textAttributes3 = effectSource;
        result2.setEffectColor(textAttributes3 != null ? textAttributes3.getEffectColor() : null);
        result2.setAdditionalEffects(MapsKt.emptyMap());
        return result2;
    }

    private final List<ScanLineEvent> toSortedScanLineEvents(List<? extends InlineCompletionSpecialRange.Highlighting> $this$toSortedScanLineEvents) {
        List result2 = new ArrayList();
        int n = ((Collection)$this$toSortedScanLineEvents).size();
        for (int i = 0; i < n; ++i) {
            ((Collection)result2).add(new ScanLineEvent(i, ScanLineEvent.Type.START, $this$toSortedScanLineEvents.get(i).getAbsoluteLocation().getStartOffset()));
            ((Collection)result2).add(new ScanLineEvent(i, ScanLineEvent.Type.END, $this$toSortedScanLineEvents.get(i).getAbsoluteLocation().getEndOffset()));
        }
        Iterable $this$sortedBy$iv = result2;
        boolean $i$f$sortedBy = false;
        return CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                ScanLineEvent it = (ScanLineEvent)a;
                boolean bl = false;
                Comparable comparable = Integer.valueOf(it.getOffset());
                it = (ScanLineEvent)b;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Integer.valueOf(it.getOffset()));
            }
        });
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean containsEffect(TextAttributes $this$containsEffect) {
        if ($this$containsEffect.getEffectColor() == null) return false;
        EffectType effectType = $this$containsEffect.getEffectType();
        if (effectType == null) return false;
        if (!this.isSupported(effectType)) return false;
        return true;
    }

    private final boolean isSupported(EffectType $this$isSupported) {
        return switch (WhenMappings.$EnumSwitchMapping$1[$this$isSupported.ordinal()]) {
            case 1, 2, 3, 4, 5 -> true;
            default -> false;
        };
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0082\b\u0018\u00002\u00020\u0001:\u0001\u0018B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0007\u0010\bJ\t\u0010\u000e\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u000f\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0010\u001a\u00020\u0003H\u00c6\u0003J'\u0010\u0011\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u0012\u001a\u00020\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0015\u001a\u00020\u0003H\u00d6\u0001J\t\u0010\u0016\u001a\u00020\u0017H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\n\u00a8\u0006\u0019"}, d2={"Lcom/intellij/fullLine/core/utils/common/InlineCompletionHighlightRangesNormalizer$ScanLineEvent;", "", "rangeIndex", "", "type", "Lcom/intellij/fullLine/core/utils/common/InlineCompletionHighlightRangesNormalizer$ScanLineEvent$Type;", "offset", "<init>", "(ILcom/intellij/fullLine/core/utils/common/InlineCompletionHighlightRangesNormalizer$ScanLineEvent$Type;I)V", "getRangeIndex", "()I", "getType", "()Lcom/intellij/fullLine/core/utils/common/InlineCompletionHighlightRangesNormalizer$ScanLineEvent$Type;", "getOffset", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "toString", "", "Type", "intellij.fullLine.core.utils.common"})
    private static final class ScanLineEvent {
        private final int rangeIndex;
        @NotNull
        private final Type type;
        private final int offset;

        public ScanLineEvent(int rangeIndex, @NotNull Type type, int offset) {
            Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
            this.rangeIndex = rangeIndex;
            this.type = type;
            this.offset = offset;
        }

        public final int getRangeIndex() {
            return this.rangeIndex;
        }

        @NotNull
        public final Type getType() {
            return this.type;
        }

        public final int getOffset() {
            return this.offset;
        }

        public final int component1() {
            return this.rangeIndex;
        }

        @NotNull
        public final Type component2() {
            return this.type;
        }

        public final int component3() {
            return this.offset;
        }

        @NotNull
        public final ScanLineEvent copy(int rangeIndex, @NotNull Type type, int offset) {
            Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
            return new ScanLineEvent(rangeIndex, type, offset);
        }

        public static /* synthetic */ ScanLineEvent copy$default(ScanLineEvent scanLineEvent, int n, Type type, int n2, int n3, Object object) {
            if ((n3 & 1) != 0) {
                n = scanLineEvent.rangeIndex;
            }
            if ((n3 & 2) != 0) {
                type = scanLineEvent.type;
            }
            if ((n3 & 4) != 0) {
                n2 = scanLineEvent.offset;
            }
            return scanLineEvent.copy(n, type, n2);
        }

        @NotNull
        public String toString() {
            return "ScanLineEvent(rangeIndex=" + this.rangeIndex + ", type=" + this.type + ", offset=" + this.offset + ")";
        }

        public int hashCode() {
            int result2 = Integer.hashCode(this.rangeIndex);
            result2 = result2 * 31 + this.type.hashCode();
            result2 = result2 * 31 + Integer.hashCode(this.offset);
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof ScanLineEvent)) {
                return false;
            }
            ScanLineEvent scanLineEvent = (ScanLineEvent)other;
            if (this.rangeIndex != scanLineEvent.rangeIndex) {
                return false;
            }
            if (this.type != scanLineEvent.type) {
                return false;
            }
            return this.offset == scanLineEvent.offset;
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0005\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005\u00a8\u0006\u0006"}, d2={"Lcom/intellij/fullLine/core/utils/common/InlineCompletionHighlightRangesNormalizer$ScanLineEvent$Type;", "", "<init>", "(Ljava/lang/String;I)V", "START", "END", "intellij.fullLine.core.utils.common"})
        public static final class Type
        extends Enum<Type> {
            public static final /* enum */ Type START = new Type();
            public static final /* enum */ Type END = new Type();
            private static final /* synthetic */ Type[] $VALUES;
            private static final /* synthetic */ EnumEntries $ENTRIES;

            public static Type[] values() {
                return (Type[])$VALUES.clone();
            }

            public static Type valueOf(String value) {
                return Enum.valueOf(Type.class, value);
            }

            @NotNull
            public static EnumEntries<Type> getEntries() {
                return $ENTRIES;
            }

            static {
                $VALUES = typeArray = new Type[]{Type.START, Type.END};
                $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
            }
        }
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;

        static {
            int[] nArray = new int[ScanLineEvent.Type.values().length];
            try {
                nArray[ScanLineEvent.Type.START.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ScanLineEvent.Type.END.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[EffectType.values().length];
            try {
                nArray[EffectType.LINE_UNDERSCORE.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[EffectType.WAVE_UNDERSCORE.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[EffectType.STRIKEOUT.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[EffectType.BOLD_LINE_UNDERSCORE.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[EffectType.BOLD_DOTTED_LINE.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$1 = nArray;
        }
    }
}

