/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.lsp.impl.highlighting;

import com.intellij.platform.lsp.api.LspServer;
import java.util.concurrent.CompletableFuture;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.eclipse.lsp4j.DocumentLink;
import org.eclipse.lsp4j.services.LanguageServer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\b\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000e\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u000b\u001a\u0004\u0018\u00010\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0013\u0010\u000f\u001a\u0004\u0018\u00010\f8F\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u000e\u00a8\u0006\u0011"}, d2={"Lcom/intellij/platform/lsp/impl/highlighting/LspDocumentLink;", "", "initialDocumentLink", "Lorg/eclipse/lsp4j/DocumentLink;", "LspDocumentLink", "(Lorg/eclipse/lsp4j/DocumentLink;)V", "resolvedDocumentLink", "resolveDocumentLink", "", "lspServer", "Lcom/intellij/platform/lsp/api/LspServer;", "tooltip", "", "getTooltip", "()Ljava/lang/String;", "targetUri", "getTargetUri", "intellij.platform.lsp.impl"})
public final class LspDocumentLink {
    @NotNull
    private final DocumentLink initialDocumentLink;
    @Nullable
    private DocumentLink resolvedDocumentLink;
    @Nullable
    private final String tooltip;

    public LspDocumentLink(@NotNull DocumentLink initialDocumentLink) {
        Intrinsics.checkNotNullParameter((Object)initialDocumentLink, (String)"initialDocumentLink");
        this.initialDocumentLink = initialDocumentLink;
        this.tooltip = this.initialDocumentLink.getTooltip();
    }

    public final void resolveDocumentLink(@NotNull LspServer lspServer) {
        Intrinsics.checkNotNullParameter((Object)lspServer, (String)"lspServer");
        if (this.initialDocumentLink.getTarget() == null && this.resolvedDocumentLink == null) {
            DocumentLink documentLink = (DocumentLink)LspServer.sendRequestSync$default(lspServer, 0, arg_0 -> LspDocumentLink.n(this, arg_0), 1, null);
            if (documentLink == null) {
                documentLink = this.initialDocumentLink;
            }
            this.resolvedDocumentLink = documentLink;
        }
    }

    @Nullable
    public final String getTooltip() {
        return this.tooltip;
    }

    @Nullable
    public final String getTargetUri() {
        Object object = this.resolvedDocumentLink;
        if (object == null || (object = object.getTarget()) == null) {
            object = this.initialDocumentLink.getTarget();
        }
        return object;
    }

    private static final CompletableFuture n(LspDocumentLink lspDocumentLink, LanguageServer languageServer) {
        Intrinsics.checkNotNullParameter((Object)languageServer, (String)"it");
        CompletableFuture completableFuture = languageServer.getTextDocumentService().documentLinkResolve(lspDocumentLink.initialDocumentLink);
        Intrinsics.checkNotNullExpressionValue((Object)completableFuture, (String)"documentLinkResolve(...)");
        return completableFuture;
    }
}

