/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.lsp.api.customization;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.util.InspectionMessage;
import com.intellij.lang.annotation.AnnotationBuilder;
import com.intellij.lang.annotation.AnnotationHolder;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.platform.lsp.api.customization.LspDiagnosticsCustomizer;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.util.concurrency.annotations.RequiresBackgroundThread;
import com.intellij.util.concurrency.annotations.RequiresReadLock;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.eclipse.lsp4j.Diagnostic;
import org.eclipse.lsp4j.DiagnosticSeverity;
import org.eclipse.lsp4j.DiagnosticTag;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0016\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J.\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011H\u0017J\u0012\u0010\u0013\u001a\u0004\u0018\u00010\u00142\u0006\u0010\f\u001a\u00020\rH\u0016J\u0010\u0010\u0015\u001a\u00020\u00162\u0006\u0010\f\u001a\u00020\rH\u0017J\u0010\u0010\u0017\u001a\u00020\u00162\u0006\u0010\f\u001a\u00020\rH\u0017J\u0012\u0010\u0018\u001a\u0004\u0018\u00010\u00192\u0006\u0010\f\u001a\u00020\rH\u0016J\u0012\u0010\u001a\u001a\u0004\u0018\u00010\u001b2\u0006\u0010\f\u001a\u00020\rH\u0017J$\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00120\u00112\u0006\u0010\f\u001a\u00020\r2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011H\u0017\u00a8\u0006\u001d"}, d2={"Lcom/intellij/platform/lsp/api/customization/LspDiagnosticsSupport;", "Lcom/intellij/platform/lsp/api/customization/LspDiagnosticsCustomizer;", "LspDiagnosticsSupport", "()V", "shouldAskServerForDiagnostics", "", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "createAnnotation", "", "holder", "Lcom/intellij/lang/annotation/AnnotationHolder;", "diagnostic", "Lorg/eclipse/lsp4j/Diagnostic;", "textRange", "Lcom/intellij/openapi/util/TextRange;", "quickFixes", "", "Lcom/intellij/codeInsight/intention/IntentionAction;", "getHighlightSeverity", "Lcom/intellij/lang/annotation/HighlightSeverity;", "getMessage", "", "getTooltip", "getSpecialHighlightType", "Lcom/intellij/codeInspection/ProblemHighlightType;", "getEnforcedTextAttributes", "Lcom/intellij/openapi/editor/markup/TextAttributes;", "customizeQuickFixes", "intellij.platform.lsp"})
@SourceDebugExtension(value={"SMAP\nLspDiagnosticsCustomizer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LspDiagnosticsCustomizer.kt\ncom/intellij/platform/lsp/api/customization/LspDiagnosticsSupport\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,109:1\n1803#2,3:110\n*S KotlinDebug\n*F\n+ 1 LspDiagnosticsCustomizer.kt\ncom/intellij/platform/lsp/api/customization/LspDiagnosticsSupport\n*L\n69#1:110,3\n*E\n"})
public non-sealed class LspDiagnosticsSupport
extends LspDiagnosticsCustomizer {
    public LspDiagnosticsSupport() {
        super(null);
    }

    public boolean shouldAskServerForDiagnostics(@NotNull VirtualFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        return true;
    }

    @RequiresReadLock
    @RequiresBackgroundThread
    public void createAnnotation(@NotNull AnnotationHolder holder, @NotNull Diagnostic diagnostic, @NotNull TextRange textRange, @NotNull List<? extends IntentionAction> quickFixes) {
        int n10;
        Document document;
        Object object;
        AnnotationBuilder annotationBuilder;
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        Intrinsics.checkNotNullParameter((Object)diagnostic, (String)"diagnostic");
        Intrinsics.checkNotNullParameter((Object)textRange, (String)"textRange");
        Intrinsics.checkNotNullParameter(quickFixes, (String)"quickFixes");
        HighlightSeverity highlightSeverity = this.getHighlightSeverity(diagnostic);
        if (highlightSeverity == null) {
            return;
        }
        HighlightSeverity highlightSeverity2 = highlightSeverity;
        AnnotationBuilder annotationBuilder2 = holder.newAnnotation(highlightSeverity2, this.getMessage(diagnostic)).tooltip(this.getTooltip(diagnostic)).range(textRange);
        boolean bl2 = false;
        if (!textRange.isEmpty()) {
            annotationBuilder = annotationBuilder2;
        } else {
            PsiFile psiFile = holder.getCurrentAnnotationSession().getFile();
            Intrinsics.checkNotNullExpressionValue((Object)psiFile, (String)"getFile(...)");
            object = psiFile;
            Document document2 = PsiDocumentManager.getInstance((Project)object.getProject()).getDocument((PsiFile)object);
            if (document2 == null) {
                annotationBuilder = annotationBuilder2;
            } else {
                document = document2;
                n10 = document.getLineNumber(textRange.getStartOffset());
                int n11 = document.getLineEndOffset(n10);
                annotationBuilder = textRange.getStartOffset() == n11 ? annotationBuilder2.afterEndOfLine() : annotationBuilder2;
            }
        }
        annotationBuilder2 = annotationBuilder;
        bl2 = false;
        object = this.getSpecialHighlightType(diagnostic);
        PsiFile psiFile = object;
        annotationBuilder2 = psiFile != null ? annotationBuilder2.highlightType((ProblemHighlightType)psiFile) : annotationBuilder2;
        bl2 = false;
        object = this.getEnforcedTextAttributes(diagnostic);
        PsiFile psiFile2 = object;
        annotationBuilder2 = psiFile2 != null ? annotationBuilder2.enforcedTextAttributes((TextAttributes)psiFile2) : annotationBuilder2;
        bl2 = false;
        object = this.customizeQuickFixes(diagnostic, quickFixes);
        document = annotationBuilder2;
        n10 = 0;
        Document document3 = document;
        Iterator iterator = object.iterator();
        while (iterator.hasNext()) {
            Object t2 = iterator.next();
            IntentionAction intentionAction = (IntentionAction)t2;
            Document document4 = document3;
            boolean bl3 = false;
            document3 = document4.withFix(intentionAction);
        }
        document3.create();
    }

    @Nullable
    public HighlightSeverity getHighlightSeverity(@NotNull Diagnostic diagnostic) {
        Intrinsics.checkNotNullParameter((Object)diagnostic, (String)"diagnostic");
        DiagnosticSeverity diagnosticSeverity = diagnostic.getSeverity();
        return switch (diagnosticSeverity == null ? -1 : WhenMappings.$EnumSwitchMapping$0[diagnosticSeverity.ordinal()]) {
            case 1 -> HighlightSeverity.ERROR;
            case 2 -> HighlightSeverity.WARNING;
            default -> HighlightSeverity.WEAK_WARNING;
        };
    }

    @InspectionMessage
    @NotNull
    public String getMessage(@NotNull Diagnostic diagnostic) {
        Intrinsics.checkNotNullParameter((Object)diagnostic, (String)"diagnostic");
        String string = diagnostic.getMessage();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getMessage(...)");
        return string;
    }

    @NlsContexts.Tooltip
    @NotNull
    public String getTooltip(@NotNull Diagnostic diagnostic) {
        Intrinsics.checkNotNullParameter((Object)diagnostic, (String)"diagnostic");
        String string = diagnostic.getMessage();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getMessage(...)");
        return string;
    }

    @Nullable
    public ProblemHighlightType getSpecialHighlightType(@NotNull Diagnostic diagnostic) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)diagnostic, (String)"diagnostic");
        List list = diagnostic.getTags();
        boolean bl2 = list != null ? list.contains(DiagnosticTag.Unnecessary) : false;
        if (bl2) {
            object = ProblemHighlightType.LIKE_UNUSED_SYMBOL;
        } else {
            List list2 = diagnostic.getTags();
            object = (list2 != null ? list2.contains(DiagnosticTag.Deprecated) : false) ? ProblemHighlightType.LIKE_DEPRECATED : null;
        }
        return object;
    }

    @ApiStatus.Experimental
    @Nullable
    public TextAttributes getEnforcedTextAttributes(@NotNull Diagnostic diagnostic) {
        Intrinsics.checkNotNullParameter((Object)diagnostic, (String)"diagnostic");
        return null;
    }

    @ApiStatus.Internal
    @ApiStatus.Experimental
    @NotNull
    public List<IntentionAction> customizeQuickFixes(@NotNull Diagnostic diagnostic, @NotNull List<? extends IntentionAction> quickFixes) {
        Intrinsics.checkNotNullParameter((Object)diagnostic, (String)"diagnostic");
        Intrinsics.checkNotNullParameter(quickFixes, (String)"quickFixes");
        return quickFixes;
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[DiagnosticSeverity.values().length];
            try {
                nArray[DiagnosticSeverity.Error.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DiagnosticSeverity.Warning.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

