/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.graph.impl.threading;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.graph.impl.threading.GraphThreadingService;
import com.intellij.openapi.graph.threading.GraphActionExecutor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.util.ThrowableRunnable;
import com.intellij.util.concurrency.ThreadingAssertions;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineDispatcher;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000p\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0010\u0003\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u0007\u0018\u0000 >2\u00020\u0001:\u0001>B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u0017\u001a\u00020\u0018H\u0016J\b\u0010\u0019\u001a\u00020\u0018H\u0016J\b\u0010\u001a\u001a\u00020\u0018H\u0016J\u0016\u0010\u001b\u001a\u00020\u00182\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001e0\u001dH\u0016J'\u0010\u001f\u001a\u0002H \"\u0004\b\u0000\u0010 2\u0012\u0010!\u001a\u000e\u0012\u0004\u0012\u0002H \u0012\u0004\u0012\u00020\u001e0\"H\u0016\u00a2\u0006\u0002\u0010#J\u0016\u0010$\u001a\u00020\u00182\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001e0\u001dH\u0016J\u0016\u0010%\u001a\u00020\u00182\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001e0\u001dH\u0016J\u0016\u0010&\u001a\u00020\u00182\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001e0\u001dH\u0016J'\u0010'\u001a\u0002H \"\u0004\b\u0000\u0010 2\u0012\u0010!\u001a\u000e\u0012\u0004\u0012\u0002H \u0012\u0004\u0012\u00020\u001e0\"H\u0016\u00a2\u0006\u0002\u0010#J5\u0010(\u001a\u0004\u0018\u0001H \"\u0004\b\u0000\u0010 2\b\u0010)\u001a\u0004\u0018\u0001H 2\u0014\u0010!\u001a\u0010\u0012\u0006\u0012\u0004\u0018\u0001H \u0012\u0004\u0012\u00020\u001e0\"H\u0016\u00a2\u0006\u0002\u0010*J'\u0010+\u001a\u0002H \"\u0004\b\u0000\u0010 2\u0012\u0010!\u001a\u000e\u0012\u0004\u0012\u0002H \u0012\u0004\u0012\u00020\u001e0\"H\u0016\u00a2\u0006\u0002\u0010#J\u0016\u0010,\u001a\b\u0012\u0004\u0012\u00020.0-2\u0006\u0010\u001c\u001a\u00020/H\u0016J\u0016\u00100\u001a\b\u0012\u0004\u0012\u00020.0-2\u0006\u0010\u001c\u001a\u00020/H\u0016J\u001c\u00101\u001a\u00020\u0018\"\u0004\b\u0000\u0010 2\f\u00102\u001a\b\u0012\u0004\u0012\u0002H 03H\u0002J!\u00104\u001a\u0002H \"\u0004\b\u0000\u0010 2\f\u00102\u001a\b\u0012\u0004\u0012\u0002H 03H\u0002\u00a2\u0006\u0002\u00105J1\u00106\u001a\u0004\u0018\u0001H \"\u0004\b\u0000\u0010 2\n\b\u0002\u0010)\u001a\u0004\u0018\u0001H 2\u000e\u00102\u001a\n\u0012\u0006\u0012\u0004\u0018\u0001H 03H\u0002\u00a2\u0006\u0002\u00107J!\u00108\u001a\u0002H \"\u0004\b\u0000\u0010 2\f\u00102\u001a\b\u0012\u0004\u0012\u0002H 03H\u0002\u00a2\u0006\u0002\u00105J!\u00109\u001a\u0002H \"\u0004\b\u0000\u0010 2\f\u00102\u001a\b\u0012\u0004\u0012\u0002H 03H\u0002\u00a2\u0006\u0002\u00105J\b\u0010:\u001a\u00020;H\u0002J\b\u0010<\u001a\u00020;H\u0002J\b\u0010=\u001a\u00020;H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R2\u0010\b\u001a&\u0012\f\u0012\n \u000b*\u0004\u0018\u00010\n0\n \u000b*\u0012\u0012\f\u0012\n \u000b*\u0004\u0018\u00010\n0\n\u0018\u00010\t0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R2\u0010\f\u001a&\u0012\f\u0012\n \u000b*\u0004\u0018\u00010\n0\n \u000b*\u0012\u0012\f\u0012\n \u000b*\u0004\u0018\u00010\n0\n\u0018\u00010\t0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\u00020\u000e8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010R\u0014\u0010\u0011\u001a\u00020\u00128VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014R\u0014\u0010\u0015\u001a\u00020\u00128VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0014\u00a8\u0006?"}, d2={"Lcom/intellij/openapi/graph/impl/threading/GraphThreadActionExecutor;", "Lcom/intellij/openapi/graph/threading/GraphActionExecutor;", "project", "Lcom/intellij/openapi/project/Project;", "GraphThreadActionExecutor", "(Lcom/intellij/openapi/project/Project;)V", "myGraphLock", "Ljava/util/concurrent/locks/ReentrantReadWriteLock;", "myReadLockCount", "Ljava/lang/ThreadLocal;", "", "kotlin.jvm.PlatformType", "mySuppressReadLockAssertionCount", "graphDispatcher", "Lkotlinx/coroutines/CoroutineDispatcher;", "getGraphDispatcher", "()Lkotlinx/coroutines/CoroutineDispatcher;", "graphExecutor", "Ljava/util/concurrent/Executor;", "getGraphExecutor", "()Ljava/util/concurrent/Executor;", "writeExecutor", "getWriteExecutor", "assertGraphThread", "", "assertReadAccess", "assertWriteAccess", "suppressRunnableReadLockAssertion", "runnable", "Lcom/intellij/util/ThrowableRunnable;", "", "suppressComputableReadLockAssertion", "T", "computable", "Lcom/intellij/openapi/util/ThrowableComputable;", "(Lcom/intellij/openapi/util/ThrowableComputable;)Ljava/lang/Object;", "runReadAction", "tryRunReadAction", "runWriteAction", "computeReadAction", "tryComputeReadAction", "defaultResult", "(Ljava/lang/Object;Lcom/intellij/openapi/util/ThrowableComputable;)Ljava/lang/Object;", "computeWriteAction", "runGraphActionAsync", "Ljava/util/concurrent/CompletableFuture;", "Ljava/lang/Void;", "Ljava/lang/Runnable;", "runWriteActionAsync", "n", "func", "Lkotlin/Function0;", "r", "(Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "n", "(Ljava/lang/Object;Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "s", "n", "n", "", "r", "s", "Companion", "intellij.platform.graph.impl"})
@ApiStatus.Experimental
public final class GraphThreadActionExecutor
implements GraphActionExecutor {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private final ReentrantReadWriteLock myGraphLock;
    private final ThreadLocal<Integer> myReadLockCount;
    private final ThreadLocal<Integer> mySuppressReadLockAssertionCount;
    @NotNull
    public static final String GRAPH_THREAD_NAME = "DiagramScheduler";
    @NotNull
    private static final Logger LOG;

    public GraphThreadActionExecutor(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        this.myGraphLock = new ReentrantReadWriteLock();
        this.myReadLockCount = ThreadLocal.withInitial(GraphThreadActionExecutor::n);
        this.mySuppressReadLockAssertionCount = ThreadLocal.withInitial(GraphThreadActionExecutor::s);
    }

    @NotNull
    public CoroutineDispatcher getGraphDispatcher() {
        return GraphThreadingService.Companion.getGraphDispatcher(this.project);
    }

    @NotNull
    public Executor getGraphExecutor() {
        return arg_0 -> GraphThreadActionExecutor.n(this, arg_0);
    }

    @NotNull
    public Executor getWriteExecutor() {
        Function1 function1 = (Function1)new Function1<Runnable, Unit>((Object)this){

            public final void invoke(Runnable p0) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                ((GraphThreadActionExecutor)this.receiver).runWriteActionAsync(p0);
            }
        };
        return new Executor(function1){
            private final /* synthetic */ Function1 function;
            {
                Intrinsics.checkNotNullParameter((Object)function, (String)"function");
                this.function = function;
            }

            public final /* synthetic */ void execute(Runnable p0) {
                this.function.invoke((Object)p0);
            }
        };
    }

    public void assertGraphThread() {
        if (!this.n()) {
            LOG.error("Method should be accessed only from Graph thread.");
        }
    }

    public void assertReadAccess() {
        if (!this.r()) {
            LOG.error("Method should be accessed only under Graph read lock.");
        }
    }

    public void assertWriteAccess() {
        this.assertGraphThread();
        if (!this.myGraphLock.isWriteLockedByCurrentThread()) {
            LOG.error("Method should be accessed only under Graph write lock.");
        }
    }

    public void suppressRunnableReadLockAssertion(@NotNull ThrowableRunnable<Throwable> runnable) {
        Intrinsics.checkNotNullParameter(runnable, (String)"runnable");
        this.n((Function0)new Function0<Unit>(runnable){

            public final void invoke() {
                ((ThrowableRunnable)this.receiver).run();
            }
        });
    }

    public <T> T suppressComputableReadLockAssertion(@NotNull ThrowableComputable<T, Throwable> computable) {
        Intrinsics.checkNotNullParameter(computable, (String)"computable");
        return this.n((Function0)new Function0<T>(computable){

            public final T invoke() {
                return (T)((ThrowableComputable)this.receiver).compute();
            }
        });
    }

    public void runReadAction(@NotNull ThrowableRunnable<Throwable> runnable) {
        Intrinsics.checkNotNullParameter(runnable, (String)"runnable");
        this.r((Function0)new Function0<Unit>(runnable){

            public final void invoke() {
                ((ThrowableRunnable)this.receiver).run();
            }
        });
    }

    public void tryRunReadAction(@NotNull ThrowableRunnable<Throwable> runnable) {
        Intrinsics.checkNotNullParameter(runnable, (String)"runnable");
        GraphThreadActionExecutor.tryRunUnderReadLock$default(this, null, () -> GraphThreadActionExecutor.n(runnable), 1, null);
    }

    public void runWriteAction(@NotNull ThrowableRunnable<Throwable> runnable) {
        Intrinsics.checkNotNullParameter(runnable, (String)"runnable");
        this.s((Function0)new Function0<Unit>(runnable){

            public final void invoke() {
                ((ThrowableRunnable)this.receiver).run();
            }
        });
    }

    public <T> T computeReadAction(@NotNull ThrowableComputable<T, Throwable> computable) {
        Intrinsics.checkNotNullParameter(computable, (String)"computable");
        return this.r((Function0)new Function0<T>(computable){

            public final T invoke() {
                return (T)((ThrowableComputable)this.receiver).compute();
            }
        });
    }

    @Nullable
    public <T> T tryComputeReadAction(@Nullable T defaultResult, @NotNull ThrowableComputable<T, Throwable> computable) {
        Intrinsics.checkNotNullParameter(computable, (String)"computable");
        return this.n(defaultResult, (Function0)new Function0<T>(computable){

            public final T invoke() {
                return (T)((ThrowableComputable)this.receiver).compute();
            }
        });
    }

    public <T> T computeWriteAction(@NotNull ThrowableComputable<T, Throwable> computable) {
        Intrinsics.checkNotNullParameter(computable, (String)"computable");
        return this.s((Function0)new Function0<T>(computable){

            public final T invoke() {
                return (T)((ThrowableComputable)this.receiver).compute();
            }
        });
    }

    @NotNull
    public CompletableFuture<Void> runGraphActionAsync(@NotNull Runnable runnable) {
        Intrinsics.checkNotNullParameter((Object)runnable, (String)"runnable");
        CompletableFuture<Void> completableFuture = CompletableFuture.runAsync(runnable::run, this.getGraphExecutor());
        Intrinsics.checkNotNullExpressionValue(completableFuture, (String)"runAsync(...)");
        return completableFuture;
    }

    @NotNull
    public CompletableFuture<Void> runWriteActionAsync(@NotNull Runnable runnable) {
        Intrinsics.checkNotNullParameter((Object)runnable, (String)"runnable");
        return this.runGraphActionAsync(() -> GraphThreadActionExecutor.s(this, runnable));
    }

    private final <T> void n(Function0<? extends T> function0) {
        Object object = this.n() ? function0.invoke() : BuildersKt.launch$default((CoroutineScope)GraphThreadingService.Companion.getGraphScope(this.project), (CoroutineContext)((CoroutineContext)this.getGraphDispatcher()), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(function0, null){
            int label;
            final /* synthetic */ Function0<T> $func;
            {
                this.$func = $func;
                super(2, $completion);
            }

            public final Object invokeSuspend(Object $result) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        this.$func.invoke();
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)2, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final <T> T r(Function0<? extends T> function0) {
        if (!this.s()) {
            ThreadingAssertions.assertNoReadAccess();
        }
        ReentrantReadWriteLock.ReadLock readLock = this.myGraphLock.readLock();
        readLock.lock();
        try {
            Object object;
            boolean bl2 = false;
            this.myReadLockCount.set(((Number)this.myReadLockCount.get()).intValue() + 1);
            try {
                Object object2 = function0.invoke();
                this.myReadLockCount.set(((Number)this.myReadLockCount.get()).intValue() - 1);
                object = object2;
            }
            catch (Throwable throwable) {
                this.myReadLockCount.set(((Number)this.myReadLockCount.get()).intValue() - 1);
                throw throwable;
            }
            return (T)object;
        }
        finally {
            readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final <T> T n(T t2, Function0<? extends T> function0) {
        Object object;
        boolean bl2 = this.myGraphLock.readLock().tryLock();
        if (bl2) {
            Object object2;
            this.myReadLockCount.set(((Number)this.myReadLockCount.get()).intValue() + 1);
            try {
                object2 = function0.invoke();
            }
            finally {
                this.myReadLockCount.set(((Number)this.myReadLockCount.get()).intValue() - 1);
                this.myGraphLock.readLock().unlock();
            }
            object = object2;
        } else {
            object = t2;
        }
        return object;
    }

    static /* synthetic */ Object tryRunUnderReadLock$default(GraphThreadActionExecutor graphThreadActionExecutor, Object object, Function0 function0, int n10, Object object2) {
        if ((n10 & 1) != 0) {
            object = null;
        }
        return graphThreadActionExecutor.n(object, function0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final <T> T s(Function0<? extends T> function0) {
        if (!this.s()) {
            ThreadingAssertions.assertNoReadAccess();
        }
        this.assertGraphThread();
        ReentrantReadWriteLock reentrantReadWriteLock = this.myGraphLock;
        ReentrantReadWriteLock.ReadLock readLock = reentrantReadWriteLock.readLock();
        int n10 = reentrantReadWriteLock.getWriteHoldCount() == 0 ? reentrantReadWriteLock.getReadHoldCount() : 0;
        for (int i2 = 0; i2 < n10; ++i2) {
            readLock.unlock();
        }
        ReentrantReadWriteLock.WriteLock writeLock = reentrantReadWriteLock.writeLock();
        writeLock.lock();
        try {
            boolean bl2 = false;
            Object object = function0.invoke();
            return (T)object;
        }
        finally {
            for (int i3 = 0; i3 < n10; ++i3) {
                readLock.lock();
            }
            writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final <T> T n(Function0<? extends T> function0) {
        this.mySuppressReadLockAssertionCount.set(((Number)this.mySuppressReadLockAssertionCount.get()).intValue() + 1);
        try {
            Object object = function0.invoke();
            return (T)object;
        }
        finally {
            this.mySuppressReadLockAssertionCount.set(((Number)this.mySuppressReadLockAssertionCount.get()).intValue() - 1);
        }
    }

    private final boolean n() {
        return Intrinsics.areEqual((Object)Thread.currentThread(), (Object)GraphThreadingService.Companion.getGraphThread(this.project));
    }

    private final boolean r() {
        Integer n10 = this.myReadLockCount.get();
        return n10 == null || n10 != 0 || this.n();
    }

    private final boolean s() {
        Integer n10 = this.mySuppressReadLockAssertionCount.get();
        return n10 == null || n10 != 0;
    }

    private static final Integer n() {
        return 0;
    }

    private static final Integer s() {
        return 0;
    }

    private static final void n(GraphThreadActionExecutor graphThreadActionExecutor, Runnable runnable) {
        Intrinsics.checkNotNull((Object)runnable);
        graphThreadActionExecutor.n((Function0)new Function0<Unit>((Object)runnable){

            public final void invoke() {
                ((Runnable)this.receiver).run();
            }
        });
    }

    private static final Unit n(ThrowableRunnable throwableRunnable) {
        throwableRunnable.run();
        return Unit.INSTANCE;
    }

    private static final void s(GraphThreadActionExecutor graphThreadActionExecutor, Runnable runnable) {
        graphThreadActionExecutor.s((Function0)new Function0<Unit>((Object)runnable){

            public final void invoke() {
                ((Runnable)this.receiver).run();
            }
        });
    }

    static {
        Logger logger = Logger.getInstance(GraphThreadActionExecutor.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0006\u001a\u00070\u0007\u00a2\u0006\u0002\b\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lcom/intellij/openapi/graph/impl/threading/GraphThreadActionExecutor$Companion;", "", "GraphThreadActionExecutor$Companion", "()V", "GRAPH_THREAD_NAME", "", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "intellij.platform.graph.impl"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

