/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.appServers.run.configuration.view;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.ConfigurationPerRunnerSettings;
import com.intellij.execution.configurations.JavaParameters;
import com.intellij.execution.configurations.ParametersList;
import com.intellij.execution.configurations.RunProfile;
import com.intellij.execution.configurations.RunnerSettings;
import com.intellij.execution.runners.JvmPatchableProgramRunner;
import com.intellij.execution.ui.ConfigurationArgumentsHelpArea;
import com.intellij.javaee.appServers.AppServersIntegrationBundle;
import com.intellij.javaee.appServers.run.configuration.CommonStrategy;
import com.intellij.javaee.appServers.run.configuration.RunnerSpecificConfigurationBit;
import com.intellij.openapi.options.SettingsEditor;
import com.intellij.openapi.util.text.StringUtil;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;

public final class RunnerSpecificRemotePanel
extends SettingsEditor<ConfigurationPerRunnerSettings> {
    private final JvmPatchableProgramRunner<?> myJavaProgramRunner;
    private ConfigurationArgumentsHelpArea myHelpArea;

    public RunnerSpecificRemotePanel(JvmPatchableProgramRunner<?> runner) {
        this.myJavaProgramRunner = runner;
    }

    private static String getActionText(@NotNull JvmPatchableProgramRunner<?> runner) {
        if (runner == null) {
            RunnerSpecificRemotePanel.$$$reportNull$$$0(0);
        }
        return StringUtil.toLowerCase((String)runner.getRunnerId());
    }

    public void resetEditorFrom(@NotNull ConfigurationPerRunnerSettings item) {
        if (item == null) {
            RunnerSpecificRemotePanel.$$$reportNull$$$0(1);
        }
        RunnerSpecificConfigurationBit runnerSpecificConfigurationBit = (RunnerSpecificConfigurationBit)item;
        this.updateHelpArea(runnerSpecificConfigurationBit.getParentConfiguration(), runnerSpecificConfigurationBit.getRunnerSettings());
    }

    public void applyEditorTo(@NotNull ConfigurationPerRunnerSettings commonModel) {
        if (commonModel == null) {
            RunnerSpecificRemotePanel.$$$reportNull$$$0(2);
        }
    }

    @NotNull
    public JComponent createEditor() {
        this.myHelpArea = new ConfigurationArgumentsHelpArea();
        this.myHelpArea.setLabelText(AppServersIntegrationBundle.message((String)"label.run.configuration.editor.add.vm.parameters", (Object[])new Object[]{RunnerSpecificRemotePanel.getActionText(this.myJavaProgramRunner)}));
        ConfigurationArgumentsHelpArea configurationArgumentsHelpArea = this.myHelpArea;
        if (configurationArgumentsHelpArea == null) {
            RunnerSpecificRemotePanel.$$$reportNull$$$0(3);
        }
        return configurationArgumentsHelpArea;
    }

    private String evaluatePatchedParameters(CommonStrategy runProfile, RunnerSettings runnerSettings) throws ExecutionException {
        JavaParameters javaParameters = new JavaParameters();
        javaParameters.setJdk(runProfile.getJre());
        this.myJavaProgramRunner.patch(javaParameters, runnerSettings, (RunProfile)runProfile, false);
        ParametersList vmParametersList = javaParameters.getVMParametersList();
        if (vmParametersList.getArray().length == 0) {
            return AppServersIntegrationBundle.message((String)"message.text.run.configuration.editor.no.specific.parameters.needed", (Object[])new Object[0]);
        }
        return vmParametersList.getParametersString();
    }

    private void updateHelpArea(CommonStrategy runProfile, RunnerSettings runnerSettings) {
        try {
            this.myHelpArea.updateText(this.evaluatePatchedParameters(runProfile, runnerSettings));
        }
        catch (ExecutionException executionException) {
            // empty catch block
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runner";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "item";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commonModel";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/javaee/appServers/run/configuration/view/RunnerSpecificRemotePanel";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/javaee/appServers/run/configuration/view/RunnerSpecificRemotePanel";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "createEditor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getActionText";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "resetEditorFrom";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "applyEditorTo";
                break;
            }
            case 3: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3 -> new IllegalStateException(string);
        };
    }
}

