/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.thinclient.terminal;

import com.intellij.codeWithMe.ClientId;
import com.intellij.cwm.frontend.following.ToolwindowUtilKt;
import com.intellij.cwm.plugin.common.users.UserManager;
import com.intellij.cwm.plugin.common.users.UserManagerKt;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.project.Project;
import com.intellij.terminal.JBTerminalWidget;
import com.intellij.terminal.ui.TerminalWidget;
import com.intellij.util.ApplicationKt;
import com.jetbrains.codeWithMe.model.RdTerminalSession;
import com.jetbrains.codeWithMe.model.RdTerminalSessionOrigin;
import com.jetbrains.codeWithMe.model.RdTerminalTitle;
import com.jetbrains.codeWithMe.model.RdUserModel;
import com.jetbrains.codeWithMe.model.TerminalModel;
import com.jetbrains.rd.platform.util.idea.LifetimedService;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.thinclient.PlatformFrontendSplitBundle;
import com.jetbrains.thinclient.terminal.NoAccessTab;
import com.jetbrains.thinclient.terminal.ThinClientTerminalRunnerKt;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import kotlinx.coroutines.CompletableDeferred;
import kotlinx.coroutines.CompletableDeferredKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.terminal.TerminalToolWindowManager;
import org.jetbrains.plugins.terminal.ui.TerminalContainer;

@Service(value={Service.Level.PROJECT})
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\b\u0007\u0018\u0000 \u00192\u00020\u0001:\u0001\u0019B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000e\u0010\r\u001a\u00020\fH\u0086@\u00a2\u0006\u0002\u0010\u000eJ\u0015\u0010\u000f\u001a\u00020\f2\u0006\u0010\u0006\u001a\u00020\u0007H\u0000\u00a2\u0006\u0002\b\u0010J(\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u00162\u000e\u0010\u0017\u001a\n\u0012\u0004\u0012\u00020\u0016\u0018\u00010\u0018R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lcom/jetbrains/thinclient/terminal/ThinClientTerminalHost;", "Lcom/jetbrains/rd/platform/util/idea/LifetimedService;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "model", "Lcom/jetbrains/codeWithMe/model/TerminalModel;", "sessionIndex", "", "modelBoundDeferred", "Lkotlinx/coroutines/CompletableDeferred;", "", "awaitModelBinding", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "bindWithModel", "bindWithModel$intellij_terminal_frontend_split", "getOrCreate", "Lcom/jetbrains/codeWithMe/model/RdTerminalSession;", "lifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "workingDirectory", "", "shellCommand", "", "Companion", "intellij.terminal.frontend.split"})
public final class ThinClientTerminalHost
extends LifetimedService {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    private TerminalModel model;
    private int sessionIndex;
    @NotNull
    private final CompletableDeferred<Unit> modelBoundDeferred;
    @NotNull
    private static final String SessionPrefix = "SessionId#";
    @NotNull
    public static final String followPrivateTerminalDir = "FollowHostPrivateTab";

    public ThinClientTerminalHost(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        this.modelBoundDeferred = CompletableDeferredKt.CompletableDeferred$default(null, (int)1, null);
    }

    @Nullable
    public final Object awaitModelBinding(@NotNull Continuation<? super Unit> $completion) {
        Object object = this.modelBoundDeferred.await($completion);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    public final void bindWithModel$intellij_terminal_frontend_split(@NotNull TerminalModel model) {
        Intrinsics.checkNotNullParameter((Object)model, (String)"model");
        this.model = model;
        model.getSessions().view(this.getServiceLifetime(), (arg_0, arg_1, arg_2) -> ThinClientTerminalHost.bindWithModel$lambda$0(this, arg_0, arg_1, arg_2));
        ToolwindowUtilKt.followContentsWhenFollowing((Project)this.project, (String)"Terminal", (Lifetime)this.getServiceLifetime(), (arg_0, arg_1) -> ThinClientTerminalHost.bindWithModel$lambda$1(this, arg_0, arg_1));
        this.modelBoundDeferred.complete((Object)Unit.INSTANCE);
    }

    @NotNull
    public final RdTerminalSession getOrCreate(@NotNull Lifetime lifetime, @Nullable String workingDirectory, @Nullable List<String> shellCommand) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)lifetime, (String)"lifetime");
        if (Companion.isRemoteDirectory(workingDirectory)) {
            String string = workingDirectory;
            Intrinsics.checkNotNull((Object)string);
            object = StringsKt.removePrefix((String)string, (CharSequence)SessionPrefix);
        } else {
            int n = this.sessionIndex;
            this.sessionIndex = n + 1;
            object = ClientId.Companion.getLocalId().getValue() + n;
        }
        String sessionId = object;
        lifetime.onTermination(() -> ThinClientTerminalHost.getOrCreate$lambda$0(this, sessionId));
        Ref.ObjectRef session = new Ref.ObjectRef();
        ApplicationKt.getApplication().invokeAndWait(() -> ThinClientTerminalHost.getOrCreate$lambda$1(session, this, sessionId, shellCommand, workingDirectory));
        Object object2 = session.element;
        Intrinsics.checkNotNull((Object)object2);
        return (RdTerminalSession)object2;
    }

    private static final Unit bindWithModel$lambda$0(ThinClientTerminalHost this$0, Lifetime lifetime, String sessionId, RdTerminalSession session) {
        Intrinsics.checkNotNullParameter((Object)lifetime, (String)"<unused var>");
        Intrinsics.checkNotNullParameter((Object)sessionId, (String)"sessionId");
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        if (StringsKt.startsWith$default((String)sessionId, (String)ClientId.Companion.getLocalId().getValue(), (boolean)false, (int)2, null)) {
            return Unit.INSTANCE;
        }
        RdTerminalTitle rdTerminalTitle = (RdTerminalTitle)session.getTitle().getValue();
        TerminalToolWindowManager.getInstance((Project)this$0.project).createShellWidget(SessionPrefix + sessionId, rdTerminalTitle != null ? rdTerminalTitle.getDefaultTitle() : null, true, true);
        return Unit.INSTANCE;
    }

    private static final Unit bindWithModel$lambda$1(ThinClientTerminalHost this$0, Lifetime lt, RdUserModel lead) {
        Intrinsics.checkNotNullParameter((Object)lt, (String)"lt");
        Intrinsics.checkNotNullParameter((Object)lead, (String)"lead");
        if (Intrinsics.areEqual((Object)lead, (Object)UserManagerKt.getHost((UserManager)UserManager.Companion.getInstance(this$0.project)))) {
            TerminalToolWindowManager manager = TerminalToolWindowManager.getInstance((Project)this$0.project);
            Intrinsics.checkNotNull((Object)manager);
            TerminalContainer privateTab = ThinClientTerminalRunnerKt.findNoAccessTab(manager);
            if (privateTab != null) {
                JBTerminalWidget jBTerminalWidget = JBTerminalWidget.asJediTermWidget((TerminalWidget)privateTab.getTerminalWidget());
                NoAccessTab noAccessTab = jBTerminalWidget instanceof NoAccessTab ? (NoAccessTab)jBTerminalWidget : null;
                if (noAccessTab != null) {
                    noAccessTab.updateEmptyText$intellij_terminal_frontend_split(true);
                }
                manager.getToolWindow().getContentManager().setSelectedContent(privateTab.getContent());
                lt.onTermination(() -> ThinClientTerminalHost.bindWithModel$lambda$1$0(privateTab));
            } else {
                TerminalWidget terminalWidget = manager.createShellWidget(followPrivateTerminalDir, null, true, true);
                Intrinsics.checkNotNullExpressionValue((Object)terminalWidget, (String)"createShellWidget(...)");
                TerminalWidget widget2 = terminalWidget;
                lt.onTermination(() -> ThinClientTerminalHost.bindWithModel$lambda$1$1(manager, widget2));
            }
        }
        return Unit.INSTANCE;
    }

    private static final Unit bindWithModel$lambda$1$0(TerminalContainer $privateTab) {
        $privateTab.closeAndHide();
        return Unit.INSTANCE;
    }

    private static final Unit bindWithModel$lambda$1$1(TerminalToolWindowManager $manager, TerminalWidget $widget) {
        block0: {
            TerminalContainer terminalContainer = $manager.getContainer($widget);
            if (terminalContainer == null) break block0;
            terminalContainer.closeAndHide();
        }
        return Unit.INSTANCE;
    }

    private static final Unit getOrCreate$lambda$0(ThinClientTerminalHost this$0, String $sessionId) {
        ApplicationKt.getApplication().invokeLater(() -> ThinClientTerminalHost.getOrCreate$lambda$0$0(this$0, $sessionId));
        return Unit.INSTANCE;
    }

    private static final void getOrCreate$lambda$0$0(ThinClientTerminalHost this$0, String $sessionId) {
        TerminalModel terminalModel = this$0.model;
        if (terminalModel == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"model");
            terminalModel = null;
        }
        terminalModel.getSessions().remove((Object)$sessionId);
    }

    /*
     * WARNING - void declaration
     */
    private static final void getOrCreate$lambda$1(Ref.ObjectRef $session, ThinClientTerminalHost this$0, String $sessionId, List $shellCommand, String $workingDirectory) {
        RdTerminalSession rdTerminalSession;
        Ref.ObjectRef objectRef = $session;
        TerminalModel terminalModel = this$0.model;
        if (terminalModel == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"model");
            terminalModel = null;
        }
        if ((rdTerminalSession = (RdTerminalSession)terminalModel.getSessions().get((Object)$sessionId)) == null) {
            RdTerminalSession rdTerminalSession2;
            RdTerminalSession rdTerminalSession3 = rdTerminalSession2 = new RdTerminalSession(RdTerminalSessionOrigin.Client, $shellCommand);
            Ref.ObjectRef objectRef2 = objectRef;
            boolean bl = false;
            if (!Intrinsics.areEqual((Object)$workingDirectory, (Object)followPrivateTerminalDir)) {
                void $this$getOrCreate_u24lambda_u241_u240;
                $this$getOrCreate_u24lambda_u241_u240.getTitle().set((Object)new RdTerminalTitle(null, null, PlatformFrontendSplitBundle.INSTANCE.message("terminal.session.tab.name", new Object[0])));
                TerminalModel terminalModel2 = this$0.model;
                if (terminalModel2 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"model");
                    terminalModel2 = null;
                }
                ((Map)terminalModel2.getSessions()).put($sessionId, $this$getOrCreate_u24lambda_u241_u240);
            }
            objectRef = objectRef2;
            rdTerminalSession = rdTerminalSession2;
        }
        objectRef.element = rdTerminalSession;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007J\u0010\u0010\b\u001a\u00020\t2\b\u0010\n\u001a\u0004\u0018\u00010\u000bR\u000e\u0010\f\u001a\u00020\u000bX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000bX\u0080T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/jetbrains/thinclient/terminal/ThinClientTerminalHost$Companion;", "", "<init>", "()V", "getInstance", "Lcom/jetbrains/thinclient/terminal/ThinClientTerminalHost;", "project", "Lcom/intellij/openapi/project/Project;", "isRemoteDirectory", "", "workingDirectory", "", "SessionPrefix", "followPrivateTerminalDir", "intellij.terminal.frontend.split"})
    @SourceDebugExtension(value={"SMAP\nThinClientTerminalHost.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ThinClientTerminalHost.kt\ncom/jetbrains/thinclient/terminal/ThinClientTerminalHost$Companion\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,101:1\n30#2,2:102\n*S KotlinDebug\n*F\n+ 1 ThinClientTerminalHost.kt\ncom/jetbrains/thinclient/terminal/ThinClientTerminalHost$Companion\n*L\n33#1:102,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final ThinClientTerminalHost getInstance(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            ComponentManager $this$service$iv = (ComponentManager)project;
            boolean $i$f$service = false;
            Class<ThinClientTerminalHost> serviceClass$iv = ThinClientTerminalHost.class;
            Object object = $this$service$iv.getService(serviceClass$iv);
            if (object == null) {
                throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
            }
            return (ThinClientTerminalHost)((Object)object);
        }

        public final boolean isRemoteDirectory(@Nullable String workingDirectory) {
            String string = workingDirectory;
            return string != null ? StringsKt.startsWith$default((String)string, (String)ThinClientTerminalHost.SessionPrefix, (boolean)false, (int)2, null) : false;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

