/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.persistence.mongodb.json.editor;

import com.intellij.codeInsight.CodeInsightSettings;
import com.intellij.codeInsight.editorActions.smartEnter.SmartEnterProcessor;
import com.intellij.openapi.editor.Editor;
import com.intellij.persistence.mongodb.json.MongoDBJsonElementTypes;
import com.intellij.persistence.mongodb.json.psi.MongoDBJsonArray;
import com.intellij.persistence.mongodb.json.psi.MongoDBJsonElement;
import com.intellij.persistence.mongodb.json.psi.MongoDBJsonObject;
import com.intellij.persistence.mongodb.json.psi.MongoDBJsonProperty;
import com.intellij.persistence.mongodb.json.psi.MongoDBJsonStringLiteral;
import com.intellij.persistence.mongodb.json.psi.MongoDBJsonValue;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilCore;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000.\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\f\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u001a \u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0002\u001a\u0018\u0010\b\u001a\u00020\t2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\n\u001a\u00020\u000bH\u0002\u001a\u001e\u0010\f\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007\u001a\u0010\u0010\r\u001a\u00020\t2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002\u00a8\u0006\u0010"}, d2={"handleMoveOutsideQuotes", "", "c", "", "editor", "Lcom/intellij/openapi/editor/Editor;", "file", "Lcom/intellij/psi/PsiFile;", "validatePositionToMoveOutOfQuotes", "", "element", "Lcom/intellij/psi/PsiElement;", "processMongoPairedBracesComma", "shouldAddCommaInParentContainer", "item", "Lcom/intellij/persistence/mongodb/json/psi/MongoDBJsonValue;", "intellij.javaee.persistence.impl"})
public final class MongoDBJsonTypedHandlerKt {
    private static final void handleMoveOutsideQuotes(char c, Editor editor, PsiFile file) {
        if (c == ':') {
            // empty if block
        }
        if (c == ',') {
            // empty if block
        }
    }

    private static final boolean validatePositionToMoveOutOfQuotes(char c, PsiElement element) {
        if (PsiUtilCore.getElementType((PsiElement)element) == MongoDBJsonElementTypes.R_CURLY) {
            return c == ',' && element.getPrevSibling() instanceof MongoDBJsonProperty;
        }
        if (PsiUtilCore.getElementType((PsiElement)element) == MongoDBJsonElementTypes.R_BRACKET) {
            return c == ',' && element.getPrevSibling() instanceof MongoDBJsonStringLiteral;
        }
        PsiElement parent = element.getParent();
        if (element instanceof PsiWhiteSpace && c == ',') {
            PsiElement sibling = element.getPrevSibling();
            return sibling instanceof MongoDBJsonProperty || sibling instanceof MongoDBJsonStringLiteral;
        }
        MongoDBJsonStringLiteral mongoDBJsonStringLiteral = parent instanceof MongoDBJsonStringLiteral ? (MongoDBJsonStringLiteral)parent : null;
        PsiElement grandParent = mongoDBJsonStringLiteral != null ? mongoDBJsonStringLiteral.getParent() : null;
        return !(!(grandParent instanceof MongoDBJsonProperty) || c == ':' && ((MongoDBJsonProperty)grandParent).getNameElement() != parent || c == ',' && ((MongoDBJsonProperty)grandParent).getValue() != parent);
    }

    public static final void processMongoPairedBracesComma(char c, @NotNull Editor editor, @NotNull PsiFile file) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        if (c != '[' && c != '{' && c != '\"' && c != '\'') {
            return;
        }
        SmartEnterProcessor.commitDocument((Editor)editor);
        int offset = editor.getCaretModel().getOffset();
        PsiElement psiElement = file.findElementAt(offset);
        if (psiElement == null) {
            return;
        }
        PsiElement element = psiElement;
        PsiElement parent = element.getParent();
        CodeInsightSettings codeInsightSettings = CodeInsightSettings.getInstance();
        if (((c == '[' && parent instanceof MongoDBJsonArray || c == '{' && parent instanceof MongoDBJsonObject) && codeInsightSettings.AUTOINSERT_PAIR_BRACKET || (c == '\"' || c == '\'') && parent instanceof MongoDBJsonStringLiteral && codeInsightSettings.AUTOINSERT_PAIR_QUOTE) && MongoDBJsonTypedHandlerKt.shouldAddCommaInParentContainer((MongoDBJsonValue)parent)) {
            editor.getDocument().insertString(((MongoDBJsonValue)parent).getTextRange().getEndOffset(), (CharSequence)",");
        }
    }

    private static final boolean shouldAddCommaInParentContainer(MongoDBJsonValue item) {
        PsiElement parent = item.getParent();
        if (parent instanceof MongoDBJsonArray || parent instanceof MongoDBJsonProperty) {
            PsiElement psiElement = parent;
            MongoDBJsonProperty mongoDBJsonProperty = psiElement instanceof MongoDBJsonProperty ? (MongoDBJsonProperty)psiElement : null;
            PsiElement nextElement = PsiTreeUtil.skipWhitespacesForward((PsiElement)(mongoDBJsonProperty != null ? (MongoDBJsonElement)mongoDBJsonProperty : (MongoDBJsonElement)item));
            if (nextElement instanceof PsiErrorElement) {
                PsiElement forward = PsiTreeUtil.skipWhitespacesForward((PsiElement)nextElement);
                return parent instanceof MongoDBJsonProperty ? forward instanceof MongoDBJsonProperty : forward instanceof MongoDBJsonValue;
            }
        }
        return false;
    }

    public static final /* synthetic */ void access$handleMoveOutsideQuotes(char c, Editor editor, PsiFile file) {
        MongoDBJsonTypedHandlerKt.handleMoveOutsideQuotes(c, editor, file);
    }
}

