/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jpa.highlighting;

import com.intellij.codeInsight.intention.preview.IntentionPreviewInfo;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.introspection.IndefiniteIntrospectionTask;
import com.intellij.database.introspection.IntrospectionTask;
import com.intellij.database.introspection.IntrospectionTasks;
import com.intellij.database.introspection.RunIntrospection;
import com.intellij.database.model.DasDataSource;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.psi.DbPsiFacade;
import com.intellij.database.util.DbImplUtilCore;
import com.intellij.icons.AllIcons;
import com.intellij.jpa.JpaEventsCollector;
import com.intellij.jpa.ORMReferencesUtil;
import com.intellij.jpa.SetupDatasourceResult;
import com.intellij.jpa.actions.AssignDataSourcesAction;
import com.intellij.jpa.facet.JpaConfigurationModel;
import com.intellij.jpa.highlighting.JpaHighlightingMessages;
import com.intellij.jpa.highlighting.JpaImportDatasourceService;
import com.intellij.jpa.highlighting.JpaInspectionUtil;
import com.intellij.jpa.inspections.AbstractUastJpaInspection;
import com.intellij.jpa.jpb.model.orm.ep.OrmModifiableUnitsProvider;
import com.intellij.jpa.jpb.model.orm.ep.OrmUnitsProvider;
import com.intellij.jpa.jpb.model.orm.jpa.JpaOrmFramework;
import com.intellij.jpa.jpb.model.orm.model.OrmFramework;
import com.intellij.jpa.jpb.model.orm.model.OrmModifiableUnit;
import com.intellij.jpa.jpb.model.orm.model.OrmUnit;
import com.intellij.jpa.jpb.model.orm.pu.OrmUnitSettingsDialog;
import com.intellij.jpa.jpb.model.util.OrmUtil;
import com.intellij.lang.jvm.JvmModifier;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Iconable;
import com.intellij.persistence.PersistenceHelper;
import com.intellij.persistence.facet.PersistenceFacet;
import com.intellij.persistence.model.PersistenceInheritanceType;
import com.intellij.persistence.model.PersistenceMappings;
import com.intellij.persistence.model.PersistentEntity;
import com.intellij.persistence.roles.PersistenceClassRole;
import com.intellij.persistence.roles.PersistenceClassRoleEnum;
import com.intellij.persistence.util.PersistenceUtil;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.search.searches.ClassInheritorsSearch;
import com.intellij.util.Processor;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import icons.DatabaseIcons;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.swing.Icon;
import kotlin.jvm.functions.Function1;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.uast.UAnnotated;
import org.jetbrains.uast.UClass;

public final class JpaDataSourceORMInspection
extends AbstractUastJpaInspection {
    @Override
    protected void checkClassAllRoles(UClass aClass, PersistenceClassRole[] roles, ProblemsHolder holder, boolean isOnTheFly) {
        if (ContainerUtil.find((Object[])roles, role -> role.getType() != PersistenceClassRoleEnum.ENTITY_LISTENER) == null) {
            return;
        }
        PersistenceClassRole entityRole = (PersistenceClassRole)ContainerUtil.find((Object[])roles, role -> role.getType() == PersistenceClassRoleEnum.ENTITY);
        if (entityRole != null && aClass.getJavaPsi().hasModifier(JvmModifier.ABSTRACT) && ((PersistentEntity)entityRole.getPersistentObject()).getObjectModelHelper().getInheritanceType(null) == PersistenceInheritanceType.TABLE_PER_CLASS && ClassInheritorsSearch.search((PsiClass)aClass.getJavaPsi(), (boolean)false).findFirst() != null) {
            return;
        }
        ProblemHighlightType highlightType = JpaDataSourceORMInspection.suggestHighlightingType(aClass);
        Processor processor = t -> {
            JpaInspectionUtil.checkMemberAnnotations(t, holder, ORMReferencesUtil.DataSourceRelatedReference.class, highlightType);
            return true;
        };
        JpaInspectionUtil.checkMemberAnnotations((UAnnotated)aClass, holder, ORMReferencesUtil.DataSourceRelatedReference.class, highlightType);
        ContainerUtil.process(Arrays.asList(aClass.getFields()), (Processor)processor);
        ContainerUtil.process(Arrays.asList(aClass.getMethods()), (Processor)processor);
    }

    public static LocalQuickFix[] createUnitDataSourceQuickFixes(@NotNull OrmFramework ormFramework, @Nullable PsiElement psiElement, @Nullable PersistenceMappings entityMappings) {
        List allConnections;
        Collection<Object> dataSources;
        if (ormFramework == null) {
            JpaDataSourceORMInspection.$$$reportNull$$$0(0);
        }
        SmartList quickFixes = new SmartList();
        Project project = null;
        if (ormFramework == JpaOrmFramework.INSTANCE) {
            Collection<Object> collection = dataSources = entityMappings == null ? Collections.emptyList() : PersistenceUtil.getDataSources((PersistenceMappings)entityMappings);
            if (entityMappings != null) {
                project = entityMappings.getPsiManager().getProject();
            }
        } else {
            dataSources = Optional.ofNullable(psiElement).map(PsiElement::getContainingFile).map(it -> OrmUtil.INSTANCE.getOrmUnitForPsiFile(ormFramework, it)).map(OrmUnit::getDefaultDataSourceId).map(it -> DbPsiFacade.getInstance((Project)psiElement.getProject()).findDataSource(it)).map(List::of).orElse(List.of());
            if (psiElement != null) {
                project = psiElement.getProject();
            }
        }
        List list = allConnections = entityMappings != null ? DbPsiFacade.getInstance((Project)entityMappings.getPsiManager().getProject()).getDataSources() : Collections.emptyList();
        if (allConnections.isEmpty() || allConnections.size() > dataSources.size() && (dataSources.size() > 1 || allConnections.size() > 1)) {
            quickFixes.add((Object)new SetupDataSourcesQuickFix(ormFramework, allConnections, dataSources));
        }
        for (DbDataSource dbDataSource : dataSources) {
            LocalDataSource localDataSource = DbImplUtilCore.getMaybeLocalDataSource((DasDataSource)dbDataSource);
            if (localDataSource == null || !DbImplUtilCore.canConnectTo((LocalDataSource)localDataSource, (Project)project)) continue;
            quickFixes.add((Object)new RefreshDataSourceQuickFix(localDataSource));
        }
        return (LocalQuickFix[])quickFixes.toArray((Object[])LocalQuickFix.EMPTY_ARRAY);
    }

    private static ProblemHighlightType suggestHighlightingType(UClass uClass) {
        return Optional.ofNullable(OrmUtil.INSTANCE.getOrmEntityForPsiClass((OrmFramework)JpaOrmFramework.INSTANCE, uClass.getJavaPsi())).map(arg_0 -> ((OrmUtil)OrmUtil.INSTANCE).getAssociatedDataStore(arg_0)).map(it -> ProblemHighlightType.GENERIC_ERROR).orElse(ProblemHighlightType.LIKE_UNUSED_SYMBOL);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ormFramework", "com/intellij/jpa/highlighting/JpaDataSourceORMInspection", "createUnitDataSourceQuickFixes"));
    }

    private static class SetupDataSourcesQuickFix
    implements LocalQuickFix,
    Iconable {
        private final OrmFramework ormFramework;
        private final boolean hasDatasource;
        private final boolean assignedDatasource;

        private SetupDataSourcesQuickFix(OrmFramework ormFramework, Collection<DbDataSource> availableDataSources, Collection<DbDataSource> assignedDataSources) {
            this.ormFramework = ormFramework;
            this.hasDatasource = !availableDataSources.isEmpty();
            this.assignedDatasource = !assignedDataSources.isEmpty();
        }

        @NotNull
        public String getName() {
            if (!this.hasDatasource) {
                String string = JpaHighlightingMessages.message("fix.create.datasource.name", new Object[0]);
                if (string == null) {
                    SetupDataSourcesQuickFix.$$$reportNull$$$0(0);
                }
                return string;
            }
            if (this.assignedDatasource) {
                String string = JpaHighlightingMessages.message("fix.reassign.unit.datasource.name", new Object[0]);
                if (string == null) {
                    SetupDataSourcesQuickFix.$$$reportNull$$$0(1);
                }
                return string;
            }
            String string = JpaHighlightingMessages.message("fix.edit.unit.datasource.name", new Object[0]);
            if (string == null) {
                SetupDataSourcesQuickFix.$$$reportNull$$$0(2);
            }
            return string;
        }

        @NotNull
        public String getFamilyName() {
            String string = this.getName();
            if (string == null) {
                SetupDataSourcesQuickFix.$$$reportNull$$$0(3);
            }
            return string;
        }

        public boolean startInWriteAction() {
            return false;
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            if (project == null) {
                SetupDataSourcesQuickFix.$$$reportNull$$$0(4);
            }
            if (descriptor == null) {
                SetupDataSourcesQuickFix.$$$reportNull$$$0(5);
            }
            PsiElement psiElement = descriptor.getPsiElement();
            if (!this.hasDatasource) {
                ((JpaImportDatasourceService)project.getService(JpaImportDatasourceService.class)).createOrImportDatasource(psiElement, (Function1<? super List<? extends DbDataSource>, ? extends Object>)((Function1)addedDs -> {
                    if (addedDs.isEmpty()) {
                        return "";
                    }
                    DbDataSource dataSource = (DbDataSource)addedDs.get(0);
                    Optional.ofNullable(ORMReferencesUtil.getTargetClass(psiElement)).map(entityClass -> OrmUtil.INSTANCE.getOrmUnitForPsiClass(this.ormFramework, entityClass)).filter(unit -> unit instanceof OrmModifiableUnit).ifPresent(unit -> ((OrmModifiableUnit)unit).setDefaultDataSourceId(dataSource.getUniqueId()));
                    return "";
                }));
                return;
            }
            if (this.ormFramework == JpaOrmFramework.INSTANCE) {
                PersistenceFacet facet = (PersistenceFacet)PersistenceHelper.getHelper().getSharedModelBrowser().queryPersistenceFacets(psiElement).findFirst();
                if (facet == null) {
                    return;
                }
                boolean assigned = AssignDataSourcesAction.showUnitDataSourceMappingDialog(facet = JpaConfigurationModel.createModifiablePersistenceFacet(facet));
                JpaEventsCollector.setupFixFinished(project, assigned ? SetupDatasourceResult.ASSIGN_DATASOURCE : SetupDatasourceResult.CANCEL);
            } else {
                Optional.ofNullable(psiElement.getContainingFile()).map(it -> OrmUtil.INSTANCE.getOrmUnitForPsiFile(this.ormFramework, it)).ifPresent(unit -> {
                    String oldDataSourceId = unit.getDefaultDataSourceId();
                    OrmModifiableUnitsProvider provider = (OrmModifiableUnitsProvider)OrmUnitsProvider.Companion.getForFramework(this.ormFramework);
                    provider.modifyUnit((OrmModifiableUnit)unit, OrmUnitSettingsDialog.FOCUSED_COMPONENT.CONNECTION, () -> {
                        boolean assigned = !Objects.equals(unit.getDefaultDataSourceId(), oldDataSourceId);
                        JpaEventsCollector.setupFixFinished(project, assigned ? SetupDatasourceResult.ASSIGN_DATASOURCE : SetupDatasourceResult.CANCEL);
                        return assigned;
                    });
                });
            }
        }

        public Icon getIcon(int flags) {
            if (!this.hasDatasource) {
                return AllIcons.General.Add;
            }
            return DatabaseIcons.Dbms;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 4, 5 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/jpa/highlighting/JpaDataSourceORMInspection$SetupDataSourcesQuickFix";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 4: 
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/jpa/highlighting/JpaDataSourceORMInspection$SetupDataSourcesQuickFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 4: 
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 4, 5 -> new IllegalArgumentException(string);
            };
        }
    }

    public static class RefreshDataSourceQuickFix
    implements LocalQuickFix,
    Iconable {
        private final LocalDataSource myDataSource;

        public RefreshDataSourceQuickFix(LocalDataSource dataSource) {
            this.myDataSource = dataSource;
        }

        @NotNull
        public IntentionPreviewInfo generatePreview(@NotNull Project project, @NotNull ProblemDescriptor previewDescriptor) {
            if (project == null) {
                RefreshDataSourceQuickFix.$$$reportNull$$$0(0);
            }
            if (previewDescriptor == null) {
                RefreshDataSourceQuickFix.$$$reportNull$$$0(1);
            }
            IntentionPreviewInfo intentionPreviewInfo = IntentionPreviewInfo.EMPTY;
            if (intentionPreviewInfo == null) {
                RefreshDataSourceQuickFix.$$$reportNull$$$0(2);
            }
            return intentionPreviewInfo;
        }

        @NotNull
        public String getName() {
            String string = JpaHighlightingMessages.message("fix.refresh.datasource.name", this.myDataSource.getName());
            if (string == null) {
                RefreshDataSourceQuickFix.$$$reportNull$$$0(3);
            }
            return string;
        }

        @NotNull
        public String getFamilyName() {
            String string = JpaHighlightingMessages.message("fix.refresh.datasource.family.name", new Object[0]);
            if (string == null) {
                RefreshDataSourceQuickFix.$$$reportNull$$$0(4);
            }
            return string;
        }

        public boolean startInWriteAction() {
            return false;
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            if (project == null) {
                RefreshDataSourceQuickFix.$$$reportNull$$$0(5);
            }
            if (descriptor == null) {
                RefreshDataSourceQuickFix.$$$reportNull$$$0(6);
            }
            IndefiniteIntrospectionTask task = IntrospectionTasks.prepareGeneralTask((String)this.myDataSource.getUniqueId());
            RunIntrospection.runAsyncIntrospection((Project)project, (LocalDataSource)this.myDataSource, (IntrospectionTask)task);
        }

        public Icon getIcon(int flags) {
            return AllIcons.Actions.Refresh;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2, 3, 4 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "previewDescriptor";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/jpa/highlighting/JpaDataSourceORMInspection$RefreshDataSourceQuickFix";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/jpa/highlighting/JpaDataSourceORMInspection$RefreshDataSourceQuickFix";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "generatePreview";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "generatePreview";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    break;
                }
                case 5: 
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2, 3, 4 -> new IllegalStateException(string);
            };
        }
    }
}

