/*
 * Decompiled with CFR 0.152.
 */
package liquibase.ext.intellij.snapshot;

import com.intellij.jpa.jpb.model.model.Index;
import com.intellij.jpa.jpb.model.orm.model.OrmEntity;
import com.intellij.liquibase.common.LiquibaseModelObjectFactory;
import com.intellij.liquibase.common.ddl.LiquibaseGenerator;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.List;
import liquibase.exception.DatabaseException;
import liquibase.ext.intellij.database.IntellijDatabase;
import liquibase.ext.intellij.snapshot.IntellijSnapshotGenerator;
import liquibase.snapshot.DatabaseSnapshot;
import liquibase.snapshot.InvalidExampleException;
import liquibase.structure.DatabaseObject;
import liquibase.structure.core.Relation;
import liquibase.structure.core.Table;
import liquibase.structure.core.UniqueConstraint;
import org.jetbrains.annotations.Nullable;

public class UniqueConstraintSnapshotGenerator
extends IntellijSnapshotGenerator {
    public UniqueConstraintSnapshotGenerator() {
        super(UniqueConstraint.class, new Class[]{Table.class});
    }

    @Override
    protected DatabaseObject snapshotObject(DatabaseObject example, DatabaseSnapshot snapshot) throws DatabaseException, InvalidExampleException {
        return example;
    }

    @Override
    protected void addTo(DatabaseObject foundObject, DatabaseSnapshot snapshot) throws DatabaseException, InvalidExampleException {
        if (!snapshot.getSnapshotControl().shouldInclude(UniqueConstraint.class)) {
            return;
        }
        if (!(foundObject instanceof Table)) {
            return;
        }
        Table table = (Table)foundObject;
        @Nullable OrmEntity entity = this.findOrmEntity(foundObject, snapshot);
        IntellijDatabase database = (IntellijDatabase)snapshot.getDatabase();
        LiquibaseGenerator liquibaseGenerator = database.getLiquibaseGenerator();
        List<Index> uniqueConstraints = liquibaseGenerator.getUniqueConstraints(table.getName(), entity, database.getOrmEntitiesToProcess());
        if (uniqueConstraints.isEmpty()) {
            return;
        }
        LiquibaseModelObjectFactory dbObjectFactory = database.getDbObjectFactory();
        for (Index constraint : uniqueConstraints) {
            UniqueConstraint uniqueConstraint = new UniqueConstraint();
            uniqueConstraint.setName(constraint.getNameNN(table.getName()));
            uniqueConstraint.setRelation((Relation)table);
            uniqueConstraint.setClustered(false);
            uniqueConstraint.setColumns(ContainerUtil.map((Collection)constraint.getAttributes(), dbObjectFactory::createIndexColumn));
            LOG.info("Found unique constraint " + String.valueOf(uniqueConstraint));
            table.getUniqueConstraints().add(uniqueConstraint);
        }
    }
}

