/*
 * Decompiled with CFR 0.152.
 */
package liquibase.ext.intellij.diff.core;

import com.intellij.jpa.jpb.model.core.model.dbtype.DbType;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Set;
import liquibase.diff.DiffResult;
import liquibase.diff.compare.CompareControl;
import liquibase.exception.DatabaseException;
import liquibase.ext.intellij.LiquibaseUtils;
import liquibase.ext.intellij.diff.postprorcess.DiffResultPostProcessor;
import liquibase.ext.intellij.diff.postprorcess.DiffResultPostProcessorFactory;
import liquibase.snapshot.DatabaseSnapshot;
import liquibase.structure.core.ForeignKey;
import liquibase.structure.core.Index;

public class StandardDiffGenerator
extends liquibase.diff.core.StandardDiffGenerator {
    public int getPriority() {
        return super.getPriority() + 1;
    }

    public DiffResult compare(DatabaseSnapshot referenceSnapshot, DatabaseSnapshot comparisonSnapshot, CompareControl compareControl) throws DatabaseException {
        DiffResult diffResult = super.compare(referenceSnapshot, comparisonSnapshot, compareControl);
        if (LiquibaseUtils.getDatabaseType(comparisonSnapshot.getDatabase()) == DbType.MYSQL || LiquibaseUtils.getDatabaseType(comparisonSnapshot.getDatabase()) == DbType.MARIA) {
            Set unexpectedIndexes = diffResult.getUnexpectedObjects(Index.class);
            block0: for (Index index : unexpectedIndexes) {
                for (ForeignKey foreignKey : comparisonSnapshot.get(ForeignKey.class)) {
                    if (!foreignKey.getName().equals(index.getName())) continue;
                    diffResult.getUnexpectedObjects().remove(index);
                    continue block0;
                }
            }
        }
        StandardDiffGenerator.postProcessDiff(referenceSnapshot, comparisonSnapshot, diffResult);
        return diffResult;
    }

    private static void postProcessDiff(DatabaseSnapshot referenceSnapshot, DatabaseSnapshot comparisonSnapshot, DiffResult diffResult) {
        ArrayList<DiffResultPostProcessorFactory> factories = new ArrayList<DiffResultPostProcessorFactory>(DiffResultPostProcessorFactory.Companion.getFactories());
        factories.sort(Comparator.comparing(DiffResultPostProcessorFactory::getPriority));
        for (DiffResultPostProcessorFactory factory : factories) {
            DiffResultPostProcessor postProcessor = factory.createPostProcessor(diffResult, referenceSnapshot, comparisonSnapshot);
            if (postProcessor == null) continue;
            postProcessor.postProcessDiffResult();
        }
    }
}

