/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.liquibase.jpa.orm;

import com.intellij.jpa.jpb.model.backend.ed.EntityDesignHelper;
import com.intellij.jpa.jpb.model.model.AttributeOverride;
import com.intellij.jpa.jpb.model.model.CollectionTable;
import com.intellij.jpa.jpb.model.model.CollectionTableAttribute;
import com.intellij.jpa.jpb.model.model.DbIdentifierHelper;
import com.intellij.jpa.jpb.model.model.Entity;
import com.intellij.jpa.jpb.model.model.EntityAttribute;
import com.intellij.jpa.jpb.model.model.Index;
import com.intellij.jpa.jpb.model.model.JoinTableAttribute;
import com.intellij.jpa.jpb.model.orm.jpa.JpaOrmFramework;
import com.intellij.jpa.jpb.model.orm.model.OrmEntity;
import com.intellij.jpa.jpb.model.service.JpabGeneratorManager;
import com.intellij.jpa.jpb.model.util.OrmUtil;
import com.intellij.liquibase.common.LiquibaseElementsNamesHelper;
import com.intellij.liquibase.common.LiquibaseGenerationContext;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.util.text.Strings;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class JpaLiquibaseUniqueConstraintsHelper {
    private final LiquibaseGenerationContext context;
    private final LiquibaseElementsNamesHelper liquibaseElementsNamesHelper;
    private final JpabGeneratorManager ddlGeneratorManager;

    JpaLiquibaseUniqueConstraintsHelper(LiquibaseGenerationContext context) {
        this.context = context;
        this.liquibaseElementsNamesHelper = new LiquibaseElementsNamesHelper(context);
        this.ddlGeneratorManager = JpabGeneratorManager.getInstance((Project)context.getProject());
    }

    List<Index> getUniqueConstraints(String tableName, List<OrmEntity> allEntities) {
        List<Entity> jpabEntities;
        CollectionTableAttribute collectionTableAttribute;
        List entitiesFqn = ContainerUtil.map(allEntities, arg_0 -> ((OrmUtil)OrmUtil.INSTANCE).getOrmEntityFqn(arg_0));
        JoinTableAttribute joinTableAttribute = this.ddlGeneratorManager.findJoinTableAttribute(tableName, entitiesFqn, true);
        if (joinTableAttribute != null) {
            List explicitConstraints = joinTableAttribute.getAttribute().getJoinTable().getUniqueConstraints();
            if (!explicitConstraints.isEmpty()) {
                return explicitConstraints;
            }
            List tableAttributes = this.ddlGeneratorManager.getJoinTableAttributes(joinTableAttribute);
            Index uniqueConstraint = this.getUniqueConstraint(DbIdentifierHelper.convertToClearValidIdentifier((String)tableName), tableAttributes);
            if (uniqueConstraint != null) {
                return Collections.singletonList(uniqueConstraint);
            }
        }
        if ((collectionTableAttribute = this.ddlGeneratorManager.findCollectionTableAttribute(tableName, jpabEntities = allEntities.stream().map(arg_0 -> ((OrmUtil)OrmUtil.INSTANCE).getEntityByOrmEntity(arg_0)).filter(Objects::nonNull).toList())) != null) {
            CollectionTable collectionTable = collectionTableAttribute.getAttribute().getCollectionTable(collectionTableAttribute.getEntity());
            if (collectionTable != null) {
                ArrayList<Index> explicitConstraints = new ArrayList<Index>(collectionTable.getUniqueConstraints());
                collectionTable.getIndexes().stream().filter(Index::isUnique).forEach(explicitConstraints::add);
                if (!explicitConstraints.isEmpty()) {
                    return explicitConstraints;
                }
            }
            List tableAttributes = JpabGeneratorManager.getCollectionTableAttributes((CollectionTableAttribute)collectionTableAttribute, (Project)this.context.getProject());
            return this.getUniqueConstraints(DbIdentifierHelper.convertToClearValidIdentifier((String)tableName), tableAttributes, null);
        }
        return Collections.emptyList();
    }

    List<Index> getUniqueConstraints(String clearValidTableName, Collection<EntityAttribute> tableAttributes, @Nullable Entity entity) {
        Index naturalIdsUnqConstraint;
        ArrayList<Index> result = new ArrayList<Index>();
        for (EntityAttribute attr : tableAttributes) {
            if (attr.isId() && entity != null) continue;
            AttributeOverride attributeOverride = entity == null ? null : entity.getAttributeOverrideEx(attr.getName());
            String columnName = attr.getColumn();
            boolean isUnique = attr.isUnique();
            if (attributeOverride != null) {
                String overrideColumnName = attributeOverride.getColumn();
                if (StringUtil.isNotEmpty((String)overrideColumnName)) {
                    columnName = overrideColumnName;
                }
                isUnique = attributeOverride.isUnique();
            }
            if (!Strings.isNotEmpty((String)columnName) || !isUnique) continue;
            LinkedHashSet<String> columnNames = new LinkedHashSet<String>(Collections.singletonList(DbIdentifierHelper.trimEscapeQuotes((String)columnName, (boolean)false)));
            LinkedHashSet<String> columnNamesForIndexName = new LinkedHashSet<String>(Collections.singletonList(DbIdentifierHelper.convertToClearValidIdentifier((String)columnName)));
            String constraintName = this.liquibaseElementsNamesHelper.generateUniqueConstraintName(clearValidTableName, columnNamesForIndexName);
            result.add(new Index(constraintName, columnNames, true, true));
        }
        if (entity != null && (naturalIdsUnqConstraint = this.createNaturalIdsUnqConstraint(clearValidTableName, tableAttributes, entity)) != null) {
            result.add(naturalIdsUnqConstraint);
        }
        return result;
    }

    boolean checkIndexAttribute(OrmEntity ormEntity, String indexColumn, List<EntityAttribute> attributesForSearch) {
        if (ormEntity.getOrmFramework() != JpaOrmFramework.INSTANCE) {
            return true;
        }
        Entity entity = OrmUtil.INSTANCE.getEntityByOrmEntity(ormEntity);
        if (entity == null) {
            return false;
        }
        if (attributesForSearch.isEmpty()) {
            return false;
        }
        if (EntityDesignHelper.getAttributeByColumn((Entity)entity, (String)indexColumn, attributesForSearch) != null) {
            return true;
        }
        if (EntityDesignHelper.mustHaveDiscriminator((Entity)entity, (Project)this.context.getProject())) {
            String discriminatorColumnName = entity.getDiscriminatorColumnName();
            if (Strings.isEmpty((String)discriminatorColumnName)) {
                discriminatorColumnName = "DTYPE";
            }
            return discriminatorColumnName.equalsIgnoreCase(indexColumn);
        }
        return false;
    }

    @Nullable
    private Index createNaturalIdsUnqConstraint(String clearValidTableName, Collection<EntityAttribute> tableAttributes, @NotNull Entity entity) {
        List<EntityAttribute> naturalIds;
        if (entity == null) {
            JpaLiquibaseUniqueConstraintsHelper.$$$reportNull$$$0(0);
        }
        if ((naturalIds = tableAttributes.stream().filter(EntityAttribute::isNaturalId).toList()).isEmpty()) {
            return null;
        }
        LinkedHashSet<String> columnNames = new LinkedHashSet<String>();
        LinkedHashSet<String> columnNamesForIndexName = new LinkedHashSet<String>();
        for (EntityAttribute naturalIdAttr : naturalIds) {
            String overrideColumnName;
            AttributeOverride attributeOverride = entity.getAttributeOverrideEx(naturalIdAttr.getName());
            String columnName = naturalIdAttr.getColumn();
            if (attributeOverride != null && StringUtil.isNotEmpty((String)(overrideColumnName = attributeOverride.getColumn()))) {
                columnName = overrideColumnName;
            }
            if (!Strings.isNotEmpty((String)columnName)) continue;
            columnNames.add(DbIdentifierHelper.trimEscapeQuotes((String)columnName, (boolean)false));
            columnNamesForIndexName.add(DbIdentifierHelper.convertToClearValidIdentifier((String)columnName));
        }
        if (columnNames.isEmpty()) {
            return null;
        }
        String constraintName = this.liquibaseElementsNamesHelper.generateUniqueConstraintName(clearValidTableName, columnNamesForIndexName);
        return new Index(constraintName, columnNames, true, true);
    }

    @Nullable
    private Index getUniqueConstraint(String clearValidTableName, Collection<EntityAttribute> tableAttributes) {
        LinkedHashSet<String> columnNames = new LinkedHashSet<String>();
        LinkedHashSet<String> columnNamesForIndexName = new LinkedHashSet<String>();
        for (EntityAttribute attr : tableAttributes) {
            if (!Strings.isNotEmpty((String)attr.getColumn()) || !attr.isUnique()) continue;
            columnNames.add(attr.getDdlManipulationColumn());
            columnNamesForIndexName.add(attr.getClearValidColumnName());
        }
        if (!columnNames.isEmpty() && !columnNamesForIndexName.isEmpty()) {
            String constraintName = this.liquibaseElementsNamesHelper.generateUniqueConstraintName(clearValidTableName, columnNamesForIndexName);
            return new Index(constraintName, columnNames, true, true);
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "entity", "com/intellij/liquibase/jpa/orm/JpaLiquibaseUniqueConstraintsHelper", "createNaturalIdsUnqConstraint"));
    }
}

