/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.liquibase.common;

import com.intellij.liquibase.common.config.LiquibaseChangeIdentifier;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.xml.XmlTag;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import liquibase.change.AbstractChange;
import liquibase.change.Change;
import liquibase.change.ChangeWithColumns;
import liquibase.change.ColumnConfig;
import liquibase.change.core.AddColumnChange;
import liquibase.change.core.DeleteDataChange;
import liquibase.change.core.DropColumnChange;
import liquibase.change.core.InsertDataChange;
import liquibase.change.core.MergeColumnChange;
import liquibase.change.core.RawSQLChange;
import liquibase.change.core.SetColumnRemarksChange;
import liquibase.change.core.SetTableRemarksChange;
import liquibase.change.core.UpdateDataChange;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service(value={Service.Level.PROJECT})
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0005\b\u0007\u0018\u0000 \u00182\u00020\u0001:\u0001\u0018B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u0007J\u0012\u0010\b\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\t\u001a\u00020\nJ\u0012\u0010\b\u001a\u0004\u0018\u00010\u00052\u0006\u0010\t\u001a\u00020\nH\u0002J\u0016\u0010\u000b\u001a\u00020\f2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eH\u0002J\u001d\u0010\u0010\u001a\u00020\f2\u000b\u0010\u0011\u001a\u00070\f\u00a2\u0006\u0002\b\u00122\u0006\u0010\t\u001a\u00020\nH\u0002J+\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0012\u0010\u0013\u001a\n\u0012\u0006\b\u0001\u0012\u00020\f0\u0014\"\u00020\fH\u0002\u00a2\u0006\u0002\u0010\u0015J+\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0016\u001a\u00020\n2\u0012\u0010\u0013\u001a\n\u0012\u0006\b\u0001\u0012\u00020\f0\u0014\"\u00020\fH\u0002\u00a2\u0006\u0002\u0010\u0017\u00a8\u0006\u0019"}, d2={"Lcom/intellij/liquibase/common/LiquibaseChangeIdentifierManager;", "", "<init>", "()V", "createIdentifier", "Lcom/intellij/liquibase/common/config/LiquibaseChangeIdentifier;", "change", "Lliquibase/change/Change;", "createIdentifierWithoutSchemaName", "changeTag", "Lcom/intellij/psi/xml/XmlTag;", "generateColumnsId", "", "columns", "", "Lliquibase/change/ColumnConfig;", "getWhereStatementWithSuffix", "changeTagName", "Lorg/jetbrains/annotations/NotNull;", "attrNames", "", "(Lliquibase/change/Change;[Ljava/lang/String;)Lcom/intellij/liquibase/common/config/LiquibaseChangeIdentifier;", "tag", "(Lcom/intellij/psi/xml/XmlTag;[Ljava/lang/String;)Lcom/intellij/liquibase/common/config/LiquibaseChangeIdentifier;", "Companion", "intellij.liquibase.common"})
@SourceDebugExtension(value={"SMAP\nLiquibaseChangeIdentifierManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LiquibaseChangeIdentifierManager.kt\ncom/intellij/liquibase/common/LiquibaseChangeIdentifierManager\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,231:1\n11879#2,9:232\n13805#2:241\n13806#2:243\n11888#2:244\n11561#2:258\n11896#2,3:259\n11561#2:262\n11896#2,3:263\n1#3:242\n1#3:255\n1617#4,9:245\n1869#4:254\n1870#4:256\n1626#4:257\n*S KotlinDebug\n*F\n+ 1 LiquibaseChangeIdentifierManager.kt\ncom/intellij/liquibase/common/LiquibaseChangeIdentifierManager\n*L\n174#1:232,9\n174#1:241\n174#1:243\n174#1:244\n218#1:258\n218#1:259,3\n226#1:262\n226#1:263,3\n174#1:242\n199#1:255\n199#1:245,9\n199#1:254\n199#1:256\n199#1:257\n*E\n"})
public final class LiquibaseChangeIdentifierManager {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final Map<String, String[]> CHANGE_NAME_TO_ID_ATTRS_MAP;

    @Nullable
    public final LiquibaseChangeIdentifier createIdentifier(@NotNull Change change) {
        LiquibaseChangeIdentifier liquibaseChangeIdentifier;
        Intrinsics.checkNotNullParameter((Object)change, (String)"change");
        LiquibaseChangeIdentifier liquibaseChangeIdentifier2 = this.createIdentifierWithoutSchemaName(change);
        if (liquibaseChangeIdentifier2 != null) {
            LiquibaseChangeIdentifier liquibaseChangeIdentifier3;
            LiquibaseChangeIdentifier $this$createIdentifier_u24lambda_u240 = liquibaseChangeIdentifier3 = liquibaseChangeIdentifier2;
            boolean bl = false;
            Object object = change.getSerializableFieldValue("schemaName");
            String schemaName = object instanceof String ? (String)object : null;
            object = schemaName;
            if (!(object == null || StringsKt.isBlank((CharSequence)object))) {
                $this$createIdentifier_u24lambda_u240.setIdName(schemaName + "#" + $this$createIdentifier_u24lambda_u240.getIdName());
            }
            liquibaseChangeIdentifier = liquibaseChangeIdentifier3;
        } else {
            liquibaseChangeIdentifier = null;
        }
        return liquibaseChangeIdentifier;
    }

    private final LiquibaseChangeIdentifier createIdentifierWithoutSchemaName(Change change) {
        LiquibaseChangeIdentifier liquibaseChangeIdentifier;
        String changeTagName = change.getSerializedObjectName();
        Change change2 = change;
        if (change2 instanceof AddColumnChange || change2 instanceof DropColumnChange) {
            String[] stringArray = new String[]{"tableName", "columnName"};
            LiquibaseChangeIdentifier inlineColumnChange = this.createIdentifier(change, stringArray);
            if (inlineColumnChange != null) {
                return inlineColumnChange;
            }
            Object object = ((AbstractChange)change).getSerializableFieldValue("tableName");
            if (object == null) {
                return null;
            }
            Object tableName = object;
            Intrinsics.checkNotNull((Object)change, (String)"null cannot be cast to non-null type liquibase.change.ChangeWithColumns<*>");
            List list = ((ChangeWithColumns)change).getColumns();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getColumns(...)");
            Object object2 = (ColumnConfig)CollectionsKt.firstOrNull((List)list);
            if (object2 == null || (object2 = object2.getName()) == null) {
                return null;
            }
            Object columnName = object2;
            return new LiquibaseChangeIdentifier(changeTagName, tableName + "#" + (String)columnName);
        }
        if (change2 instanceof InsertDataChange) {
            String string = ((InsertDataChange)change).getTableName();
            if (string == null) {
                return null;
            }
            String tableName = string;
            List columns = ((InsertDataChange)change).getColumns();
            if (columns.isEmpty()) {
                return null;
            }
            Intrinsics.checkNotNull((Object)columns);
            return new LiquibaseChangeIdentifier(changeTagName, tableName + "#" + this.generateColumnsId(columns));
        }
        if (change2 instanceof UpdateDataChange) {
            String string = ((UpdateDataChange)change).getTableName();
            if (string == null) {
                return null;
            }
            String tableName = string;
            List columns = ((UpdateDataChange)change).getColumns();
            if (columns.isEmpty()) {
                return null;
            }
            String where = ((UpdateDataChange)change).getWhere();
            Intrinsics.checkNotNull((Object)columns);
            String string2 = where;
            return new LiquibaseChangeIdentifier(changeTagName, tableName + "#" + this.generateColumnsId(columns) + (String)(string2 == null ? "" : "#" + string2));
        }
        if (change2 instanceof DeleteDataChange) {
            String where;
            String string = ((DeleteDataChange)change).getTableName();
            if (string == null) {
                return null;
            }
            String tableName = string;
            String string3 = where = ((DeleteDataChange)change).getWhere();
            return new LiquibaseChangeIdentifier(changeTagName, tableName + (String)(string3 == null ? "" : "#" + string3));
        }
        if (change2 instanceof RawSQLChange) {
            return new LiquibaseChangeIdentifier(changeTagName, StringUtil.escapeStringCharacters((String)((RawSQLChange)change).getSql()));
        }
        if (change2 instanceof SetTableRemarksChange) {
            String string = ((SetTableRemarksChange)change).getTableName();
            if (string == null) {
                return null;
            }
            String tableName = string;
            String string4 = ((SetTableRemarksChange)change).getRemarks();
            if (string4 == null) {
                return null;
            }
            String remarks = string4;
            return new LiquibaseChangeIdentifier(changeTagName, tableName + "#" + remarks);
        }
        if (change2 instanceof SetColumnRemarksChange) {
            String string = ((SetColumnRemarksChange)change).getTableName();
            if (string == null) {
                return null;
            }
            String tableName = string;
            String string5 = ((SetColumnRemarksChange)change).getColumnName();
            if (string5 == null) {
                return null;
            }
            String columnName = string5;
            String string6 = ((SetColumnRemarksChange)change).getRemarks();
            if (string6 == null) {
                return null;
            }
            String remarks = string6;
            return new LiquibaseChangeIdentifier(changeTagName, tableName + "#" + columnName + "#" + remarks);
        }
        if (change2 instanceof MergeColumnChange) {
            String string = ((MergeColumnChange)change).getTableName();
            if (string == null) {
                return null;
            }
            String tableName = string;
            String string7 = ((MergeColumnChange)change).getColumn1Name();
            if (string7 == null) {
                return null;
            }
            String column1Name = string7;
            String string8 = ((MergeColumnChange)change).getColumn2Name();
            if (string8 == null) {
                return null;
            }
            String column2Name = string8;
            String string9 = ((MergeColumnChange)change).getFinalColumnName();
            if (string9 == null) {
                return null;
            }
            String finalColumnName = string9;
            return new LiquibaseChangeIdentifier(changeTagName, tableName + "#" + column1Name + "#" + column2Name + "#" + finalColumnName);
        }
        String[] stringArray = CHANGE_NAME_TO_ID_ATTRS_MAP.get(changeTagName);
        if (stringArray != null) {
            String[] it = stringArray;
            boolean bl = false;
            liquibaseChangeIdentifier = this.createIdentifier(change, Arrays.copyOf(it, it.length));
        } else {
            liquibaseChangeIdentifier = null;
        }
        return liquibaseChangeIdentifier;
    }

    @Nullable
    public final LiquibaseChangeIdentifier createIdentifier(@NotNull XmlTag changeTag) {
        LiquibaseChangeIdentifier liquibaseChangeIdentifier;
        Intrinsics.checkNotNullParameter((Object)changeTag, (String)"changeTag");
        LiquibaseChangeIdentifier liquibaseChangeIdentifier2 = this.createIdentifierWithoutSchemaName(changeTag);
        if (liquibaseChangeIdentifier2 != null) {
            LiquibaseChangeIdentifier liquibaseChangeIdentifier3;
            LiquibaseChangeIdentifier $this$createIdentifier_u24lambda_u241 = liquibaseChangeIdentifier3 = liquibaseChangeIdentifier2;
            boolean bl = false;
            String schemaName = changeTag.getAttributeValue("schemaName");
            CharSequence charSequence = schemaName;
            if (!(charSequence == null || StringsKt.isBlank((CharSequence)charSequence))) {
                $this$createIdentifier_u24lambda_u241.setIdName(schemaName + "#" + $this$createIdentifier_u24lambda_u241.getIdName());
            }
            liquibaseChangeIdentifier = liquibaseChangeIdentifier3;
        } else {
            liquibaseChangeIdentifier = null;
        }
        return liquibaseChangeIdentifier;
    }

    /*
     * WARNING - void declaration
     */
    private final LiquibaseChangeIdentifier createIdentifierWithoutSchemaName(XmlTag changeTag) {
        LiquibaseChangeIdentifier liquibaseChangeIdentifier;
        String string = changeTag.getLocalName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getLocalName(...)");
        String changeTagName = string;
        if (Intrinsics.areEqual((Object)"addColumn", (Object)changeTagName) || Intrinsics.areEqual((Object)"dropColumn", (Object)changeTagName)) {
            String[] stringArray = new String[]{"tableName", "columnName"};
            LiquibaseChangeIdentifier inlineColumnChange = this.createIdentifier(changeTag, stringArray);
            if (inlineColumnChange != null) {
                return inlineColumnChange;
            }
            String string2 = changeTag.getAttributeValue("tableName");
            if (string2 == null) {
                return null;
            }
            String tableName = string2;
            Object object = changeTag.findFirstSubTag("column");
            if (object == null || (object = object.getAttributeValue("name")) == null) {
                return null;
            }
            Object columnName = object;
            return new LiquibaseChangeIdentifier(changeTagName, tableName + "#" + (String)columnName);
        }
        if (Intrinsics.areEqual((Object)"insert", (Object)changeTagName) || Intrinsics.areEqual((Object)"update", (Object)changeTagName)) {
            void $this$mapNotNullTo$iv$iv;
            String string3 = changeTag.getAttributeValue("tableName");
            if (string3 == null) {
                return null;
            }
            String tableName = string3;
            XmlTag[] xmlTagArray = changeTag.findSubTags("column");
            Intrinsics.checkNotNullExpressionValue((Object)xmlTagArray, (String)"findSubTags(...)");
            XmlTag[] columnTags = xmlTagArray;
            if (columnTags.length == 0) {
                return null;
            }
            XmlTag[] $this$mapNotNull$iv = columnTags;
            boolean $i$f$mapNotNull = false;
            XmlTag[] xmlTagArray2 = $this$mapNotNull$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            int n = ((void)$this$forEach$iv$iv$iv).length;
            for (int i = 0; i < n; ++i) {
                String it$iv$iv;
                String columnValue;
                String columnName;
                void element$iv$iv$iv;
                void element$iv$iv = element$iv$iv$iv = $this$forEach$iv$iv$iv[i];
                boolean bl = false;
                void columnTag = element$iv$iv;
                boolean bl2 = false;
                if ((columnTag.getAttributeValue("name") == null ? null : (columnTag.getAttributeValue("value") == null ? null : columnName + "#" + columnValue)) == null) continue;
                it$iv$iv = it$iv$iv;
                boolean bl3 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            String columnsId = CollectionsKt.joinToString$default((Iterable)((List)destination$iv$iv), (CharSequence)"#", null, null, (int)0, null, null, (int)62, null);
            return new LiquibaseChangeIdentifier(changeTagName, tableName + "#" + columnsId + this.getWhereStatementWithSuffix(changeTagName, changeTag));
        }
        if (Intrinsics.areEqual((Object)"delete", (Object)changeTagName)) {
            String string4 = changeTag.getAttributeValue("tableName");
            if (string4 == null) {
                return null;
            }
            String tableName = string4;
            return new LiquibaseChangeIdentifier(changeTagName, tableName + this.getWhereStatementWithSuffix(changeTagName, changeTag));
        }
        if (Intrinsics.areEqual((Object)"sql", (Object)changeTagName)) {
            return new LiquibaseChangeIdentifier(changeTagName, StringUtil.escapeStringCharacters((String)changeTag.getValue().getText()));
        }
        String[] stringArray = CHANGE_NAME_TO_ID_ATTRS_MAP.get(changeTagName);
        if (stringArray != null) {
            String[] it = stringArray;
            boolean bl = false;
            liquibaseChangeIdentifier = this.createIdentifier(changeTag, Arrays.copyOf(it, it.length));
        } else {
            liquibaseChangeIdentifier = null;
        }
        return liquibaseChangeIdentifier;
    }

    /*
     * WARNING - void declaration
     */
    private final String generateColumnsId(List<ColumnConfig> columns) {
        void $this$mapNotNullTo$iv$iv;
        Iterable $this$mapNotNull$iv = columns;
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            String it$iv$iv;
            String columnValue;
            String columnName;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            ColumnConfig columnConfig = (ColumnConfig)element$iv$iv;
            boolean bl2 = false;
            if ((columnConfig.getName() == null ? null : (columnConfig.getValue() == null ? null : columnName + "#" + columnValue)) == null) continue;
            it$iv$iv = it$iv$iv;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return CollectionsKt.joinToString$default((Iterable)((List)destination$iv$iv), (CharSequence)"#", null, null, (int)0, null, null, (int)62, null);
    }

    private final String getWhereStatementWithSuffix(String changeTagName, XmlTag changeTag) {
        Object object;
        block4: {
            block2: {
                block3: {
                    if (!Intrinsics.areEqual((Object)"update", (Object)changeTagName)) break block2;
                    object = changeTag.findFirstSubTag("where");
                    if (object == null || (object = object.getValue()) == null || (object = object.getText()) == null) break block3;
                    String it = object;
                    boolean bl = false;
                    String string = "#" + it;
                    object = string;
                    if (string != null) break block4;
                }
                object = "";
                break block4;
            }
            object = "";
        }
        return object;
    }

    /*
     * WARNING - void declaration
     */
    private final LiquibaseChangeIdentifier createIdentifier(Change change, String ... attrNames) {
        void $this$mapTo$iv$iv;
        String tagName = change.getSerializedObjectName();
        String[] $this$map$iv = attrNames;
        boolean $i$f$map = false;
        String[] stringArray = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.length);
        boolean $i$f$mapTo = false;
        int n = ((void)$this$mapTo$iv$iv).length;
        for (int i = 0; i < n; ++i) {
            void attrName;
            void item$iv$iv;
            void var13_12 = item$iv$iv = $this$mapTo$iv$iv[i];
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Object object = change.getSerializableFieldValue((String)attrName);
            if (object == null) {
                return null;
            }
            collection.add(object);
        }
        String id = CollectionsKt.joinToString$default((Iterable)((List)destination$iv$iv), (CharSequence)"#", null, null, (int)0, null, null, (int)62, null);
        return new LiquibaseChangeIdentifier(tagName, id);
    }

    /*
     * WARNING - void declaration
     */
    private final LiquibaseChangeIdentifier createIdentifier(XmlTag tag, String ... attrNames) {
        void $this$mapTo$iv$iv;
        String string = tag.getLocalName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getLocalName(...)");
        String tagName = string;
        String[] $this$map$iv = attrNames;
        boolean $i$f$map = false;
        String[] stringArray = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.length);
        boolean $i$f$mapTo = false;
        int n = ((void)$this$mapTo$iv$iv).length;
        for (int i = 0; i < n; ++i) {
            void attrName;
            void item$iv$iv;
            void var13_12 = item$iv$iv = $this$mapTo$iv$iv[i];
            Collection collection = destination$iv$iv;
            boolean bl = false;
            String string2 = tag.getAttributeValue((String)attrName);
            if (string2 == null) {
                return null;
            }
            collection.add(string2);
        }
        String id = CollectionsKt.joinToString$default((Iterable)((List)destination$iv$iv), (CharSequence)"#", null, null, (int)0, null, null, (int)62, null);
        return new LiquibaseChangeIdentifier(tagName, id);
    }

    static {
        Pair[] pairArray = new Pair[34];
        String[] stringArray = new String[]{"viewName"};
        pairArray[0] = TuplesKt.to((Object)"dropView", (Object)stringArray);
        stringArray = new String[]{"tableName", "columnNames"};
        pairArray[1] = TuplesKt.to((Object)"addUniqueConstraint", (Object)stringArray);
        stringArray = new String[]{"indexName"};
        pairArray[2] = TuplesKt.to((Object)"dropIndex", (Object)stringArray);
        stringArray = new String[]{"constraintName"};
        pairArray[3] = TuplesKt.to((Object)"addForeignKeyConstraint", (Object)stringArray);
        stringArray = new String[]{"tableName", "columnName"};
        pairArray[4] = TuplesKt.to((Object)"addAutoIncrement", (Object)stringArray);
        stringArray = new String[]{"tableName", "columnName"};
        pairArray[5] = TuplesKt.to((Object)"modifyDataType", (Object)stringArray);
        stringArray = new String[]{"tableName", "columnName"};
        pairArray[6] = TuplesKt.to((Object)"dropNotNullConstraint", (Object)stringArray);
        stringArray = new String[]{"oldTableName", "newTableName"};
        pairArray[7] = TuplesKt.to((Object)"renameTable", (Object)stringArray);
        stringArray = new String[]{"tableName", "column1Name", "column2Name", "finalColumnName"};
        pairArray[8] = TuplesKt.to((Object)"mergeColumns", (Object)stringArray);
        stringArray = new String[]{"tableName", "file"};
        pairArray[9] = TuplesKt.to((Object)"loadData", (Object)stringArray);
        stringArray = new String[]{"tableName", "file"};
        pairArray[10] = TuplesKt.to((Object)"loadUpdateData", (Object)stringArray);
        stringArray = new String[]{"sequenceName"};
        pairArray[11] = TuplesKt.to((Object)"alterSequence", (Object)stringArray);
        stringArray = new String[]{"indexName"};
        pairArray[12] = TuplesKt.to((Object)"createIndex", (Object)stringArray);
        stringArray = new String[]{"oldViewName", "newViewName"};
        pairArray[13] = TuplesKt.to((Object)"renameView", (Object)stringArray);
        stringArray = new String[]{"tableName"};
        pairArray[14] = TuplesKt.to((Object)"dropPrimaryKey", (Object)stringArray);
        stringArray = new String[]{"tableName", "constraintName"};
        pairArray[15] = TuplesKt.to((Object)"dropUniqueConstraint", (Object)stringArray);
        stringArray = new String[]{"sequenceName"};
        pairArray[16] = TuplesKt.to((Object)"dropSequence", (Object)stringArray);
        stringArray = new String[]{"oldSequenceName", "newSequenceName"};
        pairArray[17] = TuplesKt.to((Object)"renameSequence", (Object)stringArray);
        stringArray = new String[]{"sequenceName"};
        pairArray[18] = TuplesKt.to((Object)"createSequence", (Object)stringArray);
        stringArray = new String[]{"tableName", "columnName"};
        pairArray[19] = TuplesKt.to((Object)"addNotNullConstraint", (Object)stringArray);
        stringArray = new String[]{"tableName", "columnName"};
        pairArray[20] = TuplesKt.to((Object)"dropDefaultValue", (Object)stringArray);
        stringArray = new String[]{"tableName"};
        pairArray[21] = TuplesKt.to((Object)"dropTable", (Object)stringArray);
        stringArray = new String[]{"existingTableName", "existingColumnName", "newTableName", "newColumnName"};
        pairArray[22] = TuplesKt.to((Object)"addLookupTable", (Object)stringArray);
        stringArray = new String[]{"path"};
        pairArray[23] = TuplesKt.to((Object)"sqlFile", (Object)stringArray);
        stringArray = new String[]{"baseTableName"};
        pairArray[24] = TuplesKt.to((Object)"dropAllForeignKeyConstraints", (Object)stringArray);
        stringArray = new String[]{"viewName"};
        pairArray[25] = TuplesKt.to((Object)"createView", (Object)stringArray);
        stringArray = new String[]{"tableName"};
        pairArray[26] = TuplesKt.to((Object)"createTable", (Object)stringArray);
        stringArray = new String[]{"tableName", "oldColumnName", "newColumnName"};
        pairArray[27] = TuplesKt.to((Object)"renameColumn", (Object)stringArray);
        stringArray = new String[]{"procedureName", "path"};
        pairArray[28] = TuplesKt.to((Object)"createProcedure", (Object)stringArray);
        stringArray = new String[]{"constraintName"};
        pairArray[29] = TuplesKt.to((Object)"dropForeignKeyConstraint", (Object)stringArray);
        stringArray = new String[]{"procedureName"};
        pairArray[30] = TuplesKt.to((Object)"dropProcedure", (Object)stringArray);
        stringArray = new String[]{"tableName", "columnNames"};
        pairArray[31] = TuplesKt.to((Object)"addPrimaryKey", (Object)stringArray);
        stringArray = new String[]{"tableName", "columnName"};
        pairArray[32] = TuplesKt.to((Object)"addDefaultValue", (Object)stringArray);
        stringArray = new String[]{"tableName", "remarks"};
        pairArray[33] = TuplesKt.to((Object)"setColumnRemarks", (Object)stringArray);
        CHANGE_NAME_TO_ID_ATTRS_MAP = MapsKt.mapOf((Pair[])pairArray);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0010\u0011\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007R#\u0010\b\u001a\u0014\u0012\u0004\u0012\u00020\n\u0012\n\u0012\b\u0012\u0004\u0012\u00020\n0\u000b0\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\u000e"}, d2={"Lcom/intellij/liquibase/common/LiquibaseChangeIdentifierManager$Companion;", "", "<init>", "()V", "getInstance", "Lcom/intellij/liquibase/common/LiquibaseChangeIdentifierManager;", "project", "Lcom/intellij/openapi/project/Project;", "CHANGE_NAME_TO_ID_ATTRS_MAP", "", "", "", "getCHANGE_NAME_TO_ID_ATTRS_MAP", "()Ljava/util/Map;", "intellij.liquibase.common"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final LiquibaseChangeIdentifierManager getInstance(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Object object = project.getService(LiquibaseChangeIdentifierManager.class);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getService(...)");
            return (LiquibaseChangeIdentifierManager)object;
        }

        @NotNull
        public final Map<String, String[]> getCHANGE_NAME_TO_ID_ATTRS_MAP() {
            return CHANGE_NAME_TO_ID_ATTRS_MAP;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

