/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.view.structure;

import com.intellij.database.console.DataSourcePerFileMappings;
import com.intellij.database.console.QueryFilesUtilsKt;
import com.intellij.database.dataSource.AbstractDataSource;
import com.intellij.database.dataSource.DataSourceStorage;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.model.RawDataSource;
import com.intellij.database.model.basic.BasicModel;
import com.intellij.database.psi.DataSourceManager;
import com.intellij.database.settings.DatabaseSettings;
import com.intellij.database.view.DatabaseViewOptions;
import com.intellij.database.view.structure.DvTreeContext;
import com.intellij.database.view.structure.DvTreeLayerDef;
import com.intellij.database.view.structure.DvTreeStructure;
import com.intellij.database.view.structure.DvViewOptions;
import com.intellij.database.view.structure.DvViewOptionsFun;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.newvfs.BulkFileListener;
import com.intellij.openapi.vfs.newvfs.events.VFileDeleteEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileMoveEvent;
import com.intellij.openapi.vfs.newvfs.events.VFilePropertyChangeEvent;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.messages.Topic;
import java.util.Collection;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service(value={Service.Level.PROJECT})
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\"\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000b\b\u0007\u0018\u00002\u00020\u00012\u00020\u0002:\u0005\u0019\u001a\u001b\u001c\u001dB\u0011\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006B\u0011\b\u0012\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\u0005\u0010\tJ\u0016\u0010\r\u001a\u00020\u000e2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\f0\u0010H\u0016J\b\u0010\u0011\u001a\u00020\u000eH\u0016J\b\u0010\u0018\u001a\u00020\u000eH\u0002R\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u0012\u001a\u0004\u0018\u00010\u00138\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\u0015\"\u0004\b\u0016\u0010\u0017\u00a8\u0006\u001e"}, d2={"Lcom/intellij/database/view/structure/DvTreeStructureService;", "Lcom/intellij/database/view/structure/DvTreeStructure;", "Lcom/intellij/openapi/Disposable;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "context", "Lcom/intellij/database/view/structure/DvTreeContext;", "(Lcom/intellij/database/view/structure/DvTreeContext;)V", "selectedLayers", "Ljava/util/EnumSet;", "Lcom/intellij/database/view/structure/DvTreeLayerDef;", "setupLayers", "", "selectedLayerDefs", "", "dispose", "onStructureChanged", "Ljava/lang/Runnable;", "getOnStructureChanged", "()Ljava/lang/Runnable;", "setOnStructureChanged", "(Ljava/lang/Runnable;)V", "structureJustChanged", "DataSourceEventsListener", "StorageCoreListener", "OptionsChangedListener", "QueryFileListener", "VfsChangesListener", "intellij.database.core.impl"})
@SourceDebugExtension(value={"SMAP\nDvTreeStructureService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DvTreeStructureService.kt\ncom/intellij/database/view/structure/DvTreeStructureService\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,184:1\n13#2:185\n*S KotlinDebug\n*F\n+ 1 DvTreeStructureService.kt\ncom/intellij/database/view/structure/DvTreeStructureService\n*L\n35#1:185\n*E\n"})
public final class DvTreeStructureService
extends DvTreeStructure
implements Disposable {
    @NotNull
    private final EnumSet<DvTreeLayerDef> selectedLayers;
    @ApiStatus.Internal
    @Nullable
    private Runnable onStructureChanged;

    public DvTreeStructureService(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        DvViewOptions dvViewOptions = DvViewOptionsFun.getDatabaseViewOptions(project);
        boolean $i$f$logger = false;
        Logger logger2 = Logger.getInstance(DvTreeStructureService.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger2, (String)"getInstance(...)");
        this(new DvTreeContext(project, dvViewOptions, logger2));
    }

    private DvTreeStructureService(DvTreeContext context) {
        EnumSet<Enum[]> enumSet;
        EnumSet<DvTreeLayerDef> enumSet2 = EnumSet.allOf(DvTreeLayerDef.class);
        Intrinsics.checkNotNullExpressionValue(enumSet2, (String)"allOf(...)");
        super(context, (Set<? extends DvTreeLayerDef>)enumSet2);
        MessageBusConnection messageBusConnection = context.project.getMessageBus().connect((Disposable)this);
        OptionsChangedListener optionsChangedListener = new OptionsChangedListener();
        messageBusConnection.subscribe(DatabaseViewOptions.TOPIC, (Object)optionsChangedListener);
        Topic<Runnable> topic = DatabaseSettings.TOPIC;
        Intrinsics.checkNotNullExpressionValue(topic, (String)"TOPIC");
        messageBusConnection.subscribe(topic, (Object)optionsChangedListener);
        DataSourceEventsListener dsEventsListener = new DataSourceEventsListener();
        Topic topic2 = DataSourceManager.TOPIC;
        Intrinsics.checkNotNullExpressionValue((Object)topic2, (String)"TOPIC");
        messageBusConnection.subscribe(topic2, (Object)dsEventsListener);
        Topic<AbstractDataSource.Listener> topic3 = AbstractDataSource.TOPIC;
        Intrinsics.checkNotNullExpressionValue(topic3, (String)"TOPIC");
        messageBusConnection.subscribe(topic3, (Object)dsEventsListener);
        StorageCoreListener dsStorageCoreListener = new StorageCoreListener();
        Topic<DataSourceStorage.Listener> topic4 = DataSourceStorage.TOPIC;
        Intrinsics.checkNotNullExpressionValue(topic4, (String)"TOPIC");
        messageBusConnection.subscribe(topic4, (Object)dsStorageCoreListener);
        QueryFileListener queryFileListener2 = new QueryFileListener((Function1<? super Collection<? extends VirtualFile>, Unit>)((Function1)new Function1<Collection<? extends VirtualFile>, Unit>((Object)this){

            public final void invoke(Collection<? extends VirtualFile> p0) {
                Intrinsics.checkNotNullParameter(p0, (String)"p0");
                ((DvTreeStructureService)this.receiver).onFilesChanged(p0);
            }
        }), (Function0<Unit>)((Function0)() -> DvTreeStructureService._init_$lambda$0(this)));
        messageBusConnection.subscribe(DataSourcePerFileMappings.Companion.getTOPIC(), (Object)queryFileListener2);
        VfsChangesListener vfsListener2 = new VfsChangesListener((Function1<? super Collection<? extends VirtualFile>, Unit>)((Function1)new Function1<Collection<? extends VirtualFile>, Unit>((Object)this){

            public final void invoke(Collection<? extends VirtualFile> p0) {
                Intrinsics.checkNotNullParameter(p0, (String)"p0");
                ((DvTreeStructureService)this.receiver).onFilesChanged(p0);
            }
        }), (Function0<Unit>)((Function0)() -> DvTreeStructureService._init_$lambda$1(this)));
        Topic topic5 = VirtualFileManager.VFS_CHANGES;
        Intrinsics.checkNotNullExpressionValue((Object)topic5, (String)"VFS_CHANGES");
        messageBusConnection.subscribe(topic5, (Object)vfsListener2);
        boolean useNiceFolder = context.useNiceFolders;
        context.log.debug("UseNiceFolder: " + useNiceFolder);
        boolean useQueryFileFolder = QueryFilesUtilsKt.isQueryFilesDvTreeLayerEnabled();
        if (useNiceFolder && useQueryFileFolder) {
            var11_10 = new DvTreeLayerDef[]{DvTreeLayerDef.DVL_MODEL, DvTreeLayerDef.DVL_FILES, DvTreeLayerDef.DVL_LAYOUT, DvTreeLayerDef.DVL_IMPLANTS, DvTreeLayerDef.DVL_TRANSFORM, DvTreeLayerDef.DVL_OPTIMIZE, DvTreeLayerDef.DVL_CACHE};
            enumSet = EnumSet.of((Enum)DvTreeLayerDef.DVL_FOREST, (Enum[])var11_10);
        } else if (useNiceFolder) {
            var11_10 = new DvTreeLayerDef[]{DvTreeLayerDef.DVL_MODEL, DvTreeLayerDef.DVL_LAYOUT, DvTreeLayerDef.DVL_IMPLANTS, DvTreeLayerDef.DVL_TRANSFORM, DvTreeLayerDef.DVL_OPTIMIZE, DvTreeLayerDef.DVL_CACHE};
            enumSet = EnumSet.of((Enum)DvTreeLayerDef.DVL_FOREST, (Enum[])var11_10);
        } else {
            var11_10 = new DvTreeLayerDef[]{DvTreeLayerDef.DVL_MODEL, DvTreeLayerDef.DVL_LAYOUT, DvTreeLayerDef.DVL_IMPLANTS, DvTreeLayerDef.DVL_TRANSFORM, DvTreeLayerDef.DVL_OPTIMIZE, DvTreeLayerDef.DVL_CACHE};
            enumSet = EnumSet.of((Enum)DvTreeLayerDef.DVL_FOLDERS, (Enum[])var11_10);
        }
        EnumSet<Enum[]> enumSet3 = enumSet;
        Intrinsics.checkNotNull(enumSet3);
        this.selectedLayers = enumSet3;
        this.setupLayers((Set<? extends DvTreeLayerDef>)this.selectedLayers);
    }

    @Override
    public void setupLayers(@NotNull Set<? extends DvTreeLayerDef> selectedLayerDefs) {
        Intrinsics.checkNotNullParameter(selectedLayerDefs, (String)"selectedLayerDefs");
        super.setupLayers(selectedLayerDefs);
        this.structureJustChanged();
    }

    public void dispose() {
        this.onStructureChanged = null;
        this.clearAll();
    }

    @Nullable
    public final Runnable getOnStructureChanged() {
        return this.onStructureChanged;
    }

    public final void setOnStructureChanged(@Nullable Runnable runnable) {
        this.onStructureChanged = runnable;
    }

    private final void structureJustChanged() {
        block0: {
            Runnable runnable = this.onStructureChanged;
            if (runnable == null) break block0;
            runnable.run();
        }
    }

    private static final Unit _init_$lambda$0(DvTreeStructureService this$0) {
        this$0.structureJustChanged();
        return Unit.INSTANCE;
    }

    private static final Unit _init_$lambda$1(DvTreeStructureService this$0) {
        this$0.structureJustChanged();
        return Unit.INSTANCE;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0005\b\u0082\u0004\u0018\u00002\u00020\u00012\u00020\u0002B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J-\u0010\u0005\u001a\u00020\u0006\"\b\b\u0000\u0010\u0007*\u00020\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u0002H\u00070\n2\u0006\u0010\u000b\u001a\u0002H\u0007H\u0016\u00a2\u0006\u0002\u0010\fJ$\u0010\r\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\b2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u000fH\u0016J3\u0010\u0011\u001a\u00020\u0006\"\b\b\u0000\u0010\u0007*\u00020\b2\u0006\u0010\u000b\u001a\u0002H\u00072\b\u0010\u0012\u001a\u0004\u0018\u00010\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u0013H\u0016\u00a2\u0006\u0002\u0010\u0015J1\u0010\u0016\u001a\u00020\u0006\"\b\b\u0000\u0010\u0007*\u00020\b2\u000e\u0010\t\u001a\n\u0012\u0004\u0012\u0002H\u0007\u0018\u00010\n2\b\u0010\u000b\u001a\u0004\u0018\u0001H\u0007H\u0016\u00a2\u0006\u0002\u0010\fJ-\u0010\u0017\u001a\u00020\u0006\"\b\b\u0000\u0010\u0007*\u00020\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u0002H\u00070\n2\u0006\u0010\u000b\u001a\u0002H\u0007H\u0016\u00a2\u0006\u0002\u0010\f\u00a8\u0006\u0018"}, d2={"Lcom/intellij/database/view/structure/DvTreeStructureService$DataSourceEventsListener;", "Lcom/intellij/database/psi/DataSourceManager$Listener;", "Lcom/intellij/database/dataSource/AbstractDataSource$Listener;", "<init>", "(Lcom/intellij/database/view/structure/DvTreeStructureService;)V", "dataSourceAdded", "", "T", "Lcom/intellij/database/model/RawDataSource;", "manager", "Lcom/intellij/database/psi/DataSourceManager;", "dataSource", "(Lcom/intellij/database/psi/DataSourceManager;Lcom/intellij/database/model/RawDataSource;)V", "onModelReplaced", "oldModel", "Lcom/intellij/database/model/basic/BasicModel;", "newModel", "dataSourceGroupChanged", "oldGroupName", "", "newGroupName", "(Lcom/intellij/database/model/RawDataSource;Ljava/lang/String;Ljava/lang/String;)V", "dataSourceChanged", "dataSourceRemoved", "intellij.database.core.impl"})
    private final class DataSourceEventsListener
    implements DataSourceManager.Listener,
    AbstractDataSource.Listener {
        public <T extends RawDataSource> void dataSourceAdded(@NotNull DataSourceManager<T> manager, @NotNull T dataSource) {
            Intrinsics.checkNotNullParameter(manager, (String)"manager");
            Intrinsics.checkNotNullParameter(dataSource, (String)"dataSource");
            DvTreeStructureService.this.dataSourceAdded(dataSource);
            DvTreeStructureService.this.structureJustChanged();
        }

        @Override
        public void onModelReplaced(@NotNull RawDataSource dataSource, @Nullable BasicModel oldModel, @Nullable BasicModel newModel) {
            Intrinsics.checkNotNullParameter((Object)dataSource, (String)"dataSource");
            DvTreeStructureService.this.dataSourceModelReplaced(dataSource, oldModel, newModel);
            DvTreeStructureService.this.structureJustChanged();
        }

        public <T extends RawDataSource> void dataSourceGroupChanged(@NotNull T dataSource, @Nullable String oldGroupName, @Nullable String newGroupName) {
            Intrinsics.checkNotNullParameter(dataSource, (String)"dataSource");
            DvTreeStructureService.this.notifyDataSourcePathChanged(dataSource);
        }

        public <T extends RawDataSource> void dataSourceChanged(@Nullable DataSourceManager<T> manager, @Nullable T dataSource) {
            if (dataSource != null) {
                DvTreeStructureService.this.dataSourceChanged(dataSource);
            }
            DvTreeStructureService.this.structureJustChanged();
        }

        public <T extends RawDataSource> void dataSourceRemoved(@NotNull DataSourceManager<T> manager, @NotNull T dataSource) {
            Intrinsics.checkNotNullParameter(manager, (String)"manager");
            Intrinsics.checkNotNullParameter(dataSource, (String)"dataSource");
            DvTreeStructureService.this.dataSourceRemoved(dataSource);
            DvTreeStructureService.this.structureJustChanged();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0016\u00a8\u0006\u0006"}, d2={"Lcom/intellij/database/view/structure/DvTreeStructureService$OptionsChangedListener;", "Ljava/lang/Runnable;", "<init>", "(Lcom/intellij/database/view/structure/DvTreeStructureService;)V", "run", "", "intellij.database.core.impl"})
    private final class OptionsChangedListener
    implements Runnable {
        @Override
        public void run() {
            DvTreeStructureService.this.onViewOptionsChanged();
            DvTreeStructureService.this.structureJustChanged();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0082\u0004\u0018\u00002\u00020\u0001B/\u0012\u0018\u0010\u0002\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00050\u0004\u0012\u0004\u0012\u00020\u00060\u0003\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00060\b\u00a2\u0006\u0004\b\t\u0010\nJ\u0016\u0010\u000b\u001a\u00020\u00062\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004H\u0016R \u0010\u0002\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00050\u0004\u0012\u0004\u0012\u00020\u00060\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00060\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/intellij/database/view/structure/DvTreeStructureService$QueryFileListener;", "Lcom/intellij/database/console/DataSourcePerFileMappings$OnMappingsChangedListener;", "onFilesChanged", "Lkotlin/Function1;", "", "Lcom/intellij/openapi/vfs/VirtualFile;", "", "structureJustChanged", "Lkotlin/Function0;", "<init>", "(Lcom/intellij/database/view/structure/DvTreeStructureService;Lkotlin/jvm/functions/Function1;Lkotlin/jvm/functions/Function0;)V", "onMappingsChangedForFiles", "changedFiles", "intellij.database.core.impl"})
    private final class QueryFileListener
    implements DataSourcePerFileMappings.OnMappingsChangedListener {
        @NotNull
        private final Function1<Collection<? extends VirtualFile>, Unit> onFilesChanged;
        @NotNull
        private final Function0<Unit> structureJustChanged;

        public QueryFileListener(@NotNull Function1<? super Collection<? extends VirtualFile>, Unit> onFilesChanged, Function0<Unit> structureJustChanged) {
            Intrinsics.checkNotNullParameter(onFilesChanged, (String)"onFilesChanged");
            Intrinsics.checkNotNullParameter(structureJustChanged, (String)"structureJustChanged");
            this.onFilesChanged = onFilesChanged;
            this.structureJustChanged = structureJustChanged;
        }

        @Override
        public void onMappingsChangedForFiles(@NotNull Collection<? extends VirtualFile> changedFiles) {
            Intrinsics.checkNotNullParameter(changedFiles, (String)"changedFiles");
            this.onFilesChanged.invoke(changedFiles);
            this.structureJustChanged.invoke();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0012\u0010\b\u001a\u00020\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007H\u0016\u00a8\u0006\t"}, d2={"Lcom/intellij/database/view/structure/DvTreeStructureService$StorageCoreListener;", "Lcom/intellij/database/dataSource/DataSourceStorage$Listener;", "<init>", "(Lcom/intellij/database/view/structure/DvTreeStructureService;)V", "dataSourceRemoved", "", "dataSource", "Lcom/intellij/database/dataSource/LocalDataSource;", "dataSourceChanged", "intellij.database.core.impl"})
    private final class StorageCoreListener
    implements DataSourceStorage.Listener {
        @Override
        public void dataSourceRemoved(@NotNull LocalDataSource dataSource) {
            Intrinsics.checkNotNullParameter((Object)dataSource, (String)"dataSource");
            DvTreeStructureService.this.dataSourceRemoved(dataSource);
            DvTreeStructureService.this.structureJustChanged();
        }

        @Override
        public void dataSourceChanged(@Nullable LocalDataSource dataSource) {
            if (dataSource != null) {
                DvTreeStructureService.this.dataSourceChanged(dataSource);
            } else {
                DvTreeStructureService.this.clearAll();
            }
            DvTreeStructureService.this.structureJustChanged();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B/\u0012\u0018\u0010\u0002\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00050\u0004\u0012\u0004\u0012\u00020\u00060\u0003\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00060\b\u00a2\u0006\u0004\b\t\u0010\nJ\u0016\u0010\u000b\u001a\u00020\u00062\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rH\u0016R \u0010\u0002\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00050\u0004\u0012\u0004\u0012\u00020\u00060\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00060\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/intellij/database/view/structure/DvTreeStructureService$VfsChangesListener;", "Lcom/intellij/openapi/vfs/newvfs/BulkFileListener;", "onFilesChanged", "Lkotlin/Function1;", "", "Lcom/intellij/openapi/vfs/VirtualFile;", "", "structureJustChanged", "Lkotlin/Function0;", "<init>", "(Lcom/intellij/database/view/structure/DvTreeStructureService;Lkotlin/jvm/functions/Function1;Lkotlin/jvm/functions/Function0;)V", "after", "events", "", "Lcom/intellij/openapi/vfs/newvfs/events/VFileEvent;", "intellij.database.core.impl"})
    @SourceDebugExtension(value={"SMAP\nDvTreeStructureService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DvTreeStructureService.kt\ncom/intellij/database/view/structure/DvTreeStructureService$VfsChangesListener\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,184:1\n1869#2,2:185\n*S KotlinDebug\n*F\n+ 1 DvTreeStructureService.kt\ncom/intellij/database/view/structure/DvTreeStructureService$VfsChangesListener\n*L\n154#1:185,2\n*E\n"})
    private final class VfsChangesListener
    implements BulkFileListener {
        @NotNull
        private final Function1<Collection<? extends VirtualFile>, Unit> onFilesChanged;
        @NotNull
        private final Function0<Unit> structureJustChanged;

        public VfsChangesListener(@NotNull Function1<? super Collection<? extends VirtualFile>, Unit> onFilesChanged, Function0<Unit> structureJustChanged) {
            Intrinsics.checkNotNullParameter(onFilesChanged, (String)"onFilesChanged");
            Intrinsics.checkNotNullParameter(structureJustChanged, (String)"structureJustChanged");
            this.onFilesChanged = onFilesChanged;
            this.structureJustChanged = structureJustChanged;
        }

        public void after(@NotNull List<? extends VFileEvent> events) {
            Intrinsics.checkNotNullParameter(events, (String)"events");
            Iterable $this$forEach$iv = events;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                VirtualFile file;
                VFileEvent event = (VFileEvent)element$iv;
                boolean bl = false;
                VFileEvent vFileEvent = event;
                if (vFileEvent instanceof VFileDeleteEvent) {
                    Intrinsics.checkNotNullExpressionValue((Object)((VFileDeleteEvent)event).getFile(), (String)"getFile(...)");
                    this.onFilesChanged.invoke((Object)CollectionsKt.listOf((Object)file));
                    this.structureJustChanged.invoke();
                    continue;
                }
                if (vFileEvent instanceof VFilePropertyChangeEvent) {
                    if (!Intrinsics.areEqual((Object)((VFilePropertyChangeEvent)event).getPropertyName(), (Object)"name")) continue;
                    Intrinsics.checkNotNullExpressionValue((Object)((VFilePropertyChangeEvent)event).getFile(), (String)"getFile(...)");
                    Object oldName = ((VFilePropertyChangeEvent)event).getOldValue();
                    Object newName = ((VFilePropertyChangeEvent)event).getNewValue();
                    if (oldName == null || newName == null || Intrinsics.areEqual((Object)oldName, (Object)newName)) continue;
                    this.onFilesChanged.invoke((Object)CollectionsKt.listOf((Object)file));
                    this.structureJustChanged.invoke();
                    continue;
                }
                if (!(vFileEvent instanceof VFileMoveEvent)) continue;
                Intrinsics.checkNotNullExpressionValue((Object)((VFileMoveEvent)event).getFile(), (String)"getFile(...)");
                this.onFilesChanged.invoke((Object)CollectionsKt.listOf((Object)file));
                this.structureJustChanged.invoke();
            }
        }
    }
}

