/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.editor;

import com.intellij.database.DatabaseDataKeysCore;
import com.intellij.database.console.JdbcConsoleCore;
import com.intellij.database.console.JdbcConsoleProviderCore;
import com.intellij.database.dataSource.srcStorage.DbSrcUtilsCore;
import com.intellij.database.model.DasDataSource;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.psi.DbElement;
import com.intellij.database.psi.DbPsiFacade;
import com.intellij.database.psi.DbTable;
import com.intellij.database.script.generator.ScriptGenerator;
import com.intellij.database.script.generator.ScriptGenerators;
import com.intellij.database.util.DbImplUtilCore;
import com.intellij.database.util.ObjectPath;
import com.intellij.database.util.SearchPath;
import com.intellij.injected.editor.VirtualFileWindow;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileUtil;
import com.intellij.psi.PsiFile;
import com.intellij.util.ObjectUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DatabaseEditorHelperCore {
    public static final Key<Boolean> RESET_SEARCH_PATH = Key.create((String)"RESET_SEARCH_PATH");

    protected DatabaseEditorHelperCore() {
    }

    @Nullable
    public static SearchPath getSearchPath(@NotNull PsiFile psiFile) {
        if (psiFile == null) {
            DatabaseEditorHelperCore.$$$reportNull$$$0(0);
        }
        VirtualFile vfile = DatabaseEditorHelperCore.getVirtualFile(psiFile);
        DatabaseEditorHelperCore.resetSearchPathIfNeeded(psiFile, vfile);
        SearchPath res = (SearchPath)DatabaseDataKeysCore.SEARCH_PATH_KEY.get((UserDataHolder)psiFile);
        return res != null ? res : DatabaseEditorHelperCore.initSearchPath(psiFile, vfile);
    }

    @NotNull
    public static VirtualFile getVirtualFile(@NotNull PsiFile psiFile) {
        if (psiFile == null) {
            DatabaseEditorHelperCore.$$$reportNull$$$0(1);
        }
        VirtualFile vfile = psiFile.getViewProvider().getVirtualFile();
        if ((vfile = VirtualFileUtil.originalFileOrSelf((VirtualFile)vfile)) instanceof VirtualFileWindow) {
            vfile = ((VirtualFileWindow)vfile).getDelegate();
        }
        VirtualFile virtualFile = vfile;
        if (virtualFile == null) {
            DatabaseEditorHelperCore.$$$reportNull$$$0(2);
        }
        return virtualFile;
    }

    private static void resetSearchPathIfNeeded(@NotNull PsiFile psiFile, @NotNull VirtualFile vfile) {
        boolean resetSearchPath;
        if (psiFile == null) {
            DatabaseEditorHelperCore.$$$reportNull$$$0(3);
        }
        if (vfile == null) {
            DatabaseEditorHelperCore.$$$reportNull$$$0(4);
        }
        if (resetSearchPath = ((Boolean)RESET_SEARCH_PATH.get((UserDataHolder)vfile, (Object)false)).booleanValue()) {
            DatabaseDataKeysCore.SEARCH_PATH_KEY.set((UserDataHolder)psiFile, null);
            RESET_SEARCH_PATH.set((UserDataHolder)vfile, null);
        }
    }

    @Nullable
    private static SearchPath initSearchPath(@NotNull PsiFile psiFile, @NotNull VirtualFile vfile) {
        DbDataSource forcedDataSource;
        if (psiFile == null) {
            DatabaseEditorHelperCore.$$$reportNull$$$0(5);
        }
        if (vfile == null) {
            DatabaseEditorHelperCore.$$$reportNull$$$0(6);
        }
        Project project = psiFile.getProject();
        if (DbSrcUtilsCore.isDbSrcFile(vfile)) {
            SearchPath path = DatabaseEditorHelperCore.dbSrcSearchPath(project, vfile, false);
            DatabaseDataKeysCore.SEARCH_PATH_KEY.set((UserDataHolder)psiFile, (Object)path);
            return path;
        }
        JdbcConsoleCore console = JdbcConsoleProviderCore.getValidConsole(project, vfile);
        DbDataSource dbDataSource = forcedDataSource = console != null ? DbImplUtilCore.getDbDataSource(project, (DasDataSource)console.getDataSource()) : null;
        if (forcedDataSource != null) {
            SearchPath path = console.getSearchPath();
            DatabaseDataKeysCore.SEARCH_PATH_KEY.set((UserDataHolder)psiFile, (Object)path);
            return path;
        }
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            SearchPath path = (SearchPath)DatabaseDataKeysCore.SEARCH_PATH_KEY.get((UserDataHolder)vfile);
            DatabaseDataKeysCore.SEARCH_PATH_KEY.set((UserDataHolder)psiFile, (Object)path);
            return path;
        }
        DatabaseDataKeysCore.SEARCH_PATH_KEY.set((UserDataHolder)psiFile, null);
        return null;
    }

    @Nullable
    public static SearchPath dbSrcSearchPath(@NotNull Project project, @Nullable VirtualFile vfile, boolean schema) {
        ObjectPath path;
        DbDataSource dataSource;
        if (project == null) {
            DatabaseEditorHelperCore.$$$reportNull$$$0(7);
        }
        String dataSourceId = vfile == null ? null : DbSrcUtilsCore.getDataSource(vfile);
        DbDataSource dbDataSource = dataSource = dataSourceId == null ? null : DbPsiFacade.getInstance((Project)project).findDataSource(dataSourceId);
        if (dataSource != null && (path = DbSrcUtilsCore.getFullPath(vfile.getPath())) != null) {
            ObjectKind spKind = DbImplUtilCore.getDatabaseDialect((DbElement)dataSource).getSearchPathObjectKind();
            if (spKind == null) {
                return null;
            }
            ObjectPath spPath = path.findParent(spKind, false);
            if (spPath != null) {
                return SearchPath.of((ObjectPath)spPath);
            }
        }
        return null;
    }

    public static boolean isDefinitionAvailable(@Nullable DbElement element) {
        return element instanceof DbTable && element.getKind() == ObjectKind.TABLE ? DbImplUtilCore.isInLocalDataSource(element) : DatabaseEditorHelperCore.hasNewCodegen(element);
    }

    private static boolean hasNewCodegen(@Nullable DbElement element) {
        BasicElement e;
        BasicElement basicElement = e = element == null ? null : (BasicElement)ObjectUtils.tryCast((Object)element.getDelegate(), BasicElement.class);
        if (e == null) {
            return false;
        }
        ScriptGenerator generator = (ScriptGenerator)ScriptGenerators.INSTANCE.forDbms(DbImplUtilCore.getDbms(e));
        return generator.capabilities(e).getCreate().get(element.getDataSource().getVersion());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiFile";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/editor/DatabaseEditorHelperCore";
                break;
            }
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vfile";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/editor/DatabaseEditorHelperCore";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getVirtualFile";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getSearchPath";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getVirtualFile";
                break;
            }
            case 2: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "resetSearchPathIfNeeded";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "initSearchPath";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "dbSrcSearchPath";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2 -> new IllegalStateException(string);
        };
    }
}

