/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dataSource.connection.statements;

import com.intellij.database.dataSource.connection.Either;
import com.intellij.database.dataSource.connection.EitherKt;
import com.intellij.database.dataSource.connection.audit.ListenerAuditService;
import com.intellij.database.dataSource.connection.statements.SmartStatementMark;
import com.intellij.database.dataSource.connection.statements.StagedException;
import com.intellij.database.remote.jdbc.RemoteStatement;
import com.intellij.database.remote.jdbc.helpers.JdbcNativeUtil;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\bf\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u000222\u0012\u0016\u0012\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u0002H\u00010\u00050\u0004\u0012\u0016\u0012\u0014\u0012\u0004\u0012\u00020\u0006\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00010\u00070\u00050\u0003:\u0003\b\t\n\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\u000b\u00c0\u0006\u0001"}, d2={"Lcom/intellij/database/dataSource/connection/statements/StatementHolder;", "S", "Lcom/intellij/database/remote/jdbc/RemoteStatement;", "Lkotlin/Function1;", "Lkotlin/Function0;", "Lcom/intellij/database/dataSource/connection/Either;", "Lcom/intellij/database/dataSource/connection/statements/StagedException;", "Lcom/intellij/database/dataSource/connection/statements/StatementHolder$CloseableRef;", "Reusable", "OneShot", "CloseableRef", "intellij.database.core.impl"})
public interface StatementHolder<S extends RemoteStatement>
extends Function1<Function0<? extends Either<StagedException, S>>, Either<StagedException, CloseableRef<S>>> {

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0000\b&\u0018\u0000*\b\b\u0001\u0010\u0001*\u00020\u00022\u00060\u0003j\u0002`\u0004B\u000f\u0012\u0006\u0010\u0005\u001a\u00028\u0001\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\u000b\u001a\u00020\fH\u0016J\u0015\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0005\u001a\u00028\u0001H&\u00a2\u0006\u0002\u0010\u0007R\u0013\u0010\u0005\u001a\u00028\u0001\u00a2\u0006\n\n\u0002\u0010\n\u001a\u0004\b\b\u0010\t\u00a8\u0006\r"}, d2={"Lcom/intellij/database/dataSource/connection/statements/StatementHolder$CloseableRef;", "T", "Lcom/intellij/database/remote/jdbc/RemoteStatement;", "Ljava/lang/AutoCloseable;", "Lkotlin/AutoCloseable;", "value", "<init>", "(Lcom/intellij/database/remote/jdbc/RemoteStatement;)V", "getValue", "()Lcom/intellij/database/remote/jdbc/RemoteStatement;", "Lcom/intellij/database/remote/jdbc/RemoteStatement;", "close", "", "intellij.database.core.impl"})
    public static abstract class CloseableRef<T extends RemoteStatement>
    implements AutoCloseable {
        @NotNull
        private final T value;

        public CloseableRef(@NotNull T value) {
            Intrinsics.checkNotNullParameter(value, (String)"value");
            this.value = value;
        }

        @NotNull
        public final T getValue() {
            return this.value;
        }

        @Override
        public void close() {
            this.close(this.value);
        }

        public abstract void close(@NotNull T var1);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u0000*\b\b\u0001\u0010\u0001*\u00020\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0003B\u0017\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ5\u0010\n\u001a\u0014\u0012\u0004\u0012\u00020\f\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00010\r0\u000b2\u0018\u0010\u000e\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00028\u00010\u000b0\u000fH\u0096\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/intellij/database/dataSource/connection/statements/StatementHolder$OneShot;", "S", "Lcom/intellij/database/remote/jdbc/RemoteStatement;", "Lcom/intellij/database/dataSource/connection/statements/StatementHolder;", "listener", "Lcom/intellij/database/dataSource/connection/audit/ListenerAuditService;", "mark", "Lcom/intellij/database/dataSource/connection/statements/SmartStatementMark;", "<init>", "(Lcom/intellij/database/dataSource/connection/audit/ListenerAuditService;Lcom/intellij/database/dataSource/connection/statements/SmartStatementMark;)V", "invoke", "Lcom/intellij/database/dataSource/connection/Either;", "Lcom/intellij/database/dataSource/connection/statements/StagedException;", "Lcom/intellij/database/dataSource/connection/statements/StatementHolder$CloseableRef;", "constructor", "Lkotlin/Function0;", "intellij.database.core.impl"})
    public static final class OneShot<S extends RemoteStatement>
    implements StatementHolder<S> {
        @NotNull
        private final ListenerAuditService listener;
        @NotNull
        private final SmartStatementMark mark;

        public OneShot(@NotNull ListenerAuditService listener, @NotNull SmartStatementMark mark2) {
            Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
            Intrinsics.checkNotNullParameter((Object)mark2, (String)"mark");
            this.listener = listener;
            this.mark = mark2;
        }

        @NotNull
        public Either<StagedException, CloseableRef<S>> invoke(@NotNull Function0<Either<StagedException, S>> constructor) {
            Intrinsics.checkNotNullParameter(constructor, (String)"constructor");
            return ((Either)constructor.invoke()).shelter(arg_0 -> OneShot.invoke$lambda$0(this, arg_0));
        }

        private static final CloseableRef invoke$lambda$0(OneShot this$0, RemoteStatement it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            return new CloseableRef<S>(it, this$0){
                final /* synthetic */ OneShot<S> this$0;
                {
                    this.this$0 = $receiver;
                    super($it);
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void close(S value) {
                    Intrinsics.checkNotNullParameter(value, (String)"value");
                    try {
                        OneShot.access$getListener$p(this.this$0).beforeStatementClosing((RemoteStatement)value, OneShot.access$getMark$p(this.this$0));
                    }
                    finally {
                        JdbcNativeUtil.performSafe(() -> value.close());
                    }
                }
            };
        }

        public static final /* synthetic */ ListenerAuditService access$getListener$p(OneShot $this) {
            return $this.listener;
        }

        public static final /* synthetic */ SmartStatementMark access$getMark$p(OneShot $this) {
            return $this.mark;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u0000*\b\b\u0001\u0010\u0001*\u00020\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0003B\u0007\u00a2\u0006\u0004\b\u0004\u0010\u0005J5\u0010\f\u001a\u0014\u0012\u0004\u0012\u00020\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00010\u000f0\r2\u0018\u0010\u0010\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00028\u00010\r0\u0011H\u0096\u0002J.\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00028\u00010\r2\u0018\u0010\u0010\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00028\u00010\r0\u0011H\u0002R\u001e\u0010\u0006\u001a\u0004\u0018\u00018\u0001X\u0086\u000e\u00a2\u0006\u0010\n\u0002\u0010\u000b\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\n\u00a8\u0006\u0012"}, d2={"Lcom/intellij/database/dataSource/connection/statements/StatementHolder$Reusable;", "S", "Lcom/intellij/database/remote/jdbc/RemoteStatement;", "Lcom/intellij/database/dataSource/connection/statements/StatementHolder;", "<init>", "()V", "statement", "getStatement", "()Lcom/intellij/database/remote/jdbc/RemoteStatement;", "setStatement", "(Lcom/intellij/database/remote/jdbc/RemoteStatement;)V", "Lcom/intellij/database/remote/jdbc/RemoteStatement;", "invoke", "Lcom/intellij/database/dataSource/connection/Either;", "Lcom/intellij/database/dataSource/connection/statements/StagedException;", "Lcom/intellij/database/dataSource/connection/statements/StatementHolder$CloseableRef;", "constructor", "Lkotlin/Function0;", "intellij.database.core.impl"})
    public static final class Reusable<S extends RemoteStatement>
    implements StatementHolder<S> {
        @Nullable
        private S statement;

        @Nullable
        public final S getStatement() {
            return this.statement;
        }

        public final void setStatement(@Nullable S s) {
            this.statement = s;
        }

        @NotNull
        public Either<StagedException, CloseableRef<S>> invoke(@NotNull Function0<Either<StagedException, S>> constructor) {
            Intrinsics.checkNotNullParameter(constructor, (String)"constructor");
            return EitherKt.transformSafe(this.getStatement(constructor), Reusable::invoke$lambda$0);
        }

        private final Either<StagedException, S> getStatement(Function0<Either<StagedException, S>> constructor) {
            Either<Object, Object> either;
            if (this.statement != null) {
                S s = this.statement;
                Intrinsics.checkNotNull(s);
                either = Either.Companion.right(s);
            } else {
                either = EitherKt.transformSafe((Either)constructor.invoke(), arg_0 -> Reusable.getStatement$lambda$0(this, arg_0));
            }
            return either;
        }

        private static final Either invoke$lambda$0(RemoteStatement it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            return Either.Companion.right(new CloseableRef<S>(it){

                public void close(S value) {
                    Intrinsics.checkNotNullParameter(value, (String)"value");
                }
            });
        }

        private static final Either getStatement$lambda$0(Reusable this$0, RemoteStatement it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            this$0.statement = it;
            return Either.Companion.right(it);
        }
    }
}

