/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database;

import com.github.benmanes.caffeine.cache.Caffeine;
import com.intellij.database.dataSource.DataSourceFun;
import com.intellij.database.model.DasModel;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.RawDataSource;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicModel;
import com.intellij.database.model.basic.BasicObjectNode;
import com.intellij.database.model.basic.BasicRoot;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.psi.DbElement;
import com.intellij.database.psi.DbPsiFacade;
import com.intellij.database.util.DasUtil;
import com.intellij.database.util.DbImplUtilCore;
import com.intellij.database.view.DataSourceNode;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.project.Project;
import com.intellij.util.containers.ConcurrentFactoryMap;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.messages.Topic;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service(value={Service.Level.PROJECT})
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0005\b\u0007\u0018\u00002\u00020\u0001B\u0011\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0012\u0010\u0014\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0015\u001a\u00020\u0010H\u0002J\u0014\u0010\u0016\u001a\u0004\u0018\u00010\u00112\b\u0010\u0017\u001a\u0004\u0018\u00010\u0013H\u0002J\u0010\u0010\u0018\u001a\u0004\u0018\u00010\u00192\u0006\u0010\u001a\u001a\u00020\u001bJ\u0010\u0010\u0018\u001a\u0004\u0018\u00010\u00192\u0006\u0010\u0015\u001a\u00020\u0010J\u0010\u0010\u001c\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u001a\u001a\u00020\u001bJ\u0010\u0010\u001c\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u001a\u001a\u00020\u001dJ\u0010\u0010\u001c\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0015\u001a\u00020\u0010J\u0010\u0010\u001c\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u001e\u001a\u00020\u001fJ\u0010\u0010 \u001a\u0004\u0018\u00010!2\u0006\u0010\u001a\u001a\u00020\u001bJ\u0010\u0010 \u001a\u0004\u0018\u00010!2\u0006\u0010\u001a\u001a\u00020\u001dJ\u0012\u0010\u001c\u001a\u0004\u0018\u00010\u00112\b\u0010\"\u001a\u0004\u0018\u00010\u0013J\u0012\u0010 \u001a\u0004\u0018\u00010!2\b\u0010\"\u001a\u0004\u0018\u00010\u0013J\u0012\u0010#\u001a\u0004\u0018\u00010\u00112\u0006\u0010$\u001a\u00020\u0013H\u0002J\b\u0010%\u001a\u00020&H\u0002J\u0010\u0010'\u001a\u00020&2\u0006\u0010(\u001a\u00020\u0011H\u0002J\u0012\u0010)\u001a\u00020&2\b\u0010(\u001a\u0004\u0018\u00010\u0011H\u0002J\b\u0010*\u001a\u00020&H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u001b\u0010\b\u001a\u00020\t8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\f\u0010\r\u001a\u0004\b\n\u0010\u000bR\u001c\u0010\u000e\u001a\u0010\u0012\u0004\u0012\u00020\u0010\u0012\u0006\u0012\u0004\u0018\u00010\u00110\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0012\u001a\u0010\u0012\u0004\u0012\u00020\u0013\u0012\u0006\u0012\u0004\u0018\u00010\u00110\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006+"}, d2={"Lcom/intellij/database/DbModelRegistry;", "Lcom/intellij/openapi/Disposable;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "psiFacade", "Lcom/intellij/database/psi/DbPsiFacade;", "getPsiFacade", "()Lcom/intellij/database/psi/DbPsiFacade;", "psiFacade$delegate", "Lkotlin/Lazy;", "models", "Ljava/util/concurrent/ConcurrentMap;", "Lcom/intellij/database/model/basic/BasicModel;", "Lcom/intellij/database/psi/DbDataSource;", "roots", "Lcom/intellij/database/model/DasObject;", "obtainDbDataSourceForModel", "model", "obtainDbDataSourceForRoot", "key", "findDataSource", "Lcom/intellij/database/model/RawDataSource;", "element", "Lcom/intellij/database/model/basic/BasicElement;", "findDbDataSource", "Lcom/intellij/database/model/basic/BasicObjectNode;", "dsn", "Lcom/intellij/database/view/DataSourceNode;", "findDbElement", "Lcom/intellij/database/psi/DbElement;", "o", "getDbDataSourceByRoot", "root", "clear", "", "invalidate", "dbDS", "onDataSourceChanged", "dispose", "intellij.database.core.impl"})
@SourceDebugExtension(value={"SMAP\nDbModelRegistry.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DbModelRegistry.kt\ncom/intellij/database/DbModelRegistry\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,179:1\n1#2:180\n1761#3,3:181\n*S KotlinDebug\n*F\n+ 1 DbModelRegistry.kt\ncom/intellij/database/DbModelRegistry\n*L\n61#1:181,3\n*E\n"})
public final class DbModelRegistry
implements Disposable {
    @NotNull
    private final Project project;
    @NotNull
    private final Lazy psiFacade$delegate;
    @NotNull
    private final ConcurrentMap<BasicModel, DbDataSource> models;
    @NotNull
    private final ConcurrentMap<DasObject, DbDataSource> roots;

    private DbModelRegistry(Project project) {
        this.project = project;
        this.psiFacade$delegate = LazyKt.lazy(() -> DbModelRegistry.psiFacade_delegate$lambda$0(this));
        ConcurrentMap concurrentMap = ConcurrentFactoryMap.createWeakMap(arg_0 -> DbModelRegistry.models$lambda$0((Function1)new Function1<BasicModel, DbDataSource>((Object)this){

            public final DbDataSource invoke(BasicModel p0) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                return DbModelRegistry.access$obtainDbDataSourceForModel((DbModelRegistry)this.receiver, p0);
            }
        }, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)concurrentMap, (String)"createWeakMap(...)");
        this.models = concurrentMap;
        ConcurrentMap concurrentMap2 = ConcurrentFactoryMap.create(arg_0 -> DbModelRegistry.roots$lambda$0((Function1)new Function1<DasObject, DbDataSource>((Object)this){

            public final DbDataSource invoke(DasObject p0) {
                return DbModelRegistry.access$obtainDbDataSourceForRoot((DbModelRegistry)this.receiver, p0);
            }
        }, arg_0), DbModelRegistry::roots$lambda$1);
        Intrinsics.checkNotNullExpressionValue((Object)concurrentMap2, (String)"create(...)");
        this.roots = concurrentMap2;
        MessageBusConnection messageBusConnection = this.project.getMessageBus().connect((Disposable)this);
        Topic topic = DbPsiFacade.TOPIC;
        Intrinsics.checkNotNullExpressionValue((Object)topic, (String)"TOPIC");
        messageBusConnection.subscribe(topic, this::onDataSourceChanged);
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    private final DbPsiFacade getPsiFacade() {
        Lazy lazy = this.psiFacade$delegate;
        return (DbPsiFacade)lazy.getValue();
    }

    private final DbDataSource obtainDbDataSourceForModel(BasicModel model) {
        Object v1;
        block1: {
            List list = this.getPsiFacade().getDataSources();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getDataSources(...)");
            Iterable iterable = list;
            for (Object t : iterable) {
                DbDataSource ds = (DbDataSource)t;
                boolean bl = false;
                if (!(ds.getDelegateDataSource().getModel() == model)) continue;
                v1 = t;
                break block1;
            }
            v1 = null;
        }
        return v1;
    }

    private final DbDataSource obtainDbDataSourceForRoot(DasObject key) {
        Object v3;
        block7: {
            List list = this.getPsiFacade().getDataSources();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getDataSources(...)");
            Iterable iterable = list;
            for (Object t : iterable) {
                boolean bl;
                block6: {
                    DasModel model;
                    DbDataSource o = (DbDataSource)t;
                    boolean bl2 = false;
                    Intrinsics.checkNotNullExpressionValue((Object)o.getDelegate().getModel(), (String)"getModel(...)");
                    if (model instanceof BasicModel) {
                        bl = ((BasicModel)model).getRoot() == key;
                    } else {
                        JBIterable jBIterable = model.getModelRoots();
                        Intrinsics.checkNotNullExpressionValue((Object)jBIterable, (String)"getModelRoots(...)");
                        Iterable $this$any$iv = (Iterable)jBIterable;
                        boolean $i$f$any = false;
                        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                            bl = false;
                        } else {
                            for (Object element$iv : $this$any$iv) {
                                DasObject root = (DasObject)element$iv;
                                boolean bl3 = false;
                                if (!(root == key || root.getDasParent() == key)) continue;
                                bl = true;
                                break block6;
                            }
                            bl = false;
                        }
                    }
                }
                if (!bl) continue;
                v3 = t;
                break block7;
            }
            v3 = null;
        }
        return v3;
    }

    @Nullable
    public final RawDataSource findDataSource(@NotNull BasicElement element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        DbDataSource dbDataSource = this.findDbDataSource(element);
        return dbDataSource != null ? DataSourceFun.getRawDataSource(dbDataSource) : null;
    }

    @Nullable
    public final RawDataSource findDataSource(@NotNull BasicModel model) {
        Intrinsics.checkNotNullParameter((Object)model, (String)"model");
        DbDataSource dbDataSource = this.findDbDataSource(model);
        return dbDataSource != null ? DataSourceFun.getRawDataSource(dbDataSource) : null;
    }

    @Nullable
    public final DbDataSource findDbDataSource(@NotNull BasicElement element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        return this.findDbDataSource((BasicObjectNode)element);
    }

    @Nullable
    public final DbDataSource findDbDataSource(@NotNull BasicObjectNode element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        BasicModel basicModel = element.getModel();
        if (basicModel == null) {
            return null;
        }
        BasicModel model = basicModel;
        return this.findDbDataSource(model);
    }

    @Nullable
    public final DbDataSource findDbDataSource(@NotNull BasicModel model) {
        Intrinsics.checkNotNullParameter((Object)model, (String)"model");
        DbDataSource dbDataSource = (DbDataSource)this.models.get(model);
        if (dbDataSource != null && !dbDataSource.isValid()) {
            this.models.remove(model);
            this.roots.remove(model.getRoot(), dbDataSource);
            dbDataSource = (DbDataSource)this.models.get(model);
        }
        return dbDataSource;
    }

    @Nullable
    public final DbDataSource findDbDataSource(@NotNull DataSourceNode dsn) {
        Intrinsics.checkNotNullParameter((Object)dsn, (String)"dsn");
        BasicModel model = dsn.getModel();
        return model == null ? this.getPsiFacade().findDataSource(dsn.getUniqueId()) : this.findDbDataSource(model);
    }

    @Nullable
    public final DbElement findDbElement(@NotNull BasicElement element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        return this.findDbElement((BasicObjectNode)element);
    }

    @Nullable
    public final DbElement findDbElement(@NotNull BasicObjectNode element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        DbDataSource dbDataSource = this.findDbDataSource(element);
        if (dbDataSource == null) {
            return null;
        }
        DbDataSource dataSource = dbDataSource;
        DasObject dasObject = element instanceof DasObject ? (DasObject)element : null;
        if (dasObject == null) {
            BasicElement basicElement = element.extractObject();
            Intrinsics.checkNotNullExpressionValue((Object)basicElement, (String)"extractObject(...)");
            dasObject = basicElement;
        }
        return dataSource.findElement(dasObject);
    }

    @Nullable
    public final DbDataSource findDbDataSource(@Nullable DasObject o) {
        DbDataSource dbDataSource;
        DasObject theOldestAncestor;
        if (o == null) {
            return null;
        }
        if (o instanceof DbElement) {
            return ((DbElement)o).getDataSource();
        }
        DasObject dasObject = o;
        DasObject dasObject2 = theOldestAncestor = dasObject instanceof BasicRoot ? o : (dasObject instanceof BasicObjectNode ? (DasObject)DasUtil.getParentOfClass((DasObject)o, BasicRoot.class, (boolean)false) : (DasObject)DasUtil.dasParents((DasObject)o).last());
        if (dasObject2 != null) {
            DasObject it = dasObject2;
            boolean bl = false;
            dbDataSource = this.getDbDataSourceByRoot(it);
        } else {
            dbDataSource = null;
        }
        return dbDataSource;
    }

    @Nullable
    public final DbElement findDbElement(@Nullable DasObject o) {
        DbDataSource dataSource;
        if (o == null) {
            return null;
        }
        if (o instanceof DbElement) {
            return (DbElement)o;
        }
        DbDataSource dbDataSource = dataSource = this.findDbDataSource(o);
        return dbDataSource == null ? null : DbImplUtilCore.findElement(dbDataSource, o);
    }

    private final DbDataSource getDbDataSourceByRoot(DasObject root) {
        BasicModel model;
        DbDataSource dbDS = null;
        if (root instanceof BasicElement && (model = ((BasicElement)root).getModel()) != null) {
            dbDS = this.findDbDataSource(model);
        }
        if (dbDS == null && (dbDS = (DbDataSource)this.roots.get(root)) != null && !dbDS.isValid()) {
            this.roots.remove(root);
            this.invalidate(dbDS);
            dbDS = (DbDataSource)this.roots.get(root);
        }
        return dbDS;
    }

    private final void clear() {
        this.models.clear();
        this.roots.clear();
    }

    private final void invalidate(DbDataSource dbDS) {
        if (this.models.isEmpty()) {
            return;
        }
        Set entries = this.models.entrySet();
        Iterator it = entries.iterator();
        while (it.hasNext()) {
            Map.Entry e = it.next();
            if (e.getValue() != dbDS || e.getKey() == dbDS.getModel()) continue;
            it.remove();
        }
    }

    private final void onDataSourceChanged(DbDataSource dbDS) {
        DbDataSource dbDataSource = dbDS;
        if (dbDataSource == null) {
            this.models.clear();
        } else {
            this.invalidate(dbDataSource);
        }
        this.roots.clear();
    }

    public void dispose() {
        this.clear();
    }

    private static final DbPsiFacade psiFacade_delegate$lambda$0(DbModelRegistry this$0) {
        DbPsiFacade dbPsiFacade = DbPsiFacade.getInstance((Project)this$0.project);
        Intrinsics.checkNotNullExpressionValue((Object)dbPsiFacade, (String)"getInstance(...)");
        return dbPsiFacade;
    }

    private static final DbDataSource models$lambda$0(Function1 $tmp0, Object p0) {
        return (DbDataSource)$tmp0.invoke(p0);
    }

    private static final DbDataSource roots$lambda$0(Function1 $tmp0, Object p0) {
        return (DbDataSource)$tmp0.invoke(p0);
    }

    private static final ConcurrentMap roots$lambda$1() {
        return Caffeine.newBuilder().weakKeys().weakValues().build().asMap();
    }

    public static final /* synthetic */ DbDataSource access$obtainDbDataSourceForModel(DbModelRegistry $this, BasicModel model) {
        return $this.obtainDbDataSourceForModel(model);
    }

    public static final /* synthetic */ DbDataSource access$obtainDbDataSourceForRoot(DbModelRegistry $this, DasObject key) {
        return $this.obtainDbDataSourceForRoot(key);
    }
}

