/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.console.ssh;

import com.intellij.credentialStore.Credentials;
import com.intellij.credentialStore.OneTimeString;
import com.intellij.database.console.ssh.SocksServerConnectHandler;
import com.intellij.database.dataSource.url.HostPort;
import com.intellij.database.view.DatabaseCoreUiService;
import com.intellij.openapi.diagnostic.Logger;
import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.handler.codec.socksx.SocksMessage;
import io.netty.handler.codec.socksx.SocksVersion;
import io.netty.handler.codec.socksx.v5.DefaultSocks5InitialResponse;
import io.netty.handler.codec.socksx.v5.DefaultSocks5PasswordAuthResponse;
import io.netty.handler.codec.socksx.v5.Socks5AuthMethod;
import io.netty.handler.codec.socksx.v5.Socks5CommandRequest;
import io.netty.handler.codec.socksx.v5.Socks5CommandRequestDecoder;
import io.netty.handler.codec.socksx.v5.Socks5CommandType;
import io.netty.handler.codec.socksx.v5.Socks5InitialRequest;
import io.netty.handler.codec.socksx.v5.Socks5PasswordAuthRequest;
import io.netty.handler.codec.socksx.v5.Socks5PasswordAuthRequestDecoder;
import io.netty.handler.codec.socksx.v5.Socks5PasswordAuthStatus;
import io.netty.util.concurrent.GenericFutureListener;
import java.util.function.Function;
import org.jetbrains.annotations.NotNull;

public class SocksServerHandler
extends SimpleChannelInboundHandler<SocksMessage> {
    private static final Logger LOG = Logger.getInstance(SocksServerHandler.class);
    private final Function<HostPort, Integer> localTunnelProvider;
    private final HostPort myHostPort;

    public SocksServerHandler(@NotNull HostPort proxyHostPort, @NotNull Function<HostPort, Integer> localTunnelProvider) {
        if (proxyHostPort == null) {
            SocksServerHandler.$$$reportNull$$$0(0);
        }
        if (localTunnelProvider == null) {
            SocksServerHandler.$$$reportNull$$$0(1);
        }
        this.myHostPort = proxyHostPort;
        this.localTunnelProvider = localTunnelProvider;
    }

    public void channelRead0(ChannelHandlerContext ctx, SocksMessage socksRequest) {
        if (socksRequest.version() == SocksVersion.SOCKS5) {
            if (socksRequest instanceof Socks5InitialRequest) {
                ctx.pipeline().addFirst(new ChannelHandler[]{new Socks5PasswordAuthRequestDecoder()});
                ctx.write((Object)new DefaultSocks5InitialResponse(Socks5AuthMethod.PASSWORD));
            } else if (socksRequest instanceof Socks5PasswordAuthRequest) {
                Socks5PasswordAuthRequest passwordAuthRequest = (Socks5PasswordAuthRequest)socksRequest;
                OneTimeString password = new OneTimeString(passwordAuthRequest.password());
                ctx.pipeline().addFirst(new ChannelHandler[]{new Socks5CommandRequestDecoder()});
                Credentials expectedPassword = DatabaseCoreUiService.getInstance().getProxyServerCredentials(this.myHostPort.getHost(), this.myHostPort.getPortAsInt());
                if (expectedPassword == null || expectedPassword.getPassword() == null) {
                    LOG.warn("No password found for " + String.valueOf(this.myHostPort));
                    ctx.write((Object)new DefaultSocks5PasswordAuthResponse(Socks5PasswordAuthStatus.FAILURE));
                } else {
                    boolean passwordMatches = expectedPassword.getPassword().equals((Object)password);
                    if (!passwordMatches) {
                        LOG.warn("Password mismatch for " + String.valueOf(this.myHostPort));
                    }
                    ctx.write((Object)new DefaultSocks5PasswordAuthResponse(passwordMatches ? Socks5PasswordAuthStatus.SUCCESS : Socks5PasswordAuthStatus.FAILURE));
                }
            } else if (socksRequest instanceof Socks5CommandRequest) {
                Socks5CommandRequest socks5CmdRequest = (Socks5CommandRequest)socksRequest;
                if (socks5CmdRequest.type() == Socks5CommandType.CONNECT) {
                    ctx.pipeline().addLast(new ChannelHandler[]{new SocksServerConnectHandler(this.localTunnelProvider)});
                    ctx.pipeline().remove((ChannelHandler)this);
                    ctx.fireChannelRead((Object)socksRequest);
                } else {
                    LOG.warn("Unsupported command type: " + String.valueOf(socks5CmdRequest.type()));
                    ctx.close();
                }
            } else {
                LOG.warn("Unsupported socks5 request: " + String.valueOf(socksRequest));
                ctx.close();
            }
        } else {
            LOG.warn("Unsupported version: " + String.valueOf(socksRequest.version()));
            ctx.close();
        }
    }

    public void channelReadComplete(ChannelHandlerContext ctx) {
        ctx.flush();
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
        Channel channel = ctx.channel();
        if (channel.isActive()) {
            LOG.error("Close channel", cause);
            channel.writeAndFlush((Object)Unpooled.EMPTY_BUFFER).addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "proxyHostPort";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "localTunnelProvider";
                break;
            }
        }
        objectArray[1] = "com/intellij/database/console/ssh/SocksServerHandler";
        objectArray[2] = "<init>";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

