/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.console;

import com.intellij.database.access.DatabaseCredentials;
import com.intellij.database.console.JdbcConsoleRunContext;
import com.intellij.database.console.JdbcDriverManager;
import com.intellij.database.console.JdbcRemoteConsoleProcessSupport;
import com.intellij.database.console.RemoteConsoleProcessSupport;
import com.intellij.database.console.UtilKt;
import com.intellij.database.console.ssh.DatabaseSshTunnelsManager;
import com.intellij.database.dataSource.DatabaseConnectionManager;
import com.intellij.database.dataSource.DatabaseSshTunnelEstablisher;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.dataSource.url.HostPort;
import com.intellij.database.model.DasDataSource;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.psi.DbPsiFacade;
import com.intellij.database.remote.jdbc.RemoteDriver;
import com.intellij.database.remote.jdbc.RemoteDriverFactory;
import com.intellij.database.remote.jdbc.RemoteProcessController;
import com.intellij.database.run.ConsoleRunConfiguration;
import com.intellij.database.util.DataSourceUtil;
import com.intellij.database.util.DbImplUtilCore;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.progress.ProgressIndicatorProvider;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.ModificationTracker;
import com.intellij.openapi.util.ModificationTrackerListener;
import com.intellij.openapi.util.Pair;
import com.intellij.util.EventDispatcher;
import java.util.List;
import java.util.concurrent.Future;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

public final class JdbcDriverManagerImpl
extends JdbcDriverManager
implements Disposable {
    private final EventDispatcher<ModificationTrackerListener<JdbcDriverManager>> myDispatcher;
    private final DatabaseSshTunnelsManager mySshManager;
    private final RemoteConsoleProcessSupport<LocalDataSource, RemoteDriverFactory> mySupport;
    private final Project myProject;

    public JdbcDriverManagerImpl(@NotNull Project project) {
        if (project == null) {
            JdbcDriverManagerImpl.$$$reportNull$$$0(0);
        }
        this.myDispatcher = DataSourceUtil.eventDispatcher(ModificationTrackerListener.class);
        this.myProject = project;
        this.mySshManager = new DatabaseSshTunnelsManager(project);
        Runnable fireModificationCountChanged = () -> {
            this.incModificationCount();
            ApplicationManager.getApplication().invokeLater(() -> ((ModificationTrackerListener)this.myDispatcher.getMulticaster()).modificationCountChanged((Object)this));
        };
        this.mySupport = new JdbcRemoteConsoleProcessSupport(this.myProject, this.mySshManager, fireModificationCountChanged);
        this.myProject.getMessageBus().connect((Disposable)this).subscribe(DbPsiFacade.TOPIC, o -> {
            DbPsiFacade facade = DbPsiFacade.getInstance((Project)this.myProject);
            for (Pair pair : this.mySupport.getActiveConfigurations()) {
                DbDataSource dataSource = facade.findDataSource(((LocalDataSource)pair.first).getUniqueId());
                if (DbImplUtilCore.getMaybeLocalDataSource((DasDataSource)dataSource) == pair.first) continue;
                this.releaseDriver((LocalDataSource)pair.first, null);
            }
        });
        Disposer.register((Disposable)this, this.mySupport);
    }

    public void dispose() {
    }

    @Override
    public ModificationTracker getModificationTracker() {
        return this;
    }

    @Override
    public Project getProject() {
        return this.myProject;
    }

    @Override
    @NotNull
    public ConsoleRunConfiguration getDefaultRunConfiguration(@NotNull LocalDataSource dataSource, @Nullable DatabaseCredentials credentialsStore) {
        if (dataSource == null) {
            JdbcDriverManagerImpl.$$$reportNull$$$0(1);
        }
        ConsoleRunConfiguration consoleRunConfiguration = JdbcDriverManagerImpl.chooseRunConfiguration(this.myProject, dataSource, credentialsStore);
        if (consoleRunConfiguration == null) {
            JdbcDriverManagerImpl.$$$reportNull$$$0(2);
        }
        return consoleRunConfiguration;
    }

    @Override
    public List<ConsoleRunConfiguration> getActiveConfigurations(@NotNull LocalDataSource dataSource) {
        if (dataSource == null) {
            JdbcDriverManagerImpl.$$$reportNull$$$0(3);
        }
        return this.mySupport.getActiveConfigurations(dataSource);
    }

    @Override
    public RemoteDriver getDriver(@NotNull LocalDataSource dataSource, @NotNull ConsoleRunConfiguration configuration) throws Exception {
        if (dataSource == null) {
            JdbcDriverManagerImpl.$$$reportNull$$$0(4);
        }
        if (configuration == null) {
            JdbcDriverManagerImpl.$$$reportNull$$$0(5);
        }
        try {
            return this.getDriverImpl(dataSource, configuration);
        }
        catch (Throwable e) {
            this.releaseDriver(dataSource, configuration);
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private RemoteDriver getDriverImpl(@NotNull LocalDataSource dataSource, @NotNull ConsoleRunConfiguration configuration) throws Exception {
        RemoteDriverFactory factory;
        if (dataSource == null) {
            JdbcDriverManagerImpl.$$$reportNull$$$0(6);
        }
        if (configuration == null) {
            JdbcDriverManagerImpl.$$$reportNull$$$0(7);
        }
        if ((factory = this.mySupport.acquire(dataSource, configuration, ProgressIndicatorProvider.getGlobalProgressIndicator())).tryLockIfNotInitialized()) {
            try {
                factory.setClassPath(JdbcConsoleRunContext.shouldIsolateClassPath(dataSource) ? JdbcConsoleRunContext.getIsolatedClassPath(dataSource, this.myProject).getPathList() : List.of());
                UtilKt.initProcessBlocking((RemoteProcessController)factory, dataSource, configuration, this.myProject);
            }
            finally {
                factory.unlock();
            }
        }
        return factory.getDriver();
    }

    @Override
    @NotNull
    public List<DatabaseSshTunnelEstablisher.SshTunnel> getTunnels(@NotNull LocalDataSource dataSource) {
        if (dataSource == null) {
            JdbcDriverManagerImpl.$$$reportNull$$$0(8);
        }
        List<DatabaseSshTunnelEstablisher.SshTunnel> list = this.mySshManager.getTunnels(dataSource);
        if (list == null) {
            JdbcDriverManagerImpl.$$$reportNull$$$0(9);
        }
        return list;
    }

    @Override
    public HostPort createProxyServer(@NotNull LocalDataSource dataSource) {
        if (dataSource == null) {
            JdbcDriverManagerImpl.$$$reportNull$$$0(10);
        }
        return this.mySshManager.createProxyServer(dataSource);
    }

    @Nullable
    public Throwable getTunnelsState(@NotNull LocalDataSource dataSource) {
        if (dataSource == null) {
            JdbcDriverManagerImpl.$$$reportNull$$$0(11);
        }
        return this.mySshManager.getTunnelsState(dataSource);
    }

    @Override
    @NotNull
    public Future<?> releaseDriver(@NotNull LocalDataSource dataSource, @Nullable ConsoleRunConfiguration configuration) {
        if (dataSource == null) {
            JdbcDriverManagerImpl.$$$reportNull$$$0(12);
        }
        Future future = ApplicationManager.getApplication().executeOnPooledThread(() -> {
            JdbcDriverManagerImpl.terminateConnections(dataSource, configuration);
            try {
                this.mySupport.release(dataSource, (Object)configuration).get();
            }
            catch (Exception exception) {
                // empty catch block
            }
            ((JdbcDriverManager.Listener)this.getProject().getMessageBus().syncPublisher(TOPIC)).onTerminated(dataSource, configuration);
            (configuration == null ? DatabaseCredentials.getInstance() : configuration.CREDENTIALS).handleSessionFinished((DasDataSource)dataSource);
            if (this.getActiveConfigurations(dataSource).isEmpty()) {
                this.mySshManager.destroyTunnels(dataSource);
            }
        });
        if (future == null) {
            JdbcDriverManagerImpl.$$$reportNull$$$0(13);
        }
        return future;
    }

    @TestOnly
    public void killRemote(@NotNull LocalDataSource dataSource, @Nullable ConsoleRunConfiguration configuration) throws Exception {
        if (dataSource == null) {
            JdbcDriverManagerImpl.$$$reportNull$$$0(14);
        }
        this.mySupport.release(dataSource, (Object)configuration).get();
    }

    @Override
    public void addModificationTrackerListener(ModificationTrackerListener<JdbcDriverManager> listener, Disposable disposable) {
        this.myDispatcher.addListener(listener, disposable);
    }

    private static ConsoleRunConfiguration chooseRunConfiguration(Project project, LocalDataSource dataSource, DatabaseCredentials credentialsStore) {
        List<ConsoleRunConfiguration> active;
        JdbcDriverManager driverManager = JdbcDriverManagerImpl.getDriverManager(project);
        boolean isTemporary = dataSource.isTemporary();
        if (!isTemporary && !(active = driverManager.getActiveConfigurations(dataSource)).isEmpty()) {
            return active.get(0);
        }
        ConsoleRunConfiguration configuration = ConsoleRunConfiguration.newConfiguration(project);
        configuration.setOptionsFromDataSource(dataSource);
        if (credentialsStore != null) {
            configuration.CREDENTIALS = credentialsStore;
        }
        return configuration;
    }

    private static void terminateConnections(@NotNull LocalDataSource dataSource, @Nullable ConsoleRunConfiguration configuration) {
        if (dataSource == null) {
            JdbcDriverManagerImpl.$$$reportNull$$$0(15);
        }
        try {
            DatabaseConnectionManager.getInstance().terminateConnections(dataSource, configuration);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 9, 13 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 6: 
            case 8: 
            case 10: 
            case 11: 
            case 12: 
            case 14: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataSource";
                break;
            }
            case 2: 
            case 9: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/console/JdbcDriverManagerImpl";
                break;
            }
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configuration";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/console/JdbcDriverManagerImpl";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultRunConfiguration";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getTunnels";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "releaseDriver";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getDefaultRunConfiguration";
                break;
            }
            case 2: 
            case 9: 
            case 13: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getActiveConfigurations";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getDriver";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getDriverImpl";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getTunnels";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "createProxyServer";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getTunnelsState";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "releaseDriver";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "killRemote";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "terminateConnections";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 9, 13 -> new IllegalStateException(string);
        };
    }
}

