/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlinx.jupyter.libraries;

import java.io.File;
import java.io.IOException;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlinx.jupyter.api.libraries.LibraryDefinition;
import org.jetbrains.kotlinx.jupyter.api.libraries.LibraryReference;
import org.jetbrains.kotlinx.jupyter.api.libraries.LibraryResolutionInfo;
import org.jetbrains.kotlinx.jupyter.api.libraries.Variable;
import org.jetbrains.kotlinx.jupyter.common.HttpClient;
import org.jetbrains.kotlinx.jupyter.common.HttpUtilKt;
import org.jetbrains.kotlinx.jupyter.common.LibraryDescriptorsManager;
import org.jetbrains.kotlinx.jupyter.common.ResponseWrapper;
import org.jetbrains.kotlinx.jupyter.exceptions.ReplLibraryLoadingException;
import org.jetbrains.kotlinx.jupyter.libraries.AbstractLibraryResolutionInfo;
import org.jetbrains.kotlinx.jupyter.libraries.ByNothingLibraryResolutionInfo;
import org.jetbrains.kotlinx.jupyter.libraries.ChainedLibraryResolver;
import org.jetbrains.kotlinx.jupyter.libraries.DefaultLibraryDescriptorGlobalOptions;
import org.jetbrains.kotlinx.jupyter.libraries.LibraryDescriptorGlobalOptions;
import org.jetbrains.kotlinx.jupyter.libraries.LibraryResolversKt;
import org.jetbrains.kotlinx.jupyter.libraries.ResourcesLibraryResolver;
import org.jetbrains.kotlinx.jupyter.libraries.SpecificLibraryResolver;
import org.jetbrains.kotlinx.jupyter.streams.KernelStreams;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J \u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00130\u000bH\u0014R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\n\u001a\u0010\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\r0\f0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/kotlinx/jupyter/libraries/FallbackLibraryResolver;", "Lorg/jetbrains/kotlinx/jupyter/libraries/ChainedLibraryResolver;", "httpClient", "Lorg/jetbrains/kotlinx/jupyter/common/HttpClient;", "libraryDescriptorsManager", "Lorg/jetbrains/kotlinx/jupyter/common/LibraryDescriptorsManager;", "<init>", "(Lorg/jetbrains/kotlinx/jupyter/common/HttpClient;Lorg/jetbrains/kotlinx/jupyter/common/LibraryDescriptorsManager;)V", "resourcesResolver", "Lorg/jetbrains/kotlinx/jupyter/libraries/ResourcesLibraryResolver;", "standardResolvers", "", "Lorg/jetbrains/kotlinx/jupyter/libraries/SpecificLibraryResolver;", "Lorg/jetbrains/kotlinx/jupyter/api/libraries/LibraryResolutionInfo;", "tryResolve", "Lorg/jetbrains/kotlinx/jupyter/api/libraries/LibraryDefinition;", "reference", "Lorg/jetbrains/kotlinx/jupyter/api/libraries/LibraryReference;", "arguments", "Lorg/jetbrains/kotlinx/jupyter/api/libraries/Variable;", "shared-compiler"})
@SourceDebugExtension(value={"SMAP\nLibraryResolvers.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LibraryResolvers.kt\norg/jetbrains/kotlinx/jupyter/libraries/FallbackLibraryResolver\n+ 2 LibraryResolvers.kt\norg/jetbrains/kotlinx/jupyter/libraries/LibraryResolversKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,197:1\n165#2,4:198\n165#2,4:202\n171#2,3:206\n171#2,3:209\n171#2,3:212\n165#2,4:215\n171#2,3:219\n295#3,2:222\n*S KotlinDebug\n*F\n+ 1 LibraryResolvers.kt\norg/jetbrains/kotlinx/jupyter/libraries/FallbackLibraryResolver\n*L\n103#1:198,4\n120#1:202,4\n126#1:206,3\n129#1:209,3\n133#1:212,3\n134#1:215,4\n137#1:219,3\n143#1:222,2\n*E\n"})
public final class FallbackLibraryResolver
extends ChainedLibraryResolver {
    @NotNull
    private final HttpClient httpClient;
    @NotNull
    private final LibraryDescriptorsManager libraryDescriptorsManager;
    @NotNull
    private final ResourcesLibraryResolver resourcesResolver;
    @NotNull
    private final List<SpecificLibraryResolver<? extends LibraryResolutionInfo>> standardResolvers;

    public FallbackLibraryResolver(@NotNull HttpClient httpClient, @NotNull LibraryDescriptorsManager libraryDescriptorsManager) {
        Intrinsics.checkNotNullParameter((Object)httpClient, (String)"httpClient");
        Intrinsics.checkNotNullParameter((Object)libraryDescriptorsManager, (String)"libraryDescriptorsManager");
        super(null, 1, null);
        this.httpClient = httpClient;
        this.libraryDescriptorsManager = libraryDescriptorsManager;
        ClassLoader classLoader = ResourcesLibraryResolver.class.getClassLoader();
        Intrinsics.checkNotNullExpressionValue((Object)classLoader, (String)"getClassLoader(...)");
        this.resourcesResolver = new ResourcesLibraryResolver(null, this.libraryDescriptorsManager, classLoader);
        Object[] objectArray = new SpecificLibraryResolver[8];
        objectArray[0] = LibraryResolversKt.access$getByDirResolver(this.libraryDescriptorsManager);
        Function2 resolverFun$iv = (arg_0, arg_1) -> FallbackLibraryResolver.standardResolvers$lambda$0(this, arg_0, arg_1);
        boolean $i$f$resolverWithOptions = false;
        objectArray[1] = new SpecificLibraryResolver(Reflection.getOrCreateKotlinClass(AbstractLibraryResolutionInfo.ByGitRefWithClasspathFallback.class), resolverFun$iv);
        resolverFun$iv = (arg_0, arg_1) -> FallbackLibraryResolver.standardResolvers$lambda$1(this, arg_0, arg_1);
        $i$f$resolverWithOptions = false;
        objectArray[2] = new SpecificLibraryResolver(Reflection.getOrCreateKotlinClass(AbstractLibraryResolutionInfo.ByGitRef.class), resolverFun$iv);
        resolverFun$iv = FallbackLibraryResolver::standardResolvers$lambda$2;
        boolean $i$f$resolver = false;
        objectArray[3] = new SpecificLibraryResolver(Reflection.getOrCreateKotlinClass(AbstractLibraryResolutionInfo.ByFile.class), (Function2)new Function2<AbstractLibraryResolutionInfo.ByFile, String, Pair<? extends String, ? extends LibraryDescriptorGlobalOptions>>(resolverFun$iv){
            final /* synthetic */ Function2 $resolverFun;
            {
                this.$resolverFun = $resolverFun;
            }

            /*
             * Ignored method signature, as it can't be verified against descriptor
             */
            public final Pair invoke(LibraryResolutionInfo info, String descriptorText) {
                Intrinsics.checkNotNullParameter((Object)info, (String)"info");
                return TuplesKt.to((Object)this.$resolverFun.invoke((Object)info, (Object)descriptorText), (Object)DefaultLibraryDescriptorGlobalOptions.INSTANCE);
            }
        });
        resolverFun$iv = (arg_0, arg_1) -> FallbackLibraryResolver.standardResolvers$lambda$3(this, arg_0, arg_1);
        $i$f$resolver = false;
        objectArray[4] = new SpecificLibraryResolver(Reflection.getOrCreateKotlinClass(AbstractLibraryResolutionInfo.ByURL.class), (Function2)new Function2<AbstractLibraryResolutionInfo.ByURL, String, Pair<? extends String, ? extends LibraryDescriptorGlobalOptions>>(resolverFun$iv){
            final /* synthetic */ Function2 $resolverFun;
            {
                this.$resolverFun = $resolverFun;
            }

            /*
             * Ignored method signature, as it can't be verified against descriptor
             */
            public final Pair invoke(LibraryResolutionInfo info, String descriptorText) {
                Intrinsics.checkNotNullParameter((Object)info, (String)"info");
                return TuplesKt.to((Object)this.$resolverFun.invoke((Object)info, (Object)descriptorText), (Object)DefaultLibraryDescriptorGlobalOptions.INSTANCE);
            }
        });
        resolverFun$iv = FallbackLibraryResolver::standardResolvers$lambda$4;
        $i$f$resolver = false;
        objectArray[5] = new SpecificLibraryResolver(Reflection.getOrCreateKotlinClass(ByNothingLibraryResolutionInfo.class), (Function2)new Function2<ByNothingLibraryResolutionInfo, String, Pair<? extends String, ? extends LibraryDescriptorGlobalOptions>>(resolverFun$iv){
            final /* synthetic */ Function2 $resolverFun;
            {
                this.$resolverFun = $resolverFun;
            }

            /*
             * Ignored method signature, as it can't be verified against descriptor
             */
            public final Pair invoke(LibraryResolutionInfo info, String descriptorText) {
                Intrinsics.checkNotNullParameter((Object)info, (String)"info");
                return TuplesKt.to((Object)this.$resolverFun.invoke((Object)info, (Object)descriptorText), (Object)DefaultLibraryDescriptorGlobalOptions.INSTANCE);
            }
        });
        resolverFun$iv = (arg_0, arg_1) -> FallbackLibraryResolver.standardResolvers$lambda$5(this, arg_0, arg_1);
        $i$f$resolverWithOptions = false;
        objectArray[6] = new SpecificLibraryResolver(Reflection.getOrCreateKotlinClass(AbstractLibraryResolutionInfo.ByClasspath.class), resolverFun$iv);
        resolverFun$iv = FallbackLibraryResolver::standardResolvers$lambda$6;
        $i$f$resolver = false;
        objectArray[7] = new SpecificLibraryResolver(Reflection.getOrCreateKotlinClass(AbstractLibraryResolutionInfo.Default.class), (Function2)new Function2<AbstractLibraryResolutionInfo.Default, String, Pair<? extends String, ? extends LibraryDescriptorGlobalOptions>>(resolverFun$iv){
            final /* synthetic */ Function2 $resolverFun;
            {
                this.$resolverFun = $resolverFun;
            }

            /*
             * Ignored method signature, as it can't be verified against descriptor
             */
            public final Pair invoke(LibraryResolutionInfo info, String descriptorText) {
                Intrinsics.checkNotNullParameter((Object)info, (String)"info");
                return TuplesKt.to((Object)this.$resolverFun.invoke((Object)info, (Object)descriptorText), (Object)DefaultLibraryDescriptorGlobalOptions.INSTANCE);
            }
        });
        this.standardResolvers = CollectionsKt.listOf((Object[])objectArray);
    }

    @Override
    @Nullable
    protected LibraryDefinition tryResolve(@NotNull LibraryReference reference, @NotNull List<Variable> arguments) {
        Object v0;
        block1: {
            Intrinsics.checkNotNullParameter((Object)reference, (String)"reference");
            Intrinsics.checkNotNullParameter(arguments, (String)"arguments");
            Iterable $this$firstOrNull$iv = this.standardResolvers;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                SpecificLibraryResolver it = (SpecificLibraryResolver)element$iv;
                boolean bl = false;
                if (!it.accepts(reference)) continue;
                v0 = element$iv;
                break block1;
            }
            v0 = null;
        }
        SpecificLibraryResolver specificLibraryResolver = v0;
        return specificLibraryResolver != null ? specificLibraryResolver.resolve(reference, arguments) : null;
    }

    private static final Pair standardResolvers$lambda$0(FallbackLibraryResolver this$0, AbstractLibraryResolutionInfo.ByGitRefWithClasspathFallback $this$resolverWithOptions, String name) {
        String string;
        Intrinsics.checkNotNullParameter((Object)$this$resolverWithOptions, (String)"$this$resolverWithOptions");
        if (name == null) {
            throw new ReplLibraryLoadingException(null, "Reference library resolver needs name to be specified", null, 5, null);
        }
        try {
            string = this$0.libraryDescriptorsManager.downloadLibraryDescriptor($this$resolverWithOptions.getRef(), name);
        }
        catch (IOException e) {
            KernelStreams.INSTANCE.getErr().println("WARNING: Can't resolve library " + name + " from the given reference. Using classpath version of this library. Error: " + e);
            KernelStreams.INSTANCE.getErr().flush();
            string = this$0.resourcesResolver.resolveDescriptorFromResources(name);
        }
        String descriptorText = string;
        return TuplesKt.to((Object)descriptorText, (Object)LibraryResolversKt.access$getDescriptorOptions(this$0.libraryDescriptorsManager, $this$resolverWithOptions.getRef()));
    }

    private static final Pair standardResolvers$lambda$1(FallbackLibraryResolver this$0, AbstractLibraryResolutionInfo.ByGitRef $this$resolverWithOptions, String name) {
        Intrinsics.checkNotNullParameter((Object)$this$resolverWithOptions, (String)"$this$resolverWithOptions");
        if (name == null) {
            throw new ReplLibraryLoadingException(null, "Reference library resolver needs name to be specified", null, 5, null);
        }
        String descriptorText = this$0.libraryDescriptorsManager.downloadLibraryDescriptor($this$resolverWithOptions.getRef(), name);
        return TuplesKt.to((Object)descriptorText, (Object)LibraryResolversKt.access$getDescriptorOptions(this$0.libraryDescriptorsManager, $this$resolverWithOptions.getRef()));
    }

    private static final String standardResolvers$lambda$2(AbstractLibraryResolutionInfo.ByFile $this$resolver, String it) {
        Intrinsics.checkNotNullParameter((Object)$this$resolver, (String)"$this$resolver");
        return FilesKt.readText$default((File)$this$resolver.getFile(), null, (int)1, null);
    }

    private static final String standardResolvers$lambda$3(FallbackLibraryResolver this$0, AbstractLibraryResolutionInfo.ByURL $this$resolver, String it) {
        Intrinsics.checkNotNullParameter((Object)$this$resolver, (String)"$this$resolver");
        HttpClient httpClient = this$0.httpClient;
        String string = $this$resolver.getUrl().toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        ResponseWrapper response = HttpUtilKt.getHttp(httpClient, string);
        return response.getText();
    }

    private static final String standardResolvers$lambda$4(ByNothingLibraryResolutionInfo $this$resolver, String it) {
        Intrinsics.checkNotNullParameter((Object)$this$resolver, (String)"$this$resolver");
        return "{}";
    }

    private static final Pair standardResolvers$lambda$5(FallbackLibraryResolver this$0, AbstractLibraryResolutionInfo.ByClasspath $this$resolverWithOptions, String name) {
        Intrinsics.checkNotNullParameter((Object)$this$resolverWithOptions, (String)"$this$resolverWithOptions");
        return TuplesKt.to((Object)this$0.resourcesResolver.resolveDescriptorFromResources(name), (Object)this$0.resourcesResolver.resolveDescriptorOptionsFromResources());
    }

    private static final String standardResolvers$lambda$6(AbstractLibraryResolutionInfo.Default $this$resolver, String it) {
        Intrinsics.checkNotNullParameter((Object)$this$resolver, (String)"$this$resolver");
        return null;
    }
}

