/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.performancePlugin.commands;

import com.intellij.analysis.AnalysisScope;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.actions.RunInspectionIntention;
import com.intellij.codeInspection.ex.GlobalInspectionContextImpl;
import com.intellij.codeInspection.ex.InspectionManagerEx;
import com.intellij.codeInspection.ex.InspectionProfileImpl;
import com.intellij.codeInspection.ex.InspectionToolWrapper;
import com.intellij.codeInspection.ui.InspectionResultsView;
import com.intellij.codeInspection.ui.InspectionTree;
import com.intellij.codeInspection.ui.actions.ExportToXMLAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.playback.PlaybackContext;
import com.intellij.openapi.ui.playback.commands.AbstractCommand;
import com.intellij.openapi.util.ActionCallback;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.profile.codeInspection.InspectionProjectProfileManager;
import com.jetbrains.performancePlugin.PerformanceTestingBundle;
import com.jetbrains.performancePlugin.commands.InspectionCommand;
import com.jetbrains.performancePlugin.utils.ActionCallbackProfilerStopper;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.concurrency.Promises;

public class SingleInspectionCommand
extends AbstractCommand {
    public static final String PREFIX = "%runSingleInspection";
    private static final Logger LOGGER = Logger.getInstance(SingleInspectionCommand.class);

    public SingleInspectionCommand(@NotNull String text, int line) {
        if (text == null) {
            SingleInspectionCommand.$$$reportNull$$$0(0);
        }
        super(text, line);
    }

    @NotNull
    protected Promise<Object> _execute(final @NotNull PlaybackContext context) {
        if (context == null) {
            SingleInspectionCommand.$$$reportNull$$$0(1);
        }
        final ActionCallbackProfilerStopper actionCallback = new ActionCallbackProfilerStopper();
        String[] commandArguments = this.extractCommandArgument(PREFIX).split("\\s+", 2);
        String shortInspectionName = commandArguments[0];
        String extension = "";
        if (commandArguments.length > 1) {
            extension = commandArguments[1];
        }
        @NotNull Project project = context.getProject();
        InspectionProfileImpl currentProfile = InspectionProjectProfileManager.getInstance((Project)project).getCurrentProfile();
        InspectionToolWrapper toolWrapper = currentProfile.getInspectionTool(shortInspectionName, project);
        InspectionManagerEx inspectionManagerEx = (InspectionManagerEx)InspectionManager.getInstance((Project)project);
        if (toolWrapper != null) {
            InspectionProfileImpl model = RunInspectionIntention.createProfile((InspectionToolWrapper)toolWrapper, (InspectionManagerEx)inspectionManagerEx, null);
            GlobalInspectionContextImpl inspectionContext = new GlobalInspectionContextImpl(project, inspectionManagerEx.getContentManager()){
                private long numberOfProblems;
                {
                    super(arg0, arg1);
                    this.numberOfProblems = 0L;
                }

                protected void notifyInspectionsFinished(@NotNull AnalysisScope scope) {
                    if (scope == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    super.notifyInspectionsFinished(scope);
                    try {
                        File tempDirectory = FileUtil.createTempDirectory((String)"inspection", (String)"result");
                        InspectionResultsView view = this.getView();
                        if (view != null) {
                            ExportToXMLAction.Util.dumpToXml((InspectionProfileImpl)view.getCurrentProfile(), (InspectionTree)view.getTree(), (Project)view.getProject(), (GlobalInspectionContextImpl)view.getGlobalInspectionContext(), (Path)tempDirectory.toPath());
                            File[] files = tempDirectory.listFiles();
                            if (files != null) {
                                for (File file : files) {
                                    if (file.isHidden()) continue;
                                    Path path = file.toPath();
                                    try (Stream<String> lines = Files.lines(path).filter(line -> line.contains("<problem>"));){
                                        this.numberOfProblems = lines.count();
                                    }
                                }
                            } else {
                                LOGGER.error("tempDirectory.listFiles() is null");
                            }
                        }
                    }
                    catch (IOException ex) {
                        LOGGER.error((Throwable)ex);
                    }
                    context.message(PerformanceTestingBundle.message("command.inspection.finish", new Object[0]) + " " + PerformanceTestingBundle.message("command.inspection.finish.result", this.numberOfProblems), SingleInspectionCommand.this.getLine());
                    actionCallback.setDone();
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/jetbrains/performancePlugin/commands/SingleInspectionCommand$1", "notifyInspectionsFinished"));
                }
            };
            inspectionContext.setExternalProfile(model);
            AnalysisScope scope = InspectionCommand.getAnalysisScope(extension, project);
            if (scope == null) {
                context.message(PerformanceTestingBundle.message("command.inspection.extension", new Object[0]) + " " + extension, this.getLine());
            } else {
                inspectionContext.doInspections(scope);
            }
        } else {
            actionCallback.reject(PerformanceTestingBundle.message("command.singleInspection.noinspection", shortInspectionName));
        }
        Promise promise = Promises.toPromise((ActionCallback)actionCallback);
        if (promise == null) {
            SingleInspectionCommand.$$$reportNull$$$0(2);
        }
        return promise;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/performancePlugin/commands/SingleInspectionCommand";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/performancePlugin/commands/SingleInspectionCommand";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "_execute";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "_execute";
                break;
            }
            case 2: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2 -> new IllegalStateException(string);
        };
    }
}

