/*
 * Decompiled with CFR 0.152.
 */
package de.plushnikov.intellij.plugin.processor.clazz;

import com.intellij.openapi.components.Service;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierList;
import de.plushnikov.intellij.plugin.problem.ProblemSink;
import de.plushnikov.intellij.plugin.processor.clazz.AbstractClassProcessor;
import de.plushnikov.intellij.plugin.psi.LombokLightMethodBuilder;
import de.plushnikov.intellij.plugin.util.PsiClassUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service
public final class UtilityClassProcessor
extends AbstractClassProcessor {
    public UtilityClassProcessor() {
        super((Class<? extends PsiElement>)PsiMethod.class, "lombok.experimental.UtilityClass");
    }

    @Override
    protected boolean possibleToGenerateElementNamed(@NotNull String nameHint, @NotNull PsiClass psiClass, @NotNull PsiAnnotation psiAnnotation) {
        if (nameHint == null) {
            UtilityClassProcessor.$$$reportNull$$$0(0);
        }
        if (psiClass == null) {
            UtilityClassProcessor.$$$reportNull$$$0(1);
        }
        if (psiAnnotation == null) {
            UtilityClassProcessor.$$$reportNull$$$0(2);
        }
        return nameHint.equals(psiClass.getName());
    }

    @Override
    protected Collection<String> getNamesOfPossibleGeneratedElements(@NotNull PsiClass psiClass, @NotNull PsiAnnotation psiAnnotation) {
        if (psiClass == null) {
            UtilityClassProcessor.$$$reportNull$$$0(3);
        }
        if (psiAnnotation == null) {
            UtilityClassProcessor.$$$reportNull$$$0(4);
        }
        return Collections.singleton(psiClass.getName());
    }

    @Override
    protected boolean validate(@NotNull PsiAnnotation psiAnnotation, @NotNull PsiClass psiClass, @NotNull ProblemSink builder) {
        if (psiAnnotation == null) {
            UtilityClassProcessor.$$$reportNull$$$0(5);
        }
        if (psiClass == null) {
            UtilityClassProcessor.$$$reportNull$$$0(6);
        }
        if (builder == null) {
            UtilityClassProcessor.$$$reportNull$$$0(7);
        }
        return UtilityClassProcessor.validateOnRightType(psiClass, builder) && UtilityClassProcessor.validateNoConstructorsDefined(psiClass, builder);
    }

    private static boolean validateNoConstructorsDefined(PsiClass psiClass, ProblemSink builder) {
        Collection<PsiMethod> psiMethods = PsiClassUtil.collectClassConstructorIntern(psiClass);
        if (!psiMethods.isEmpty()) {
            builder.addErrorMessage("inspection.message.utility.classes.cannot.have.declared.constructors", new Object[0]);
            return false;
        }
        return true;
    }

    public static boolean validateOnRightType(@NotNull PsiClass psiClass, @NotNull ProblemSink builder) {
        if (psiClass == null) {
            UtilityClassProcessor.$$$reportNull$$$0(8);
        }
        if (builder == null) {
            UtilityClassProcessor.$$$reportNull$$$0(9);
        }
        if (UtilityClassProcessor.checkWrongType(psiClass)) {
            builder.addErrorMessage("inspection.message.utility.class.only.supported.on.class", new Object[0]);
            return false;
        }
        PsiElement context = psiClass.getContext();
        if (context == null) {
            return false;
        }
        if (!(context instanceof PsiFile)) {
            PsiElement contextUp = context;
            while (contextUp instanceof PsiClass) {
                PsiClass psiClassUp = (PsiClass)contextUp;
                if (psiClassUp.getContext() instanceof PsiFile) {
                    return true;
                }
                boolean isStatic = UtilityClassProcessor.isStatic(psiClassUp.getModifierList());
                if (isStatic || UtilityClassProcessor.checkWrongType(psiClassUp)) {
                    contextUp = contextUp.getContext();
                    continue;
                }
                builder.addErrorMessage("inspection.message.utility.class.automatically.makes.class.static", new Object[0]);
                return false;
            }
            builder.addErrorMessage("inspection.message.utility.class.cannot.be.placed", new Object[0]);
            return false;
        }
        return true;
    }

    private static boolean isStatic(PsiModifierList modifierList) {
        return modifierList != null && modifierList.hasModifierProperty("static");
    }

    private static boolean checkWrongType(@NotNull PsiClass psiClass) {
        if (psiClass == null) {
            UtilityClassProcessor.$$$reportNull$$$0(10);
        }
        return psiClass.isInterface() || psiClass.isEnum() || psiClass.isAnnotationType() || psiClass.isRecord();
    }

    @Override
    protected void generatePsiElements(@NotNull PsiClass psiClass, @NotNull PsiAnnotation psiAnnotation, @NotNull List<? super PsiElement> target, @Nullable String nameHint) {
        if (psiClass == null) {
            UtilityClassProcessor.$$$reportNull$$$0(11);
        }
        if (psiAnnotation == null) {
            UtilityClassProcessor.$$$reportNull$$$0(12);
        }
        if (target == null) {
            UtilityClassProcessor.$$$reportNull$$$0(13);
        }
        LombokLightMethodBuilder constructorBuilder = new LombokLightMethodBuilder(psiClass.getManager(), psiClass.getName()).withConstructor(true).withContainingClass(psiClass).withNavigationElement((PsiElement)psiAnnotation).withModifier("private").withBodyText(String.format("throw new %s(%s);", "java.lang.UnsupportedOperationException", "\"This is a utility class and cannot be instantiated\""));
        target.add((PsiElement)constructorBuilder);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nameHint";
                break;
            }
            case 1: 
            case 3: 
            case 6: 
            case 8: 
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiClass";
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiAnnotation";
                break;
            }
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
        }
        objectArray2[1] = "de/plushnikov/intellij/plugin/processor/clazz/UtilityClassProcessor";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "possibleToGenerateElementNamed";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "getNamesOfPossibleGeneratedElements";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "validate";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "validateOnRightType";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[2] = "checkWrongType";
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[2] = "generatePsiElements";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

