/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.idea.lang.javascript.intention.opassign;

import com.intellij.codeInspection.util.IntentionFamilyName;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.psi.JSAssignmentExpression;
import com.intellij.lang.javascript.psi.JSBinaryExpression;
import com.intellij.lang.javascript.psi.JSDefinitionExpression;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.impl.JSElementPredicate;
import com.intellij.lang.javascript.psi.util.SideEffectChecker;
import com.intellij.lang.javascript.refactoring.util.JSRefactoringUtil;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.IncorrectOperationException;
import com.sixrr.inspectjs.utils.EquivalenceChecker;
import org.intellij.idea.lang.javascript.intention.JSIntentionBundle;
import org.intellij.idea.lang.javascript.intention.JSMutablyNamedIntention;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class JSReplaceWithOperatorAssignmentIntention
extends JSMutablyNamedIntention {
    @Override
    public String getTextForElement(PsiElement element) {
        JSAssignmentExpression exp = (JSAssignmentExpression)element;
        JSBinaryExpression rhs = (JSBinaryExpression)exp.getROperand();
        assert (rhs != null);
        return JSIntentionBundle.message("opassign.replace-with-operator-assignment.display-name", rhs.getOperationNode().getText());
    }

    @NotNull
    @IntentionFamilyName
    public String getFamilyName() {
        String string = JSIntentionBundle.message("opassign.replace-with-operator-assignment.family-name", new Object[0]);
        if (string == null) {
            JSReplaceWithOperatorAssignmentIntention.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    @NotNull
    public JSElementPredicate getElementPredicate() {
        return new Predicate();
    }

    @Override
    public void processIntention(@NotNull Project project, @Nullable Editor editor, @NotNull PsiElement element) throws IncorrectOperationException {
        if (project == null) {
            JSReplaceWithOperatorAssignmentIntention.$$$reportNull$$$0(1);
        }
        if (element == null) {
            JSReplaceWithOperatorAssignmentIntention.$$$reportNull$$$0(2);
        }
        JSAssignmentExpression exp = (JSAssignmentExpression)element;
        JSBinaryExpression rhs = (JSBinaryExpression)exp.getROperand();
        JSExpression lhs = exp.getLOperand();
        assert (rhs != null);
        String operand = rhs.getOperationNode().getText();
        JSExpression rhsrhs = rhs.getROperand();
        assert (rhsrhs != null);
        JSRefactoringUtil.replaceExpressionAndReformat((JSExpression)exp, (String)(lhs.getText() + operand + "=" + rhsrhs.getText()));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/intellij/idea/lang/javascript/intention/opassign/JSReplaceWithOperatorAssignmentIntention";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "org/intellij/idea/lang/javascript/intention/opassign/JSReplaceWithOperatorAssignmentIntention";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "processIntention";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2 -> new IllegalArgumentException(string);
        };
    }

    private static class Predicate
    implements JSElementPredicate {
        private Predicate() {
        }

        public boolean satisfiedBy(@NotNull PsiElement element) {
            if (element == null) {
                Predicate.$$$reportNull$$$0(0);
            }
            if (!(element instanceof JSAssignmentExpression)) {
                return false;
            }
            JSAssignmentExpression assignment = (JSAssignmentExpression)element;
            if (PsiUtilCore.hasErrorElementChild((PsiElement)element)) {
                return false;
            }
            IElementType tokenType = assignment.getOperationSign();
            if (!JSTokenTypes.EQ.equals(tokenType)) {
                return false;
            }
            JSExpression lhs = assignment.getLOperand();
            JSExpression rhs = assignment.getROperand();
            if (lhs instanceof JSDefinitionExpression) {
                lhs = ((JSDefinitionExpression)lhs).getExpression();
            }
            if (lhs == null || rhs == null) {
                return false;
            }
            if (!(rhs instanceof JSBinaryExpression)) {
                return false;
            }
            JSBinaryExpression binaryRhs = (JSBinaryExpression)rhs;
            JSExpression rhsRhs = binaryRhs.getROperand();
            JSExpression rhsLhs = binaryRhs.getLOperand();
            if (rhsRhs == null) {
                return false;
            }
            IElementType rhsTokenType = binaryRhs.getOperationSign();
            if (!Holder.ACCEPTABLE_OPERATORS.contains(rhsTokenType)) {
                return false;
            }
            if (SideEffectChecker.mayHaveSideEffects((JSExpression)lhs)) {
                return false;
            }
            return EquivalenceChecker.expressionsAreEquivalent((JSExpression)lhs, (JSExpression)rhsLhs);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/intellij/idea/lang/javascript/intention/opassign/JSReplaceWithOperatorAssignmentIntention$Predicate", "satisfiedBy"));
        }
    }

    private static class Holder {
        private static final TokenSet ACCEPTABLE_OPERATORS = TokenSet.create((IElementType[])new IElementType[]{JSTokenTypes.MULT, JSTokenTypes.DIV, JSTokenTypes.PERC, JSTokenTypes.PLUS, JSTokenTypes.MINUS, JSTokenTypes.LTLT, JSTokenTypes.GTGT, JSTokenTypes.GTGTGT, JSTokenTypes.AND, JSTokenTypes.XOR, JSTokenTypes.OR, JSTokenTypes.MULTMULT});

        private Holder() {
        }
    }
}

