/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.idea.lang.javascript.intention.number;

import com.intellij.codeInspection.util.IntentionFamilyName;
import com.intellij.lang.javascript.psi.JSAssignmentExpression;
import com.intellij.lang.javascript.psi.JSBinaryExpression;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSParenthesizedExpression;
import com.intellij.lang.javascript.psi.impl.JSElementPredicate;
import com.intellij.lang.javascript.psi.util.JSParenthesesUtils;
import com.intellij.lang.javascript.refactoring.util.JSRefactoringUtil;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.ObjectUtils;
import org.intellij.idea.lang.javascript.intention.JSIntentionBundle;
import org.intellij.idea.lang.javascript.intention.JSMutablyNamedIntention;
import org.intellij.idea.lang.javascript.intention.number.ShiftUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class JSReplaceShiftWithMultiplyIntention
extends JSMutablyNamedIntention {
    @Override
    protected String getTextForElement(PsiElement element) {
        IElementType tokenType = ((JSBinaryExpression)element).getOperationSign();
        Pair<String, String> pair = ShiftUtils.shiftOperators.get(tokenType);
        return JSIntentionBundle.message("number.replace-shift-with-multiply.display-name", pair.first, pair.second);
    }

    @NotNull
    @IntentionFamilyName
    public String getFamilyName() {
        String string = JSIntentionBundle.message("number.replace-shift-with-multiply.family-name", new Object[0]);
        if (string == null) {
            JSReplaceShiftWithMultiplyIntention.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    @NotNull
    public JSElementPredicate getElementPredicate() {
        return new ShiftByLiteralPredicate();
    }

    @Override
    public void processIntention(@NotNull Project project, @Nullable Editor editor, @NotNull PsiElement element) throws IncorrectOperationException {
        if (project == null) {
            JSReplaceShiftWithMultiplyIntention.$$$reportNull$$$0(1);
        }
        if (element == null) {
            JSReplaceShiftWithMultiplyIntention.$$$reportNull$$$0(2);
        }
        if (element instanceof JSAssignmentExpression) {
            JSReplaceShiftWithMultiplyIntention.replaceShiftAssignWithMultiplyOrDivideAssign((JSAssignmentExpression)element);
        } else {
            assert (element instanceof JSBinaryExpression);
            JSReplaceShiftWithMultiplyIntention.replaceShiftWithMultiplyOrDivide((JSBinaryExpression)element);
        }
    }

    private static void replaceShiftAssignWithMultiplyOrDivideAssign(JSAssignmentExpression exp) throws IncorrectOperationException {
        JSExpression lhs = exp.getLOperand();
        assert (lhs != null);
        String lhsText = lhs.getText();
        String expString = JSReplaceShiftWithMultiplyIntention.getExpressionText((JSBinaryExpression)exp, lhsText);
        JSRefactoringUtil.replaceExpressionAndReformat((JSExpression)exp, (String)expString);
    }

    private static void replaceShiftWithMultiplyOrDivide(JSBinaryExpression exp) throws IncorrectOperationException {
        JSExpression lhs = exp.getLOperand();
        assert (lhs != null);
        Object expString = JSReplaceShiftWithMultiplyIntention.getExpressionText(exp, JSParenthesesUtils.getParenthesized((JSExpression)lhs, (int)6));
        JSElement parent = (JSElement)exp.getParent();
        if (parent instanceof JSExpression && !(parent instanceof JSParenthesizedExpression) && JSParenthesesUtils.getPrecedence((JSExpression)((JSExpression)parent)) < 6) {
            expString = "(" + (String)expString + ")";
        }
        JSRefactoringUtil.replaceExpressionAndReformat((JSExpression)exp, (String)expString);
    }

    @NotNull
    private static String getExpressionText(JSBinaryExpression exp, String lhsText) {
        JSExpression rhs = exp.getROperand();
        IElementType tokenType = exp.getOperationSign();
        String operatorString = (String)ShiftUtils.shiftOperators.get((Object)tokenType).second;
        assert (rhs != null);
        String string = lhsText + operatorString + ShiftUtils.getExpBase2(rhs);
        if (string == null) {
            JSReplaceShiftWithMultiplyIntention.$$$reportNull$$$0(3);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/intellij/idea/lang/javascript/intention/number/JSReplaceShiftWithMultiplyIntention";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "org/intellij/idea/lang/javascript/intention/number/JSReplaceShiftWithMultiplyIntention";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getExpressionText";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "processIntention";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2 -> new IllegalArgumentException(string);
        };
    }

    private static class ShiftByLiteralPredicate
    implements JSElementPredicate {
        private ShiftByLiteralPredicate() {
        }

        public boolean satisfiedBy(@NotNull PsiElement element) {
            JSBinaryExpression binaryExpression;
            if (element == null) {
                ShiftByLiteralPredicate.$$$reportNull$$$0(0);
            }
            return (binaryExpression = (JSBinaryExpression)ObjectUtils.tryCast((Object)element, JSBinaryExpression.class)) != null && binaryExpression.getLOperand() != null && ShiftUtils.shiftOperators.containsKey(binaryExpression.getOperationSign()) && ShiftUtils.isIntLiteral(binaryExpression.getROperand());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/intellij/idea/lang/javascript/intention/number/JSReplaceShiftWithMultiplyIntention$ShiftByLiteralPredicate", "satisfiedBy"));
        }
    }
}

