/*
 * Decompiled with CFR 0.152.
 */
package org.angular2.inspections.quickfixes;

import com.intellij.codeInsight.intention.PriorityAction;
import com.intellij.codeInsight.intention.preview.IntentionPreviewInfo;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.LocalQuickFixAndIntentionActionOnPsiElement;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.lang.javascript.modules.imports.JSImportCandidate;
import com.intellij.lang.javascript.psi.ecma6.ES6Decorator;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.angular2.entities.Angular2Declaration;
import org.angular2.entities.source.Angular2SourceDeclaration;
import org.angular2.inspections.actions.Angular2ActionFactory;
import org.angular2.inspections.actions.ExportNgModuleDeclarationAction;
import org.angular2.lang.Angular2Bundle;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000  2\u00020\u00012\u00020\u0002:\u0001 B\u0019\b\u0002\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\b\u0010\u000e\u001a\u00020\nH\u0016J\b\u0010\u000f\u001a\u00020\nH\u0017J3\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u00172\u0006\u0010\u0018\u001a\u00020\u00042\u0006\u0010\u0019\u001a\u00020\u0004H\u0096\u0002J \u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\u0018\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u001c\u001a\u00020\u001dH\u0016J\b\u0010\u001e\u001a\u00020\u001fH\u0016R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lorg/angular2/inspections/quickfixes/ExportNgModuleDeclarationQuickFix;", "Lcom/intellij/codeInspection/LocalQuickFixAndIntentionActionOnPsiElement;", "Lcom/intellij/codeInsight/intention/PriorityAction;", "context", "Lcom/intellij/psi/PsiElement;", "declaration", "Lorg/angular2/entities/source/Angular2SourceDeclaration;", "<init>", "(Lcom/intellij/psi/PsiElement;Lorg/angular2/entities/source/Angular2SourceDeclaration;)V", "myDeclarationName", "", "myDeclarationDecorator", "Lcom/intellij/psi/SmartPsiElementPointer;", "Lcom/intellij/lang/javascript/psi/ecma6/ES6Decorator;", "getText", "getFamilyName", "invoke", "", "project", "Lcom/intellij/openapi/project/Project;", "psiFile", "Lcom/intellij/psi/PsiFile;", "editor", "Lcom/intellij/openapi/editor/Editor;", "startElement", "endElement", "generatePreview", "Lcom/intellij/codeInsight/intention/preview/IntentionPreviewInfo;", "previewDescriptor", "Lcom/intellij/codeInspection/ProblemDescriptor;", "getPriority", "Lcom/intellij/codeInsight/intention/PriorityAction$Priority;", "Companion", "intellij.angular"})
public final class ExportNgModuleDeclarationQuickFix
extends LocalQuickFixAndIntentionActionOnPsiElement
implements PriorityAction {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String myDeclarationName;
    @NotNull
    private final SmartPsiElementPointer<ES6Decorator> myDeclarationDecorator;

    private ExportNgModuleDeclarationQuickFix(PsiElement context, Angular2SourceDeclaration declaration) {
        super(context);
        String string = declaration.getTypeScriptClass().getName();
        Intrinsics.checkNotNull((Object)string);
        this.myDeclarationName = string;
        SmartPsiElementPointer smartPsiElementPointer = SmartPointerManager.createPointer((PsiElement)((PsiElement)declaration.getDecorator()));
        Intrinsics.checkNotNullExpressionValue((Object)smartPsiElementPointer, (String)"createPointer(...)");
        this.myDeclarationDecorator = smartPsiElementPointer;
    }

    @NotNull
    public String getText() {
        Object[] objectArray = new Object[]{this.myDeclarationName};
        return Angular2Bundle.Companion.message("angular.quickfix.ngmodule.export.name", objectArray);
    }

    @Nls(capitalization=Nls.Capitalization.Sentence)
    @NotNull
    public String getFamilyName() {
        return Angular2Bundle.Companion.message("angular.quickfix.ngmodule.export.family", new Object[0]);
    }

    public void invoke(@NotNull Project project, @NotNull PsiFile psiFile, @Nullable Editor editor, @NotNull PsiElement startElement, @NotNull PsiElement endElement) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)psiFile, (String)"psiFile");
        Intrinsics.checkNotNullParameter((Object)startElement, (String)"startElement");
        Intrinsics.checkNotNullParameter((Object)endElement, (String)"endElement");
        if (this.myDeclarationDecorator.getElement() == null) {
            return;
        }
        ExportNgModuleDeclarationAction action = Angular2ActionFactory.INSTANCE.createExportNgModuleDeclarationAction(editor, startElement, this.myDeclarationDecorator, this.getText(), false);
        List<JSImportCandidate> candidates = action.getCandidates();
        if (candidates.size() == 1 || editor != null) {
            action.execute();
        }
    }

    @NotNull
    public IntentionPreviewInfo generatePreview(@NotNull Project project, @NotNull Editor editor, @NotNull PsiFile psiFile) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)psiFile, (String)"psiFile");
        IntentionPreviewInfo intentionPreviewInfo = IntentionPreviewInfo.EMPTY;
        Intrinsics.checkNotNullExpressionValue((Object)intentionPreviewInfo, (String)"EMPTY");
        return intentionPreviewInfo;
    }

    @NotNull
    public IntentionPreviewInfo generatePreview(@NotNull Project project, @NotNull ProblemDescriptor previewDescriptor) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)previewDescriptor, (String)"previewDescriptor");
        IntentionPreviewInfo intentionPreviewInfo = IntentionPreviewInfo.EMPTY;
        Intrinsics.checkNotNullExpressionValue((Object)intentionPreviewInfo, (String)"EMPTY");
        return intentionPreviewInfo;
    }

    @NotNull
    public PriorityAction.Priority getPriority() {
        return PriorityAction.Priority.HIGH;
    }

    public /* synthetic */ ExportNgModuleDeclarationQuickFix(PsiElement context, Angular2SourceDeclaration declaration, DefaultConstructorMarker $constructor_marker) {
        this(context, declaration);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J$\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b\u00a8\u0006\r"}, d2={"Lorg/angular2/inspections/quickfixes/ExportNgModuleDeclarationQuickFix$Companion;", "", "<init>", "()V", "add", "", "context", "Lcom/intellij/psi/PsiElement;", "declaration", "Lorg/angular2/entities/Angular2Declaration;", "fixes", "", "Lcom/intellij/codeInspection/LocalQuickFix;", "intellij.angular"})
    public static final class Companion {
        private Companion() {
        }

        public final void add(@NotNull PsiElement context, @NotNull Angular2Declaration declaration, @NotNull List<LocalQuickFix> fixes) {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
            Intrinsics.checkNotNullParameter(fixes, (String)"fixes");
            if (declaration instanceof Angular2SourceDeclaration && ((Angular2SourceDeclaration)declaration).getTypeScriptClass().getName() != null) {
                fixes.add((LocalQuickFix)new ExportNgModuleDeclarationQuickFix(context, (Angular2SourceDeclaration)declaration, null));
            }
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

