/*
 * Decompiled with CFR 0.152.
 */
package org.jrubyparser.ast;

import org.jrubyparser.NodeVisitor;
import org.jrubyparser.SourcePosition;
import org.jrubyparser.ast.BlockAcceptingNode;
import org.jrubyparser.ast.IArgumentNode;
import org.jrubyparser.ast.INameNode;
import org.jrubyparser.ast.ListNode;
import org.jrubyparser.ast.Node;
import org.jrubyparser.ast.NodeType;

public class CallNode
extends Node
implements INameNode,
IArgumentNode,
BlockAcceptingNode {
    private Node receiverNode;
    private Node argsNode;
    protected Node iterNode;
    protected String name;
    protected String lexicalName;
    private boolean hasParens = false;

    public CallNode(SourcePosition position, Node receiverNode, String name, Node argsNode) {
        this(position, receiverNode, name, argsNode, null);
    }

    public CallNode(SourcePosition position, Node receiverNode, String name, Node argsNode, Node iterNode) {
        super(position);
        assert (receiverNode != null) : "receiverNode is not null";
        this.receiverNode = this.adopt(receiverNode);
        this.setArgs(argsNode);
        this.iterNode = this.adopt(iterNode);
        this.name = name;
        this.lexicalName = name;
    }

    public boolean isSame(Node node) {
        return super.isSame(node) && this.isNameMatch(((CallNode)node).getName());
    }

    public NodeType getNodeType() {
        return NodeType.CALLNODE;
    }

    public Object accept(NodeVisitor iVisitor) {
        return iVisitor.visitCallNode(this);
    }

    @Deprecated
    public Node getIterNode() {
        return this.getIter();
    }

    public Node getIter() {
        return this.iterNode;
    }

    public Node setIterNode(Node iterNode) {
        this.setIter(iterNode);
        return this;
    }

    public void setIter(Node iter) {
        this.iterNode = this.adopt(iter);
    }

    @Deprecated
    public Node getArgsNode() {
        return this.getArgs();
    }

    public Node getArgs() {
        return this.argsNode;
    }

    @Deprecated
    public Node setArgsNode(Node argsNode) {
        this.setArgs(argsNode);
        return this.getArgs();
    }

    public void setArgs(Node argsNode) {
        if (argsNode == null) {
            argsNode = new ListNode(this.getReceiver().getPosition());
        }
        this.argsNode = this.adopt(argsNode);
    }

    public boolean hasParens() {
        return this.hasParens;
    }

    public void setHasParens(boolean hasParens) {
        this.hasParens = hasParens;
    }

    public String getLexicalName() {
        return this.lexicalName;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setLexicalName(String lexcicalName) {
        this.lexicalName = this.lexicalName;
    }

    public boolean isNameMatch(String name) {
        String thisName = this.getName();
        return thisName != null && thisName.equals(name);
    }

    @Deprecated
    public Node getReceiverNode() {
        return this.getReceiver();
    }

    public Node getReceiver() {
        return this.receiverNode;
    }

    public void setReceiver(Node receiver) {
        this.receiverNode = this.adopt(receiver);
    }

    public SourcePosition getNamePosition() {
        SourcePosition pos = this.receiverNode.getPosition();
        return new SourcePosition(pos.getFile(), pos.getStartLine(), pos.getEndLine(), pos.getEndOffset(), pos.getEndOffset() + this.getName().length());
    }

    public SourcePosition getLexicalNamePosition() {
        return this.getNamePosition();
    }
}

