/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.scss.index;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.platform.backend.workspace.WorkspaceModel;
import com.intellij.platform.workspace.storage.url.VirtualFileUrl;
import com.intellij.platform.workspace.storage.url.VirtualFileUrlManager;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.ContainerUtil;
import java.net.URL;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.sass.stdlib.SassScssStdlibInclusionContext;
import org.jetbrains.plugins.sass.stdlib.SassScssStubMarker;
import org.jetbrains.plugins.scss.index.entities.SassScssDependenciesEntityBuilder;
import org.jetbrains.plugins.scss.index.entities.SassScssDependenciesEntityModifications;
import org.jetbrains.plugins.scss.index.entities.SassScssDependencySource;

@Service
public final class SassScssDependencyManager {
    private static final Logger LOG = Logger.getInstance(SassScssDependencyManager.class);
    private volatile String globalFunctionsFileUrl;
    @Nullable
    private volatile VirtualFile globalFunctionsFile;
    private volatile Map<String, VirtualFile> builtInModuleNameToFileMap;

    public static SassScssDependencyManager getInstance() {
        return (SassScssDependencyManager)ApplicationManager.getApplication().getService(SassScssDependencyManager.class);
    }

    private static boolean useWorkspaceModelForDependencies() {
        return Registry.is((String)"sass.scss.use.workspace.model.for.dependencies");
    }

    @NotNull
    Set<VirtualFile> getRootsForIndexableSetContributor() {
        if (SassScssDependencyManager.useWorkspaceModelForDependencies()) {
            Set<VirtualFile> set = Collections.emptySet();
            if (set == null) {
                SassScssDependencyManager.$$$reportNull$$$0(0);
            }
            return set;
        }
        HashSet<VirtualFile> result = new HashSet<VirtualFile>();
        this.ensureCacheInitialized();
        if (this.globalFunctionsFile != null) {
            result.add(this.globalFunctionsFile);
        }
        result.addAll(this.builtInModuleNameToFileMap.values());
        HashSet<VirtualFile> hashSet = result;
        if (hashSet == null) {
            SassScssDependencyManager.$$$reportNull$$$0(1);
        }
        return hashSet;
    }

    @Nullable
    public VirtualFile getGlobalFunctionsFile() {
        this.ensureCacheInitialized();
        return this.globalFunctionsFile;
    }

    @Nullable
    public VirtualFile getBuiltInModuleFile(@NotNull String moduleName) {
        if (moduleName == null) {
            SassScssDependencyManager.$$$reportNull$$$0(2);
        }
        LOG.assertTrue(ArrayUtil.contains((String)moduleName, (String[])SassScssStdlibInclusionContext.SASS_BUILTIN_MODULES), (Object)("unexpected module name: " + moduleName));
        this.ensureCacheInitialized();
        return this.builtInModuleNameToFileMap.get(moduleName);
    }

    @Nullable
    public SassScssDependenciesEntityBuilder createSampleEntity(@NotNull Project project) {
        if (project == null) {
            SassScssDependencyManager.$$$reportNull$$$0(3);
        }
        if (!SassScssDependencyManager.useWorkspaceModelForDependencies()) {
            return null;
        }
        this.ensureCacheInitialized();
        VirtualFileUrlManager urlManager = WorkspaceModel.getInstance((Project)project).getVirtualFileUrlManager();
        VirtualFileUrl rootUrl = urlManager.getOrCreateFromUrl(this.globalFunctionsFileUrl);
        VirtualFileUrl parentUrl = Objects.requireNonNull(rootUrl.getParent(), rootUrl.getUrl());
        List moduleFilesMap = ContainerUtil.map((Object[])SassScssStdlibInclusionContext.SASS_BUILTIN_MODULES, moduleName -> parentUrl.append(SassScssDependencyManager.getFileNameFromModuleName(moduleName)));
        return SassScssDependenciesEntityModifications.createSassScssDependenciesEntity(rootUrl, moduleFilesMap, SassScssDependencySource.INSTANCE);
    }

    @NotNull
    private static String getFileNameFromModuleName(@NonNls String moduleName) {
        String string = moduleName.replace(':', '_') + ".scss";
        if (string == null) {
            SassScssDependencyManager.$$$reportNull$$$0(4);
        }
        return string;
    }

    private void ensureCacheInitialized() {
        VirtualFile globalFile;
        if (this.builtInModuleNameToFileMap != null) {
            return;
        }
        URL globalFunctionsUrl = SassScssStubMarker.class.getResource("sass_functions.scss");
        assert (globalFunctionsUrl != null);
        this.globalFunctionsFile = globalFile = VfsUtil.findFileByURL((URL)globalFunctionsUrl);
        if (globalFile == null) {
            LOG.error("Cannot find sass stdlib file in ", new String[]{globalFunctionsUrl.getFile()});
            this.globalFunctionsFileUrl = VfsUtilCore.convertFromUrl((URL)globalFunctionsUrl);
            this.builtInModuleNameToFileMap = Collections.emptyMap();
            return;
        }
        this.globalFunctionsFileUrl = globalFile.getUrl();
        HashMap<String, VirtualFile> fileMap = new HashMap<String, VirtualFile>();
        VirtualFile parent = globalFile.getParent();
        for (String moduleName : SassScssStdlibInclusionContext.SASS_BUILTIN_MODULES) {
            String fileName = SassScssDependencyManager.getFileNameFromModuleName(moduleName);
            VirtualFile moduleFile = parent.findChild(fileName);
            if (moduleFile != null) {
                fileMap.put(moduleName, moduleFile);
                continue;
            }
            LOG.error("Cannot find sass built-in module file ", new String[]{moduleName});
        }
        this.builtInModuleNameToFileMap = Map.copyOf(fileMap);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 2, 3 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/scss/index/SassScssDependencyManager";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "moduleName";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getRootsForIndexableSetContributor";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/scss/index/SassScssDependencyManager";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getFileNameFromModuleName";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getBuiltInModuleFile";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "createSampleEntity";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 2, 3 -> new IllegalArgumentException(string);
        };
    }
}

