/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.kubernetes.helm.model;

import com.intellij.kubernetes.helm.model.spec.Definition;
import com.intellij.openapi.util.NlsSafe;
import java.lang.reflect.Constructor;
import java.util.Iterator;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.yaml.meta.model.Field;
import org.jetbrains.yaml.meta.model.YamlAnything;
import org.jetbrains.yaml.meta.model.YamlBooleanType;
import org.jetbrains.yaml.meta.model.YamlIntegerType;
import org.jetbrains.yaml.meta.model.YamlMetaClass;
import org.jetbrains.yaml.meta.model.YamlMetaType;
import org.jetbrains.yaml.meta.model.YamlStringType;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0016\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0014\u0010\b\u001a\u0004\u0018\u00010\u00032\b\u0010\t\u001a\u0004\u0018\u00010\u0003H\u0007J\u0018\u0010\n\u001a\u00020\u000b2\u0006\u0010\t\u001a\u00020\u00032\u0006\u0010\f\u001a\u00020\u0005H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/intellij/kubernetes/helm/model/HelmObjectMetaClass;", "Lorg/jetbrains/yaml/meta/model/YamlMetaClass;", "typeName", "", "def", "Lcom/intellij/kubernetes/helm/model/spec/Definition;", "<init>", "(Ljava/lang/String;Lcom/intellij/kubernetes/helm/model/spec/Definition;)V", "getDescription", "fieldName", "getType", "Lorg/jetbrains/yaml/meta/model/YamlMetaType;", "definition", "intellij.clouds.kubernetes.backend"})
@SourceDebugExtension(value={"SMAP\nHelmMetaClassDefinitions.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HelmMetaClassDefinitions.kt\ncom/intellij/kubernetes/helm/model/HelmObjectMetaClass\n+ 2 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,586:1\n216#2,2:587\n*S KotlinDebug\n*F\n+ 1 HelmMetaClassDefinitions.kt\ncom/intellij/kubernetes/helm/model/HelmObjectMetaClass\n*L\n55#1:587,2\n*E\n"})
public class HelmObjectMetaClass
extends YamlMetaClass {
    @NotNull
    private final Definition def;

    public HelmObjectMetaClass(@NotNull String typeName, @NotNull Definition def) {
        Intrinsics.checkNotNullParameter((Object)typeName, (String)"typeName");
        Intrinsics.checkNotNullParameter((Object)def, (String)"def");
        super(typeName);
        this.def = def;
        Map<String, Definition> map2 = this.def.getDefinitions();
        if (map2 != null) {
            Map<String, Definition> $this$forEach$iv = map2;
            boolean $i$f$forEach = false;
            Iterator<Map.Entry<String, Definition>> iterator = $this$forEach$iv.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<String, Definition> element$iv;
                Map.Entry<String, Definition> it = element$iv = iterator.next();
                boolean bl = false;
                Definition definition = it.getValue();
                String fieldName = it.getKey();
                YamlMetaType feature = this.getType(fieldName, definition);
                Field field2 = new Field(fieldName, feature);
                if (definition.getRequired()) {
                    field2.setRequired();
                }
                if (definition.getDeprecated()) {
                    field2.setDeprecated();
                }
                if (definition.isSequence()) {
                    field2.withMultiplicityMany();
                }
                this.addFeature(field2);
            }
        }
        if (this.def.getAnyNames()) {
            this.addFeature(new Field("<any-name>", (YamlMetaType)YamlStringType.getInstance())).withAnyName();
        }
    }

    @NlsSafe
    @Nullable
    public final String getDescription(@Nullable String fieldName) {
        Object object;
        return fieldName != null ? ((object = this.def.getDefinitions()) != null && (object = object.get(fieldName)) != null ? ((Definition)object).getDescription() : null) : this.def.getDescription();
    }

    private final YamlMetaType getType(String fieldName, Definition definition) {
        YamlMetaType yamlMetaType;
        block16: {
            block17: {
                block15: {
                    if (definition.getMetatype() == null) break block15;
                    Object[] objectArray = new Class[]{Definition.class};
                    Constructor<?> constructor = Class.forName(definition.getMetatype()).getConstructor((Class<?>[])objectArray);
                    objectArray = new Object[]{definition};
                    Object obj = constructor.newInstance(objectArray);
                    Intrinsics.checkNotNull(obj, (String)"null cannot be cast to non-null type org.jetbrains.yaml.meta.model.YamlMetaType");
                    yamlMetaType = (YamlMetaType)obj;
                    break block16;
                }
                if (definition.getType() == null) break block17;
                YamlMetaType yamlMetaType2 = switch (definition.getType()) {
                    case "boolean" -> (YamlMetaType)YamlBooleanType.getSharedInstance();
                    case "integer" -> (YamlMetaType)YamlIntegerType.getInstance((boolean)false);
                    case "anything" -> YamlAnything.getInstance();
                    default -> (YamlMetaType)YamlStringType.getInstance();
                };
                Intrinsics.checkNotNull((Object)yamlMetaType2);
                yamlMetaType = yamlMetaType2;
                break block16;
            }
            Map<String, Definition> map2 = definition.getDefinitions();
            boolean bl = map2 != null ? !map2.isEmpty() : false;
            if (bl || definition.getAnyNames()) {
                yamlMetaType = (YamlMetaType)new HelmObjectMetaClass(this.getTypeName() + "." + fieldName, definition);
            } else {
                YamlStringType yamlStringType = YamlStringType.getInstance();
                Intrinsics.checkNotNullExpressionValue((Object)yamlStringType, (String)"getInstance(...)");
                yamlMetaType = (YamlMetaType)yamlStringType;
            }
        }
        return yamlMetaType;
    }
}

