/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.kubernetes.view.ui.actions;

import com.intellij.kubernetes.api.KubernetesApiModelInterface;
import com.intellij.kubernetes.i18n.KubernetesBundle;
import com.intellij.kubernetes.splitApi.KubernetesActionsRpcServiceKt;
import com.intellij.kubernetes.view.ui.actions.KubernetesModelBasedDumbAwareToggleAction;
import com.intellij.kubernetes.view.ui.actions.KubernetesNamespaceAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.remoting.ActionRemoteBehaviorSpecification;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\u0018\u00002\u00020\u00012\u00020\u00022\u00020\u0003B\u0014\u0012\u000b\u0010\u0004\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0018\u0010\u0011\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0012\u001a\u00020\u0010H\u0016R\u0019\u0010\u0004\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0013"}, d2={"Lcom/intellij/kubernetes/view/ui/actions/KubernetesNamespaceToggleAction;", "Lcom/intellij/kubernetes/view/ui/actions/KubernetesModelBasedDumbAwareToggleAction;", "Lcom/intellij/kubernetes/view/ui/actions/KubernetesNamespaceAction;", "Lcom/intellij/openapi/actionSystem/remoting/ActionRemoteBehaviorSpecification$Frontend;", "namespace", "", "Lcom/intellij/openapi/util/NlsSafe;", "<init>", "(Ljava/lang/String;)V", "getNamespace", "()Ljava/lang/String;", "update", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "isSelected", "", "setSelected", "state", "intellij.clouds.kubernetes"})
public final class KubernetesNamespaceToggleAction
extends KubernetesModelBasedDumbAwareToggleAction
implements KubernetesNamespaceAction,
ActionRemoteBehaviorSpecification.Frontend {
    @NotNull
    private final String namespace;

    public KubernetesNamespaceToggleAction(@NotNull String namespace) {
        Intrinsics.checkNotNullParameter((Object)namespace, (String)"namespace");
        this.namespace = namespace;
    }

    @Override
    @NotNull
    public String getNamespace() {
        return this.namespace;
    }

    @Override
    public void update(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        super.update(e);
        Presentation presentation = e.getPresentation();
        Intrinsics.checkNotNullExpressionValue((Object)presentation, (String)"getPresentation(...)");
        Presentation presentation2 = presentation;
        if (!presentation2.isVisible()) {
            return;
        }
        presentation2.setText(this.getNamespace());
        Object[] objectArray = new Object[]{this.getNamespace()};
        presentation2.setDescription(KubernetesBundle.messagePointer("action.Kubernetes.Namespace.description", objectArray));
    }

    public boolean isSelected(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        KubernetesApiModelInterface kubernetesApiModelInterface = KubernetesActionsRpcServiceKt.getApiModel(e);
        return Intrinsics.areEqual((Object)(kubernetesApiModelInterface != null ? kubernetesApiModelInterface.getNamespaceForRequest() : null), (Object)this.getNamespace());
    }

    public void setSelected(@NotNull AnActionEvent e, boolean state) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        KubernetesApiModelInterface kubernetesApiModelInterface = KubernetesActionsRpcServiceKt.getApiModel(e);
        Intrinsics.checkNotNull((Object)kubernetesApiModelInterface);
        KubernetesApiModelInterface apiModel2 = kubernetesApiModelInterface;
        apiModel2.scheduleSetNamespace(this.getNamespace());
    }
}

