/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.util;

import com.intellij.codeInsight.ExternalAnnotationsManager;
import com.intellij.openapi.diagnostic.Attachment;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Condition;
import com.intellij.pom.java.JavaFeature;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaResolveResult;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.LambdaUtil;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiArrayInitializerExpression;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiCapturedWildcardType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiDisjunctionType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiEllipsisType;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiIntersectionType;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiLambdaExpressionType;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodReferenceExpression;
import com.intellij.psi.PsiMethodReferenceType;
import com.intellij.psi.PsiMethodReferenceUtil;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParenthesizedExpression;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiTypeParameterListOwner;
import com.intellij.psi.PsiTypeVisitor;
import com.intellij.psi.PsiTypes;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.PsiWildcardType;
import com.intellij.psi.StubBasedPsiElement;
import com.intellij.psi.TypeAnnotationProvider;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PsiTypesUtil {
    private static final Logger LOG = Logger.getInstance(PsiTypesUtil.class);
    @NonNls
    private static final Map<String, String> ourUnboxedTypes = new HashMap<String, String>();
    @NonNls
    private static final Map<String, String> ourBoxedTypes = new HashMap<String, String>();
    @NonNls
    private static final String GET_CLASS_METHOD = "getClass";

    private PsiTypesUtil() {
    }

    public static Object getDefaultValue(PsiType type) {
        if (!(type instanceof PsiPrimitiveType)) {
            return null;
        }
        switch (type.getCanonicalText()) {
            case "boolean": {
                return false;
            }
            case "byte": {
                return (byte)0;
            }
            case "char": {
                return Character.valueOf('\u0000');
            }
            case "short": {
                return (short)0;
            }
            case "int": {
                return 0;
            }
            case "long": {
                return 0L;
            }
            case "float": {
                return Float.valueOf(0.0f);
            }
            case "double": {
                return 0.0;
            }
        }
        return null;
    }

    @NotNull
    public static String getDefaultValueOfType(@Nullable PsiType type) {
        return PsiTypesUtil.getDefaultValueOfType(type, false);
    }

    @NotNull
    public static String getDefaultValueOfType(@Nullable PsiType type, boolean customDefaultValues) {
        if (type instanceof PsiPrimitiveType) {
            return PsiTypes.booleanType().equals(type) ? "false" : "0";
        }
        if (customDefaultValues) {
            String typeText;
            if (type instanceof PsiArrayType) {
                PsiClassType classType;
                int count = type.getArrayDimensions() - 1;
                PsiType componentType = type.getDeepComponentType();
                if (componentType instanceof PsiClassType && (classType = (PsiClassType)componentType).resolve() instanceof PsiTypeParameter) {
                    return "null";
                }
                PsiType erasedComponentType = TypeConversionUtil.erasure(componentType);
                StringBuilder buffer = new StringBuilder();
                buffer.append("new");
                buffer.append(" ");
                buffer.append(erasedComponentType.getCanonicalText());
                buffer.append("[0]");
                for (int i = 0; i < count; ++i) {
                    buffer.append("[]");
                }
                String string = buffer.toString();
                if (string == null) {
                    PsiTypesUtil.$$$reportNull$$$0(0);
                }
                return string;
            }
            PsiClass psiClass = PsiUtil.resolveClassInClassTypeOnly(type);
            if (psiClass != null && (typeText = psiClass.getQualifiedName()) != null) {
                switch (typeText) {
                    case "java.util.Optional": 
                    case "java.util.OptionalInt": 
                    case "java.util.OptionalLong": 
                    case "java.util.OptionalDouble": 
                    case "java.util.stream.Stream": 
                    case "java.util.stream.IntStream": 
                    case "java.util.stream.LongStream": 
                    case "java.util.stream.DoubleStream": {
                        String string = typeText + ".empty()";
                        if (string == null) {
                            PsiTypesUtil.$$$reportNull$$$0(1);
                        }
                        return string;
                    }
                    case "java.lang.String": {
                        return "\"\"";
                    }
                    case "java.lang.Long": {
                        return "0L";
                    }
                    case "java.lang.Integer": 
                    case "java.lang.Short": 
                    case "java.lang.Byte": {
                        return "0";
                    }
                    case "java.lang.Float": {
                        return "0f";
                    }
                    case "java.lang.Double": {
                        return "0.0";
                    }
                    case "java.util.Set": {
                        return PsiUtil.isAvailable(JavaFeature.COLLECTION_FACTORIES, psiClass) ? "java.util.Set.of()" : "java.util.Collections.emptySet()";
                    }
                    case "java.util.Collection": 
                    case "java.util.List": {
                        return PsiUtil.isAvailable(JavaFeature.COLLECTION_FACTORIES, psiClass) ? "java.util.List.of()" : "java.util.Collections.emptyList()";
                    }
                    case "java.util.Map": {
                        return PsiUtil.isAvailable(JavaFeature.COLLECTION_FACTORIES, psiClass) ? "java.util.Map.of()" : "java.util.Collections.emptyMap()";
                    }
                }
            }
        }
        return "null";
    }

    @Contract(value="null -> null; !null -> !null")
    @Nullable
    @NonNls
    public static String unboxIfPossible(@Nullable @NonNls String type) {
        if (type == null) {
            return null;
        }
        String s = ourUnboxedTypes.get(type);
        return s == null ? type : s;
    }

    @Contract(value="null -> null; !null -> !null")
    @Nullable
    public static String boxIfPossible(@Nullable String type) {
        if (type == null) {
            return null;
        }
        String s = ourBoxedTypes.get(type);
        return s == null ? type : s;
    }

    @Nullable
    public static PsiClass getPsiClass(@Nullable PsiType psiType) {
        return psiType instanceof PsiClassType ? ((PsiClassType)psiType).resolve() : null;
    }

    @NotNull
    public static PsiClassType getClassType(@NotNull PsiClass psiClass) {
        if (psiClass == null) {
            PsiTypesUtil.$$$reportNull$$$0(2);
        }
        PsiClassType psiClassType = JavaPsiFacade.getElementFactory(psiClass.getProject()).createType(psiClass);
        if (psiClassType == null) {
            PsiTypesUtil.$$$reportNull$$$0(3);
        }
        return psiClassType;
    }

    @Nullable
    public static PsiClassType getLowestUpperBoundClassType(@NotNull PsiDisjunctionType type) {
        PsiType lub;
        if (type == null) {
            PsiTypesUtil.$$$reportNull$$$0(4);
        }
        if ((lub = type.getLeastUpperBound()) instanceof PsiClassType) {
            return (PsiClassType)lub;
        }
        if (lub instanceof PsiIntersectionType) {
            for (PsiType subType : ((PsiIntersectionType)lub).getConjuncts()) {
                PsiClass aClass;
                if (!(subType instanceof PsiClassType) || (aClass = ((PsiClassType)subType).resolve()) == null || aClass.isInterface()) continue;
                return (PsiClassType)subType;
            }
        }
        return null;
    }

    public static PsiType patchMethodGetClassReturnType(@NotNull PsiMethodReferenceExpression methodExpression, @NotNull PsiMethod method) {
        if (methodExpression == null) {
            PsiTypesUtil.$$$reportNull$$$0(5);
        }
        if (method == null) {
            PsiTypesUtil.$$$reportNull$$$0(6);
        }
        if (PsiTypesUtil.isGetClass(method)) {
            PsiType qualifierType = PsiMethodReferenceUtil.getQualifierType(methodExpression);
            return qualifierType != null ? PsiTypesUtil.createJavaLangClassType(methodExpression, qualifierType, true) : null;
        }
        return null;
    }

    public static PsiType patchMethodGetClassReturnType(@NotNull PsiExpression call, @NotNull PsiReferenceExpression methodExpression, @NotNull PsiMethod method, @NotNull Condition<? super IElementType> condition, @NotNull LanguageLevel languageLevel) {
        if (call == null) {
            PsiTypesUtil.$$$reportNull$$$0(7);
        }
        if (methodExpression == null) {
            PsiTypesUtil.$$$reportNull$$$0(8);
        }
        if (method == null) {
            PsiTypesUtil.$$$reportNull$$$0(9);
        }
        if (condition == null) {
            PsiTypesUtil.$$$reportNull$$$0(10);
        }
        if (languageLevel == null) {
            PsiTypesUtil.$$$reportNull$$$0(11);
        }
        if (JavaFeature.GENERICS.isSufficient(languageLevel) && PsiTypesUtil.isGetClass(method)) {
            PsiExpression qualifier = methodExpression.getQualifierExpression();
            PsiType qualifierType = null;
            Project project = call.getProject();
            if (qualifier != null) {
                qualifierType = TypeConversionUtil.erasure(qualifier.getType());
            } else {
                PsiElement parent;
                for (parent = call.getContext(); parent != null && condition.value((Object)(parent instanceof StubBasedPsiElement ? ((StubBasedPsiElement)parent).getIElementType() : parent.getNode().getElementType())); parent = parent.getContext()) {
                }
                if (parent != null) {
                    qualifierType = JavaPsiFacade.getElementFactory(project).createType((PsiClass)parent);
                }
            }
            if (PsiTypes.nullType().equals(qualifierType)) {
                LOG.error("Unexpected null qualifier", new Attachment[]{new Attachment("expression.txt", call.getText())});
            }
            return PsiTypesUtil.createJavaLangClassType(methodExpression, qualifierType, true);
        }
        return null;
    }

    public static boolean isGetClass(@NotNull PsiMethod method) {
        if (method == null) {
            PsiTypesUtil.$$$reportNull$$$0(12);
        }
        if (GET_CLASS_METHOD.equals(method.getName())) {
            PsiClass aClass = method.getContainingClass();
            return aClass != null && "java.lang.Object".equals(aClass.getQualifiedName());
        }
        return false;
    }

    @Nullable
    public static PsiType createJavaLangClassType(@NotNull PsiElement context, @Nullable PsiType qualifierType, boolean captureTopLevelWildcards) {
        if (context == null) {
            PsiTypesUtil.$$$reportNull$$$0(13);
        }
        if (qualifierType != null) {
            PsiUtil.ensureValidType(qualifierType);
            JavaPsiFacade facade = JavaPsiFacade.getInstance(context.getProject());
            PsiClass javaLangClass = facade.findClass("java.lang.Class", context.getResolveScope());
            if (javaLangClass != null && javaLangClass.getTypeParameters().length == 1) {
                PsiSubstitutor substitutor = PsiSubstitutor.EMPTY.put(javaLangClass.getTypeParameters()[0], PsiWildcardType.createExtends(context.getManager(), qualifierType));
                PsiClassType classType = facade.getElementFactory().createType(javaLangClass, substitutor, PsiUtil.getLanguageLevel(context));
                return captureTopLevelWildcards ? PsiUtil.captureToplevelWildcards(classType, context) : classType;
            }
        }
        return null;
    }

    @Nullable
    public static PsiType getExpectedTypeByParent(@NotNull PsiElement element) {
        PsiElement parent;
        if (element == null) {
            PsiTypesUtil.$$$reportNull$$$0(14);
        }
        if ((parent = PsiUtil.skipParenthesizedExprUp(element.getParent())) instanceof PsiVariable) {
            if (PsiUtil.checkSameExpression(element, ((PsiVariable)parent).getInitializer())) {
                PsiTypeElement typeElement = ((PsiVariable)parent).getTypeElement();
                if (typeElement != null && typeElement.isInferredType()) {
                    return null;
                }
                return ((PsiVariable)parent).getType();
            }
        } else if (parent instanceof PsiAssignmentExpression) {
            if (((PsiAssignmentExpression)parent).getOperationSign().getTokenType() == JavaTokenType.EQ && PsiUtil.checkSameExpression(element, ((PsiAssignmentExpression)parent).getRExpression())) {
                PsiType type = ((PsiAssignmentExpression)parent).getLExpression().getType();
                return !PsiTypes.nullType().equals(type) ? type : null;
            }
        } else if (parent instanceof PsiReturnStatement) {
            PsiElement psiElement = PsiTreeUtil.getParentOfType((PsiElement)parent, (Class[])new Class[]{PsiLambdaExpression.class, PsiMethod.class});
            if (psiElement instanceof PsiLambdaExpression) {
                return null;
            }
            if (psiElement instanceof PsiMethod) {
                return ((PsiMethod)psiElement).getReturnType();
            }
        } else {
            if (PsiUtil.isCondition(element, parent)) {
                return PsiTypes.booleanType();
            }
            if (parent instanceof PsiArrayInitializerExpression) {
                PsiElement gParent = parent.getParent();
                if (gParent instanceof PsiNewExpression) {
                    PsiType type = ((PsiNewExpression)gParent).getType();
                    if (type instanceof PsiArrayType) {
                        return ((PsiArrayType)type).getComponentType();
                    }
                } else if (gParent instanceof PsiVariable) {
                    PsiType type = ((PsiVariable)gParent).getType();
                    if (type instanceof PsiArrayType) {
                        return ((PsiArrayType)type).getComponentType();
                    }
                } else if (gParent instanceof PsiArrayInitializerExpression) {
                    PsiType expectedTypeByParent = PsiTypesUtil.getExpectedTypeByParent(parent);
                    return expectedTypeByParent instanceof PsiArrayType ? ((PsiArrayType)expectedTypeByParent).getComponentType() : null;
                }
            }
        }
        return null;
    }

    @Nullable
    public static PsiType getMethodReturnType(@NotNull PsiElement element) {
        PsiElement methodOrLambda;
        if (element == null) {
            PsiTypesUtil.$$$reportNull$$$0(15);
        }
        return (methodOrLambda = PsiTreeUtil.getParentOfType((PsiElement)element, (Class[])new Class[]{PsiMethod.class, PsiLambdaExpression.class})) instanceof PsiMethod ? ((PsiMethod)methodOrLambda).getReturnType() : (methodOrLambda instanceof PsiLambdaExpression ? LambdaUtil.getFunctionalInterfaceReturnType((PsiLambdaExpression)methodOrLambda) : null);
    }

    public static boolean compareTypes(PsiType leftType, PsiType rightType, boolean ignoreEllipsis) {
        if (ignoreEllipsis) {
            if (leftType instanceof PsiEllipsisType) {
                leftType = ((PsiEllipsisType)leftType).toArrayType();
            }
            if (rightType instanceof PsiEllipsisType) {
                rightType = ((PsiEllipsisType)rightType).toArrayType();
            }
        }
        return Comparing.equal((Object)leftType, (Object)rightType);
    }

    @Contract(value="null, _ -> false")
    public static boolean isDenotableType(@Nullable PsiType type, @NotNull PsiElement context) {
        if (context == null) {
            PsiTypesUtil.$$$reportNull$$$0(16);
        }
        if (type == null || type instanceof PsiWildcardType || type instanceof PsiCapturedWildcardType || type instanceof PsiIntersectionType) {
            return false;
        }
        if ((type = type.getDeepComponentType()) instanceof PsiPrimitiveType) {
            return !PsiTypes.nullType().equals(type);
        }
        if (type instanceof PsiClassType) {
            String className = ((PsiClassType)type).getClassName();
            if (className == null) {
                return false;
            }
            LanguageLevel level = PsiUtil.getLanguageLevel(context);
            if (PsiUtil.isKeyword(className, level) || PsiUtil.isSoftKeyword(className, level)) {
                return false;
            }
            for (PsiType parameter : ((PsiClassType)type).getParameters()) {
                if (parameter instanceof PsiWildcardType) {
                    parameter = ((PsiWildcardType)parameter).getBound();
                }
                if (parameter == null || PsiTypesUtil.isDenotableType(parameter, context)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public static boolean hasTypeAnnotation(@NotNull PsiType type) {
        if (type == null) {
            PsiTypesUtil.$$$reportNull$$$0(17);
        }
        return type.accept(new PsiTypeVisitor<Boolean>(){

            @Override
            public Boolean visitType(@NotNull PsiType type) {
                if (type == null) {
                    1.$$$reportNull$$$0(0);
                }
                return type.hasAnnotations();
            }

            @Override
            public Boolean visitClassType(@NotNull PsiClassType classType) {
                if (classType == null) {
                    1.$$$reportNull$$$0(1);
                }
                if (((Boolean)super.visitClassType(classType)).booleanValue()) {
                    return true;
                }
                for (PsiType t1 : classType.getParameters()) {
                    if (!t1.accept(this).booleanValue()) continue;
                    return true;
                }
                return false;
            }

            @Override
            public Boolean visitArrayType(@NotNull PsiArrayType arrayType) {
                if (arrayType == null) {
                    1.$$$reportNull$$$0(2);
                }
                return (Boolean)super.visitArrayType(arrayType) != false || arrayType.getComponentType().accept(this) != false;
            }

            @Override
            public Boolean visitWildcardType(@NotNull PsiWildcardType wildcardType) {
                if (wildcardType == null) {
                    1.$$$reportNull$$$0(3);
                }
                return (Boolean)super.visitWildcardType(wildcardType) != false || wildcardType.getBound() != null && wildcardType.getBound().accept(this) != false;
            }

            @Override
            public Boolean visitIntersectionType(@NotNull PsiIntersectionType intersectionType) {
                if (intersectionType == null) {
                    1.$$$reportNull$$$0(4);
                }
                for (PsiType t1 : intersectionType.getConjuncts()) {
                    if (!t1.accept(this).booleanValue()) continue;
                    return true;
                }
                return false;
            }

            @Override
            public Boolean visitDisjunctionType(@NotNull PsiDisjunctionType disjunctionType) {
                if (disjunctionType == null) {
                    1.$$$reportNull$$$0(5);
                }
                for (PsiType t1 : disjunctionType.getDisjunctions()) {
                    if (!t1.accept(this).booleanValue()) continue;
                    return true;
                }
                return false;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "type";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "classType";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "arrayType";
                        break;
                    }
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "wildcardType";
                        break;
                    }
                    case 4: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "intersectionType";
                        break;
                    }
                    case 5: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "disjunctionType";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/psi/util/PsiTypesUtil$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitType";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitClassType";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitArrayType";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitWildcardType";
                        break;
                    }
                    case 4: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitIntersectionType";
                        break;
                    }
                    case 5: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitDisjunctionType";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
    }

    public static boolean hasUnresolvedComponents(@NotNull PsiType type) {
        if (type == null) {
            PsiTypesUtil.$$$reportNull$$$0(18);
        }
        return type.accept(new PsiTypeVisitor<Boolean>(){

            @Override
            @Nullable
            public Boolean visitClassType(@NotNull PsiClassType classType) {
                PsiClassType.ClassResolveResult resolveResult;
                PsiClass psiClass;
                if (classType == null) {
                    2.$$$reportNull$$$0(0);
                }
                if ((psiClass = (resolveResult = classType.resolveGenerics()).getElement()) == null) {
                    return true;
                }
                PsiSubstitutor substitutor = resolveResult.getSubstitutor();
                for (PsiTypeParameter param : PsiUtil.typeParametersIterable(psiClass)) {
                    PsiType psiType = substitutor.substitute(param);
                    if (psiType == null || !psiType.accept(this).booleanValue()) continue;
                    return true;
                }
                return (Boolean)super.visitClassType(classType);
            }

            @Override
            @Nullable
            public Boolean visitArrayType(@NotNull PsiArrayType arrayType) {
                if (arrayType == null) {
                    2.$$$reportNull$$$0(1);
                }
                return arrayType.getComponentType().accept(this);
            }

            @Override
            @NotNull
            public Boolean visitWildcardType(@NotNull PsiWildcardType wildcardType) {
                PsiType bound;
                if (wildcardType == null) {
                    2.$$$reportNull$$$0(2);
                }
                Boolean bl = (bound = wildcardType.getBound()) != null && bound.accept(this) != false;
                if (bl == null) {
                    2.$$$reportNull$$$0(3);
                }
                return bl;
            }

            @Override
            public Boolean visitType(@NotNull PsiType type) {
                if (type == null) {
                    2.$$$reportNull$$$0(4);
                }
                return false;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                    case 3: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 3;
                        break;
                    }
                    case 3: {
                        n2 = 2;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "classType";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "arrayType";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "wildcardType";
                        break;
                    }
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/psi/util/PsiTypesUtil$2";
                        break;
                    }
                    case 4: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "type";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/psi/util/PsiTypesUtil$2";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[1] = "visitWildcardType";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "visitClassType";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray;
                        objectArray[2] = "visitArrayType";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray;
                        objectArray[2] = "visitWildcardType";
                        break;
                    }
                    case 3: {
                        break;
                    }
                    case 4: {
                        objectArray = objectArray;
                        objectArray[2] = "visitType";
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                    case 3: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        });
    }

    @NotNull
    public static PsiType getParameterType(PsiParameter @NotNull [] parameters, int i, boolean varargs) {
        PsiParameter parameter;
        PsiType parameterType;
        if (parameters == null) {
            PsiTypesUtil.$$$reportNull$$$0(19);
        }
        if ((parameterType = (parameter = parameters[i < parameters.length ? i : parameters.length - 1]).getType()) instanceof PsiEllipsisType) {
            parameterType = varargs ? ((PsiEllipsisType)parameterType).getComponentType() : ((PsiEllipsisType)parameterType).toArrayType();
        }
        if (!parameterType.isValid()) {
            PsiUtil.ensureValidType(parameterType, "Invalid type of parameter " + parameter + " of " + parameter.getClass());
        }
        PsiType psiType = parameterType;
        if (psiType == null) {
            PsiTypesUtil.$$$reportNull$$$0(20);
        }
        return psiType;
    }

    public static PsiTypeParameter @NotNull [] filterUnusedTypeParameters(PsiTypeParameter @NotNull [] typeParameters, PsiType ... types) {
        if (typeParameters == null) {
            PsiTypesUtil.$$$reportNull$$$0(21);
        }
        if (types == null) {
            PsiTypesUtil.$$$reportNull$$$0(22);
        }
        if (typeParameters.length == 0) {
            if (PsiTypeParameter.EMPTY_ARRAY == null) {
                PsiTypesUtil.$$$reportNull$$$0(23);
            }
            return PsiTypeParameter.EMPTY_ARRAY;
        }
        TypeParameterSearcher searcher = new TypeParameterSearcher();
        for (PsiType type : types) {
            type.accept(searcher);
        }
        PsiTypeParameter[] psiTypeParameterArray = searcher.getTypeParameters().toArray(PsiTypeParameter.EMPTY_ARRAY);
        if (psiTypeParameterArray == null) {
            PsiTypesUtil.$$$reportNull$$$0(24);
        }
        return psiTypeParameterArray;
    }

    public static PsiTypeParameter @NotNull [] filterUnusedTypeParameters(@NotNull PsiType superReturnTypeInBaseClassType, PsiTypeParameter @NotNull [] typeParameters) {
        if (superReturnTypeInBaseClassType == null) {
            PsiTypesUtil.$$$reportNull$$$0(25);
        }
        if (typeParameters == null) {
            PsiTypesUtil.$$$reportNull$$$0(26);
        }
        return PsiTypesUtil.filterUnusedTypeParameters(typeParameters, superReturnTypeInBaseClassType);
    }

    private static boolean isAccessibleAt(@NotNull PsiTypeParameter parameter, @NotNull PsiElement context) {
        PsiTypeParameterListOwner owner;
        if (parameter == null) {
            PsiTypesUtil.$$$reportNull$$$0(27);
        }
        if (context == null) {
            PsiTypesUtil.$$$reportNull$$$0(28);
        }
        if ((owner = parameter.getOwner()) instanceof PsiMethod) {
            return PsiTreeUtil.isAncestor((PsiElement)owner, (PsiElement)context, (boolean)false);
        }
        if (owner instanceof PsiClass) {
            return PsiTreeUtil.isAncestor((PsiElement)owner, (PsiElement)context, (boolean)false) && InheritanceUtil.hasEnclosingInstanceInScope((PsiClass)owner, context, false, false);
        }
        return false;
    }

    public static boolean allTypeParametersResolved(@NotNull PsiElement context, @NotNull PsiType targetType) {
        if (context == null) {
            PsiTypesUtil.$$$reportNull$$$0(29);
        }
        if (targetType == null) {
            PsiTypesUtil.$$$reportNull$$$0(30);
        }
        TypeParameterSearcher searcher = new TypeParameterSearcher();
        targetType.accept(searcher);
        Set<PsiTypeParameter> parameters = searcher.getTypeParameters();
        return ContainerUtil.and(parameters, parameter -> PsiTypesUtil.isAccessibleAt(parameter, context));
    }

    @NotNull
    public static PsiType createArrayType(@NotNull PsiType newType, int arrayDim) {
        if (newType == null) {
            PsiTypesUtil.$$$reportNull$$$0(31);
        }
        for (int i = 0; i < arrayDim; ++i) {
            newType = newType.createArrayType();
        }
        PsiType psiType = newType;
        if (psiType == null) {
            PsiTypesUtil.$$$reportNull$$$0(32);
        }
        return psiType;
    }

    @Nullable
    public static PsiTypeElement replaceWithExplicitType(PsiTypeElement typeElement) {
        PsiType type = typeElement.getType();
        if (!PsiTypesUtil.isDenotableType(type, typeElement)) {
            return null;
        }
        Project project = typeElement.getProject();
        PsiTypeElement typeElementByExplicitType = JavaPsiFacade.getElementFactory(project).createTypeElement(type);
        PsiElement explicitTypeElement = typeElement.replace(typeElementByExplicitType);
        explicitTypeElement = JavaCodeStyleManager.getInstance(project).shortenClassReferences(explicitTypeElement);
        return (PsiTypeElement)CodeStyleManager.getInstance((Project)project).reformat(explicitTypeElement);
    }

    public static PsiType getTypeByMethod(@NotNull PsiElement context, PsiExpressionList argumentList, PsiElement parentMethod, boolean varargs, PsiSubstitutor substitutor, boolean inferParent) {
        if (context == null) {
            PsiTypesUtil.$$$reportNull$$$0(33);
        }
        if (parentMethod instanceof PsiMethod) {
            PsiParameter[] parameters = ((PsiMethod)parentMethod).getParameterList().getParameters();
            if (parameters.length == 0) {
                return null;
            }
            Object[] args = argumentList.getExpressions();
            if (!((PsiMethod)parentMethod).isVarArgs() && parameters.length != args.length && !inferParent) {
                return null;
            }
            PsiElement arg = context;
            while (arg.getParent() instanceof PsiParenthesizedExpression) {
                arg = arg.getParent();
            }
            int i = ArrayUtilRt.find((Object[])args, (Object)arg);
            if (i < 0) {
                return null;
            }
            PsiType parameterType = substitutor != null ? substitutor.substitute(PsiTypesUtil.getParameterType(parameters, i, varargs)) : null;
            boolean isRaw = substitutor != null && PsiUtil.isRawSubstitutor((PsiMethod)parentMethod, substitutor);
            return isRaw ? TypeConversionUtil.erasure(parameterType) : parameterType;
        }
        return null;
    }

    public static boolean mentionsTypeParameters(@Nullable PsiType type, @NotNull Set<? extends PsiTypeParameter> typeParameters) {
        if (typeParameters == null) {
            PsiTypesUtil.$$$reportNull$$$0(34);
        }
        return PsiTypesUtil.mentionsTypeParametersOrUnboundedWildcard(type, typeParameters::contains);
    }

    public static boolean mentionsTypeParameters(@Nullable PsiType type, @NotNull Predicate<? super PsiTypeParameter> wantedTypeParameter) {
        if (wantedTypeParameter == null) {
            PsiTypesUtil.$$$reportNull$$$0(35);
        }
        return PsiTypesUtil.mentionsTypeParametersOrUnboundedWildcard(type, wantedTypeParameter);
    }

    public static boolean isUncheckedCall(JavaResolveResult resolveResult) {
        PsiSubstitutor substitutor;
        PsiMethod method;
        PsiElement element = resolveResult.getElement();
        if (element instanceof PsiMethod && PsiUtil.isRawSubstitutor(method = (PsiMethod)element, substitutor = resolveResult.getSubstitutor())) {
            for (PsiParameter t : method.getParameterList().getParameters()) {
                PsiClass aClass;
                PsiType type = t.getType().getDeepComponentType();
                if (!(type instanceof PsiClassType) || !((aClass = ((PsiClassType)type).resolveGenerics().getElement()) instanceof PsiTypeParameter) && (aClass == null || !PsiUtil.typeParametersIterator(aClass).hasNext() || ((PsiClassType)type).isRaw())) continue;
                return true;
            }
            return false;
        }
        return false;
    }

    private static boolean mentionsTypeParametersOrUnboundedWildcard(@Nullable PsiType type, final Predicate<? super PsiTypeParameter> wantedTypeParameter) {
        if (type == null) {
            return false;
        }
        return type.accept(new PsiTypeVisitor<Boolean>(){

            @Override
            public Boolean visitType(@NotNull PsiType type) {
                if (type == null) {
                    3.$$$reportNull$$$0(0);
                }
                return false;
            }

            @Override
            public Boolean visitWildcardType(@NotNull PsiWildcardType wildcardType) {
                PsiType bound;
                if (wildcardType == null) {
                    3.$$$reportNull$$$0(1);
                }
                return (bound = wildcardType.getBound()) != null ? bound.accept(this) : Boolean.valueOf(false);
            }

            @Override
            public Boolean visitClassType(@NotNull PsiClassType classType) {
                PsiClassType.ClassResolveResult result;
                PsiClass psiClass;
                if (classType == null) {
                    3.$$$reportNull$$$0(2);
                }
                if ((psiClass = (result = classType.resolveGenerics()).getElement()) != null) {
                    PsiSubstitutor substitutor = result.getSubstitutor();
                    for (PsiTypeParameter parameter : PsiUtil.typeParametersIterable(psiClass)) {
                        PsiType type = substitutor.substitute(parameter);
                        if (type == null || !type.accept(this).booleanValue()) continue;
                        return true;
                    }
                }
                return psiClass instanceof PsiTypeParameter && wantedTypeParameter.test((PsiTypeParameter)psiClass);
            }

            @Override
            public Boolean visitIntersectionType(@NotNull PsiIntersectionType intersectionType) {
                if (intersectionType == null) {
                    3.$$$reportNull$$$0(3);
                }
                for (PsiType conjunct : intersectionType.getConjuncts()) {
                    if (!conjunct.accept(this).booleanValue()) continue;
                    return true;
                }
                return false;
            }

            @Override
            public Boolean visitMethodReferenceType(@NotNull PsiMethodReferenceType methodReferenceType) {
                if (methodReferenceType == null) {
                    3.$$$reportNull$$$0(4);
                }
                return false;
            }

            @Override
            public Boolean visitLambdaExpressionType(@NotNull PsiLambdaExpressionType lambdaExpressionType) {
                if (lambdaExpressionType == null) {
                    3.$$$reportNull$$$0(5);
                }
                return false;
            }

            @Override
            public Boolean visitArrayType(@NotNull PsiArrayType arrayType) {
                if (arrayType == null) {
                    3.$$$reportNull$$$0(6);
                }
                return arrayType.getComponentType().accept(this);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "type";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "wildcardType";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "classType";
                        break;
                    }
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "intersectionType";
                        break;
                    }
                    case 4: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "methodReferenceType";
                        break;
                    }
                    case 5: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "lambdaExpressionType";
                        break;
                    }
                    case 6: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "arrayType";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/psi/util/PsiTypesUtil$3";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitType";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitWildcardType";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitClassType";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitIntersectionType";
                        break;
                    }
                    case 4: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitMethodReferenceType";
                        break;
                    }
                    case 5: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitLambdaExpressionType";
                        break;
                    }
                    case 6: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitArrayType";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
    }

    @Contract(value="null, _ -> false")
    public static boolean classNameEquals(@Nullable PsiType type, @NotNull String qualifiedClassName) {
        if (qualifiedClassName == null) {
            PsiTypesUtil.$$$reportNull$$$0(36);
        }
        if (!(type instanceof PsiClassType)) {
            return false;
        }
        PsiClassType classType = (PsiClassType)type;
        String className = classType.getClassName();
        if (className == null || !qualifiedClassName.endsWith(className)) {
            return false;
        }
        PsiClass psiClass = classType.resolve();
        if (psiClass == null) {
            return false;
        }
        return qualifiedClassName.equals(psiClass.getQualifiedName());
    }

    @NotNull
    public static List<? extends PsiClassType> getClassTypeComponents(PsiType type) {
        if (type instanceof PsiClassType) {
            List<PsiClassType> list = Collections.singletonList((PsiClassType)type);
            if (list == null) {
                PsiTypesUtil.$$$reportNull$$$0(37);
            }
            return list;
        }
        if (type instanceof PsiCapturedWildcardType) {
            return PsiTypesUtil.getClassTypeComponents(((PsiCapturedWildcardType)type).getUpperBound());
        }
        if (type instanceof PsiIntersectionType) {
            ArrayList<? extends PsiClassType> classTypes = new ArrayList<PsiClassType>();
            for (PsiType conjunct : ((PsiIntersectionType)type).getConjuncts()) {
                classTypes.addAll(PsiTypesUtil.getClassTypeComponents(conjunct));
            }
            ArrayList<? extends PsiClassType> arrayList = classTypes;
            if (arrayList == null) {
                PsiTypesUtil.$$$reportNull$$$0(38);
            }
            return arrayList;
        }
        List list = Collections.emptyList();
        if (list == null) {
            PsiTypesUtil.$$$reportNull$$$0(39);
        }
        return list;
    }

    @NotNull
    public static PsiType removeExternalAnnotations(@NotNull PsiType type) {
        List newAnnotations;
        Object[] annotations;
        if (type == null) {
            PsiTypesUtil.$$$reportNull$$$0(40);
        }
        if ((annotations = type.getAnnotations()).length > 0 && (newAnnotations = ContainerUtil.filter((Object[])annotations, annotation -> !ExternalAnnotationsManager.getInstance(annotation.getProject()).isExternalAnnotation((PsiAnnotation)annotation))).size() < annotations.length) {
            type = type.annotate(TypeAnnotationProvider.Static.create(newAnnotations.toArray(PsiAnnotation.EMPTY_ARRAY)));
        }
        if (type instanceof PsiClassType) {
            PsiClassType classType = (PsiClassType)type;
            PsiClass psiClass = classType.resolve();
            if (psiClass != null) {
                PsiType[] parameters = classType.getParameters();
                boolean changed = false;
                for (int i = 0; i < parameters.length; ++i) {
                    PsiType updatedParameter;
                    PsiType parameter = parameters[i];
                    parameters[i] = updatedParameter = PsiTypesUtil.removeExternalAnnotations(parameter);
                    changed |= updatedParameter != parameter;
                }
                if (changed) {
                    PsiClassType psiClassType = JavaPsiFacade.getElementFactory(psiClass.getProject()).createType(psiClass, parameters);
                    if (psiClassType == null) {
                        PsiTypesUtil.$$$reportNull$$$0(41);
                    }
                    return psiClassType;
                }
            }
            PsiType psiType = type;
            if (psiType == null) {
                PsiTypesUtil.$$$reportNull$$$0(42);
            }
            return psiType;
        }
        if (type instanceof PsiArrayType) {
            PsiArrayType arrayType = (PsiArrayType)type;
            PsiType origComponentType = arrayType.getComponentType();
            PsiType componentType = PsiTypesUtil.removeExternalAnnotations(origComponentType);
            PsiType psiType = componentType == origComponentType ? type : componentType.createArrayType();
            if (psiType == null) {
                PsiTypesUtil.$$$reportNull$$$0(43);
            }
            return psiType;
        }
        if (type instanceof PsiWildcardType) {
            PsiWildcardType wildcardType = (PsiWildcardType)type;
            PsiType bound = wildcardType.getBound();
            PsiWildcardType psiWildcardType = bound == null ? wildcardType : (wildcardType.isExtends() ? PsiWildcardType.createExtends(wildcardType.getManager(), PsiTypesUtil.removeExternalAnnotations(bound)) : (wildcardType.isSuper() ? PsiWildcardType.createSuper(wildcardType.getManager(), PsiTypesUtil.removeExternalAnnotations(bound)) : wildcardType));
            if (psiWildcardType == null) {
                PsiTypesUtil.$$$reportNull$$$0(44);
            }
            return psiWildcardType;
        }
        if (type instanceof PsiIntersectionType) {
            PsiIntersectionType intersectionType = (PsiIntersectionType)type;
            PsiType[] conjuncts = intersectionType.getConjuncts();
            PsiType[] newConjuncts = new PsiType[conjuncts.length];
            for (int i = 0; i < conjuncts.length; ++i) {
                newConjuncts[i] = PsiTypesUtil.removeExternalAnnotations(conjuncts[i]);
            }
            PsiType psiType = PsiIntersectionType.createIntersection(newConjuncts);
            if (psiType == null) {
                PsiTypesUtil.$$$reportNull$$$0(45);
            }
            return psiType;
        }
        PsiType psiType = type;
        if (psiType == null) {
            PsiTypesUtil.$$$reportNull$$$0(46);
        }
        return psiType;
    }

    public static boolean isValidAnnotationMethodType(@NotNull PsiType type) {
        if (type == null) {
            PsiTypesUtil.$$$reportNull$$$0(47);
        }
        if (type instanceof PsiArrayType) {
            PsiArrayType arrayType = (PsiArrayType)type;
            if (arrayType.getArrayDimensions() != 1) {
                return false;
            }
            type = arrayType.getComponentType();
        }
        if (type instanceof PsiPrimitiveType) {
            return !PsiTypes.voidType().equals(type) && !PsiTypes.nullType().equals(type);
        }
        if (type instanceof PsiClassType) {
            PsiClassType classType = (PsiClassType)type;
            if (classType.getParameters().length > 0) {
                return PsiTypesUtil.classNameEquals(classType, "java.lang.Class");
            }
            if (classType.equalsToText("java.lang.Class") || classType.equalsToText("java.lang.String")) {
                return true;
            }
            PsiClass aClass = classType.resolve();
            return aClass != null && (aClass.isAnnotationType() || aClass.isEnum());
        }
        return false;
    }

    public static boolean isRestrictedIdentifier(@Nullable String typeName, @NotNull LanguageLevel level) {
        if (level == null) {
            PsiTypesUtil.$$$reportNull$$$0(48);
        }
        return "var".equals(typeName) && JavaFeature.LVTI.isSufficient(level) || "yield".equals(typeName) && JavaFeature.SWITCH_EXPRESSION.isSufficient(level) || "record".equals(typeName) && JavaFeature.RECORDS.isSufficient(level) || ("sealed".equals(typeName) || "permits".equals(typeName)) && JavaFeature.SEALED_CLASSES.isSufficient(level) || "value".equals(typeName) && JavaFeature.VALHALLA_VALUE_CLASSES.isSufficient(level);
    }

    static {
        ourUnboxedTypes.put("java.lang.Boolean", "boolean");
        ourUnboxedTypes.put("java.lang.Byte", "byte");
        ourUnboxedTypes.put("java.lang.Short", "short");
        ourUnboxedTypes.put("java.lang.Integer", "int");
        ourUnboxedTypes.put("java.lang.Long", "long");
        ourUnboxedTypes.put("java.lang.Float", "float");
        ourUnboxedTypes.put("java.lang.Double", "double");
        ourUnboxedTypes.put("java.lang.Character", "char");
        ourBoxedTypes.put("boolean", "java.lang.Boolean");
        ourBoxedTypes.put("byte", "java.lang.Byte");
        ourBoxedTypes.put("short", "java.lang.Short");
        ourBoxedTypes.put("int", "java.lang.Integer");
        ourBoxedTypes.put("long", "java.lang.Long");
        ourBoxedTypes.put("float", "java.lang.Float");
        ourBoxedTypes.put("double", "java.lang.Double");
        ourBoxedTypes.put("char", "java.lang.Character");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 21: 
            case 22: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 40: 
            case 47: 
            case 48: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 21: 
            case 22: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 40: 
            case 47: 
            case 48: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/util/PsiTypesUtil";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiClass";
                break;
            }
            case 4: 
            case 17: 
            case 18: 
            case 40: 
            case 47: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 5: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "methodExpression";
                break;
            }
            case 6: 
            case 9: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "call";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "condition";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "languageLevel";
                break;
            }
            case 13: 
            case 16: 
            case 28: 
            case 29: 
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 14: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameters";
                break;
            }
            case 21: 
            case 26: 
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeParameters";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "types";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "superReturnTypeInBaseClassType";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameter";
                break;
            }
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetType";
                break;
            }
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newType";
                break;
            }
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "wantedTypeParameter";
                break;
            }
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "qualifiedClassName";
                break;
            }
            case 48: {
                objectArray2 = objectArray3;
                objectArray3[0] = "level";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultValueOfType";
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 21: 
            case 22: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 40: 
            case 47: 
            case 48: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/util/PsiTypesUtil";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getClassType";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "getParameterType";
                break;
            }
            case 23: 
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "filterUnusedTypeParameters";
                break;
            }
            case 32: {
                objectArray = objectArray2;
                objectArray2[1] = "createArrayType";
                break;
            }
            case 37: 
            case 38: 
            case 39: {
                objectArray = objectArray2;
                objectArray2[1] = "getClassTypeComponents";
                break;
            }
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: {
                objectArray = objectArray2;
                objectArray2[1] = "removeExternalAnnotations";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getClassType";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getLowestUpperBoundClassType";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "patchMethodGetClassReturnType";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "isGetClass";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "createJavaLangClassType";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getExpectedTypeByParent";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getMethodReturnType";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "isDenotableType";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "hasTypeAnnotation";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "hasUnresolvedComponents";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "getParameterType";
                break;
            }
            case 21: 
            case 22: 
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "filterUnusedTypeParameters";
                break;
            }
            case 27: 
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "isAccessibleAt";
                break;
            }
            case 29: 
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "allTypeParametersResolved";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "createArrayType";
                break;
            }
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "getTypeByMethod";
                break;
            }
            case 34: 
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "mentionsTypeParameters";
                break;
            }
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "classNameEquals";
                break;
            }
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "removeExternalAnnotations";
                break;
            }
            case 47: {
                objectArray = objectArray;
                objectArray[2] = "isValidAnnotationMethodType";
                break;
            }
            case 48: {
                objectArray = objectArray;
                objectArray[2] = "isRestrictedIdentifier";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 21: 
            case 22: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 40: 
            case 47: 
            case 48: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class TypeParameterSearcher
    extends PsiTypeVisitor<Boolean> {
        private final Set<PsiTypeParameter> myTypeParams = new HashSet<PsiTypeParameter>();

        @NotNull
        public Set<PsiTypeParameter> getTypeParameters() {
            Set<PsiTypeParameter> set = this.myTypeParams;
            if (set == null) {
                TypeParameterSearcher.$$$reportNull$$$0(0);
            }
            return set;
        }

        @Override
        public Boolean visitType(@NotNull PsiType type) {
            if (type == null) {
                TypeParameterSearcher.$$$reportNull$$$0(1);
            }
            return false;
        }

        @Override
        public Boolean visitArrayType(@NotNull PsiArrayType arrayType) {
            if (arrayType == null) {
                TypeParameterSearcher.$$$reportNull$$$0(2);
            }
            return arrayType.getComponentType().accept(this);
        }

        @Override
        public Boolean visitClassType(@NotNull PsiClassType classType) {
            PsiClassType.ClassResolveResult resolveResult;
            PsiClass aClass;
            if (classType == null) {
                TypeParameterSearcher.$$$reportNull$$$0(3);
            }
            if ((aClass = (resolveResult = classType.resolveGenerics()).getElement()) instanceof PsiTypeParameter) {
                this.myTypeParams.add((PsiTypeParameter)aClass);
            }
            if (aClass != null) {
                PsiSubstitutor substitutor = resolveResult.getSubstitutor();
                for (PsiTypeParameter parameter : PsiUtil.typeParametersIterable(aClass)) {
                    PsiType psiType = substitutor.substitute(parameter);
                    if (psiType == null) continue;
                    psiType.accept(this);
                }
            }
            return false;
        }

        @Override
        public Boolean visitWildcardType(@NotNull PsiWildcardType wildcardType) {
            PsiType bound;
            if (wildcardType == null) {
                TypeParameterSearcher.$$$reportNull$$$0(4);
            }
            if ((bound = wildcardType.getBound()) != null) {
                bound.accept(this);
            }
            return false;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/psi/util/PsiTypesUtil$TypeParameterSearcher";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "type";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "arrayType";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "classType";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "wildcardType";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getTypeParameters";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/psi/util/PsiTypesUtil$TypeParameterSearcher";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "visitType";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "visitArrayType";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "visitClassType";
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "visitWildcardType";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

