/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.tree.java;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Computable;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiParenthesizedExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.ResolveState;
import com.intellij.psi.impl.source.Constants;
import com.intellij.psi.impl.source.tree.ChildRole;
import com.intellij.psi.impl.source.tree.java.ExpressionPsiElement;
import com.intellij.psi.scope.ElementClassHint;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.tree.IElementType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PsiParenthesizedExpressionImpl
extends ExpressionPsiElement
implements PsiParenthesizedExpression,
Constants {
    private static final Logger LOG = Logger.getInstance(PsiParenthesizedExpressionImpl.class);

    public PsiParenthesizedExpressionImpl() {
        super(PARENTH_EXPRESSION);
    }

    @Override
    @Nullable
    public PsiExpression getExpression() {
        return (PsiExpression)this.findChildByRoleAsPsiElement(64);
    }

    @Override
    public PsiType getType() {
        PsiExpression expr = this.getExpression();
        if (expr == null) {
            return null;
        }
        return expr.getType();
    }

    public ASTNode findChildByRole(int role) {
        LOG.assertTrue(ChildRole.isUnique(role));
        switch (role) {
            case 24: {
                return this.findChildByType(LPARENTH);
            }
            case 25: {
                return this.findChildByType(RPARENTH);
            }
            case 64: {
                return this.findChildByType(EXPRESSION_BIT_SET);
            }
        }
        return null;
    }

    public int getChildRole(@NotNull ASTNode child) {
        if (child == null) {
            PsiParenthesizedExpressionImpl.$$$reportNull$$$0(0);
        }
        LOG.assertTrue(child.getTreeParent() == this);
        IElementType i = child.getElementType();
        if (i == LPARENTH) {
            return 24;
        }
        if (i == RPARENTH) {
            return 25;
        }
        if (EXPRESSION_BIT_SET.contains(child.getElementType())) {
            return 64;
        }
        return 0;
    }

    public void accept(@NotNull PsiElementVisitor visitor) {
        if (visitor == null) {
            PsiParenthesizedExpressionImpl.$$$reportNull$$$0(1);
        }
        if (visitor instanceof JavaElementVisitor) {
            ((JavaElementVisitor)visitor).visitParenthesizedExpression(this);
        } else {
            visitor.visitElement((PsiElement)this);
        }
    }

    public boolean processDeclarations(@NotNull PsiScopeProcessor processor, @NotNull ResolveState state, PsiElement lastParent, @NotNull PsiElement place) {
        ElementClassHint elementClassHint;
        if (processor == null) {
            PsiParenthesizedExpressionImpl.$$$reportNull$$$0(2);
        }
        if (state == null) {
            PsiParenthesizedExpressionImpl.$$$reportNull$$$0(3);
        }
        if (place == null) {
            PsiParenthesizedExpressionImpl.$$$reportNull$$$0(4);
        }
        if ((elementClassHint = (ElementClassHint)processor.getHint(ElementClassHint.KEY)) != null && !elementClassHint.shouldProcess(ElementClassHint.DeclarationKind.VARIABLE)) {
            return true;
        }
        return PsiParenthesizedExpressionImpl.processDeclarations(processor, state, lastParent, place, (Computable<? extends PsiElement>)((Computable)this::getExpression));
    }

    public static boolean processDeclarations(@NotNull PsiScopeProcessor processor, @NotNull ResolveState state, PsiElement lastParent, @NotNull PsiElement place, @NotNull Computable<? extends @Nullable PsiElement> expressionProducer) {
        if (processor == null) {
            PsiParenthesizedExpressionImpl.$$$reportNull$$$0(5);
        }
        if (state == null) {
            PsiParenthesizedExpressionImpl.$$$reportNull$$$0(6);
        }
        if (place == null) {
            PsiParenthesizedExpressionImpl.$$$reportNull$$$0(7);
        }
        if (expressionProducer == null) {
            PsiParenthesizedExpressionImpl.$$$reportNull$$$0(8);
        }
        if (lastParent != null) {
            return true;
        }
        PsiElement expression = (PsiElement)expressionProducer.get();
        if (expression == null) {
            return true;
        }
        return expression.processDeclarations(processor, state, null, place);
    }

    public String toString() {
        return "PsiParenthesizedExpression:" + this.getText();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "child";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visitor";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 4: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "place";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expressionProducer";
                break;
            }
        }
        objectArray2[1] = "com/intellij/psi/impl/source/tree/java/PsiParenthesizedExpressionImpl";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getChildRole";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "accept";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "processDeclarations";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

