/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.file;

import com.intellij.codeInsight.completion.scope.JavaCompletionHints;
import com.intellij.codeInsight.multiverse.CodeInsightContexts;
import com.intellij.core.CoreJavaDirectoryService;
import com.intellij.lang.Language;
import com.intellij.lang.java.JavaLanguage;
import com.intellij.navigation.ItemPresentation;
import com.intellij.navigation.ItemPresentationProviders;
import com.intellij.navigation.NavigationItem;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.IndexNotReadyException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Queryable;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.RecursionGuard;
import com.intellij.openapi.util.RecursionManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassOwner;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiImplicitClass;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiNameHelper;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.PsiPackageStatement;
import com.intellij.psi.ResolveState;
import com.intellij.psi.impl.JavaPsiFacadeImpl;
import com.intellij.psi.impl.file.PsiPackageBase;
import com.intellij.psi.impl.file.PsiPackageImplementationHelper;
import com.intellij.psi.impl.source.tree.java.PsiCompositeModifierList;
import com.intellij.psi.scope.ElementClassHint;
import com.intellij.psi.scope.NameHint;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.PsiSearchScopeUtil;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiClassUtil;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.psi.util.PsiUtil;
import com.intellij.reference.SoftReference;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Processor;
import com.intellij.util.Processors;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;

public class PsiPackageImpl
extends PsiPackageBase
implements PsiPackage,
Queryable {
    private static final Logger LOG = Logger.getInstance(PsiPackageImpl.class);
    private volatile CachedValue<PsiModifierList> myAnnotationList;
    private volatile java.lang.ref.SoftReference<Map<GlobalSearchScope, Map<String, PsiClass[]>>> myClassCache;
    private volatile CachedValue<Collection<PsiDirectory>> myDirectories;
    private volatile CachedValue<Collection<PsiDirectory>> myDirectoriesWithLibSources;
    private volatile CachedValue<Collection<PsiFile>> myFiles;
    private volatile java.lang.ref.SoftReference<Map<GlobalSearchScope, Map<String, PsiClass[]>>> myDumbModeFullCache;
    private volatile java.lang.ref.SoftReference<Map<Pair<GlobalSearchScope, String>, PsiClass[]>> myDumbModePartialCache;

    public PsiPackageImpl(PsiManager manager, String qualifiedName) {
        super(manager, qualifiedName);
    }

    protected @Unmodifiable Collection<PsiDirectory> getAllDirectories(@NotNull GlobalSearchScope scope) {
        if (scope == null) {
            PsiPackageImpl.$$$reportNull$$$0(0);
        }
        if (scope.isForceSearchingInLibrarySources()) {
            if (this.myDirectoriesWithLibSources == null) {
                this.myDirectoriesWithLibSources = this.createCachedDirectories(true);
            }
            return ContainerUtil.filter((Collection)((Collection)this.myDirectoriesWithLibSources.getValue()), d -> scope.contains(d.getVirtualFile()));
        }
        if (this.myDirectories == null) {
            this.myDirectories = this.createCachedDirectories(false);
        }
        return ContainerUtil.filter((Collection)((Collection)this.myDirectories.getValue()), d -> scope.contains(d.getVirtualFile()));
    }

    @Override
    @NotNull
    public @Unmodifiable @NotNull Collection<@NotNull PsiFile> getIndividualFiles(@NotNull GlobalSearchScope scope) {
        if (scope == null) {
            PsiPackageImpl.$$$reportNull$$$0(1);
        }
        if (this.myFiles == null) {
            this.myFiles = this.createCachedFiles();
        }
        List list = ContainerUtil.filter((Collection)((Collection)this.myFiles.getValue()), d -> scope.contains(d.getVirtualFile()));
        if (list == null) {
            PsiPackageImpl.$$$reportNull$$$0(2);
        }
        return list;
    }

    @NotNull
    private CachedValue<Collection<PsiDirectory>> createCachedDirectories(boolean includeLibrarySources) {
        CachedValue cachedValue = CachedValuesManager.getManager((Project)this.getProject()).createCachedValue(() -> {
            ArrayList result = new ArrayList();
            Processor processor = Processors.cancelableCollectProcessor(result);
            this.getFacade().processPackageDirectories(this, this.allScope(), (Processor<? super PsiDirectory>)processor, includeLibrarySources);
            return CachedValueProvider.Result.create(result, (Object[])PsiPackageImplementationHelper.getInstance().getDirectoryCachedValueDependencies(this));
        }, false);
        if (cachedValue == null) {
            PsiPackageImpl.$$$reportNull$$$0(3);
        }
        return cachedValue;
    }

    @NotNull
    private CachedValue<Collection<PsiFile>> createCachedFiles() {
        CachedValue cachedValue = CachedValuesManager.getManager((Project)this.getProject()).createCachedValue(() -> {
            ArrayList result = new ArrayList();
            Processor processor = Processors.cancelableCollectProcessor(result);
            this.getFacade().processPackageFiles(this, this.allScope(), (Processor<? super PsiFile>)processor);
            return CachedValueProvider.Result.create(result, (Object[])PsiPackageImplementationHelper.getInstance().getDirectoryCachedValueDependencies(this));
        }, false);
        if (cachedValue == null) {
            PsiPackageImpl.$$$reportNull$$$0(4);
        }
        return cachedValue;
    }

    protected PsiPackageImpl findPackage(@NotNull String qName) {
        if (qName == null) {
            PsiPackageImpl.$$$reportNull$$$0(5);
        }
        return (PsiPackageImpl)this.getFacade().findPackage(qName);
    }

    @Override
    public void handleQualifiedNameChange(@NotNull String newQualifiedName) {
        if (newQualifiedName == null) {
            PsiPackageImpl.$$$reportNull$$$0(6);
        }
        PsiPackageImplementationHelper.getInstance().handleQualifiedNameChange(this, newQualifiedName);
    }

    @Override
    public VirtualFile @NotNull [] occursInPackagePrefixes() {
        VirtualFile[] virtualFileArray = PsiPackageImplementationHelper.getInstance().occursInPackagePrefixes(this);
        if (virtualFileArray == null) {
            PsiPackageImpl.$$$reportNull$$$0(7);
        }
        return virtualFileArray;
    }

    @Override
    public PsiPackageImpl getParentPackage() {
        return (PsiPackageImpl)super.getParentPackage();
    }

    @NotNull
    public Language getLanguage() {
        JavaLanguage javaLanguage = JavaLanguage.INSTANCE;
        if (javaLanguage == null) {
            PsiPackageImpl.$$$reportNull$$$0(8);
        }
        return javaLanguage;
    }

    public boolean isValid() {
        return !this.getProject().isDisposed();
    }

    public void accept(@NotNull PsiElementVisitor visitor) {
        if (visitor == null) {
            PsiPackageImpl.$$$reportNull$$$0(9);
        }
        if (visitor instanceof JavaElementVisitor) {
            ((JavaElementVisitor)visitor).visitPackage(this);
        } else {
            visitor.visitElement((PsiElement)this);
        }
    }

    public String toString() {
        return "PsiPackage:" + this.getQualifiedName();
    }

    @Override
    public PsiClass @NotNull [] getClasses() {
        PsiClass[] psiClassArray = this.getClasses(this.allScope());
        if (psiClassArray == null) {
            PsiPackageImpl.$$$reportNull$$$0(10);
        }
        return psiClassArray;
    }

    @NotNull
    protected GlobalSearchScope allScope() {
        GlobalSearchScope globalSearchScope = PsiPackageImplementationHelper.getInstance().adjustAllScope(this, GlobalSearchScope.allScope((Project)this.getProject()));
        if (globalSearchScope == null) {
            PsiPackageImpl.$$$reportNull$$$0(11);
        }
        return globalSearchScope;
    }

    @Override
    public PsiClass @NotNull [] getClasses(@NotNull GlobalSearchScope scope) {
        if (scope == null) {
            PsiPackageImpl.$$$reportNull$$$0(12);
        }
        PsiClass[] psiClassArray = this.getFacade().getClasses(this, scope);
        if (psiClassArray == null) {
            PsiPackageImpl.$$$reportNull$$$0(13);
        }
        return psiClassArray;
    }

    @Override
    public PsiFile @NotNull [] getFiles(@NotNull GlobalSearchScope scope) {
        if (scope == null) {
            PsiPackageImpl.$$$reportNull$$$0(14);
        }
        Object[] files = this.getFacade().getPackageFiles(this, scope);
        Collection<@NotNull PsiFile> individualFiles = this.getIndividualFiles(scope);
        Object[] objectArray = individualFiles.isEmpty() ? files : (PsiFile[])ArrayUtil.mergeArrays((Object[])files, (Object[])individualFiles.toArray(PsiFile.EMPTY_ARRAY));
        if (objectArray == null) {
            PsiPackageImpl.$$$reportNull$$$0(15);
        }
        return objectArray;
    }

    @Override
    @Nullable
    public PsiModifierList getAnnotationList() {
        if (this.myAnnotationList == null) {
            this.myAnnotationList = CachedValuesManager.getManager((Project)this.getProject()).createCachedValue((CachedValueProvider)new PackageAnnotationValueProvider(), false);
        }
        return (PsiModifierList)this.myAnnotationList.getValue();
    }

    @Override
    public PsiPackage @NotNull [] getSubPackages() {
        PsiPackage[] psiPackageArray = this.getSubPackages(this.allScope());
        if (psiPackageArray == null) {
            PsiPackageImpl.$$$reportNull$$$0(16);
        }
        return psiPackageArray;
    }

    @Override
    public PsiPackage @NotNull [] getSubPackages(@NotNull GlobalSearchScope scope) {
        if (scope == null) {
            PsiPackageImpl.$$$reportNull$$$0(17);
        }
        PsiPackage[] psiPackageArray = this.getFacade().getSubPackages(this, scope);
        if (psiPackageArray == null) {
            PsiPackageImpl.$$$reportNull$$$0(18);
        }
        return psiPackageArray;
    }

    private JavaPsiFacadeImpl getFacade() {
        return (JavaPsiFacadeImpl)JavaPsiFacade.getInstance(this.getProject());
    }

    private PsiClass @NotNull [] getCachedClassesByName(@NotNull String shortName, @NotNull GlobalSearchScope scope) {
        DumbService dumbService;
        if (shortName == null) {
            PsiPackageImpl.$$$reportNull$$$0(19);
        }
        if (scope == null) {
            PsiPackageImpl.$$$reportNull$$$0(20);
        }
        if ((dumbService = DumbService.getInstance((Project)this.getProject())).isAlternativeResolveEnabled()) {
            return this.getCachedClassesInDumbMode(shortName, scope);
        }
        boolean sharedSourceSupportEnabled = CodeInsightContexts.isSharedSourceSupportEnabled((Project)this.getProject());
        GlobalSearchScope effectiveScope = sharedSourceSupportEnabled ? scope : GlobalSearchScope.everythingScope((Project)this.getProject());
        return this.getCachedClassesByNameImpl(shortName, effectiveScope);
    }

    private PsiClass @NotNull [] getCachedClassesByNameImpl(@NotNull String shortName, @NotNull GlobalSearchScope scope) {
        Map map2;
        PsiClass[] classes;
        Map cache;
        if (shortName == null) {
            PsiPackageImpl.$$$reportNull$$$0(21);
        }
        if (scope == null) {
            PsiPackageImpl.$$$reportNull$$$0(22);
        }
        if ((cache = (Map)SoftReference.dereference(this.myClassCache)) == null) {
            cache = ContainerUtil.createConcurrentSoftValueMap();
            this.myClassCache = new java.lang.ref.SoftReference<Map>(cache);
        }
        if ((classes = (PsiClass[])(map2 = cache.computeIfAbsent(scope, __ -> ContainerUtil.createConcurrentSoftValueMap())).get(shortName)) != null) {
            if (classes == null) {
                PsiPackageImpl.$$$reportNull$$$0(23);
            }
            return classes;
        }
        RecursionGuard.StackStamp stamp = RecursionManager.markStack();
        classes = this.findAllClasses(shortName, scope);
        if (stamp.mayCacheNow()) {
            map2.put(shortName, classes);
        }
        if (classes == null) {
            PsiPackageImpl.$$$reportNull$$$0(24);
        }
        return classes;
    }

    private PsiClass @NotNull [] findAllClasses(@NotNull String shortName, @NotNull GlobalSearchScope scope) {
        String qName;
        if (shortName == null) {
            PsiPackageImpl.$$$reportNull$$$0(25);
        }
        if (scope == null) {
            PsiPackageImpl.$$$reportNull$$$0(26);
        }
        String classQName = !(qName = this.getQualifiedName()).isEmpty() ? qName + "." + shortName : shortName;
        PsiClass[] psiClassArray = this.getFacade().findClasses(classQName, scope);
        if (psiClassArray == null) {
            PsiPackageImpl.$$$reportNull$$$0(27);
        }
        return psiClassArray;
    }

    private PsiClass @NotNull [] getCachedClassesInDumbMode(String shortName, GlobalSearchScope scope) {
        PsiClass[] classes;
        HashMap<String, PsiClass[]> map2;
        ConcurrentHashMap scopeMap = (ConcurrentHashMap)SoftReference.dereference(this.myDumbModeFullCache);
        if (scopeMap == null) {
            scopeMap = new ConcurrentHashMap();
            this.myDumbModeFullCache = new java.lang.ref.SoftReference(scopeMap);
        }
        if ((map2 = (HashMap<String, PsiClass[]>)scopeMap.get(scope)) == null) {
            PsiClass[] array = this.findClassesHeuristically(shortName, scope);
            if (array != null) {
                if (array == null) {
                    PsiPackageImpl.$$$reportNull$$$0(28);
                }
                return array;
            }
            RecursionGuard.StackStamp stamp = RecursionManager.markStack();
            map2 = new HashMap<String, PsiClass[]>();
            for (PsiClass psiClass : this.getClasses(scope)) {
                PsiClass[] psiClassArray;
                String psiClassName = psiClass.getName();
                if (psiClassName == null) continue;
                Object[] existing = (PsiClass[])map2.get(psiClassName);
                if (existing == null) {
                    PsiClass[] psiClassArray2 = new PsiClass[1];
                    psiClassArray = psiClassArray2;
                    psiClassArray2[0] = psiClass;
                } else {
                    psiClassArray = (PsiClass[])ArrayUtil.append((Object[])existing, (Object)psiClass);
                }
                map2.put(psiClassName, psiClassArray);
            }
            if (stamp.mayCacheNow()) {
                scopeMap.put(scope, map2);
            }
        }
        PsiClass[] psiClassArray = (classes = (PsiClass[])map2.get(shortName)) == null ? PsiClass.EMPTY_ARRAY : classes;
        if (psiClassArray == null) {
            PsiPackageImpl.$$$reportNull$$$0(29);
        }
        return psiClassArray;
    }

    private PsiClass @Nullable [] findClassesHeuristically(@NotNull String shortName, @NotNull GlobalSearchScope scope) {
        PsiClass[] result;
        if (shortName == null) {
            PsiPackageImpl.$$$reportNull$$$0(30);
        }
        if (scope == null) {
            PsiPackageImpl.$$$reportNull$$$0(31);
        }
        if (this.findSubPackageByName(shortName) != null) {
            return PsiClass.EMPTY_ARRAY;
        }
        ConcurrentHashMap<Pair, PsiClass[]> partial = (ConcurrentHashMap<Pair, PsiClass[]>)SoftReference.dereference(this.myDumbModePartialCache);
        if (partial == null) {
            partial = new ConcurrentHashMap<Pair, PsiClass[]>();
            this.myDumbModePartialCache = new java.lang.ref.SoftReference(partial);
        }
        if ((result = (PsiClass[])partial.get(Pair.create((Object)scope, (Object)shortName))) == null) {
            RecursionGuard.StackStamp stamp = RecursionManager.markStack();
            ArrayList<PsiClass> fastClasses = new ArrayList<PsiClass>();
            for (PsiDirectory directory : this.getDirectories(scope)) {
                PsiClass[] classes;
                List sameNamed = ContainerUtil.filter((Object[])directory.getFiles(scope), file -> file.getName().contains(shortName));
                for (PsiClass aClass : classes = CoreJavaDirectoryService.getPsiClasses(directory, sameNamed.toArray(PsiFile.EMPTY_ARRAY))) {
                    if (!shortName.equals(aClass.getName())) continue;
                    fastClasses.add(aClass);
                }
            }
            if (!fastClasses.isEmpty() && stamp.mayCacheNow()) {
                result = fastClasses.toArray(PsiClass.EMPTY_ARRAY);
                partial.put(Pair.create((Object)scope, (Object)shortName), result);
            }
        }
        return result;
    }

    @Override
    public boolean containsClassNamed(@NotNull String shortName) {
        if (shortName == null) {
            PsiPackageImpl.$$$reportNull$$$0(32);
        }
        return this.getCachedClassesByName(shortName, GlobalSearchScope.everythingScope((Project)this.getProject())).length > 0;
    }

    @Override
    public PsiClass @NotNull [] findClassByShortName(@NotNull String shortName, @NotNull GlobalSearchScope scope) {
        Object[] allClasses;
        if (shortName == null) {
            PsiPackageImpl.$$$reportNull$$$0(33);
        }
        if (scope == null) {
            PsiPackageImpl.$$$reportNull$$$0(34);
        }
        if ((allClasses = this.getCachedClassesByName(shortName, scope)).length == 0) {
            if (allClasses == null) {
                PsiPackageImpl.$$$reportNull$$$0(35);
            }
            return allClasses;
        }
        if (allClasses.length == 1) {
            PsiClass[] psiClassArray = PsiSearchScopeUtil.isInScope((GlobalSearchScope)scope, (PsiElement)allClasses[0]) ? (PsiClass[])allClasses.clone() : PsiClass.EMPTY_ARRAY;
            if (psiClassArray == null) {
                PsiPackageImpl.$$$reportNull$$$0(36);
            }
            return psiClassArray;
        }
        PsiClass[] psiClassArray = (PsiClass[])((StreamEx)((StreamEx)StreamEx.of((Object[])allClasses).filter(aClass -> PsiSearchScopeUtil.isInScope((GlobalSearchScope)scope, (PsiElement)aClass) && aClass.getContainingClass() == null)).sorted(PsiClassUtil.createScopeComparator(scope).thenComparing(c -> c.getQualifiedName(), Comparator.nullsLast(Comparator.naturalOrder())).thenComparing(c -> {
            PsiFile file = c.getContainingFile();
            return file instanceof PsiClassOwner ? ((PsiClassOwner)file).getPackageName() : "";
        }))).toArray((Object[])PsiClass.EMPTY_ARRAY);
        if (psiClassArray == null) {
            PsiPackageImpl.$$$reportNull$$$0(37);
        }
        return psiClassArray;
    }

    @Override
    public boolean hasClassWithShortName(@NotNull String shortName, @NotNull GlobalSearchScope scope) {
        if (shortName == null) {
            PsiPackageImpl.$$$reportNull$$$0(38);
        }
        if (scope == null) {
            PsiPackageImpl.$$$reportNull$$$0(39);
        }
        Object[] classes = this.getCachedClassesByName(shortName, scope);
        return ContainerUtil.exists((Object[])classes, aClass -> PsiSearchScopeUtil.isInScope((GlobalSearchScope)scope, (PsiElement)aClass));
    }

    @Nullable
    private PsiPackage findSubPackageByName(@NotNull String name) {
        String qName;
        if (name == null) {
            PsiPackageImpl.$$$reportNull$$$0(40);
        }
        String subpackageQName = (qName = this.getQualifiedName()).isEmpty() ? name : qName + "." + name;
        return this.getFacade().findPackage(subpackageQName);
    }

    public boolean processDeclarations(@NotNull PsiScopeProcessor processor, @NotNull ResolveState state, PsiElement lastParent, @NotNull PsiElement place) {
        String providedName;
        if (processor == null) {
            PsiPackageImpl.$$$reportNull$$$0(41);
        }
        if (state == null) {
            PsiPackageImpl.$$$reportNull$$$0(42);
        }
        if (place == null) {
            PsiPackageImpl.$$$reportNull$$$0(43);
        }
        GlobalSearchScope scope = place.getResolveScope();
        processor.handleEvent(PsiScopeProcessor.Event.SET_DECLARATION_HOLDER, (Object)this);
        ElementClassHint classHint = (ElementClassHint)processor.getHint(ElementClassHint.KEY);
        Condition nameCondition = (Condition)processor.getHint(JavaCompletionHints.NAME_FILTER);
        NameHint providedNameHint = (NameHint)processor.getHint(NameHint.KEY);
        String string = providedName = providedNameHint == null ? null : providedNameHint.getName(state);
        if (classHint == null || classHint.shouldProcess(ElementClassHint.DeclarationKind.CLASS)) {
            PsiClass[] classes;
            if (providedName != null) {
                classes = this.findClassByShortName(providedName, scope);
                if (classes.length == 0 && PsiUtil.isInsideJavadocComment(place)) {
                    classes = this.findClassByShortName(providedName, this.allScope());
                }
                if (!PsiPackageImpl.processClasses(processor, state, classes, (Condition<? super String>)Conditions.alwaysTrue())) {
                    return false;
                }
            } else {
                classes = this.getClasses(scope);
                if (classes.length == 0 && PsiUtil.isInsideJavadocComment(place)) {
                    classes = this.getClasses(this.allScope());
                }
                if (!PsiPackageImpl.processClasses(processor, state, classes, (Condition<? super String>)(nameCondition != null ? nameCondition : Conditions.alwaysTrue()))) {
                    return false;
                }
            }
        }
        if (classHint == null || classHint.shouldProcess(ElementClassHint.DeclarationKind.PACKAGE)) {
            if (providedName != null) {
                PsiPackage aPackage = this.findSubPackageByName(providedName);
                if (aPackage != null && !processor.execute((PsiElement)aPackage, state)) {
                    return false;
                }
            } else {
                PsiPackage[] packs;
                for (PsiPackage pack : packs = this.getSubPackages(scope)) {
                    String packageName = pack.getName();
                    if (packageName == null || !PsiNameHelper.getInstance(this.getProject()).isIdentifier(packageName, PsiUtil.getLanguageLevel(this)) || processor.execute((PsiElement)pack, state)) continue;
                    return false;
                }
            }
        }
        return true;
    }

    private static boolean processClasses(@NotNull PsiScopeProcessor processor, @NotNull ResolveState state, PsiClass @NotNull [] classes, @NotNull Condition<? super String> nameCondition) {
        if (processor == null) {
            PsiPackageImpl.$$$reportNull$$$0(44);
        }
        if (state == null) {
            PsiPackageImpl.$$$reportNull$$$0(45);
        }
        if (nameCondition == null) {
            PsiPackageImpl.$$$reportNull$$$0(46);
        }
        if (classes == null) {
            PsiPackageImpl.$$$reportNull$$$0(47);
        }
        for (PsiClass aClass : classes) {
            String name;
            if (aClass instanceof PsiImplicitClass || (name = aClass.getName()) == null || !nameCondition.value((Object)name)) continue;
            try {
                if (processor.execute((PsiElement)aClass, state)) continue;
                return false;
            }
            catch (ProcessCanceledException | IndexNotReadyException e) {
                throw e;
            }
            catch (Exception e) {
                LOG.error((Throwable)e);
            }
        }
        return true;
    }

    public ItemPresentation getPresentation() {
        return ItemPresentationProviders.getItemPresentation((NavigationItem)this);
    }

    public void navigate(boolean requestFocus) {
        PsiPackageImplementationHelper.getInstance().navigate(this, requestFocus);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean mayHaveContentInScope(@NotNull GlobalSearchScope scope) {
        if (scope == null) {
            PsiPackageImpl.$$$reportNull$$$0(48);
        }
        if (this.getDirectories(scope).length > 0) return true;
        if (this.getClasses(scope).length > 0) return true;
        if (!ContainerUtil.exists((Object[])this.occursInPackagePrefixes(), arg_0 -> ((GlobalSearchScope)scope).contains(arg_0))) return false;
        return true;
    }

    @Override
    @Nullable
    public PsiModifierList getModifierList() {
        return this.getAnnotationList();
    }

    @Override
    public boolean hasModifierProperty(@NonNls @NotNull String name) {
        if (name == null) {
            PsiPackageImpl.$$$reportNull$$$0(49);
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 13: 
            case 15: 
            case 16: 
            case 18: 
            case 23: 
            case 24: 
            case 27: 
            case 28: 
            case 29: 
            case 35: 
            case 36: 
            case 37: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 13: 
            case 15: 
            case 16: 
            case 18: 
            case 23: 
            case 24: 
            case 27: 
            case 28: 
            case 29: 
            case 35: 
            case 36: 
            case 37: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 13: 
            case 15: 
            case 16: 
            case 18: 
            case 23: 
            case 24: 
            case 27: 
            case 28: 
            case 29: 
            case 35: 
            case 36: 
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/impl/file/PsiPackageImpl";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "qName";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newQualifiedName";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visitor";
                break;
            }
            case 19: 
            case 21: 
            case 25: 
            case 30: 
            case 32: 
            case 33: 
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "shortName";
                break;
            }
            case 40: 
            case 49: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 41: 
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 42: 
            case 45: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "place";
                break;
            }
            case 46: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nameCondition";
                break;
            }
            case 47: {
                objectArray2 = objectArray3;
                objectArray3[0] = "classes";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/impl/file/PsiPackageImpl";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getIndividualFiles";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "createCachedDirectories";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "createCachedFiles";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "occursInPackagePrefixes";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getLanguage";
                break;
            }
            case 10: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getClasses";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "allScope";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getFiles";
                break;
            }
            case 16: 
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getSubPackages";
                break;
            }
            case 23: 
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "getCachedClassesByNameImpl";
                break;
            }
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "findAllClasses";
                break;
            }
            case 28: 
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "getCachedClassesInDumbMode";
                break;
            }
            case 35: 
            case 36: 
            case 37: {
                objectArray = objectArray2;
                objectArray2[1] = "findClassByShortName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getAllDirectories";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getIndividualFiles";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 13: 
            case 15: 
            case 16: 
            case 18: 
            case 23: 
            case 24: 
            case 27: 
            case 28: 
            case 29: 
            case 35: 
            case 36: 
            case 37: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "findPackage";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "handleQualifiedNameChange";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "accept";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getClasses";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getFiles";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getSubPackages";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "getCachedClassesByName";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "getCachedClassesByNameImpl";
                break;
            }
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "findAllClasses";
                break;
            }
            case 30: 
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "findClassesHeuristically";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "containsClassNamed";
                break;
            }
            case 33: 
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "findClassByShortName";
                break;
            }
            case 38: 
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "hasClassWithShortName";
                break;
            }
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "findSubPackageByName";
                break;
            }
            case 41: 
            case 42: 
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "processDeclarations";
                break;
            }
            case 44: 
            case 45: 
            case 46: 
            case 47: {
                objectArray = objectArray;
                objectArray[2] = "processClasses";
                break;
            }
            case 48: {
                objectArray = objectArray;
                objectArray[2] = "mayHaveContentInScope";
                break;
            }
            case 49: {
                objectArray = objectArray;
                objectArray[2] = "hasModifierProperty";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 13: 
            case 15: 
            case 16: 
            case 18: 
            case 23: 
            case 24: 
            case 27: 
            case 28: 
            case 29: 
            case 35: 
            case 36: 
            case 37: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class PackageAnnotationValueProvider
    implements CachedValueProvider<PsiModifierList> {
        private PackageAnnotationValueProvider() {
        }

        public CachedValueProvider.Result<PsiModifierList> compute() {
            ArrayList modifiers = new ArrayList();
            Consumer<PsiFile> processFile = file -> {
                PsiPackageStatement statement;
                if (file instanceof PsiJavaFile && (statement = ((PsiJavaFile)file).getPackageStatement()) != null) {
                    ContainerUtil.addIfNotNull((Collection)modifiers, (Object)statement.getAnnotationList());
                }
            };
            for (PsiDirectory psiDirectory : PsiPackageImpl.this.getDirectories()) {
                processFile.accept(psiDirectory.findFile("package-info.java"));
            }
            for (PsiClass psiClass : PsiPackageImpl.this.getFacade().findClasses(PsiPackageImpl.this.getQualifiedName() + ".package-info", PsiPackageImpl.this.allScope())) {
                processFile.accept(psiClass.getContainingFile());
            }
            PsiCompositeModifierList psiCompositeModifierList = modifiers.isEmpty() ? null : new PsiCompositeModifierList(PsiPackageImpl.this.getManager(), modifiers);
            return new CachedValueProvider.Result((Object)psiCompositeModifierList, new Object[]{PsiModificationTracker.MODIFICATION_COUNT});
        }
    }
}

