/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.application.options;

import com.intellij.application.options.ImportLayoutPanelUI;
import com.intellij.icons.AllIcons;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.highlighter.JavaHighlightingColors;
import com.intellij.java.frontback.impl.JavaFrontbackBundle;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonShortcuts;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.psi.codeStyle.PackageEntry;
import com.intellij.psi.codeStyle.PackageEntryTable;
import com.intellij.ui.BooleanTableCellRenderer;
import com.intellij.ui.ColoredTableCellRenderer;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.TableUtil;
import com.intellij.ui.ToolbarDecorator;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.ui.table.JBTable;
import com.intellij.util.ui.JBUI;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.util.ArrayList;
import javax.swing.DefaultCellEditor;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.event.CellEditorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ImportLayoutPanel
extends JPanel {
    private final JBCheckBox myCbLayoutStaticImportsSeparately = new JBCheckBox(JavaFrontbackBundle.message("import.layout.static.imports.separately", new Object[0]));
    @Nullable
    private final JBCheckBox myCbLayoutOnDemandImportsFromSamePackageFirst;
    private final JBTable myImportLayoutTable;
    private final PackageEntryTable myImportLayoutList = new PackageEntryTable();

    public JBTable getImportLayoutTable() {
        return this.myImportLayoutTable;
    }

    public PackageEntryTable getImportLayoutList() {
        return this.myImportLayoutList;
    }

    public JBCheckBox getCbLayoutStaticImportsSeparately() {
        return this.myCbLayoutStaticImportsSeparately;
    }

    @Nullable
    public JBCheckBox getCbLayoutOnDemandImportsFromSamePackageFirst() {
        return this.myCbLayoutOnDemandImportsFromSamePackageFirst;
    }

    public ImportLayoutPanel(boolean showLayoutOnDemandImportFromSamePackageFirstCheckbox, boolean supportModuleImport) {
        super(new BorderLayout());
        this.myCbLayoutStaticImportsSeparately.addItemListener(e -> {
            if (this.areStaticImportsEnabled()) {
                boolean found = false;
                for (int i = this.myImportLayoutList.getEntryCount() - 1; i >= 0; --i) {
                    PackageEntry entry = this.myImportLayoutList.getEntryAt(i);
                    if (entry != PackageEntry.ALL_OTHER_STATIC_IMPORTS_ENTRY) continue;
                    found = true;
                    break;
                }
                if (!found) {
                    int index = this.myImportLayoutList.getEntryCount();
                    if (index != 0 && this.myImportLayoutList.getEntryAt(index - 1) != PackageEntry.BLANK_LINE_ENTRY) {
                        this.myImportLayoutList.addEntry(PackageEntry.BLANK_LINE_ENTRY);
                    }
                    this.myImportLayoutList.addEntry(PackageEntry.ALL_OTHER_STATIC_IMPORTS_ENTRY);
                }
            } else {
                for (int i = this.myImportLayoutList.getEntryCount() - 1; i >= 0; --i) {
                    PackageEntry entry = this.myImportLayoutList.getEntryAt(i);
                    if (!entry.isStatic()) continue;
                    this.myImportLayoutList.removeEntryAt(i);
                }
            }
            this.refresh();
        });
        DefaultActionGroup addGroup = new DefaultActionGroup(new AnAction[]{new AddPackageAction(), new AddBlankLineAction()});
        addGroup.getTemplatePresentation().setIcon(AllIcons.General.Add);
        addGroup.getTemplatePresentation().setText(JavaFrontbackBundle.lazyMessage("button.add", new Object[0]));
        addGroup.getTemplatePresentation().setPopupGroup(true);
        addGroup.registerCustomShortcutSet(CommonShortcuts.getNewForDialogs(), null);
        this.myImportLayoutTable = ImportLayoutPanel.createTableForPackageEntries(this.myImportLayoutList, this);
        JPanel importLayoutPanel = ToolbarDecorator.createDecorator((JTable)this.myImportLayoutTable).addExtraAction((AnAction)addGroup).setRemoveAction(button -> this.removeEntryFromImportLayouts()).setMoveUpAction(button -> this.moveRowUp()).setMoveDownAction(button -> this.moveRowDown()).setRemoveActionUpdater(e -> {
            int selectedImport = this.myImportLayoutTable.getSelectedRow();
            PackageEntry entry = selectedImport < 0 ? null : this.myImportLayoutList.getEntryAt(selectedImport);
            return entry != null && entry != PackageEntry.ALL_OTHER_STATIC_IMPORTS_ENTRY && entry != PackageEntry.ALL_OTHER_IMPORTS_ENTRY && entry != PackageEntry.ALL_MODULE_IMPORTS;
        }).setButtonComparator(new String[]{JavaFrontbackBundle.message("button.add", new Object[0]), IdeBundle.message((String)"action.remove", (Object[])new Object[0]), JavaFrontbackBundle.message("import.layout.panel.up.button", new Object[0]), JavaFrontbackBundle.message("import.layout.panel.down.button", new Object[0])}).setPreferredSize(new Dimension(-1, JBUI.scale((int)180))).createPanel();
        this.myCbLayoutOnDemandImportsFromSamePackageFirst = showLayoutOnDemandImportFromSamePackageFirstCheckbox ? new JBCheckBox(JavaFrontbackBundle.message("import.layout.on.demand.import.from.same.package.first", new Object[0])) : null;
        ArrayList<@Nullable JBCheckBox> additionalCheckBoxes = new ArrayList<JBCheckBox>();
        additionalCheckBoxes.add(this.myCbLayoutOnDemandImportsFromSamePackageFirst);
        ImportLayoutPanelUI UI = new ImportLayoutPanelUI(this.myCbLayoutStaticImportsSeparately, additionalCheckBoxes, importLayoutPanel);
        this.add((Component)UI.getPanel(), "Center");
    }

    public abstract void refresh();

    private void addPackageToImportLayouts() {
        int selected = this.myImportLayoutTable.getSelectedRow() + 1;
        if (selected < 0) {
            selected = this.myImportLayoutList.getEntryCount();
        }
        PackageEntry entry = new PackageEntry(false, "", true);
        this.myImportLayoutList.insertEntryAt(entry, selected);
        ImportLayoutPanel.refreshTableModel(selected, this.myImportLayoutTable);
    }

    private void addBlankLine() {
        int selected = this.myImportLayoutTable.getSelectedRow() + 1;
        if (selected < 0) {
            selected = this.myImportLayoutList.getEntryCount();
        }
        this.myImportLayoutList.insertEntryAt(PackageEntry.BLANK_LINE_ENTRY, selected);
        AbstractTableModel model = (AbstractTableModel)this.myImportLayoutTable.getModel();
        model.fireTableRowsInserted(selected, selected);
        this.myImportLayoutTable.setRowSelectionInterval(selected, selected);
    }

    private void removeEntryFromImportLayouts() {
        int selected = this.myImportLayoutTable.getSelectedRow();
        if (selected < 0) {
            return;
        }
        PackageEntry entry = this.myImportLayoutList.getEntryAt(selected);
        if (entry == PackageEntry.ALL_OTHER_STATIC_IMPORTS_ENTRY || entry == PackageEntry.ALL_OTHER_IMPORTS_ENTRY || entry == PackageEntry.ALL_MODULE_IMPORTS) {
            return;
        }
        TableUtil.stopEditing((JTable)this.myImportLayoutTable);
        this.myImportLayoutList.removeEntryAt(selected);
        AbstractTableModel model = (AbstractTableModel)this.myImportLayoutTable.getModel();
        model.fireTableRowsDeleted(selected, selected);
        if (selected >= this.myImportLayoutList.getEntryCount()) {
            --selected;
        }
        if (selected >= 0) {
            this.myImportLayoutTable.setRowSelectionInterval(selected, selected);
        }
    }

    private void moveRowUp() {
        int selected = this.myImportLayoutTable.getSelectedRow();
        if (selected < 1) {
            return;
        }
        TableUtil.stopEditing((JTable)this.myImportLayoutTable);
        PackageEntry entry = this.myImportLayoutList.getEntryAt(selected);
        PackageEntry previousEntry = this.myImportLayoutList.getEntryAt(selected - 1);
        this.myImportLayoutList.setEntryAt(previousEntry, selected);
        this.myImportLayoutList.setEntryAt(entry, selected - 1);
        AbstractTableModel model = (AbstractTableModel)this.myImportLayoutTable.getModel();
        model.fireTableRowsUpdated(selected - 1, selected);
        this.myImportLayoutTable.setRowSelectionInterval(selected - 1, selected - 1);
    }

    private void moveRowDown() {
        int selected = this.myImportLayoutTable.getSelectedRow();
        if (selected >= this.myImportLayoutList.getEntryCount() - 1) {
            return;
        }
        TableUtil.stopEditing((JTable)this.myImportLayoutTable);
        PackageEntry entry = this.myImportLayoutList.getEntryAt(selected);
        PackageEntry nextEntry = this.myImportLayoutList.getEntryAt(selected + 1);
        this.myImportLayoutList.setEntryAt(nextEntry, selected);
        this.myImportLayoutList.setEntryAt(entry, selected + 1);
        AbstractTableModel model = (AbstractTableModel)this.myImportLayoutTable.getModel();
        model.fireTableRowsUpdated(selected, selected + 1);
        this.myImportLayoutTable.setRowSelectionInterval(selected + 1, selected + 1);
    }

    public boolean areStaticImportsEnabled() {
        return this.myCbLayoutStaticImportsSeparately.isSelected();
    }

    public boolean isLayoutOnDemandImportsFromSamePackageFirst() {
        return this.myCbLayoutOnDemandImportsFromSamePackageFirst != null && this.myCbLayoutOnDemandImportsFromSamePackageFirst.isSelected();
    }

    public static JBTable createTableForPackageEntries(final PackageEntryTable packageTable, final ImportLayoutPanel panel) {
        final String[] names = new String[]{JavaFrontbackBundle.message("listbox.import.package", new Object[0]), JavaFrontbackBundle.message("listbox.import.with.subpackages", new Object[0])};
        AbstractTableModel dataModel = new AbstractTableModel(){

            @Override
            public int getColumnCount() {
                return names.length + (panel.areStaticImportsEnabled() ? 1 : 0);
            }

            @Override
            public int getRowCount() {
                return packageTable.getEntryCount();
            }

            @Override
            @Nullable
            public Object getValueAt(int row, int col) {
                PackageEntry entry = packageTable.getEntryAt(row);
                if (entry == null || !this.isCellEditable(row, col)) {
                    return null;
                }
                if ((col += panel.areStaticImportsEnabled() ? 0 : 1) == 0) {
                    return entry.isStatic();
                }
                if (col == 1) {
                    return entry.getPackageName();
                }
                if (col == 2) {
                    return entry.isWithSubpackages();
                }
                throw new IllegalArgumentException(String.valueOf(col));
            }

            @Override
            public String getColumnName(int column) {
                if (panel.areStaticImportsEnabled() && column == 0) {
                    return JavaFrontbackBundle.message("listbox.import.static", new Object[0]);
                }
                return names[column -= panel.areStaticImportsEnabled() ? 1 : 0];
            }

            @Override
            public Class<?> getColumnClass(int col) {
                if ((col += panel.areStaticImportsEnabled() ? 0 : 1) == 0) {
                    return Boolean.class;
                }
                if (col == 1) {
                    return String.class;
                }
                if (col == 2) {
                    return Boolean.class;
                }
                throw new IllegalArgumentException(String.valueOf(col));
            }

            @Override
            public boolean isCellEditable(int row, int col) {
                PackageEntry packageEntry = packageTable.getEntryAt(row);
                return !packageEntry.isSpecial();
            }

            @Override
            public void setValueAt(Object aValue, int row, int col) {
                PackageEntry packageEntry = packageTable.getEntryAt(row);
                if ((col += panel.areStaticImportsEnabled() ? 0 : 1) == 0) {
                    PackageEntry newPackageEntry = new PackageEntry(((Boolean)aValue).booleanValue(), packageEntry.getPackageName(), packageEntry.isWithSubpackages());
                    packageTable.setEntryAt(newPackageEntry, row);
                } else if (col == 1) {
                    PackageEntry newPackageEntry = new PackageEntry(packageEntry.isStatic(), ((String)aValue).trim(), packageEntry.isWithSubpackages());
                    packageTable.setEntryAt(newPackageEntry, row);
                } else if (col == 2) {
                    PackageEntry newPackageEntry = new PackageEntry(packageEntry.isStatic(), packageEntry.getPackageName(), ((Boolean)aValue).booleanValue());
                    packageTable.setEntryAt(newPackageEntry, row);
                } else {
                    throw new IllegalArgumentException(String.valueOf(col));
                }
            }
        };
        final JBTable result = new JBTable((TableModel)dataModel);
        result.setShowGrid(false);
        result.getSelectionModel().setSelectionMode(0);
        ImportLayoutPanel.resizeColumns(packageTable, result, panel.areStaticImportsEnabled());
        TableCellEditor editor = result.getDefaultEditor(String.class);
        if (editor instanceof DefaultCellEditor) {
            ((DefaultCellEditor)editor).setClickCountToStart(1);
        }
        TableCellEditor beditor = result.getDefaultEditor(Boolean.class);
        beditor.addCellEditorListener(new CellEditorListener(){

            @Override
            public void editingStopped(ChangeEvent e) {
                if (panel.areStaticImportsEnabled()) {
                    result.repaint();
                }
            }

            @Override
            public void editingCanceled(ChangeEvent e) {
            }
        });
        return result;
    }

    public static void resizeColumns(final PackageEntryTable packageTable, JBTable result, boolean areStaticImportsEnabled) {
        ColoredTableCellRenderer packageRenderer = new ColoredTableCellRenderer(){

            protected void customizeCellRenderer(@NotNull JTable table, Object value, boolean selected, boolean hasFocus, int row, int column) {
                PackageEntry entry;
                if (table == null) {
                    3.$$$reportNull$$$0(0);
                }
                if ((entry = packageTable.getEntryAt(row)) == PackageEntry.BLANK_LINE_ENTRY) {
                    this.append(JavaFrontbackBundle.message("import.layout.panel.blank.line.entry", new Object[0]), SimpleTextAttributes.GRAYED_ATTRIBUTES);
                } else {
                    TextAttributes attributes = JavaHighlightingColors.KEYWORD.getDefaultAttributes();
                    this.append("import", SimpleTextAttributes.fromTextAttributes((TextAttributes)attributes));
                    if (entry.isStatic()) {
                        this.append(" ", SimpleTextAttributes.REGULAR_ATTRIBUTES);
                        this.append("static", SimpleTextAttributes.fromTextAttributes((TextAttributes)attributes));
                    }
                    this.append(" ", SimpleTextAttributes.REGULAR_ATTRIBUTES);
                    if (entry == PackageEntry.ALL_OTHER_IMPORTS_ENTRY || entry == PackageEntry.ALL_OTHER_STATIC_IMPORTS_ENTRY) {
                        this.append(JavaFrontbackBundle.message("import.layout.panel.all.other.imports", new Object[0]), SimpleTextAttributes.REGULAR_ATTRIBUTES);
                    } else if (entry == PackageEntry.ALL_MODULE_IMPORTS) {
                        this.append(JavaFrontbackBundle.message("import.layout.panel.module.imports", new Object[0]), SimpleTextAttributes.REGULAR_ATTRIBUTES);
                    } else {
                        this.append(entry.getPackageName() + ".*", SimpleTextAttributes.REGULAR_ATTRIBUTES);
                    }
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "table", "com/intellij/application/options/ImportLayoutPanel$3", "customizeCellRenderer"));
            }
        };
        if (areStaticImportsEnabled) {
            ImportLayoutPanel.fixColumnWidthToHeader(result, 0);
            ImportLayoutPanel.fixColumnWidthToHeader(result, 2);
            result.getColumnModel().getColumn(1).setCellRenderer((TableCellRenderer)packageRenderer);
            result.getColumnModel().getColumn(0).setCellRenderer((TableCellRenderer)new BooleanTableCellRenderer());
            result.getColumnModel().getColumn(2).setCellRenderer((TableCellRenderer)new BooleanTableCellRenderer());
        } else {
            ImportLayoutPanel.fixColumnWidthToHeader(result, 1);
            result.getColumnModel().getColumn(0).setCellRenderer((TableCellRenderer)packageRenderer);
            result.getColumnModel().getColumn(1).setCellRenderer((TableCellRenderer)new BooleanTableCellRenderer());
        }
    }

    private static void fixColumnWidthToHeader(JBTable result, int columnIdx) {
        TableColumn column = result.getColumnModel().getColumn(columnIdx);
        int width = 16 + result.getTableHeader().getFontMetrics(result.getTableHeader().getFont()).stringWidth(result.getColumnName(columnIdx));
        column.setMinWidth(width);
        column.setMaxWidth(width);
    }

    public static void refreshTableModel(int selectedRow, JBTable table) {
        AbstractTableModel model = (AbstractTableModel)table.getModel();
        model.fireTableRowsInserted(selectedRow, selectedRow);
        table.setRowSelectionInterval(selectedRow, selectedRow);
        TableUtil.editCellAt((JTable)table, (int)selectedRow, (int)0);
        Component editorComp = table.getEditorComponent();
        if (editorComp != null) {
            IdeFocusManager.getGlobalInstance().doWhenFocusSettlesDown(() -> IdeFocusManager.getGlobalInstance().requestFocus(editorComp, true));
        }
    }

    private class AddPackageAction
    extends DumbAwareAction {
        private AddPackageAction() {
            super(JavaFrontbackBundle.lazyMessage("button.add.package", new Object[0]), AllIcons.Nodes.Package);
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                AddPackageAction.$$$reportNull$$$0(0);
            }
            ImportLayoutPanel.this.addPackageToImportLayouts();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/application/options/ImportLayoutPanel$AddPackageAction", "actionPerformed"));
        }
    }

    private class AddBlankLineAction
    extends DumbAwareAction {
        private AddBlankLineAction() {
            super(JavaFrontbackBundle.lazyMessage("button.add.blank", new Object[0]), AllIcons.Actions.SearchNewLine);
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                AddBlankLineAction.$$$reportNull$$$0(0);
            }
            ImportLayoutPanel.this.addBlankLine();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/application/options/ImportLayoutPanel$AddBlankLineAction", "actionPerformed"));
        }
    }
}

