/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jpa.jpb.model.util;

import com.intellij.java.library.JavaLibraryUtil;
import com.intellij.jpa.jpb.model.core.es.ExternalSystemInfo;
import com.intellij.jpa.jpb.model.core.es.PluginInfo;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0002J\u000e\u0010\n\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007J\u000e\u0010\n\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\fJ\u000e\u0010\r\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007J\u000e\u0010\u000e\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007J\u000e\u0010\r\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\fJ\u000e\u0010\u000e\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\f\u00a8\u0006\u000f"}, d2={"Lcom/intellij/jpa/jpb/model/util/DiffHelper;", "", "<init>", "()V", "hasPlugin", "", "project", "Lcom/intellij/openapi/project/Project;", "pluginId", "", "isFlywaySupported", "module", "Lcom/intellij/openapi/module/Module;", "isLiquibaseSupported", "hasLiquibaseLibrary", "intellij.javaee.jpa.jpb.model"})
@SourceDebugExtension(value={"SMAP\nDiffHelper.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DiffHelper.kt\ncom/intellij/jpa/jpb/model/util/DiffHelper\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,42:1\n1761#2,3:43\n*S KotlinDebug\n*F\n+ 1 DiffHelper.kt\ncom/intellij/jpa/jpb/model/util/DiffHelper\n*L\n17#1:43,3\n*E\n"})
public final class DiffHelper {
    @NotNull
    public static final DiffHelper INSTANCE = new DiffHelper();

    private DiffHelper() {
    }

    private final boolean hasPlugin(Project project, String pluginId) {
        boolean bl;
        block3: {
            Iterable $this$any$iv = ExternalSystemInfo.Companion.getPlugins(project);
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    PluginInfo it = (PluginInfo)element$iv;
                    boolean bl2 = false;
                    if (!Intrinsics.areEqual((Object)it.getArtifact(), (Object)pluginId)) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    public final boolean isFlywaySupported(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        return JavaLibraryUtil.hasLibraryJar((Project)project, (String)"org.flywaydb:flyway-core") || this.hasPlugin(project, "flyway-maven-plugin");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean isFlywaySupported(@NotNull Module module) {
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        if (JavaLibraryUtil.hasLibraryJar((Module)module, (String)"org.flywaydb:flyway-core")) return true;
        Project project = module.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        if (!this.hasPlugin(project, "flyway-maven-plugin")) return false;
        return true;
    }

    public final boolean isLiquibaseSupported(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        return this.hasLiquibaseLibrary(project) || this.hasPlugin(project, "liquibase-maven-plugin");
    }

    public final boolean hasLiquibaseLibrary(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        return JavaLibraryUtil.hasLibraryJar((Project)project, (String)"org.liquibase:liquibase-core");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean isLiquibaseSupported(@NotNull Module module) {
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        if (this.hasLiquibaseLibrary(module)) return true;
        Project project = module.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        if (!this.hasPlugin(project, "liquibase-maven-plugin")) return false;
        return true;
    }

    public final boolean hasLiquibaseLibrary(@NotNull Module module) {
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        return JavaLibraryUtil.hasLibraryJar((Module)module, (String)"org.liquibase:liquibase-core");
    }
}

