/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jpa.jpb.model.ui.component;

import com.intellij.openapi.actionSystem.ActionToolbarPosition;
import com.intellij.ui.AnActionButton;
import com.intellij.ui.ListUtil;
import com.intellij.ui.ScrollingUtil;
import com.intellij.ui.SimpleListCellRenderer;
import com.intellij.ui.ToolbarDecorator;
import com.intellij.ui.components.JBList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.EditableModel;
import com.intellij.util.ui.ListItemEditor;
import com.intellij.util.ui.ListModelEditorBase;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class SListModelEditor<T>
extends ListModelEditorBase<T> {
    protected final ToolbarDecorator toolbarDecorator;
    private final JBList<T> list;

    public SListModelEditor(@NotNull ListItemEditor<T> itemEditor) {
        if (itemEditor == null) {
            SListModelEditor.$$$reportNull$$$0(0);
        }
        super(itemEditor);
        this.list = new JBList((ListModel)this.model);
        this.list.setSelectionMode(0);
        this.list.setCellRenderer((ListCellRenderer)SimpleListCellRenderer.create((label, value, index) -> {
            if (value == null) {
                return;
            }
            label.setIcon(this.getIcon(value));
            label.setText(itemEditor.getName(value));
        }));
        this.toolbarDecorator = ToolbarDecorator.createDecorator(this.list, (EditableModel)this.model).setAddAction(button -> {
            Object lastItem;
            if (!this.model.isEmpty() && ((ListItemEditor)this.itemEditor).isEmpty(lastItem = this.model.getElementAt(this.model.getSize() - 1))) {
                ScrollingUtil.selectItem(this.list, (int)ContainerUtil.indexOfIdentity((List)this.model.getItems(), (Object)lastItem));
                return;
            }
            this.addActionPerformed((AnActionButton)button);
        }).setRemoveActionUpdater(e -> this.areSelectedItemsRemovable(this.list.getSelectionModel())).setToolbarPosition(this.getActionToolbarPosition());
    }

    @Nullable
    protected Icon getIcon(T value) {
        return null;
    }

    protected ActionToolbarPosition getActionToolbarPosition() {
        return ActionToolbarPosition.RIGHT;
    }

    protected abstract void addActionPerformed(AnActionButton var1);

    public ToolbarDecorator getToolbarDecorator() {
        return this.toolbarDecorator;
    }

    @NotNull
    public SListModelEditor<T> disableUpDownActions() {
        this.toolbarDecorator.disableUpDownActions();
        SListModelEditor sListModelEditor = this;
        if (sListModelEditor == null) {
            SListModelEditor.$$$reportNull$$$0(1);
        }
        return sListModelEditor;
    }

    @NotNull
    public JComponent createComponent() {
        JPanel jPanel = this.toolbarDecorator.createPanel();
        if (jPanel == null) {
            SListModelEditor.$$$reportNull$$$0(2);
        }
        return jPanel;
    }

    @NotNull
    public JBList getList() {
        JBList<T> jBList = this.list;
        if (jBList == null) {
            SListModelEditor.$$$reportNull$$$0(3);
        }
        return jBList;
    }

    @Nullable
    public T getSelected() {
        return (T)this.list.getSelectedValue();
    }

    public void reset(@NotNull List<? extends T> items2) {
        if (items2 == null) {
            SListModelEditor.$$$reportNull$$$0(4);
        }
        super.reset(items2);
        SwingUtilities.invokeLater(() -> {
            if (!this.model.isEmpty()) {
                this.list.setSelectedIndex(0);
            }
        });
    }

    protected void removeEmptyItem(int i) {
        ListUtil.removeIndices((JList)this.getList(), (int[])new int[]{i});
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2, 3 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "itemEditor";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/jpa/jpb/model/ui/component/SListModelEditor";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "items";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/jpa/jpb/model/ui/component/SListModelEditor";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "disableUpDownActions";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "createComponent";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getList";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "reset";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2, 3 -> new IllegalStateException(string);
        };
    }
}

