/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.dialects.base;

import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.sql.dialects.SqlLanguageDialect;
import com.intellij.sql.formatter.SqlDialectCodeStyleProvider;
import com.intellij.sql.formatter.settings.SqlCodeStyleSettings;
import java.lang.reflect.Constructor;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0016\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\u00020\u0003B)\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00028\u00000\u0007\u0012\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0015\u0010\u0012\u001a\u00028\u00002\u0006\u0010\u0013\u001a\u00020\u0014H\u0016\u00a2\u0006\u0002\u0010\u0015R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u001a\u0010\u0006\u001a\b\u0012\u0004\u0012\u00028\u00000\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0016\u0010\b\u001a\u0004\u0018\u00010\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006\u0016"}, d2={"Lcom/intellij/sql/dialects/base/BaseSqlDialectCodeStyleProvider;", "S", "Lcom/intellij/sql/formatter/settings/SqlCodeStyleSettings;", "Lcom/intellij/sql/formatter/SqlDialectCodeStyleProvider;", "dialect", "Lcom/intellij/sql/dialects/SqlLanguageDialect;", "settingsClass", "Ljava/lang/Class;", "dialectDisplayName", "", "<init>", "(Lcom/intellij/sql/dialects/SqlLanguageDialect;Ljava/lang/Class;Ljava/lang/String;)V", "getDialect", "()Lcom/intellij/sql/dialects/SqlLanguageDialect;", "getSettingsClass", "()Ljava/lang/Class;", "getDialectDisplayName", "()Ljava/lang/String;", "createCustomSettings", "settingsContainer", "Lcom/intellij/psi/codeStyle/CodeStyleSettings;", "(Lcom/intellij/psi/codeStyle/CodeStyleSettings;)Lcom/intellij/sql/formatter/settings/SqlCodeStyleSettings;", "intellij.database.dialects.base"})
public class BaseSqlDialectCodeStyleProvider<S extends SqlCodeStyleSettings>
implements SqlDialectCodeStyleProvider {
    @NotNull
    private final SqlLanguageDialect dialect;
    @NotNull
    private final Class<S> settingsClass;
    @Nullable
    private final String dialectDisplayName;

    public BaseSqlDialectCodeStyleProvider(@NotNull SqlLanguageDialect dialect, @NotNull Class<S> settingsClass, @Nullable String dialectDisplayName) {
        Intrinsics.checkNotNullParameter((Object)dialect, (String)"dialect");
        Intrinsics.checkNotNullParameter(settingsClass, (String)"settingsClass");
        this.dialect = dialect;
        this.settingsClass = settingsClass;
        this.dialectDisplayName = dialectDisplayName;
    }

    public /* synthetic */ BaseSqlDialectCodeStyleProvider(SqlLanguageDialect sqlLanguageDialect, Class clazz, String string, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            string = null;
        }
        this(sqlLanguageDialect, clazz, string);
    }

    @NotNull
    public SqlLanguageDialect getDialect() {
        return this.dialect;
    }

    @NotNull
    public Class<S> getSettingsClass() {
        return this.settingsClass;
    }

    @Nullable
    public String getDialectDisplayName() {
        return this.dialectDisplayName;
    }

    @NotNull
    public S createCustomSettings(@NotNull CodeStyleSettings settingsContainer) {
        Intrinsics.checkNotNullParameter((Object)settingsContainer, (String)"settingsContainer");
        Constructor<?>[] constructorArray = this.getSettingsClass().getConstructors();
        Intrinsics.checkNotNullExpressionValue(constructorArray, (String)"getConstructors(...)");
        Constructor constructor = (Constructor)ArraysKt.firstOrNull((Object[])constructorArray);
        if (constructor == null) {
            throw new IllegalStateException("Class " + this.getSettingsClass().getCanonicalName() + " has no constructors");
        }
        Constructor constructor2 = constructor;
        Object[] objectArray = new Object[]{settingsContainer};
        Object t = constructor2.newInstance(objectArray);
        Intrinsics.checkNotNull(t, (String)"null cannot be cast to non-null type S of com.intellij.sql.dialects.base.BaseSqlDialectCodeStyleProvider");
        SqlCodeStyleSettings settingsInstance = (SqlCodeStyleSettings)t;
        return (S)settingsInstance;
    }
}

