/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.dom;

import com.intellij.codeInsight.daemon.impl.analysis.XmlHighlightVisitor;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.spring.model.values.PlaceholderUtils;
import com.intellij.util.xml.ConvertContext;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomReferenceInjector;
import com.intellij.util.xml.GenericAttributeValue;
import com.intellij.util.xml.GenericDomValue;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PlaceholderDomReferenceInjector
implements DomReferenceInjector {
    public static final ThreadLocal<Boolean> IS_COMPUTING = ThreadLocal.withInitial(() -> Boolean.FALSE);
    private static final Set<Pair<String, String>> SKIP_ATTRS = Set.of(new Pair((Object)"bean", (Object)"parent"), new Pair((Object)"bean", (Object)"factory-bean"), new Pair((Object)"import", (Object)"resource"), new Pair((Object)"component-scan", (Object)"base-package"));

    @Nullable
    @NlsSafe
    public String resolveString(@Nullable @NonNls String unresolvedText, @NotNull ConvertContext context) {
        DomElement domElement;
        if (context == null) {
            PlaceholderDomReferenceInjector.$$$reportNull$$$0(0);
        }
        if (unresolvedText == null) {
            return null;
        }
        Boolean isComputing = IS_COMPUTING.get();
        if (isComputing == Boolean.TRUE) {
            return unresolvedText;
        }
        if (!DumbService.isDumb((Project)context.getProject()) && (domElement = context.getInvocationElement()) instanceof GenericDomValue && !PlaceholderDomReferenceInjector.skipAttributes((GenericDomValue)domElement) && PlaceholderUtils.getInstance().containsDefaultPlaceholderDefinitions((GenericDomValue)domElement)) {
            return PlaceholderUtils.getInstance().resolvePlaceholders((GenericDomValue)domElement);
        }
        return unresolvedText;
    }

    private static boolean skipAttributes(GenericDomValue<?> domElement) {
        if (!(domElement instanceof GenericAttributeValue)) {
            return false;
        }
        String attributeName = domElement.getXmlElementName();
        NotNullLazyValue tagName = NotNullLazyValue.lazy(() -> domElement.getParent().getXmlElementName());
        for (Pair<String, String> pair : SKIP_ATTRS) {
            if (!((String)pair.second).equals(attributeName) || !((String)pair.first).equals(tagName.getValue())) continue;
            return true;
        }
        return false;
    }

    public PsiReference @NotNull [] inject(@Nullable String unresolvedText, @NotNull PsiElement element, @NotNull ConvertContext context) {
        DomElement domElement;
        if (element == null) {
            PlaceholderDomReferenceInjector.$$$reportNull$$$0(1);
        }
        if (context == null) {
            PlaceholderDomReferenceInjector.$$$reportNull$$$0(2);
        }
        if ((domElement = context.getInvocationElement()) instanceof GenericDomValue) {
            GenericDomValue genericDomValue = (GenericDomValue)domElement;
            if (PlaceholderUtils.getInstance().isPlaceholder(genericDomValue, genericDomValue.getRawText())) {
                XmlHighlightVisitor.setSkipValidation((PsiElement)element);
                PsiReference[] psiReferenceArray = PlaceholderUtils.getInstance().createPlaceholderPropertiesReferences((GenericDomValue)domElement);
                if (psiReferenceArray == null) {
                    PlaceholderDomReferenceInjector.$$$reportNull$$$0(3);
                }
                return psiReferenceArray;
            }
        }
        if (PsiReference.EMPTY_ARRAY == null) {
            PlaceholderDomReferenceInjector.$$$reportNull$$$0(4);
        }
        return PsiReference.EMPTY_ARRAY;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 4 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/spring/dom/PlaceholderDomReferenceInjector";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/spring/dom/PlaceholderDomReferenceInjector";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "inject";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "resolveString";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "inject";
                break;
            }
            case 3: 
            case 4: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 4 -> new IllegalStateException(string);
        };
    }
}

