/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.protobuf.lang.resolve;

import com.intellij.protobuf.lang.psi.PbSymbol;
import com.intellij.protobuf.lang.psi.util.PbPsiUtil;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.util.QualifiedName;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PbResolveResult
implements ResolveResult {
    private final PbSymbol symbol;
    private final QualifiedName name;
    private final ResultType resultType;
    private final boolean validResult;

    PbResolveResult(@NotNull PbSymbol element, QualifiedName name, ResultType resultType) {
        if (element == null) {
            PbResolveResult.$$$reportNull$$$0(0);
        }
        this(element, name, resultType, true);
    }

    PbResolveResult(@NotNull PbSymbol symbol, QualifiedName name, ResultType resultType, boolean validResult) {
        if (symbol == null) {
            PbResolveResult.$$$reportNull$$$0(1);
        }
        this.symbol = symbol;
        this.name = name;
        this.resultType = resultType;
        this.validResult = validResult;
    }

    public static PbResolveResult create(PbSymbol symbol) {
        ResultType type = PbPsiUtil.isPackageElement(symbol) ? ResultType.PACKAGE : ResultType.ELEMENT;
        return new PbResolveResult(symbol, symbol.getQualifiedName(), type);
    }

    public ResultType getResultType() {
        return this.resultType;
    }

    @Nullable
    public PbSymbol getElement() {
        return this.symbol;
    }

    @Nullable
    public QualifiedName getName() {
        return this.name;
    }

    public boolean isValidResult() {
        return this.validResult;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PbResolveResult other = (PbResolveResult)obj;
        return Objects.equals(this.symbol, other.symbol) && Objects.equals(this.name, other.name) && Objects.equals((Object)this.resultType, (Object)other.resultType) && Objects.equals(this.validResult, other.validResult);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.symbol, this.name, this.resultType, this.validResult});
    }

    public String toString() {
        return String.format("%s: element=%s; name=%s; resultType=%s; validResult=%s", new Object[]{this.getClass().getName(), this.symbol, this.name, this.resultType, this.validResult});
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "element";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "symbol";
                break;
            }
        }
        objectArray[1] = "com/intellij/protobuf/lang/resolve/PbResolveResult";
        objectArray[2] = "<init>";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static enum ResultType {
        PACKAGE,
        ELEMENT;

    }
}

