/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.protobuf.lang.psi;

import com.intellij.protobuf.lang.psi.PbIdentifierValue;
import com.intellij.protobuf.lang.psi.PbMessageBody;
import com.intellij.protobuf.lang.psi.PbNamedTypeElement;
import com.intellij.protobuf.lang.psi.PbReservedStatement;
import com.intellij.protobuf.lang.psi.PbStringValue;
import com.intellij.protobuf.lang.psi.PbSymbolOwner;
import com.intellij.protobuf.lang.psi.SyntaxLevel;
import com.intellij.protobuf.lang.psi.util.PbPsiUtil;

public interface PbMessageType
extends PbNamedTypeElement,
PbSymbolOwner {
    public PbMessageBody getBody();

    default public boolean isMessageSet() {
        PbMessageBody body = this.getBody();
        if (body == null) {
            return false;
        }
        return Boolean.TRUE.equals(PbPsiUtil.getBooleanDescriptorOption(body, "message_set_wire_format"));
    }

    default public boolean isReservedFieldName(String fieldName) {
        if (fieldName == null) {
            return false;
        }
        PbMessageBody body = this.getBody();
        if (body == null) {
            return false;
        }
        for (PbReservedStatement reservedStatement : body.getReservedStatementList()) {
            if (this.getPbFile().getSyntaxLevel() instanceof SyntaxLevel.Edition) {
                for (PbIdentifierValue pbIdentifierValue : reservedStatement.getIdentifierValueList()) {
                    if (!fieldName.equals(pbIdentifierValue.getAsString())) continue;
                    return true;
                }
                continue;
            }
            for (PbStringValue pbStringValue : reservedStatement.getStringValueList()) {
                if (!fieldName.equals(pbStringValue.getAsString())) continue;
                return true;
            }
        }
        return false;
    }
}

