/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugins.remotesdk.console;

import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.PlatformCoreDataKeys;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.ListPopup;
import com.intellij.openapi.ui.popup.ListPopupStep;
import com.intellij.openapi.ui.popup.PopupStep;
import com.intellij.openapi.ui.popup.util.BaseListPopupStep;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.remote.RemoteConnectionType;
import com.intellij.remote.RemoteConnector;
import com.intellij.remote.RemoteCredentials;
import com.intellij.serviceContainer.AlreadyDisposedException;
import com.intellij.ssh.config.unified.SshConfig;
import com.intellij.util.Consumer;
import com.intellij.util.concurrency.ThreadingAssertions;
import com.intellij.util.concurrency.annotations.RequiresEdt;
import com.jetbrains.plugins.remotesdk.RemoteSdkBundle;
import com.jetbrains.plugins.remotesdk.RemoteSdkUtil;
import com.jetbrains.plugins.remotesdk.SshConnectionProvider;
import com.jetbrains.plugins.remotesdk.console.NonSpecifiedRemoteConnector;
import com.jetbrains.plugins.remotesdk.console.RemoteConnectionUtil;
import com.jetbrains.plugins.remotesdk.console.SshConfigConnector;
import com.jetbrains.plugins.remotesdk.ui.RemoteCredentialsDialog;
import com.jetbrains.plugins.webDeployment.config.RemoteCredentialsVerifiableHolder;
import java.awt.Component;
import java.awt.MouseInfo;
import java.awt.event.KeyEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Supplier;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RemoteDataProducer {
    public static final Supplier<@NlsContexts.DialogTitle String> NO_HOST_TO_CONNECT_SUPPLIER = RemoteSdkBundle.messagePointer("dialog.title.no.host.to.connect", new Object[0]);
    private static final Logger LOG = Logger.getInstance(RemoteDataProducer.class);
    private Project myProject;
    private Module myModule;
    private AnActionEvent myActionEvent;
    private boolean myShowProjectLevelServers = false;
    private Component myComponentOwner;

    public RemoteDataProducer withComponentOwner(@NotNull Component componentOwner) {
        if (componentOwner == null) {
            RemoteDataProducer.$$$reportNull$$$0(0);
        }
        this.myComponentOwner = componentOwner;
        return this;
    }

    public RemoteDataProducer withProject(@NotNull Project project) {
        if (project == null) {
            RemoteDataProducer.$$$reportNull$$$0(1);
        }
        this.myProject = project;
        return this;
    }

    public RemoteDataProducer withModule(@Nullable Module module) {
        this.myModule = module;
        return this;
    }

    public RemoteDataProducer withShowProjectLevelServers(boolean show) {
        this.myShowProjectLevelServers = show;
        return this;
    }

    public RemoteDataProducer withActionEvent(@NotNull AnActionEvent event) {
        if (event == null) {
            RemoteDataProducer.$$$reportNull$$$0(2);
        }
        this.myActionEvent = event;
        this.myProject = (Project)event.getData(CommonDataKeys.PROJECT);
        this.myModule = (Module)event.getData(PlatformCoreDataKeys.MODULE);
        return this;
    }

    private Project getProjectForServersSearch() {
        return this.myShowProjectLevelServers ? this.myProject : null;
    }

    @Nullable
    public RemoteConnector getRemoteConnector(@Nullable RemoteConnectionType type, @Nullable String id, @Nullable String additionalData) {
        SshConfig config;
        if (type == RemoteConnectionType.SSH_CONFIG && (config = RemoteDataProducer.findSshConfigById(id, additionalData, this.getProjectForServersSearch())) != null) {
            return new SshConfigConnector(config);
        }
        if (type != null) {
            if (this.myProject == null) {
                LOG.warn("Project must not be null");
            } else {
                for (SshConnectionProvider provider : (SshConnectionProvider[])SshConnectionProvider.EP_NAME.getExtensions()) {
                    RemoteConnector connector = provider.getRemoteConnector(type, id, this.myProject, this.myModule);
                    if (connector == null) continue;
                    return connector;
                }
            }
        }
        return null;
    }

    @Nullable
    private static SshConfig findSshConfigById(@Nullable String id, @Nullable String additionalData, @Nullable Project project) {
        List<SshConfig> list = RemoteSdkUtil.getSshConfigList(project);
        if (additionalData != null) {
            for (SshConfig config : list) {
                if (!additionalData.equals(config.getId())) continue;
                return config;
            }
        }
        if (id != null) {
            for (SshConfig config : list) {
                if (!id.equals(config.getName())) continue;
                return config;
            }
        }
        return null;
    }

    public void produceRemoteData(@Nullable RemoteConnectionType type, @Nullable String id, @Nullable String additionalData, @NotNull java.util.function.Consumer<? super RemoteCredentials> consumer) {
        if (consumer == null) {
            RemoteDataProducer.$$$reportNull$$$0(3);
        }
        this.selectRemoteConnector(type, id, additionalData, connector -> RemoteDataProducer.produceRemoteCredentials(this.myProject, connector, consumer));
    }

    void selectRemoteConnector(@Nullable RemoteConnectionType type, @Nullable String id, @Nullable String additionalData, @NotNull java.util.function.Consumer<? super RemoteConnector> consumer) {
        RemoteConnector connector;
        if (consumer == null) {
            RemoteDataProducer.$$$reportNull$$$0(4);
        }
        if ((connector = this.getRemoteConnector(type, id, additionalData)) != null) {
            consumer.accept((RemoteConnector)connector);
        } else {
            ApplicationManager.getApplication().invokeLater(() -> this.selectConnectorInPopup(consumer), this.myProject.getDisposed());
        }
    }

    @RequiresEdt
    private void selectConnectorInPopup(@NotNull java.util.function.Consumer<? super RemoteConnector> consumer) {
        if (consumer == null) {
            RemoteDataProducer.$$$reportNull$$$0(5);
        }
        ThreadingAssertions.assertEventDispatchThread();
        List<RemoteConnector> connectors = RemoteConnectionUtil.getSortedUniqueRemoteConnectors(this.getProjectForServersSearch());
        if (connectors.isEmpty()) {
            Messages.showWarningDialog((Project)this.myProject, (String)RemoteDataProducer.getEmptyConnectorsMessage(), (String)NO_HOST_TO_CONNECT_SUPPLIER.get());
        } else if (connectors.size() == 1) {
            consumer.accept((RemoteConnector)connectors.get(0));
        } else {
            this.chooseConnector(connectors, consumer);
        }
    }

    @NlsContexts.DialogMessage
    @NotNull
    private static String getEmptyConnectorsMessage() {
        ArrayList<String> allMessages = new ArrayList<String>();
        allMessages.add(RemoteSdkBundle.message("settings.specify.sftp.server.in.deployment", new Object[0]));
        SshConnectionProvider.EP_NAME.getExtensionList().stream().map(SshConnectionProvider::getSettingCreationDescription).filter(d -> d != null).forEach(d -> allMessages.add((String)d));
        String string = StringUtil.join(allMessages, (String)", ");
        if (string == null) {
            RemoteDataProducer.$$$reportNull$$$0(6);
        }
        return string;
    }

    private void chooseConnector(@NotNull List<RemoteConnector> connectors, final @NotNull java.util.function.Consumer<? super RemoteConnector> consumer) {
        if (connectors == null) {
            RemoteDataProducer.$$$reportNull$$$0(7);
        }
        if (consumer == null) {
            RemoteDataProducer.$$$reportNull$$$0(8);
        }
        BaseListPopupStep<RemoteConnector> sdkHomesStep = new BaseListPopupStep<RemoteConnector>(this, RemoteSdkBundle.message("popup.title.select.host.to.connect", new Object[0]), connectors){

            @NlsContexts.ListItem
            @NotNull
            public String getTextFor(RemoteConnector value) {
                if (value.getType() == RemoteConnectionType.NONE) {
                    String string = RemoteSdkBundle.message("list.item.edit.credentials", new Object[0]);
                    if (string == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    return string;
                }
                String string = value.getName();
                if (string == null) {
                    1.$$$reportNull$$$0(1);
                }
                return string;
            }

            public PopupStep<?> onChosen(RemoteConnector selected, boolean finalChoice) {
                ApplicationManager.getApplication().invokeLater(() -> consumer.accept(Objects.requireNonNull(selected)));
                return FINAL_CHOICE;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/plugins/remotesdk/console/RemoteDataProducer$1", "getTextFor"));
            }
        };
        ListPopup popup = JBPopupFactory.getInstance().createListPopup((ListPopupStep)sdkHomesStep);
        if (this.myComponentOwner != null) {
            popup.showInCenterOf(this.myComponentOwner);
        } else if (this.myProject != null) {
            if (this.myActionEvent != null && this.myActionEvent.getInputEvent() instanceof KeyEvent) {
                popup.showInFocusCenter();
            } else {
                popup.showInScreenCoordinates((Component)WindowManager.getInstance().getIdeFrame(this.myProject).getComponent(), MouseInfo.getPointerInfo().getLocation());
            }
        } else {
            popup.showInFocusCenter();
        }
    }

    static void produceRemoteCredentials(@NotNull Project project, @NotNull RemoteConnector connector, @NotNull java.util.function.Consumer<? super RemoteCredentials> consumer) {
        if (project == null) {
            RemoteDataProducer.$$$reportNull$$$0(9);
        }
        if (connector == null) {
            RemoteDataProducer.$$$reportNull$$$0(10);
        }
        if (consumer == null) {
            RemoteDataProducer.$$$reportNull$$$0(11);
        }
        if (connector == NonSpecifiedRemoteConnector.INSTANCE) {
            ApplicationManager.getApplication().invokeLater(() -> RemoteDataProducer.showDialogAskingCredentials(project, consumer), project.getDisposed());
        } else {
            ApplicationManager.getApplication().executeOnPooledThread(() -> {
                try {
                    connector.produceRemoteCredentials(credentials -> ApplicationManager.getApplication().invokeLater(() -> consumer.accept((RemoteCredentials)credentials), project.getDisposed()));
                }
                catch (AlreadyDisposedException alreadyDisposedException) {
                    // empty catch block
                }
            });
        }
    }

    @RequiresEdt
    public static void showDialogAskingCredentials(@Nullable Project project, final @NotNull java.util.function.Consumer<? super RemoteCredentials> credentialsConsumer) {
        if (credentialsConsumer == null) {
            RemoteDataProducer.$$$reportNull$$$0(12);
        }
        ThreadingAssertions.assertEventDispatchThread();
        RemoteCredentialsDialog dialog = new RemoteCredentialsDialog(project){

            protected void doOKAction() {
                super.doOKAction();
                RemoteCredentialsVerifiableHolder credentials = this.createCredentials();
                ApplicationManager.getApplication().invokeLater(() -> 2.lambda$doOKAction$0(credentialsConsumer, (RemoteCredentials)credentials));
            }

            public void doCancelAction() {
                super.doCancelAction();
                ApplicationManager.getApplication().invokeLater(() -> credentialsConsumer.accept(null));
            }

            private static /* synthetic */ void lambda$doOKAction$0(java.util.function.Consumer credentialsConsumer2, RemoteCredentials credentials) {
                credentialsConsumer2.accept(credentials);
            }
        };
        dialog.show();
    }

    @Deprecated(forRemoval=true)
    public static void showAskCredentialsDialog(@Nullable Project project, @NotNull Consumer<? super RemoteCredentials> credentialsConsumer) {
        if (credentialsConsumer == null) {
            RemoteDataProducer.$$$reportNull$$$0(13);
        }
        RemoteDataProducer.showDialogAskingCredentials(project, arg_0 -> credentialsConsumer.consume(arg_0));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 6 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "componentOwner";
                break;
            }
            case 1: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 8: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/plugins/remotesdk/console/RemoteDataProducer";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "connectors";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "connector";
                break;
            }
            case 12: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "credentialsConsumer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/plugins/remotesdk/console/RemoteDataProducer";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getEmptyConnectorsMessage";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "withComponentOwner";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "withProject";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "withActionEvent";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "produceRemoteData";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "selectRemoteConnector";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "selectConnectorInPopup";
                break;
            }
            case 6: {
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "chooseConnector";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "produceRemoteCredentials";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "showDialogAskingCredentials";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "showAskCredentialsDialog";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 6 -> new IllegalStateException(string);
        };
    }
}

