/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.model;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.util.Comparing;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.spring.model.QualifierAttribute;
import com.intellij.spring.model.SpringInheritableQualifier;
import com.intellij.spring.model.SpringQualifier;
import com.intellij.spring.model.aliasFor.SpringAliasForUtils;
import com.intellij.spring.model.jam.qualifiers.SpringJamQualifier;
import com.intellij.spring.model.jam.utils.JamAnnotationTypeUtil;
import com.intellij.util.containers.CollectionFactory;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.jetbrains.annotations.Nullable;

public final class SpringQualifierComparator {
    public static boolean compareQualifiers(@Nullable SpringQualifier one, @Nullable SpringQualifier two) {
        List<? extends QualifierAttribute> list2;
        int size2;
        if (one == null || two == null) {
            return false;
        }
        if (!Comparing.equal((Object)one.getQualifierType(), (Object)two.getQualifierType())) {
            return false;
        }
        if (!Objects.equals(one.getQualifierValue(), two.getQualifierValue())) {
            return false;
        }
        List<? extends QualifierAttribute> list1 = one.getQualifierAttributes();
        int size1 = list1.size();
        if (size1 != (size2 = (list2 = two.getQualifierAttributes()).size())) {
            return false;
        }
        if (size1 == 0) {
            return true;
        }
        Set set = CollectionFactory.createCustomHashingStrategySet(QualifierAttribute.HASHING_STRATEGY);
        set.addAll(list1);
        return set.containsAll(list2);
    }

    public static boolean compareInheritorQualifier(@Nullable SpringQualifier childrenQualifier, @Nullable SpringQualifier baseQualifier, @Nullable Module module) {
        if (childrenQualifier instanceof SpringInheritableQualifier && baseQualifier instanceof SpringInheritableQualifier) {
            Collection<PsiClass> children;
            PsiAnnotation definingMetaAnnotation;
            String baseAnnoQualifiedName;
            if (Comparing.equal((Object)childrenQualifier.getQualifierType(), (Object)baseQualifier.getQualifierType())) {
                return false;
            }
            if (module == null) {
                return false;
            }
            PsiClass baseType = baseQualifier.getQualifierType();
            PsiClass childrenType = childrenQualifier.getQualifierType();
            if (baseType != null && childrenType != null && (baseAnnoQualifiedName = baseType.getQualifiedName()) != null && (definingMetaAnnotation = SpringAliasForUtils.findDefiningMetaAnnotation(childrenType, baseAnnoQualifiedName, children = JamAnnotationTypeUtil.getInstance(module.getProject()).getAnnotationTypesWithChildren(baseAnnoQualifiedName, module))) != null) {
                return SpringQualifierComparator.compareQualifiers(new SpringJamQualifier(definingMetaAnnotation, null), baseQualifier);
            }
        }
        return false;
    }
}

