/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.remote.jdbc.helpers;

import com.intellij.database.remote.jdba.jdbc.JdbcConnectionProvider;
import com.intellij.database.remote.jdba.jdbc.JdbcIntermediateFacade;
import com.intellij.database.remote.jdba.jdbc.dialects.MysqlExceptionRecognizer;
import com.intellij.database.remote.jdba.jdbc.dialects.MysqlIntermediateFacade;
import com.intellij.database.remote.jdbc.ColumnInfo;
import com.intellij.database.remote.jdbc.RemoteCloseable;
import com.intellij.database.remote.jdbc.RemotePreparedStatement;
import com.intellij.database.remote.jdbc.RemoteResultSet;
import com.intellij.database.remote.jdbc.helpers.GBaseJdbcHelper;
import com.intellij.database.remote.jdbc.helpers.JdbcHelper;
import com.intellij.database.remote.jdbc.helpers.JdbcHelperImpl;
import com.intellij.database.remote.jdbc.helpers.JdbcNativeUtil;
import com.intellij.database.remote.jdbc.helpers.JdbcSettings;
import com.intellij.database.remote.jdbc.helpers.MariaJdbcHelper;
import com.intellij.database.remote.jdbc.helpers.MemJdbcHelper;
import com.intellij.database.remote.jdbc.helpers.MysqlJdbcHelper;
import com.intellij.database.remote.jdbc.helpers.RemoteLogHelper;
import com.intellij.database.remote.jdbc.impl.BitString;
import com.intellij.database.remote.jdbc.impl.UnparsedValueKind;
import com.intellij.openapi.util.Couple;
import com.intellij.openapi.util.text.StringUtilRt;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.Driver;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class MysqlBaseJdbcHelper
extends JdbcHelperImpl {
    public static final String AURORA = "MYSQL AURORA";
    public static final String MYSQL = "MYSQL";
    public static final String MARIADB = "MARIADB";
    public static final String MEMSQL = "MEMSQL";
    public static final String VITESS = "VITESS";
    public static final String TIDB = "TiDB";
    public static final String OCEANBASE = "OceanBase";
    private static final String MYSQL_DRIVER_NAME = "MySQL Connector/J";
    private static final String MARIADB_DRIVER_NAME = "MariaDB Connector/J";
    protected final boolean mySupportsDatesAsStrings;
    protected final boolean myIsMySQLDriver;
    private static final List<JdbcHelperImpl.PropertyReplacement> REPLACEMENTS = Collections.singletonList(new JdbcHelperImpl.PropertyReplacement("zeroDateTimeBehavior", Collections.singletonList(Couple.of((Object)"convertToNull", (Object)"CONVERT_TO_NULL"))){

        @Override
        @NotNull
        JdbcHelperImpl.PropertyReplacement.Direction getDirection(@NotNull Driver driver) {
            int version;
            if (driver == null) {
                1.$$$reportNull$$$0(0);
            }
            JdbcHelperImpl.PropertyReplacement.Direction direction = (version = driver.getMajorVersion()) >= 8 ? JdbcHelperImpl.PropertyReplacement.Direction.FORWARD : JdbcHelperImpl.PropertyReplacement.Direction.BACKWARD;
            if (direction == null) {
                1.$$$reportNull$$$0(1);
            }
            return direction;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "driver";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/remote/jdbc/helpers/MysqlBaseJdbcHelper$1";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/remote/jdbc/helpers/MysqlBaseJdbcHelper$1";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getDirection";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "getDirection";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    });
    protected static final Pattern TIDB_VERSION_PATTERN = Pattern.compile("TiDB-v(\\d+(?:\\.\\d+)+)");
    protected static final Pattern OB_VERSION_PATTERN = Pattern.compile("OceanBase.*-v(\\d+(?:\\.\\d+)+)");

    public MysqlBaseJdbcHelper(@NotNull String dbmsName, @Nullable String version, @Nullable Connection connection, @Nullable ClassLoader jdbcClassLoader) {
        if (dbmsName == null) {
            MysqlBaseJdbcHelper.$$$reportNull$$$0(0);
        }
        super(dbmsName, version, connection, jdbcClassLoader);
        this.mySupportsDatesAsStrings = MysqlBaseJdbcHelper.isSupportsDatesAsStrings(connection);
        this.myIsMySQLDriver = MysqlBaseJdbcHelper.isMySQLDriver(connection);
    }

    protected MysqlBaseJdbcHelper(@NotNull MysqlBaseJdbcHelper helper, @NotNull ClassLoader jdbcCLassLoader) {
        if (helper == null) {
            MysqlBaseJdbcHelper.$$$reportNull$$$0(1);
        }
        if (jdbcCLassLoader == null) {
            MysqlBaseJdbcHelper.$$$reportNull$$$0(2);
        }
        super(helper, jdbcCLassLoader);
        this.mySupportsDatesAsStrings = helper.mySupportsDatesAsStrings;
        this.myIsMySQLDriver = helper.myIsMySQLDriver;
    }

    @Override
    @NotNull
    public JdbcIntermediateFacade createFacade(@NotNull JdbcConnectionProvider ds) {
        if (ds == null) {
            MysqlBaseJdbcHelper.$$$reportNull$$$0(3);
        }
        return new MysqlIntermediateFacade(ds, MysqlExceptionRecognizer.INSTANCE, this);
    }

    @Override
    @Nullable
    public RemoteCloseable setStatementParameter(@NotNull RemotePreparedStatement statement, @Nullable Object value, @NotNull ColumnInfo columnInfo, boolean needsEscaping, int idx) throws Exception {
        if (statement == null) {
            MysqlBaseJdbcHelper.$$$reportNull$$$0(4);
        }
        if (columnInfo == null) {
            MysqlBaseJdbcHelper.$$$reportNull$$$0(5);
        }
        String typeName = columnInfo.getTypeName();
        if (value instanceof String && "bit".equalsIgnoreCase(typeName)) {
            MysqlBaseJdbcHelper.setBits(statement, (String)value, idx);
            return null;
        }
        return super.setStatementParameter(statement, value, columnInfo, needsEscaping, idx);
    }

    private boolean isPossiblyIncorrectTime(int type) {
        return this.mySupportsDatesAsStrings && (this.myIsMySQLDriver && type == 92 || type == 91 || type == 93);
    }

    @Override
    @Nullable
    public UnparsedValueKind detectUnparsedValueKind(@Nullable String typeName, int jdbcType) {
        if (this.isPossiblyIncorrectTime(jdbcType)) {
            switch (jdbcType) {
                case 91: {
                    return UnparsedValueKind.DATE;
                }
                case 92: {
                    return UnparsedValueKind.TIME;
                }
                case 93: {
                    return UnparsedValueKind.TIMESTAMP;
                }
            }
        }
        return super.detectUnparsedValueKind(typeName, jdbcType);
    }

    private static boolean isSupportsDatesAsStrings(@Nullable Connection connection) {
        if (connection == null) {
            return false;
        }
        try {
            DatabaseMetaData metaData = connection.getMetaData();
            int version = metaData.getDriverMajorVersion();
            int minorVersion = metaData.getDriverMinorVersion();
            String driverName = metaData.getDriverName();
            return MYSQL_DRIVER_NAME.equals(driverName) && version >= 8 || MARIADB_DRIVER_NAME.equals(driverName) && (version > 2 || version == 2 && minorVersion >= 4);
        }
        catch (Throwable throwable) {
            return false;
        }
    }

    private static boolean isMySQLDriver(@Nullable Connection connection) {
        if (connection == null) {
            return false;
        }
        try {
            DatabaseMetaData metaData = connection.getMetaData();
            String driverName = metaData.getDriverName();
            return MYSQL_DRIVER_NAME.equals(driverName);
        }
        catch (Throwable throwable) {
            return false;
        }
    }

    private static void setBits(@NotNull RemotePreparedStatement statement, @NotNull String value, int idx) throws Exception {
        if (statement == null) {
            MysqlBaseJdbcHelper.$$$reportNull$$$0(6);
        }
        if (value == null) {
            MysqlBaseJdbcHelper.$$$reportNull$$$0(7);
        }
        int length = value.length();
        int size = length / 8 + (length % 8 > 0 ? 1 : 0);
        byte[] bytes = new byte[size];
        for (int i = 0; i < size; ++i) {
            int start = Math.max(length - (i + 1) * 8, 0);
            int end = length - i * 8;
            String substring = value.substring(start, end);
            bytes[size - i - 1] = (byte)Short.parseShort(substring, 2);
        }
        statement.setBytes(idx, bytes);
    }

    @Override
    @NotNull
    protected String getCharsToEscape() {
        return "%_\\#";
    }

    @Override
    public String getColumnTypeName(@NotNull ResultSetMetaData delegate, int idx) throws SQLException {
        String typeName;
        if (delegate == null) {
            MysqlBaseJdbcHelper.$$$reportNull$$$0(8);
        }
        if ("INTEGER".equalsIgnoreCase(typeName = super.getColumnTypeName(delegate, idx))) {
            return typeName.substring(0, 3);
        }
        if ("BIT".equals(typeName)) {
            int type = delegate.getColumnType(idx);
            String clazz = delegate.getColumnClassName(idx);
            if (type == -7 && "java.lang.Integer".equals(clazz)) {
                return "TINYINT";
            }
        }
        return typeName;
    }

    @Override
    public int fixJdbcType(@Nullable String typeName, @Nullable String clazz, int type) {
        if (type == 91 && "YEAR".equals(typeName) && Short.class.getCanonicalName().equals(clazz)) {
            return 5;
        }
        if (type == -7 && "java.lang.Integer".equals(clazz)) {
            return -6;
        }
        return super.fixJdbcType(typeName, clazz, type);
    }

    @Override
    @Nullable
    protected Object tryGetObject(@NotNull RemoteResultSet.DataRetrievingOptions options, @NotNull ResultSet resultSet, @NotNull ResultSetMetaData metaData, int index) throws SQLException {
        int precision;
        String typeName;
        if (options == null) {
            MysqlBaseJdbcHelper.$$$reportNull$$$0(9);
        }
        if (resultSet == null) {
            MysqlBaseJdbcHelper.$$$reportNull$$$0(10);
        }
        if (metaData == null) {
            MysqlBaseJdbcHelper.$$$reportNull$$$0(11);
        }
        if ("bit".equalsIgnoreCase(typeName = metaData.getColumnTypeName(index)) && !options.raw && (precision = metaData.getPrecision(index)) > 1) {
            byte[] bytes = resultSet.getBytes(index);
            return BitString.of(bytes);
        }
        return super.tryGetObject(options, resultSet, metaData, index);
    }

    @Override
    public void adjustType(@NotNull JdbcHelper.Type e) {
        if (e == null) {
            MysqlBaseJdbcHelper.$$$reportNull$$$0(12);
        }
        if (e.typeName == null) {
            return;
        }
        String us = " unsigned";
        if (StringUtilRt.endsWithIgnoreCase((CharSequence)e.typeName, (CharSequence)us)) {
            int end = e.typeName.length() - us.length();
            e.typeSuffix = e.typeName.substring(end + 1);
            e.typeName = e.typeName.substring(0, end);
        }
    }

    @Override
    @Nullable
    public JdbcHelperImpl detect(@Nullable Connection delegate, @Nullable String product, @Nullable String productVer, @Nullable JdbcHelperImpl connectHelper, @Nullable ClassLoader jdbcClassLoader) throws Exception {
        String[] stringArray;
        if (!JdbcNativeUtil.detectString(product, MYSQL) && !JdbcNativeUtil.detectString(product, MARIADB)) {
            return null;
        }
        if (delegate == null) {
            String[] stringArray2 = new String[3];
            stringArray2[0] = productVer;
            stringArray2[1] = productVer;
            stringArray = stringArray2;
            stringArray2[2] = null;
        } else {
            stringArray = JdbcNativeUtil.getStrings(delegate, "select version(), @@version_comment, database()");
        }
        String[] v = stringArray;
        String ver = v.length < 1 ? null : v[0];
        String verComment = v.length < 2 ? null : v[1];
        String db = v.length < 3 ? null : v[2];
        JdbcNativeUtil.logInfo("@@version_comment: " + verComment + "\nversion(): " + ver + "\ndatabase(): " + db);
        try {
            String auroraVersion;
            if (verComment == null && "gitbase".equals(db) && GBaseJdbcHelper.extractVersion(ver) != null) {
                return GBaseJdbcHelper.create(delegate, ver, jdbcClassLoader);
            }
            if (StringUtilRt.isEmpty((CharSequence)verComment)) {
                verComment = ver;
            }
            if (JdbcNativeUtil.detectString(verComment, MEMSQL) || JdbcNativeUtil.detectString(verComment, "singlestore")) {
                return MemJdbcHelper.create(delegate, delegate == null ? ver : JdbcNativeUtil.getString(delegate, "select @@memsql_version"), jdbcClassLoader);
            }
            if (JdbcNativeUtil.detectString(ver, MARIADB) || JdbcNativeUtil.detectString(verComment, MARIADB)) {
                return MariaJdbcHelper.create(delegate, ver, jdbcClassLoader);
            }
            if (JdbcNativeUtil.detectString(productVer, VITESS)) {
                return MysqlBaseJdbcHelper.createVitess(delegate, verComment, jdbcClassLoader);
            }
            if (JdbcNativeUtil.detectString(ver, TIDB) || JdbcNativeUtil.detectString(verComment, TIDB)) {
                return MysqlBaseJdbcHelper.createTi(delegate, ver, jdbcClassLoader);
            }
            if (JdbcNativeUtil.detectString(ver, OCEANBASE) || JdbcNativeUtil.detectString(verComment, OCEANBASE)) {
                return MysqlBaseJdbcHelper.createOB(delegate, ver, jdbcClassLoader);
            }
            String string = auroraVersion = delegate == null ? null : JdbcNativeUtil.getString(delegate, "show variables like 'aurora\\_version'", 2);
            if (auroraVersion != null) {
                JdbcNativeUtil.logInfo("aurora_version: " + auroraVersion);
                String version = MysqlJdbcHelper.extractVersion(auroraVersion);
                return connectHelper instanceof MariaJdbcHelper ? new MariaJdbcHelper(AURORA, version, delegate, jdbcClassLoader) : new MysqlJdbcHelper(AURORA, version, delegate, jdbcClassLoader);
            }
        }
        catch (SQLException ex) {
            JdbcNativeUtil.logWarn("mysql, but further detection failed", ex);
        }
        return MysqlJdbcHelper.create(delegate, ver, jdbcClassLoader);
    }

    @Override
    protected void enableSsl(@NotNull Driver driver, @NotNull Properties properties, @NotNull JdbcSettings.SslMode sslMode) {
        if (driver == null) {
            MysqlBaseJdbcHelper.$$$reportNull$$$0(13);
        }
        if (properties == null) {
            MysqlBaseJdbcHelper.$$$reportNull$$$0(14);
        }
        if (sslMode == null) {
            MysqlBaseJdbcHelper.$$$reportNull$$$0(15);
        }
        MysqlBaseJdbcHelper.setIfEmpty(properties, "useSSL", "true");
        MysqlBaseJdbcHelper.setIfEmpty(properties, "requireSSL", "true");
        if (sslMode != JdbcSettings.SslMode.REQUIRE) {
            MysqlBaseJdbcHelper.setIfEmpty(properties, "verifyServerCertificate", "true");
        }
        MysqlBaseJdbcHelper.setIfEmpty(properties, "sslMode", MysqlBaseJdbcHelper.getSslMode(sslMode));
    }

    @Override
    @NotNull
    public JdbcHelper.Case getCaseMode(boolean sensitive, boolean forceLower, boolean forceUpper, boolean asIs) {
        JdbcHelper.Case mode = super.getCaseMode(sensitive, forceLower, forceUpper, asIs);
        JdbcHelper.Case case_ = mode == JdbcHelper.Case.UPPER ? JdbcHelper.Case.MIXED : mode;
        if (case_ == null) {
            MysqlBaseJdbcHelper.$$$reportNull$$$0(16);
        }
        return case_;
    }

    @Override
    public JdbcSettings.SslMode[] supportedSslModes() {
        return JdbcSettings.SslMode.values();
    }

    @NotNull
    private static String getSslMode(@NotNull JdbcSettings.SslMode sslMode) {
        if (sslMode == null) {
            MysqlBaseJdbcHelper.$$$reportNull$$$0(17);
        }
        switch (sslMode) {
            case VERIFY_FULL: {
                return "VERIFY_IDENTITY";
            }
            case REQUIRE: {
                return "REQUIRED";
            }
        }
        return "VERIFY_CA";
    }

    @Override
    public boolean canChangePassword(@NotNull Driver driver, String url, @NotNull Properties properties) {
        if (driver == null) {
            MysqlBaseJdbcHelper.$$$reportNull$$$0(18);
        }
        if (properties == null) {
            MysqlBaseJdbcHelper.$$$reportNull$$$0(19);
        }
        return true;
    }

    @Override
    public void setFetchSize(Statement stmt, int fetchSize) throws SQLException {
        stmt.setFetchSize(MysqlBaseJdbcHelper.activateStreaming(fetchSize));
    }

    private static int activateStreaming(int fetchSize) {
        return fetchSize > 0 ? Integer.MIN_VALUE : fetchSize;
    }

    @Override
    @Nullable
    public final Connection connect(@NotNull Driver driver, String url, @NotNull Properties properties, @NotNull Map<String, Serializable> extra) throws SQLException {
        if (driver == null) {
            MysqlBaseJdbcHelper.$$$reportNull$$$0(20);
        }
        if (properties == null) {
            MysqlBaseJdbcHelper.$$$reportNull$$$0(21);
        }
        if (extra == null) {
            MysqlBaseJdbcHelper.$$$reportNull$$$0(22);
        }
        return super.connect(driver, url, MysqlBaseJdbcHelper.replaceInvalidProperties(driver, properties, REPLACEMENTS), extra);
    }

    @Override
    protected void setDriverLogLevel(Driver driver, Properties properties, Level level, String logPath) {
        MysqlBaseJdbcHelper.setIfEmpty(properties, "logger", "Jdk14Logger");
        if (level != null) {
            RemoteLogHelper.setLogLevel("MySQL", level);
            if (Level.FINEST.intValue() >= level.intValue()) {
                MysqlBaseJdbcHelper.setIfEmpty(properties, "traceProtocol", "true");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void changeExpiredPassword(@NotNull Driver driver, String url, @NotNull Properties properties, @NotNull Map<String, Serializable> extra, @NotNull String newPassword) throws SQLException {
        if (driver == null) {
            MysqlBaseJdbcHelper.$$$reportNull$$$0(23);
        }
        if (properties == null) {
            MysqlBaseJdbcHelper.$$$reportNull$$$0(24);
        }
        if (extra == null) {
            MysqlBaseJdbcHelper.$$$reportNull$$$0(25);
        }
        if (newPassword == null) {
            MysqlBaseJdbcHelper.$$$reportNull$$$0(26);
        }
        MysqlBaseJdbcHelper.setIfEmpty(properties, "disconnectOnExpiredPasswords", "false");
        MysqlBaseJdbcHelper.setIfEmpty(properties, "jdbcCompliantTruncation", "false");
        MysqlBaseJdbcHelper.setIfEmpty(properties, "useLocalSessionState", "true");
        Connection c = this.connect(driver, url, properties, extra);
        if (c == null) {
            throw new AssertionError((Object)"Null connection");
        }
        try {
            JdbcNativeUtil.prepared(c, "alter user user() identified by ?", statement -> {
                statement.setString(1, newPassword);
                statement.execute();
            });
        }
        finally {
            MysqlBaseJdbcHelper.closeSafe(c);
        }
    }

    @NotNull
    protected static MysqlJdbcHelper createTi(@Nullable Connection delegate, @Nullable String versionStr, @Nullable ClassLoader jdbcClassLoader) {
        String version = MysqlBaseJdbcHelper.extractTiVersion(versionStr);
        return new MysqlJdbcHelper(TIDB, version, delegate, jdbcClassLoader);
    }

    @NotNull
    protected static MysqlJdbcHelper createOB(@Nullable Connection delegate, @Nullable String versionStr, @Nullable ClassLoader jdbcClassLoader) {
        String version = MysqlBaseJdbcHelper.extractOBVersion(versionStr);
        return new MysqlJdbcHelper(OCEANBASE, version, delegate, jdbcClassLoader);
    }

    @NotNull
    protected static MysqlJdbcHelper createVitess(@Nullable Connection delegate, @Nullable String versionStr, @Nullable ClassLoader jdbcClassLoader) {
        String version = MysqlJdbcHelper.extractVersion(versionStr);
        return new MysqlJdbcHelper(VITESS, version, delegate, jdbcClassLoader);
    }

    @Nullable
    public static String extractTiVersion(@Nullable String str) {
        return JdbcNativeUtil.findVersion(str, TIDB_VERSION_PATTERN);
    }

    @Nullable
    public static String extractOBVersion(@Nullable String str) {
        return JdbcNativeUtil.findVersion(str, OB_VERSION_PATTERN);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 16: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 16: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dbmsName";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "helper";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jdbcCLassLoader";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ds";
                break;
            }
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "statement";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "columnInfo";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "delegate";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "options";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resultSet";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "metaData";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 13: 
            case 18: 
            case 20: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "driver";
                break;
            }
            case 14: 
            case 19: 
            case 21: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "properties";
                break;
            }
            case 15: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sslMode";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/remote/jdbc/helpers/MysqlBaseJdbcHelper";
                break;
            }
            case 22: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "extra";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newPassword";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/remote/jdbc/helpers/MysqlBaseJdbcHelper";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getCaseMode";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "createFacade";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "setStatementParameter";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "setBits";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getColumnTypeName";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "tryGetObject";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "adjustType";
                break;
            }
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "enableSsl";
                break;
            }
            case 16: {
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getSslMode";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "canChangePassword";
                break;
            }
            case 20: 
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "connect";
                break;
            }
            case 23: 
            case 24: 
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "changeExpiredPassword";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 16: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

