/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.remote.jdba.jdbc;

import com.intellij.database.remote.jdba.core.ResultLayout;
import com.intellij.database.remote.jdba.core.RowLayout;
import com.intellij.database.remote.jdba.exceptions.DBPreparingException;
import com.intellij.database.remote.jdba.intermediate.PrimeIntermediateCursor;
import com.intellij.database.remote.jdba.jdbc.JdbcIntermediateSeance;
import com.intellij.database.remote.jdba.jdbc.JdbcRowFetcher;
import com.intellij.database.remote.jdba.jdbc.JdbcRowFetchers;
import com.intellij.database.remote.jdba.jdbc.JdbcRowsCollector;
import com.intellij.database.remote.jdba.jdbc.JdbcRowsCollectors;
import com.intellij.database.remote.jdba.jdbc.JdbcUtil;
import com.intellij.database.remote.jdba.jdbc.JdbcValueGetter;
import com.intellij.database.remote.jdba.jdbc.JdbcValueGetters;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JdbcIntermediateCursor<R>
implements PrimeIntermediateCursor<R> {
    @NotNull
    private final JdbcIntermediateSeance mySeance;
    @NotNull
    private final ResultSet myResultSet;
    @NotNull
    protected final ResultLayout<R> myResultLayout;
    private final boolean myIsDefault;
    private boolean myOpened;
    private boolean myHasRows;
    private int myCollectLimit;
    private JdbcRowsCollector<R> myRowsCollector;
    private static final JdbcRowFetcher<Void> NOTHING_FETCHER = new JdbcRowFetcher<Void>(){

        @Override
        Void fetchRow(@NotNull ResultSet rset) {
            if (rset == null) {
                1.$$$reportNull$$$0(0);
            }
            return null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rset", "com/intellij/database/remote/jdba/jdbc/JdbcIntermediateCursor$1", "fetchRow"));
        }
    };

    protected JdbcIntermediateCursor(@NotNull JdbcIntermediateSeance seance, @NotNull ResultSet resultSet, @NotNull ResultLayout<R> resultLayout, boolean isDefault, @Nullable Boolean hasRows) {
        if (seance == null) {
            JdbcIntermediateCursor.$$$reportNull$$$0(0);
        }
        if (resultSet == null) {
            JdbcIntermediateCursor.$$$reportNull$$$0(1);
        }
        if (resultLayout == null) {
            JdbcIntermediateCursor.$$$reportNull$$$0(2);
        }
        this.myCollectLimit = Integer.MAX_VALUE;
        this.mySeance = seance;
        this.myResultSet = resultSet;
        this.myResultLayout = resultLayout;
        this.myIsDefault = isDefault;
        try {
            this.myOpened = !JdbcUtil.isClosed(this.myResultSet);
        }
        catch (SQLException sqle) {
            throw seance.mySession.recognizeException(sqle, seance.myStatementText);
        }
        if (this.myOpened) {
            if (hasRows == null) {
                try {
                    this.myHasRows = resultSet.next();
                }
                catch (SQLException sqle) {
                    throw seance.mySession.recognizeException(sqle, seance.myStatementText);
                }
            } else {
                this.myHasRows = hasRows;
            }
        } else {
            this.myHasRows = false;
        }
        if (this.myHasRows) {
            try {
                this.myRowsCollector = JdbcIntermediateCursor.createRowsCollector(resultLayout, this.myResultSet, seance.myStatementText, seance.useLabels());
            }
            catch (SQLException sqle) {
                throw seance.mySession.recognizeException(sqle, seance.myStatementText);
            }
        }
        if (resultLayout.kind == ResultLayout.Kind.EXISTENCE || resultLayout.kind == ResultLayout.Kind.SINGLE_ROW) {
            this.myCollectLimit = 1;
        } else {
            int seancePackLimit = this.mySeance.myPackLimit;
            if (seancePackLimit > 0) {
                this.myCollectLimit = seancePackLimit;
            }
        }
    }

    private static <R> JdbcRowsCollector<R> createRowsCollector(ResultLayout<R> resultLayout, ResultSet resultSet, String statementText, boolean useLabels) throws SQLException {
        JdbcRowsCollector collector;
        JdbcRowFetcher fetcher;
        int jdbcType;
        int i;
        JdbcValueGetter[] getters;
        int n;
        RowLayout<?> rowLayout = resultLayout.row;
        switch (rowLayout.kind) {
            case EXISTENCE: {
                n = 0;
                break;
            }
            case ONE_VALUE: {
                n = 1;
                break;
            }
            default: {
                n = rowLayout.components.length;
            }
        }
        ResultSetMetaData metaData = resultSet.getMetaData();
        int m = metaData.getColumnCount();
        if (n > 0 && rowLayout.kind != RowLayout.Kind.TUPLE && rowLayout.kind != RowLayout.Kind.STRUCT) {
            getters = new JdbcValueGetter[n];
            if (n > m && rowLayout.kind == RowLayout.Kind.ARRAY) {
                throw new DBPreparingException(String.format("Query returns too few columns: %d when expected %d (row type is %s).", m, n, resultLayout.row.rowClass), statementText);
            }
            for (i = 0; i < Math.min(m, n); ++i) {
                jdbcType = metaData.getColumnType(i + 1);
                getters[i] = JdbcValueGetters.of(jdbcType, rowLayout.components[i].clazz);
            }
        } else if (n == 0 && rowLayout.commonComponentClass == Object.class) {
            getters = new JdbcValueGetter[m];
            for (i = 0; i < m; ++i) {
                jdbcType = metaData.getColumnType(i + 1);
                getters[i] = JdbcValueGetters.of(jdbcType, Object.class);
            }
        } else {
            getters = null;
        }
        switch (rowLayout.kind) {
            case EXISTENCE: {
                fetcher = NOTHING_FETCHER;
                break;
            }
            case ONE_VALUE: {
                assert (getters != null && getters.length > 0);
                fetcher = JdbcRowFetchers.createOneValueFetcher(1, getters[0]);
                break;
            }
            case ARRAY: {
                if (rowLayout.commonComponentClass == Integer.TYPE) {
                    fetcher = JdbcRowFetchers.createIntArrayFetcher(1);
                    break;
                }
                if (rowLayout.commonComponentClass == Long.TYPE) {
                    fetcher = JdbcRowFetchers.createLongArrayFetcher(1);
                    break;
                }
                fetcher = JdbcRowFetchers.createArrayFetcher(1, rowLayout.commonComponentClass, getters);
                break;
            }
            case TUPLE: {
                fetcher = JdbcRowFetchers.createTupleFetcher(rowLayout.components, useLabels, rowLayout.expandMaps);
                break;
            }
            case STRUCT: {
                fetcher = JdbcRowFetchers.createStructFetcher(rowLayout.rowClass, rowLayout.components, useLabels, rowLayout.expandMaps);
                break;
            }
            default: {
                throw new DBPreparingException(String.format("Unknown how to handle the row layout %s", rowLayout.kind.toString()), statementText);
            }
        }
        switch (resultLayout.kind) {
            case EXISTENCE: {
                collector = JdbcRowsCollectors.createExistenceCollector();
                break;
            }
            case SINGLE_ROW: {
                collector = JdbcRowsCollectors.createSingleRowCollector(fetcher);
                break;
            }
            case ARRAY: {
                collector = JdbcRowsCollectors.createArrayCollector(fetcher);
                break;
            }
            case ARRAY_OF_PRIMITIVES: {
                Class componentClass = resultLayout.row.commonComponentClass;
                if (componentClass == Integer.TYPE) {
                    collector = JdbcRowsCollectors.createArrayOfIntsCollector(resultLayout.initialCapacity);
                    break;
                }
                if (componentClass == Long.TYPE) {
                    collector = JdbcRowsCollectors.createArrayOfLongsCollector(resultLayout.initialCapacity);
                    break;
                }
                throw new DBPreparingException("Primitive array of " + componentClass.getName() + " is not supported", statementText);
            }
            case LIST: {
                collector = JdbcRowsCollectors.createListCollector(fetcher);
                break;
            }
            case MAP: {
                if (resultLayout.sorted) {
                    collector = JdbcRowsCollectors.createHashMapCollector(getters[0], getters[1]);
                    break;
                }
                JdbcValueGetter keyGetter = getters[0];
                collector = JdbcRowsCollectors.createSortedMapCollector(keyGetter, getters[1]);
                break;
            }
            default: {
                throw new DBPreparingException(String.format("Unknown how to handle the result layout %s", resultLayout.kind.toString()), statementText);
            }
        }
        return collector;
    }

    @Override
    public boolean hasRows() {
        return this.myHasRows;
    }

    @Override
    @NotNull
    public String[] getColumnNames() {
        String[] names;
        block4: {
            if (!this.myOpened) {
                throw new IllegalStateException("The cursor is not opened or is yet closed.");
            }
            try {
                ResultSetMetaData md = this.myResultSet.getMetaData();
                int n = md.getColumnCount();
                names = new String[n];
                for (int j = 0; j < n; ++j) {
                    names[j] = JdbcUtil.getColumnName(md, j + 1);
                }
                if (names != null) break block4;
            }
            catch (SQLException sqle) {
                throw this.mySeance.mySession.recognizeException(sqle, this.mySeance.myStatementText);
            }
            JdbcIntermediateCursor.$$$reportNull$$$0(3);
        }
        return names;
    }

    @Override
    public synchronized void setCollectLimit(int limit) {
        this.myCollectLimit = limit;
    }

    @Override
    public R fetch() {
        R result;
        if (!this.myHasRows) {
            if (this.myResultLayout.kind == ResultLayout.Kind.EXISTENCE) {
                return (R)Boolean.FALSE;
            }
            return null;
        }
        if (!this.myOpened) {
            throw new IllegalStateException("The cursor is not opened or is yet closed.");
        }
        try {
            result = this.myRowsCollector.collectRows(this.myResultSet, this.myCollectLimit);
        }
        catch (SQLException sqle) {
            this.close();
            throw this.mySeance.mySession.recognizeException(sqle, this.mySeance.myStatementText);
        }
        this.myHasRows = this.myRowsCollector.hasMoreRows;
        if (!this.myHasRows) {
            this.close();
        }
        return result;
    }

    boolean isOpened() {
        return this.myOpened;
    }

    @Override
    public synchronized void close() {
        try {
            JdbcUtil.close(this.myResultSet);
        }
        finally {
            this.myHasRows = false;
            this.myOpened = false;
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "seance";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resultSet";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resultLayout";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/remote/jdba/jdbc/JdbcIntermediateCursor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/remote/jdba/jdbc/JdbcIntermediateCursor";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getColumnNames";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

