/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.httpClient.grpc.requests;

import com.intellij.httpClient.grpc.requests.GrpcRequestManager;
import com.intellij.httpClient.grpc.requests.ProtocDistributive;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.util.PathUtil;
import com.intellij.util.io.HttpRequests;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.PosixFilePermission;
import java.nio.file.attribute.PosixFilePermissions;
import java.util.Arrays;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0004\b\u00c0\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007J\n\u0010\b\u001a\u0004\u0018\u00010\tH\u0002J\u0012\u0010\n\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u000b\u001a\u00020\u0005H\u0002J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0005H\u0002J\n\u0010\u000f\u001a\u0004\u0018\u00010\u0007H\u0002J\b\u0010\u0010\u001a\u00020\u0005H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/intellij/httpClient/grpc/requests/ProtocCliAccessor;", "", "<init>", "()V", "PROTOC_FOLDER", "Ljava/nio/file/Path;", "findProtocExecutablePath", "", "downloadProtocExecutable", "Ljava/io/File;", "findOrDownloadExecutable", "targetPath", "tunePermissions", "", "path", "chooseUrlForCurrentOS", "assembleLatestExecutableLocalPath", "intellij.httpClient.grpc"})
@SourceDebugExtension(value={"SMAP\nProtocCliAccessor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ProtocCliAccessor.kt\ncom/intellij/httpClient/grpc/requests/ProtocCliAccessor\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 4 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,96:1\n1#2:97\n13#3:98\n13#3:101\n1400#4,2:99\n*S KotlinDebug\n*F\n+ 1 ProtocCliAccessor.kt\ncom/intellij/httpClient/grpc/requests/ProtocCliAccessor\n*L\n48#1:98\n28#1:101\n74#1:99,2\n*E\n"})
public final class ProtocCliAccessor {
    @NotNull
    public static final ProtocCliAccessor INSTANCE = new ProtocCliAccessor();
    @NotNull
    private static final Path PROTOC_FOLDER;

    private ProtocCliAccessor() {
    }

    @Nullable
    public final String findProtocExecutablePath() {
        String string;
        String string2;
        File file = this.downloadProtocExecutable();
        if (file != null && (string2 = file.getAbsolutePath()) != null) {
            String p0 = string2;
            boolean bl = false;
            string = PathUtil.toSystemDependentName((String)p0);
        } else {
            string = null;
        }
        return string;
    }

    private final File downloadProtocExecutable() {
        File file;
        try {
            Path executableLocalPath = this.assembleLatestExecutableLocalPath();
            LinkOption[] linkOptionArray = new LinkOption[]{};
            if (Files.exists(executableLocalPath, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
                return executableLocalPath.toFile();
            }
            Path path = this.findOrDownloadExecutable(executableLocalPath);
            if (path == null) {
                return null;
            }
            Path executable = path;
            this.tunePermissions(executable);
            file = executable.toFile();
        }
        catch (IOException exception) {
            boolean $i$f$logger = false;
            Logger logger = Logger.getInstance(ProtocCliAccessor.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            logger.warn("Unable to download protoc executable", (Throwable)exception);
            file = null;
        }
        return file;
    }

    private final Path findOrDownloadExecutable(Path targetPath) throws IOException {
        String string = this.chooseUrlForCurrentOS();
        if (string == null) {
            return null;
        }
        String executableURL = string;
        HttpRequests.request((String)executableURL).connect(arg_0 -> ProtocCliAccessor.findOrDownloadExecutable$lambda$0(targetPath, arg_0));
        LinkOption[] linkOptionArray = new LinkOption[]{};
        if (Files.exists(targetPath, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
            LinkOption[] linkOptionArray2 = new LinkOption[]{};
            if (Files.isRegularFile(targetPath, Arrays.copyOf(linkOptionArray2, linkOptionArray2.length))) {
                return targetPath;
            }
        }
        throw new IOException("Unable to find extracted executable");
    }

    private final void tunePermissions(Path path) {
        if (!SystemInfo.isWindows) {
            Set<PosixFilePermission> permissions = PosixFilePermissions.fromString("r-xr--r--");
            Files.setPosixFilePermissions(path, permissions);
        }
    }

    private final String chooseUrlForCurrentOS() {
        ProtocDistributive protocDistributive;
        block1: {
            ProtocDistributive[] $this$firstOrNull$iv = ProtocDistributive.values();
            boolean $i$f$firstOrNull = false;
            int n = $this$firstOrNull$iv.length;
            for (int i = 0; i < n; ++i) {
                ProtocDistributive element$iv;
                ProtocDistributive it = element$iv = $this$firstOrNull$iv[i];
                boolean bl = false;
                if (!((Boolean)it.getAcceptsCurrentOS().invoke()).booleanValue()) continue;
                protocDistributive = element$iv;
                break block1;
            }
            protocDistributive = null;
        }
        ProtocDistributive protocDistributive2 = protocDistributive;
        return protocDistributive2 != null ? protocDistributive2.getUrl() : null;
    }

    private final Path assembleLatestExecutableLocalPath() {
        String systemDependentExecutableName = SystemInfo.isWindows ? "protoc.exe" : "protoc";
        Path path = PROTOC_FOLDER.resolve(systemDependentExecutableName);
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"resolve(...)");
        return path;
    }

    private static final Path findOrDownloadExecutable$lambda$0(Path $targetPath, HttpRequests.Request it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.saveToFile($targetPath, ProgressManager.getInstance().getProgressIndicator());
    }

    static {
        Path path = Paths.get(PathManager.getSystemPath(), new String[0]).resolve("grpc/protoc");
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"resolve(...)");
        PROTOC_FOLDER = path;
        try {
            LinkOption[] linkOptionArray = new LinkOption[]{};
            if (!Files.exists(PROTOC_FOLDER, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
                Files.createDirectories(PROTOC_FOLDER, new FileAttribute[0]);
            }
        }
        catch (IOException exception) {
            boolean $i$f$logger = false;
            Logger logger = Logger.getInstance(GrpcRequestManager.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            logger.warn("Unable to create temp directory for protoc", (Throwable)exception);
        }
    }
}

