/*
 * Decompiled with CFR 0.152.
 */
package com.sixrr.inspectjs.confusing;

import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.util.InspectionMessage;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.psi.JSBinaryExpression;
import com.intellij.lang.javascript.psi.JSBlockStatement;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSIfStatement;
import com.intellij.lang.javascript.psi.JSSourceElement;
import com.intellij.lang.javascript.psi.JSStatement;
import com.intellij.lang.javascript.psi.util.JSParenthesesUtils;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.IncorrectOperationException;
import com.sixrr.inspectjs.BaseInspectionVisitor;
import com.sixrr.inspectjs.InspectionJSBundle;
import com.sixrr.inspectjs.InspectionJSFix;
import com.sixrr.inspectjs.JavaScriptInspection;
import com.sixrr.inspectjs.utils.BoolUtils;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public final class NegatedIfStatementJSInspection
extends JavaScriptInspection {
    private final NegatedIfElseFix fix = new NegatedIfElseFix();

    @Override
    @InspectionMessage
    @NotNull
    protected String buildErrorString(Object ... args) {
        String string = InspectionJSBundle.message("negated.ref.statement.error.string", new Object[0]);
        if (string == null) {
            NegatedIfStatementJSInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new Visitor();
    }

    @Override
    protected InspectionJSFix buildFix(PsiElement location) {
        return this.fix;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/sixrr/inspectjs/confusing/NegatedIfStatementJSInspection", "buildErrorString"));
    }

    private static class NegatedIfElseFix
    extends InspectionJSFix {
        private NegatedIfElseFix() {
        }

        @NotNull
        public String getFamilyName() {
            String string = InspectionJSBundle.message("invert.if.condition.fix", new Object[0]);
            if (string == null) {
                NegatedIfElseFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        @Override
        public void doFix(Project project, ProblemDescriptor descriptor) throws IncorrectOperationException {
            PsiComment comment;
            IElementType tokenType;
            PsiElement ifToken = descriptor.getPsiElement();
            JSIfStatement ifStatement = (JSIfStatement)ifToken.getParent();
            assert (ifStatement != null);
            JSStatement elseBranch = (JSStatement)ifStatement.getElseBranch();
            JSStatement thenBranch = (JSStatement)ifStatement.getThenBranch();
            JSExpression condition = ifStatement.getCondition();
            String negatedCondition = BoolUtils.getNegatedExpressionText(condition);
            Object elseText = elseBranch.getText();
            PsiElement lastChild = elseBranch.getLastChild();
            if (lastChild instanceof PsiComment && JSTokenTypes.END_OF_LINE_COMMENT.equals(tokenType = (comment = (PsiComment)lastChild).getTokenType())) {
                elseText = (String)elseText + "\n";
            }
            if (!(elseBranch instanceof JSBlockStatement)) {
                elseText = "{\n" + (String)elseText + "\n}";
            }
            @NonNls String newStatement = "if(" + negatedCondition + ")" + (String)elseText + " else " + thenBranch.getText();
            NegatedIfElseFix.replaceStatement((JSStatement)ifStatement, newStatement);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/sixrr/inspectjs/confusing/NegatedIfStatementJSInspection$NegatedIfElseFix", "getFamilyName"));
        }
    }

    private static class Visitor
    extends BaseInspectionVisitor {
        private Visitor() {
        }

        public void visitJSIfStatement(@NotNull JSIfStatement statement) {
            JSIfStatement parentStatement;
            JSStatement elseBranch;
            if (statement == null) {
                Visitor.$$$reportNull$$$0(0);
            }
            super.visitJSIfStatement(statement);
            PsiElement parent = statement.getParent();
            if (parent instanceof JSIfStatement && statement.equals((Object)(elseBranch = (JSStatement)(parentStatement = (JSIfStatement)parent).getElseBranch()))) {
                return;
            }
            JSStatement elseStatement = (JSStatement)statement.getElseBranch();
            if (elseStatement == null) {
                return;
            }
            JSExpression condition = statement.getCondition();
            if ((condition = JSParenthesesUtils.stripParentheses((JSExpression)condition)) == null || !BoolUtils.isNegation(condition) && !Visitor.isNotEquals(condition)) {
                return;
            }
            if (elseStatement instanceof JSIfStatement) {
                JSExpression elseCondition = ((JSIfStatement)elseStatement).getCondition();
                if ((elseCondition = JSParenthesesUtils.stripParentheses((JSExpression)elseCondition)) != null && (BoolUtils.isNegation(elseCondition) || Visitor.isNotEquals(condition))) {
                    return;
                }
            }
            this.registerStatementError((JSSourceElement)statement, new Object[0]);
        }

        private static boolean isNotEquals(JSExpression expression) {
            if (!(expression instanceof JSBinaryExpression)) {
                return false;
            }
            JSBinaryExpression binaryExpression = (JSBinaryExpression)expression;
            IElementType sign = binaryExpression.getOperationSign();
            return JSTokenTypes.NE.equals(sign) || JSTokenTypes.NEQEQ.equals(sign);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "statement", "com/sixrr/inspectjs/confusing/NegatedIfStatementJSInspection$Visitor", "visitJSIfStatement"));
        }
    }
}

