/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.refactoring;

import com.intellij.lang.Language;
import com.intellij.lang.LanguageNamesValidation;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.JavascriptLanguage;
import com.intellij.lang.javascript.index.JSSymbolUtil;
import com.intellij.lang.javascript.psi.util.JSClassUtils;
import com.intellij.lang.javascript.refactoring.BasicJavascriptNamesValidator;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.util.ObjectUtils;
import com.sixrr.inspectjs.validity.ReservedWordUsedAsNameJSInspection;
import org.jetbrains.annotations.NotNull;

public final class JSNamesValidation {
    private JSNamesValidation() {
    }

    public static boolean isPropertyName(@NotNull String newName, @NotNull PsiElement context2) {
        if (newName == null) {
            JSNamesValidation.$$$reportNull$$$0(0);
        }
        if (context2 == null) {
            JSNamesValidation.$$$reportNull$$$0(1);
        }
        return ReservedWordUsedAsNameJSInspection.dialectIsES5OrAbove(context2) ? JSNamesValidation.isIdentifierName(newName) : JSNamesValidation.isIdentifier(newName, context2);
    }

    public static boolean isClassMemberName(@NotNull String name, @NotNull PsiElement context2) {
        if (name == null) {
            JSNamesValidation.$$$reportNull$$$0(2);
        }
        if (context2 == null) {
            JSNamesValidation.$$$reportNull$$$0(3);
        }
        if (JSClassUtils.isES6ClassImplementation((PsiElement)context2)) {
            return JSNamesValidation.isIdentifierName(name);
        }
        return JSNamesValidation.isIdentifier(name, context2);
    }

    public static boolean isIdentifierName(@NotNull String name) {
        if (name == null) {
            JSNamesValidation.$$$reportNull$$$0(4);
        }
        return BasicJavascriptNamesValidator.isIdentifierName((CharSequence)name);
    }

    public static boolean isIdentifier(String name, @NotNull PsiElement context2) {
        if (context2 == null) {
            JSNamesValidation.$$$reportNull$$$0(5);
        }
        Language language = (Language)ObjectUtils.coalesce((Object)DialectDetector.languageDialectOfElement((PsiElement)context2), (Object)JavascriptLanguage.INSTANCE);
        return LanguageNamesValidation.isIdentifier((Language)language, (String)name, (Project)context2.getProject());
    }

    public static boolean isUnqualifiedType(@NotNull String name) {
        if (name == null) {
            JSNamesValidation.$$$reportNull$$$0(6);
        }
        return "*".equals(name) || JSSymbolUtil.isValidPropertyName((String)name);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newName";
                break;
            }
            case 1: 
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 2: 
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
        }
        objectArray2[1] = "com/intellij/lang/javascript/refactoring/JSNamesValidation";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "isPropertyName";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "isClassMemberName";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "isIdentifierName";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "isIdentifier";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "isUnqualifiedType";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

