/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.stubs.impl;

import com.intellij.lang.Language;
import com.intellij.lang.javascript.JSLanguageDialect;
import com.intellij.lang.javascript.flex.FlexSupportLoader;
import com.intellij.lang.javascript.index.JSIndexKeys;
import com.intellij.lang.javascript.index.flags.BooleanStructureElement;
import com.intellij.lang.javascript.index.flags.EnumStructureElement;
import com.intellij.lang.javascript.index.flags.FlagsStructure;
import com.intellij.lang.javascript.index.flags.FlagsStructureElement;
import com.intellij.lang.javascript.psi.JSElementBase;
import com.intellij.lang.javascript.psi.JSElementType;
import com.intellij.lang.javascript.psi.JSNamespace;
import com.intellij.lang.javascript.psi.JSQualifiedName;
import com.intellij.lang.javascript.psi.JSQualifiedNameImpl;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeList;
import com.intellij.lang.javascript.psi.ecmal4.JSQualifiedNamedElement;
import com.intellij.lang.javascript.psi.resolve.JSIndexBasedResolveUtil;
import com.intellij.lang.javascript.psi.stubs.ES6ExportedMembersByKindIndex;
import com.intellij.lang.javascript.psi.stubs.ES6ExportedNamesIndex;
import com.intellij.lang.javascript.psi.stubs.JSClassIndex;
import com.intellij.lang.javascript.psi.stubs.impl.BackendStubTreeUtil;
import com.intellij.lang.javascript.psi.stubs.impl.JSNamedObjectStubBase;
import com.intellij.lang.javascript.psi.stubs.impl.JSQualifiedObjectStub;
import com.intellij.lang.javascript.psi.stubs.impl.JSStubElementTypeHolder;
import com.intellij.lang.javascript.psi.types.JSAnyType;
import com.intellij.lang.javascript.psi.types.JSContext;
import com.intellij.lang.javascript.psi.types.JSNamedTypeFactory;
import com.intellij.lang.javascript.psi.types.JSTopLevelNamespace;
import com.intellij.lang.javascript.psi.types.JSTypeBaseImpl;
import com.intellij.lang.javascript.psi.types.JSTypeSource;
import com.intellij.lang.javascript.psi.types.JSTypeSourceFactory;
import com.intellij.lang.javascript.types.JSPackageStatementElementType;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.psi.PsiElement;
import com.intellij.psi.stubs.IndexSink;
import com.intellij.psi.stubs.StubElement;
import com.intellij.psi.stubs.StubInputStream;
import com.intellij.psi.stubs.StubOutputStream;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.IFileElementType;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class JSQualifiedObjectStubBase<T extends JSQualifiedNamedElement>
extends JSNamedObjectStubBase<T>
implements JSQualifiedObjectStub<T> {
    private static final BooleanStructureElement NAMESPACE_EXPLICITLY_DECLARED_FLAG = new BooleanStructureElement();
    private static final BooleanStructureElement DEPRECATED_FLAG = new BooleanStructureElement();
    private static final EnumStructureElement<JSAttributeList.AccessType> ACCESS_TYPE_FLAG = new EnumStructureElement(JSAttributeList.AccessType.class);
    private static final BooleanStructureElement IS_CLASS_FLAG = new BooleanStructureElement();
    private static final BooleanStructureElement IS_INTERFACE_FLAG = new BooleanStructureElement();
    private static final BooleanStructureElement IS_EXPORTED_FLAG = new BooleanStructureElement();
    private static final BooleanStructureElement IS_EXPORTED_DEFAULT_OR_ASSIGNMENT_FLAG = new BooleanStructureElement();
    private static final BooleanStructureElement HAS_JSDOC_FLAG = new BooleanStructureElement();
    protected static final FlagsStructure FLAGS_STRUCTURE = new FlagsStructure(JSNamedObjectStubBase.FLAGS_STRUCTURE, new FlagsStructureElement[]{NAMESPACE_EXPLICITLY_DECLARED_FLAG, DEPRECATED_FLAG, ACCESS_TYPE_FLAG, IS_CLASS_FLAG, IS_INTERFACE_FLAG, IS_EXPORTED_FLAG, IS_EXPORTED_DEFAULT_OR_ASSIGNMENT_FLAG, HAS_JSDOC_FLAG});
    @NotNull
    protected final JSStubElementTypeHolder myNamespace;

    protected JSQualifiedObjectStubBase(@NotNull T qualifiedObject, @Nullable StubElement parent, @NotNull JSElementType<? super T> elementType, int childFlags) {
        if (qualifiedObject == null) {
            JSQualifiedObjectStubBase.$$$reportNull$$$0(0);
        }
        if (elementType == null) {
            JSQualifiedObjectStubBase.$$$reportNull$$$0(1);
        }
        super(qualifiedObject, parent, elementType, JSQualifiedObjectStubBase.initFromPsi(qualifiedObject, childFlags));
        this.myNamespace = JSStubElementTypeHolder.fromJSType((JSType)qualifiedObject.getJSNamespace());
    }

    private static int initFromPsi(JSQualifiedNamedElement psi, int flags) {
        flags = JSQualifiedObjectStubBase.writeFlag(flags, FLAGS_STRUCTURE, NAMESPACE_EXPLICITLY_DECLARED_FLAG, psi.isNamespaceExplicitlyDeclared());
        flags = JSQualifiedObjectStubBase.writeFlag(flags, FLAGS_STRUCTURE, ACCESS_TYPE_FLAG, psi.getAccessType());
        flags = JSQualifiedObjectStubBase.writeFlag(flags, FLAGS_STRUCTURE, DEPRECATED_FLAG, psi.isDeprecated());
        JSElementBase.ClassOrInterface classOrInterface = psi.isClassOrInterface();
        flags = JSQualifiedObjectStubBase.writeFlag(flags, FLAGS_STRUCTURE, IS_CLASS_FLAG, classOrInterface == JSElementBase.ClassOrInterface.CLASS);
        flags = JSQualifiedObjectStubBase.writeFlag(flags, FLAGS_STRUCTURE, IS_INTERFACE_FLAG, classOrInterface == JSElementBase.ClassOrInterface.INTERFACE);
        flags = JSQualifiedObjectStubBase.writeFlag(flags, FLAGS_STRUCTURE, IS_EXPORTED_FLAG, psi.isExported());
        flags = JSQualifiedObjectStubBase.writeFlag(flags, FLAGS_STRUCTURE, IS_EXPORTED_DEFAULT_OR_ASSIGNMENT_FLAG, psi.isExportedWithDefault());
        flags = JSQualifiedObjectStubBase.writeFlag(flags, FLAGS_STRUCTURE, HAS_JSDOC_FLAG, psi.hasJSDoc());
        return flags;
    }

    @ApiStatus.Obsolete
    protected JSQualifiedObjectStubBase(String name, String qName, StubElement parent, @NotNull JSContext jsContext, @NotNull JSAttributeList.AccessType accessType, @NotNull IElementType elementType, int childFlags) {
        if (jsContext == null) {
            JSQualifiedObjectStubBase.$$$reportNull$$$0(2);
        }
        if (accessType == null) {
            JSQualifiedObjectStubBase.$$$reportNull$$$0(3);
        }
        if (elementType == null) {
            JSQualifiedObjectStubBase.$$$reportNull$$$0(4);
        }
        super(name, parent, elementType, JSQualifiedObjectStubBase.writeFlag(childFlags, FLAGS_STRUCTURE, NAMESPACE_EXPLICITLY_DECLARED_FLAG, true) | JSQualifiedObjectStubBase.writeFlag(childFlags, FLAGS_STRUCTURE, ACCESS_TYPE_FLAG, JSAttributeList.AccessType.PACKAGE_LOCAL) | JSQualifiedObjectStubBase.writeFlag(childFlags, FLAGS_STRUCTURE, DEPRECATED_FLAG, false) | JSQualifiedObjectStubBase.writeFlag(childFlags, FLAGS_STRUCTURE, ACCESS_TYPE_FLAG, accessType) | JSQualifiedObjectStubBase.writeFlag(childFlags, FLAGS_STRUCTURE, IS_EXPORTED_FLAG, false) | JSQualifiedObjectStubBase.writeFlag(childFlags, FLAGS_STRUCTURE, IS_EXPORTED_DEFAULT_OR_ASSIGNMENT_FLAG, false));
        JSQualifiedNameImpl qualifiedName = qName != null ? JSQualifiedNameImpl.fromQualifiedName((String)qName) : null;
        JSQualifiedName nsName = qualifiedName != null ? qualifiedName.getParent() : null;
        this.myNamespace = JSStubElementTypeHolder.fromJSType((JSType)JSNamedTypeFactory.createNamespace((JSQualifiedName)nsName, (JSContext)jsContext, null));
    }

    protected JSQualifiedObjectStubBase(@NotNull StubInputStream dataStream, @Nullable StubElement parentStub, @NotNull IElementType elementType) throws IOException {
        if (dataStream == null) {
            JSQualifiedObjectStubBase.$$$reportNull$$$0(5);
        }
        if (elementType == null) {
            JSQualifiedObjectStubBase.$$$reportNull$$$0(6);
        }
        super(dataStream, parentStub, elementType);
        this.myNamespace = JSStubElementTypeHolder.fromDataStream((DataInput)dataStream);
    }

    @Override
    public void index(@NotNull IndexSink sink) {
        Language language;
        String name;
        String fqn;
        if (sink == null) {
            JSQualifiedObjectStubBase.$$$reportNull$$$0(7);
        }
        if (!"module.exports".equals(fqn = this.getQualifiedName())) {
            super.index(sink);
        }
        if ((name = this.getName()) != null && this.doIndexName() && ((language = BackendStubTreeUtil.getJSLanguage(this)) == FlexSupportLoader.ECMA_SCRIPT_L4 || !(language instanceof JSLanguageDialect))) {
            sink.occurrence(JSIndexKeys.JS_NAME_INDEX_KEY, (Object)name);
        }
        if (fqn != null && this.doIndexQualifiedName()) {
            if (this.doIndexForQualifiedNameIndex()) {
                sink.occurrence(JSIndexKeys.JS_QUALIFIED_ELEMENT_INDEX_KEY, (Object)fqn);
            }
            if (this.doIndexForGlobalQualifiedNameIndex()) {
                sink.occurrence(JSIndexKeys.JS_GLOBAL_QUALIFIED_ELEMENT_INDEX_KEY, (Object)fqn);
            }
        }
        if (name != null && ((Boolean)this.readFlag(IS_SYMBOL_FLAG)).booleanValue()) {
            String qNameForIndexing;
            JSQualifiedName namespace;
            boolean shouldProcessExportedIndexes = true;
            JSNamespace jsNamespace = this.getJSNamespace();
            JSQualifiedName jSQualifiedName = namespace = jsNamespace.isLocal() ? null : jsNamespace.getQualifiedName();
            if (namespace != null || this.isNamespaceExplicitlyDeclared()) {
                if (namespace != null) {
                    sink.occurrence(JSIndexKeys.JS_NAMESPACE_MEMBERS_INDEX_KEY, (Object)namespace.getQualifiedName());
                } else if (this.isGlobalNamespace()) {
                    sink.occurrence(JSIndexKeys.JS_NAMESPACE_MEMBERS_INDEX_KEY, (Object)"");
                    shouldProcessExportedIndexes = false;
                }
            }
            if (shouldProcessExportedIndexes) {
                this.processExportIndices(sink, name);
            }
            String namespaceForIndexing = JSQualifiedNameImpl.getNamespaceForIndexing((JSNamespace)jsNamespace, (boolean)false);
            if (namespace == null && namespaceForIndexing != null) {
                sink.occurrence(JSIndexKeys.JS_LOCAL_NAMESPACE_MEMBERS_INDEX_KEY, (Object)namespaceForIndexing);
            }
            if ((namespaceForIndexing != null || this.isNamespaceExplicitlyDeclared()) && (qNameForIndexing = JSIndexBasedResolveUtil.getQualifiedNameToIndex((JSElementBase)this)) != null) {
                sink.occurrence(JSIndexKeys.JS_SYMBOL_QUALIFIED_NAMES_INDEX_KEY, (Object)qNameForIndexing);
            }
        }
        if (name != null && (((Boolean)this.readFlag(IS_CLASS_FLAG)).booleanValue() || ((Boolean)this.readFlag(IS_INTERFACE_FLAG)).booleanValue())) {
            sink.occurrence(JSClassIndex.KEY, (Object)JSClassIndex.getNameToIndex(name, (Boolean)this.readFlag(IS_INTERFACE_FLAG)));
        }
    }

    protected void processExportIndices(@NotNull IndexSink sink, @NotNull String name) {
        if (sink == null) {
            JSQualifiedObjectStubBase.$$$reportNull$$$0(8);
        }
        if (name == null) {
            JSQualifiedObjectStubBase.$$$reportNull$$$0(9);
        }
        if (this.isExported()) {
            sink.occurrence(ES6ExportedMembersByKindIndex.KEY, (Object)"exp");
            sink.occurrence(ES6ExportedNamesIndex.KEY, (Object)name);
        }
        if (this.isExportedWithDefault()) {
            sink.occurrence(ES6ExportedMembersByKindIndex.KEY, (Object)"def");
            sink.occurrence(ES6ExportedNamesIndex.KEY, (Object)name);
        }
    }

    protected boolean doIndexName() {
        return false;
    }

    protected boolean isGlobalNamespace() {
        return BackendStubTreeUtil.isFromGlobalNamespace(this);
    }

    @NotNull
    public JSElementBase.ClassOrInterface isClassOrInterface() {
        JSElementBase.ClassOrInterface classOrInterface = (Boolean)this.readFlag(IS_INTERFACE_FLAG) != false ? JSElementBase.ClassOrInterface.INTERFACE : ((Boolean)this.readFlag(IS_CLASS_FLAG) != false ? JSElementBase.ClassOrInterface.CLASS : JSElementBase.ClassOrInterface.NONE);
        if (classOrInterface == null) {
            JSQualifiedObjectStubBase.$$$reportNull$$$0(10);
        }
        return classOrInterface;
    }

    @Override
    public void serialize(StubOutputStream dataStream) throws IOException {
        super.serialize(dataStream);
        JSStubElementTypeHolder.serialize((JSStubElementTypeHolder)this.myNamespace, (DataOutput)dataStream);
    }

    public boolean isNamespaceExplicitlyDeclared() {
        return (Boolean)this.readFlag(NAMESPACE_EXPLICITLY_DECLARED_FLAG);
    }

    protected boolean doIndexQualifiedName() {
        return false;
    }

    protected boolean doIndexForQualifiedNameIndex() {
        return true;
    }

    protected boolean doIndexForGlobalQualifiedNameIndex() {
        return false;
    }

    protected static boolean isUnderPackageOrUnderFile(StubElement stub) {
        StubElement parentStub = stub.getParentStub();
        if (parentStub == null) {
            return false;
        }
        IElementType stubType = parentStub.getElementType();
        return stubType instanceof JSPackageStatementElementType || stubType == null || stubType instanceof IFileElementType;
    }

    @NotNull
    public JSAttributeList.AccessType getAccessType() {
        JSAttributeList.AccessType accessType = this.readFlag(ACCESS_TYPE_FLAG);
        if (accessType == null) {
            JSQualifiedObjectStubBase.$$$reportNull$$$0(11);
        }
        return accessType;
    }

    public boolean isExported() {
        return (Boolean)this.readFlag(IS_EXPORTED_FLAG);
    }

    public boolean isExportedWithDefault() {
        return (Boolean)this.readFlag(IS_EXPORTED_DEFAULT_OR_ASSIGNMENT_FLAG);
    }

    public boolean isDeprecated() {
        return (Boolean)this.readFlag(DEPRECATED_FLAG);
    }

    @Override
    @NotNull
    protected FlagsStructure getFlagsStructure() {
        FlagsStructure flagsStructure = FLAGS_STRUCTURE;
        if (flagsStructure == null) {
            JSQualifiedObjectStubBase.$$$reportNull$$$0(12);
        }
        return flagsStructure;
    }

    @Override
    protected boolean doIndexGlobalSymbol() {
        return JSQualifiedObjectStubBase.doIndexGlobalSymbol((JSElementBase)this);
    }

    public static boolean doIndexGlobalSymbol(JSElementBase element2) {
        JSNamespace namespace = element2.getJSNamespace();
        return !namespace.isLocal() && namespace instanceof JSTopLevelNamespace;
    }

    @Override
    protected boolean doIndexNonGlobalSymbol() {
        if (!this.isNamespaceExplicitlyDeclared()) {
            return true;
        }
        JSNamespace namespace = this.getJSNamespace();
        return namespace.getQualifiedName() != null || namespace instanceof JSAnyType;
    }

    public boolean hasJSDoc() {
        return (Boolean)this.readFlag(HAS_JSDOC_FLAG);
    }

    @Nullable
    public JSQualifiedName getNamespace() {
        JSNamespace namespace = this.getJSNamespace();
        return namespace.isLocal() ? null : namespace.getQualifiedName();
    }

    @NotNull
    public final JSNamespace getJSNamespace() {
        JSNamespace jSNamespace = (JSNamespace)this.myNamespace.getTypeOrFromSerialized().copyWithStrict(this.isNamespaceExplicitlyDeclared());
        if (jSNamespace == null) {
            JSQualifiedObjectStubBase.$$$reportNull$$$0(13);
        }
        return jSNamespace;
    }

    @NotNull
    public JSNamespace getNamespaceWithSource(@Nullable PsiElement namespaceSource) {
        JSNamespace typeOrFromSerialized = (JSNamespace)this.myNamespace.getTypeOrFromSerialized();
        if (typeOrFromSerialized.getSourceElement() != null) {
            JSNamespace jSNamespace = typeOrFromSerialized;
            if (jSNamespace == null) {
                JSQualifiedObjectStubBase.$$$reportNull$$$0(14);
            }
            return jSNamespace;
        }
        boolean isStrict = this.isNamespaceExplicitlyDeclared();
        if (namespaceSource == null && isStrict == typeOrFromSerialized.isSourceStrict()) {
            JSNamespace jSNamespace = typeOrFromSerialized;
            if (jSNamespace == null) {
                JSQualifiedObjectStubBase.$$$reportNull$$$0(15);
            }
            return jSNamespace;
        }
        JSTypeSource newSource = JSTypeSourceFactory.createTypeSource((PsiElement)namespaceSource, (boolean)isStrict);
        JSNamespace jSNamespace = (JSNamespace)JSTypeBaseImpl.replaceEmptySourceRecursive((JSType)typeOrFromSerialized, (JSTypeSource)newSource);
        if (jSNamespace == null) {
            JSQualifiedObjectStubBase.$$$reportNull$$$0(16);
        }
        return jSNamespace;
    }

    @Nullable
    @NlsSafe
    public final String getQualifiedName() {
        Object result2 = this.getName();
        if (result2 == null) {
            return null;
        }
        JSQualifiedName qName = this.getJSNamespace().getQualifiedName();
        if (qName != null) {
            result2 = qName.getQualifiedName() + "." + (String)result2;
        }
        return result2;
    }

    @NotNull
    public final JSContext getJSContext() {
        JSContext jSContext = this.getJSNamespace().getJSContext();
        if (jSContext == null) {
            JSQualifiedObjectStubBase.$$$reportNull$$$0(17);
        }
        return jSContext;
    }

    public String toString() {
        return super.toString() + "[qname=" + this.getQualifiedName() + "]";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 10, 11, 12, 13, 14, 15, 16, 17 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "qualifiedObject";
                break;
            }
            case 1: 
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementType";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jsContext";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "accessType";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataStream";
                break;
            }
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sink";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/psi/stubs/impl/JSQualifiedObjectStubBase";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/psi/stubs/impl/JSQualifiedObjectStubBase";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "isClassOrInterface";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getAccessType";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getFlagsStructure";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getJSNamespace";
                break;
            }
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getNamespaceWithSource";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getJSContext";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "index";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "processExportIndices";
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 10, 11, 12, 13, 14, 15, 16, 17 -> new IllegalStateException(string);
        };
    }
}

